/**
 * Note: This file was auto-generated by TI PinMux on 2/23/2015 at 11:44:06 AM.
 *
 * \file  am335x_icev2_pinmux_data.c
 *
 * \brief  This file contains the pin mux configurations for the boards.
 *         These are prepared based on how the peripherals are extended on
 *         the boards.
 *
 * \copyright Copyright (CU) 2015 Texas Instruments Incorporated -
 *             http://www.ti.com/
 */

/**
 *  Redistribution and use in source and binary forms, with or without
 *  modification, are permitted provided that the following conditions
 *  are met:
 *
 *    Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 *    Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the
 *    distribution.
 *
 *    Neither the name of Texas Instruments Incorporated nor the names of
 *    its contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

/* ========================================================================== */
/*                             Include Files                                  */
/* ========================================================================== */
#include "types.h"
#include "pinmux.h"
#include "am335x_pinmux.h"

/** Peripheral Pin Configurations */
#ifndef BUILDCFG_MOD_UART
#define BUILDCFG_MOD_UART
#endif /* BUILDCFG_MOD_UART */

#ifndef BUILDCFG_MOD_CPSW
#define BUILDCFG_MOD_CPSW
#endif /* BUILDCFG_MOD_CPSW */

#ifndef BUILDCFG_MOD_GPMC
#define BUILDCFG_MOD_GPMC
#endif /* BUILDCFG_MOD_GPMC */

#ifndef BUILDCFG_MOD_GPIO
#define BUILDCFG_MOD_GPIO
#endif /* BUILDCFG_MOD_GPIO */

#ifndef BUILDCFG_MOD_PRU_ICSS
#define BUILDCFG_MOD_PRU_ICSS
#endif /* BUILDCFG_MOD_PRU_ICSS */

#ifndef BUILDCFG_MOD_I2C
#define BUILDCFG_MOD_I2C
#endif /* BUILDCFG_MOD_I2C */

#ifndef BUILDCFG_MOD_MCSPI
#define BUILDCFG_MOD_MCSPI
#endif /* BUILDCFG_MOD_MCSPI */

#ifndef BUILDCFG_MOD_MMCSD
#define BUILDCFG_MOD_MMCSD
#endif /* BUILDCFG_MOD_MMCSD */


#if defined(BUILDCFG_MOD_UART)

static pinmuxPerCfg_t gUart0PinCfg[] =
{
    {
        /* UART 0 -> uart0_rxd -> E15 */
        PIN_UART0_RXD, 0, \
        ( \
            PIN_MODE(0) | \
            ((PIN_PULL_TYPE_SEL | PIN_RX_ACTIVE) & (~PIN_PULL_UD_EN)) \
        ) \
    },
    {
        /* UART 0 -> uart0_txd -> E16 */
        PIN_UART0_TXD, 0, \
        ( \
            PIN_MODE(0) | \
            ((PIN_PULL_TYPE_SEL) & (~PIN_PULL_UD_EN & ~PIN_RX_ACTIVE)) \
        ) \
    },
    {PINMUX_INVALID_PIN}
};

static pinmuxPerCfg_t gUart1PinCfg[] =
{
    {
        /* UART1 -> uart1_rxd -> D16 */
        PIN_UART1_RXD, 0, \
        ( \
            PIN_MODE(0) | \
            ((PIN_PULL_TYPE_SEL | PIN_RX_ACTIVE) & (~PIN_PULL_UD_EN)) \
        ) \
    },
    {
        /* UART1 -> uart1_txd -> D15 */
        PIN_UART1_TXD, 0, \
        ( \
            PIN_MODE(0) | \
            ((PIN_PULL_TYPE_SEL) & (~PIN_PULL_UD_EN & ~PIN_RX_ACTIVE)) \
        ) \
    },
    {PINMUX_INVALID_PIN}
};

static pinmuxPerCfg_t gUart3PinCfg[] =
{
    {
        /* UART3 -> uart3_rxd -> L17 */
        PIN_GMII1_RXD3, 0, \
        ( \
            PIN_MODE(1) | \
            ((PIN_PULL_TYPE_SEL | PIN_RX_ACTIVE) & (~PIN_PULL_UD_EN)) \
        ) \
    },
    {
        /* UART3 -> uart3_txd -> L16 */
        PIN_GMII1_RXD2, 0, \
        ( \
            PIN_MODE(1) | \
            ((PIN_PULL_TYPE_SEL) & (~PIN_PULL_UD_EN & ~PIN_RX_ACTIVE)) \
        ) \
    },
    {PINMUX_INVALID_PIN}
};

static pinmuxPerCfg_t gUart4PinCfg[] =
{
    {
        /* UART 4 -> uart4_rxd -> J18 */
        PIN_GMII1_TXD3, 0, \
        ( \
            PIN_MODE(3) | \
            ((PIN_PULL_TYPE_SEL | PIN_RX_ACTIVE) & (~PIN_PULL_UD_EN)) \
        ) \
    },
    {
        /* UART 4 -> uart4_txd -> K15 */
        PIN_GMII1_TXD2, 0, \
        ( \
            PIN_MODE(3) | \
            ((PIN_PULL_TYPE_SEL) & (~PIN_PULL_UD_EN & ~PIN_RX_ACTIVE)) \
        ) \
    },
    {PINMUX_INVALID_PIN}
};

static pinmuxModuleCfg_t gUartPinCfg[] =
{
    {0, TRUE, gUart0PinCfg},
    {1, TRUE, gUart1PinCfg},
    {3, TRUE, gUart3PinCfg},
    {4, TRUE, gUart4PinCfg},
    {CHIPDB_INVALID_INSTANCE_NUM}
};

#endif /* if defined(BUILDCFG_MOD_UART) */

#if defined(BUILDCFG_MOD_CPSW)

static pinmuxPerCfg_t gCpsw0PinCfg[] =
{
    {
        /* MDIO -> mdio_clk -> M18 */
        PIN_MDIO_CLK, 0, \
        ( \
            PIN_MODE(0) | \
            ((PIN_PULL_TYPE_SEL) & (~PIN_PULL_UD_EN & ~PIN_RX_ACTIVE)) \
        ) \
    },
    {
        /* MDIO -> mdio_data -> M17 */
        PIN_MDIO_DATA, 0, \
        ( \
            PIN_MODE(0) | \
            ((PIN_PULL_TYPE_SEL | PIN_RX_ACTIVE) & (~PIN_PULL_UD_EN)) \
        ) \
    },
    {
        /* RMII1 -> rmii1_crs_dv -> H17 */
        PIN_GMII1_CRS, 0, \
        ( \
            PIN_MODE(1) | \
            ((PIN_PULL_UD_EN | PIN_RX_ACTIVE) & (~PIN_PULL_TYPE_SEL)) \
        ) \
    },
    {
        /* RMII1 -> rmii1_rxer -> J15 */
        PIN_GMII1_RXER, 0, \
        ( \
            PIN_MODE(1) | \
            ((PIN_PULL_UD_EN | PIN_RX_ACTIVE) & (~PIN_PULL_TYPE_SEL)) \
        ) \
    },
    {
        /* RMII1 -> rmii1_txen -> J16 */
        PIN_GMII1_TXEN, 0, \
        ( \
            PIN_MODE(1) | \
            ((PIN_PULL_UD_EN) & (~PIN_PULL_TYPE_SEL & ~PIN_RX_ACTIVE)) \
        ) \
    },
    {
        /* RMII1 -> rmii1_txd0 -> K17 */
        PIN_GMII1_TXD0, 0, \
        ( \
            PIN_MODE(1) | \
            ((PIN_PULL_UD_EN) & (~PIN_PULL_TYPE_SEL & ~PIN_RX_ACTIVE)) \
        ) \
    },
    {
        /* RMII1 -> rmii1_txd1 -> K16 */
        PIN_GMII1_TXD1, 0, \
        ( \
            PIN_MODE(1) | \
            ((PIN_PULL_UD_EN) & (~PIN_PULL_TYPE_SEL & ~PIN_RX_ACTIVE)) \
        ) \
    },
    {
        /* RMII1 -> rmii1_rxd0 -> M16 */
        PIN_GMII1_RXD0, 0, \
        ( \
            PIN_MODE(1) | \
            ((PIN_PULL_UD_EN | PIN_RX_ACTIVE) & (~PIN_PULL_TYPE_SEL)) \
        ) \
    },
    {
        /* RMII1 -> rmii1_rxd1 -> L15 */
        PIN_GMII1_RXD1, 0, \
        ( \
            PIN_MODE(1) | \
            ((PIN_PULL_UD_EN | PIN_RX_ACTIVE) & (~PIN_PULL_TYPE_SEL)) \
        ) \
    },
    {
        /* RMII1 -> rmii1_refclk -> H18 */
        PIN_RMII1_REFCLK, 0, \
        ( \
            PIN_MODE(0) | \
            ((PIN_PULL_TYPE_SEL | PIN_RX_ACTIVE) & (~PIN_PULL_UD_EN)) \
        ) \
    },
    {
        /* RMII2 -> rmii2_crs_dv -> T17 */
        PIN_GPMC_WAIT0, 0, \
        ( \
            PIN_MODE(3) | \
            ((PIN_PULL_UD_EN | PIN_RX_ACTIVE) & (~PIN_PULL_TYPE_SEL)) \
        ) \
    },
    {
        /* RMII2 -> rmii2_rxer -> U17 */
        PIN_GPMC_WPN, 0, \
        ( \
            PIN_MODE(3) | \
            ((PIN_PULL_UD_EN | PIN_RX_ACTIVE) & (~PIN_PULL_TYPE_SEL)) \
        ) \
    },
    {
        /* RMII2 -> rmii2_txen -> R13 */
        PIN_GPMC_A0, 0, \
        ( \
            PIN_MODE(3) | \
            ((PIN_PULL_UD_EN) & (~PIN_PULL_TYPE_SEL & ~PIN_RX_ACTIVE)) \
        ) \
    },
    {
        /* RMII2 -> rmii2_txd0 -> V15 */
        PIN_GPMC_A5, 0, \
        ( \
            PIN_MODE(3) | \
            ((PIN_PULL_UD_EN) & (~PIN_PULL_TYPE_SEL & ~PIN_RX_ACTIVE)) \
        ) \
    },
    {
        /* RMII2 -> rmii2_txd1 -> R14 */
        PIN_GPMC_A4, 0, \
        ( \
            PIN_MODE(3) | \
            ((PIN_PULL_UD_EN) & (~PIN_PULL_TYPE_SEL & ~PIN_RX_ACTIVE)) \
        ) \
    },
    {
        /* RMII2 -> rmii2_rxd0 -> V17 */
        PIN_GPMC_A11, 0, \
        ( \
            PIN_MODE(3) | \
            ((PIN_PULL_UD_EN | PIN_RX_ACTIVE) & (~PIN_PULL_TYPE_SEL)) \
        ) \
    },
    {
        /* RMII2 -> rmii2_rxd1 -> T16 */
        PIN_GPMC_A10, 0, \
        ( \
            PIN_MODE(3) | \
            ((PIN_PULL_UD_EN | PIN_RX_ACTIVE) & (~PIN_PULL_TYPE_SEL)) \
        ) \
    },
    {
        /* RMII2 -> rmii2_refclk -> H16 */
        PIN_GMII1_COL, 0, \
        ( \
            PIN_MODE(1) | \
            ((PIN_PULL_TYPE_SEL | PIN_RX_ACTIVE) & (~PIN_PULL_UD_EN)) \
        ) \
    },
    {PINMUX_INVALID_PIN}
};

static pinmuxModuleCfg_t gCpswPinCfg[] =
{
    {0, TRUE, gCpsw0PinCfg},
    {CHIPDB_INVALID_INSTANCE_NUM}
};

#endif /* if defined(BUILDCFG_MOD_CPSW) */

#if defined(BUILDCFG_MOD_GPIO)

static pinmuxPerCfg_t gGpio0PinCfg[] =
{
    {
        /* GPIO0 -> gpio0[7] -> C18 */
        PIN_ECAP0_IN_PWM0_OUT, 7, \
        ( \
            PIN_MODE(7) | \
            ((PIN_PULL_TYPE_SEL) & (~PIN_PULL_UD_EN & ~PIN_RX_ACTIVE)) \
        ) \
    },
    {
        /* GPIO0 -> gpio0[18] -> F16 */
        PIN_USB0_DRVVBUS, 18, \
        ( \
            PIN_MODE(7) | \
            ((PIN_PULL_UD_EN) & (~PIN_PULL_TYPE_SEL & ~PIN_RX_ACTIVE)) \
        ) \
    },
	{
		/* My GPIO 1 -> gpio0[16] -> J18 */
		PIN_GMII1_TXD3, 16, \
		( \
			PIN_MODE(7) | \
			((PIN_PULL_UD_EN | PIN_RX_ACTIVE) & (~PIN_PULL_TYPE_SEL)) \
		) \
	},
	{
		/* My GPIO 1 -> gpio0[17] -> K15 */
		PIN_GMII1_TXD2, 17, \
		( \
			PIN_MODE(7) | \
			((PIN_PULL_UD_EN | PIN_RX_ACTIVE) & (~PIN_PULL_TYPE_SEL)) \
		) \
	},
	{
		/* My GPIO 0 -> gpio0[7] -> C18 */
		PIN_ECAP0_IN_PWM0_OUT, 7, \
		( \
			PIN_MODE(7) | \
			((PIN_PULL_TYPE_SEL) & (~PIN_PULL_UD_EN & ~PIN_RX_ACTIVE)) \
		) \
	},
	{
		/* My GPIO 0 -> gpio0[16] -> J18 */
		PIN_GMII1_TXD3, 16, \
		( \
			PIN_MODE(7) | \
			((0x38) & (~PIN_PULL_UD_EN & ~PIN_PULL_TYPE_SEL & ~PIN_RX_ACTIVE)) \
		) \
	},
	{
		/* My GPIO 0 -> gpio0[17] -> K15 */
		PIN_GMII1_TXD2, 17, \
		( \
			PIN_MODE(7) | \
			((0x38) & (~PIN_PULL_UD_EN & ~PIN_PULL_TYPE_SEL & ~PIN_RX_ACTIVE)) \
		) \
	},
	{
		/* My GPIO 0 -> gpio0[18] -> F16 */
		PIN_USB0_DRVVBUS, 18, \
		( \
			PIN_MODE(7) | \
			((PIN_PULL_TYPE_SEL) & (~PIN_PULL_UD_EN & ~PIN_RX_ACTIVE)) \
		) \
	},
	{
		/* My GPIO 0 -> gpio0[19] -> A15 */
		PIN_XDMA_EVENT_INTR0, 19, \
		( \
			PIN_MODE(7) | \
			((0x38) & (~PIN_PULL_UD_EN & ~PIN_PULL_TYPE_SEL & ~PIN_RX_ACTIVE)) \
		) \
	},
	{
		/* My GPIO 0 -> gpio0[20] -> D14 */
		PIN_XDMA_EVENT_INTR1, 20, \
		( \
			PIN_MODE(7) | \
			((0x38) & (~PIN_PULL_UD_EN & ~PIN_PULL_TYPE_SEL & ~PIN_RX_ACTIVE)) \
		) \
	},
    {PINMUX_INVALID_PIN}
};

static pinmuxPerCfg_t gGpio1PinCfg[] =
{
    {
        /* GPIO1 -> gpio1[9] -> E17 */
        PIN_UART0_RTSN, 9, \
        ( \
            PIN_MODE(7) | \
            ((PIN_PULL_UD_EN) & (~PIN_PULL_TYPE_SEL & ~PIN_RX_ACTIVE)) \
        ) \
    },
    {
        /* GPIO1 -> gpio1[30] -> U9 */
        PIN_GPMC_CSN1, 30, \
        ( \
            PIN_MODE(7) | \
            ((PIN_PULL_UD_EN) & (~PIN_PULL_TYPE_SEL & ~PIN_RX_ACTIVE)) \
        ) \
    },
	{
		/* My GPIO 1 -> gpio1[31] -> V9 */
		PIN_GPMC_CSN2, 31, \
		( \
			PIN_MODE(7) | \
			((0x38) & (~PIN_PULL_UD_EN & ~PIN_PULL_TYPE_SEL & ~PIN_RX_ACTIVE)) \
		) \
	},
	{PINMUX_INVALID_PIN}
};

static pinmuxPerCfg_t gGpio2PinCfg[] =
{
	{
		/* My GPIO 2 -> gpio2[5] -> T6 */
		PIN_GPMC_BE0N_CLE, 5, \
		( \
			PIN_MODE(7) | \
			((0x38) & (~PIN_PULL_UD_EN & ~PIN_PULL_TYPE_SEL & ~PIN_RX_ACTIVE)) \
		) \
	},
	{PINMUX_INVALID_PIN}
};

static pinmuxPerCfg_t gGpio3PinCfg[] =
{
	{
		/* My GPIO 3 -> gpio3[4] -> J17 */
		PIN_GMII1_RXDV, 4, \
		( \
			PIN_MODE(7) | \
			((0x38) & (~PIN_PULL_UD_EN & ~PIN_PULL_TYPE_SEL & ~PIN_RX_ACTIVE)) \
		) \
	},
	{
		/* My GPIO 3 -> gpio3[9] -> K18 */
		PIN_GMII1_TXCLK, 9, \
		( \
			PIN_MODE(7) | \
			((0x38) & (~PIN_PULL_UD_EN & ~PIN_PULL_TYPE_SEL & ~PIN_RX_ACTIVE)) \
		) \
	},
	{
		/* My GPIO 3 -> gpio3[10] -> L18 */
		PIN_GMII1_RXCLK, 10, \
		( \
			PIN_MODE(7) | \
			((0x38) & (~PIN_PULL_UD_EN & ~PIN_PULL_TYPE_SEL & ~PIN_RX_ACTIVE)) \
		) \
	},
	{
		/* My GPIO 3 -> gpio3[18] -> B12 */
		PIN_MCASP0_ACLKR, 18, \
		( \
			PIN_MODE(7) | \
			((PIN_PULL_TYPE_SEL) & (~PIN_PULL_UD_EN & ~PIN_RX_ACTIVE)) \
		) \
	},
    {
        /* GPIO3 -> gpio3[21] -> A14 */
        PIN_MCASP0_AHCLKX, 21, \
        ( \
            PIN_MODE(7) | \
            ((PIN_PULL_UD_EN) & (~PIN_PULL_TYPE_SEL & ~PIN_RX_ACTIVE)) \
        ) \
    },

	{PINMUX_INVALID_PIN}
};

static pinmuxModuleCfg_t gGpioPinCfg[] =
{
    {1, TRUE, gGpio1PinCfg},
    {2, TRUE, gGpio2PinCfg},
    {0, TRUE, gGpio0PinCfg},
    {3, TRUE, gGpio3PinCfg},
    {CHIPDB_INVALID_INSTANCE_NUM}
};

#endif /* if defined(BUILDCFG_MOD_GPIO) */
#if defined(BUILDCFG_MOD_GPMC)

static pinmuxPerCfg_t gGpmc0PinCfg[] =
{
	{
		/* My GPMC 1 -> gpmc_csn0 -> V6 */
		PIN_GPMC_CSN0, 0, \
		( \
			PIN_MODE(0) | \
			((0x38) & (~PIN_PULL_UD_EN & ~PIN_PULL_TYPE_SEL & ~PIN_RX_ACTIVE)) \
		) \
	},
	{
		/* My GPMC 1 -> gpmc_advn_ale -> R7 */
		PIN_GPMC_ADVN_ALE, 0, \
		( \
			PIN_MODE(0) | \
			((0x38) & (~PIN_PULL_UD_EN & ~PIN_PULL_TYPE_SEL & ~PIN_RX_ACTIVE)) \
		) \
	},
	{
		/* My GPMC 1 -> gpmc_oen_ren -> T7 */
		PIN_GPMC_OEN_REN, 0, \
		( \
			PIN_MODE(0) | \
			((0x38) & (~PIN_PULL_UD_EN & ~PIN_PULL_TYPE_SEL & ~PIN_RX_ACTIVE)) \
		) \
	},
	{
		/* My GPMC 1 -> gpmc_wen -> U6 */
		PIN_GPMC_WEN, 0, \
		( \
			PIN_MODE(0) | \
			((0x38) & (~PIN_PULL_UD_EN & ~PIN_PULL_TYPE_SEL & ~PIN_RX_ACTIVE)) \
		) \
	},
	{PINMUX_INVALID_PIN}
};

static pinmuxModuleCfg_t gGpmcPinCfg[] =
{
    {0, TRUE, gGpmc0PinCfg},
    {CHIPDB_INVALID_INSTANCE_NUM}
};

#endif /* if defined(BUILDCFG_MOD_GPMC) */

#if defined(BUILDCFG_MOD_PRU_ICSS)

static pinmuxPerCfg_t gPru_icss1PinCfg[] =
{
	{
		/* My UART_PRUSS1 1 -> pr1_uart0_rxd -> D16 */
		PIN_UART1_RXD, (uint16_t)PINMUX_SS_PRU_ICSS_UART0, \
		( \
			PIN_MODE(5) | \
			((PIN_PULL_UD_EN | PIN_RX_ACTIVE) & (~PIN_PULL_TYPE_SEL)) \
		) \
	},
	{
		/* My UART_PRUSS1 1 -> pr1_uart0_txd -> D15 */
		PIN_UART1_TXD, (uint16_t)PINMUX_SS_PRU_ICSS_UART0, \
		( \
			PIN_MODE(5) | \
			((0x38) & (~PIN_PULL_UD_EN & ~PIN_PULL_TYPE_SEL & ~PIN_RX_ACTIVE)) \
		) \
	},
	{
		/* My PRU_PRUSS1 1 -> pr1_pru0_pru_r30[5] -> C13 */
		PIN_MCASP0_FSR, (uint16_t)PINMUX_SS_PRU_ICSS_PRU0, \
		( \
			PIN_MODE(5) | \
			((0x38) & (~PIN_PULL_UD_EN & ~PIN_PULL_TYPE_SEL & ~PIN_RX_ACTIVE)) \
		) \
	},

	{
		/* My MDIO_PRUSS1 1 -> pr1_mdio_mdclk -> V12 */
		PIN_GPMC_CLK, (uint16_t)PINMUX_SS_PRU_ICSS_MDIO, \
		( \
			PIN_MODE(5) | \
			((PIN_PULL_TYPE_SEL) & (~PIN_PULL_UD_EN & ~PIN_RX_ACTIVE)) \
		) \
	},
	{
		/* My MDIO_PRUSS1 1 -> pr1_mdio_data -> T13 */
		PIN_GPMC_CSN3, (uint16_t)PINMUX_SS_PRU_ICSS_MDIO, \
		( \
			PIN_MODE(5) | \
			((PIN_PULL_TYPE_SEL | PIN_RX_ACTIVE) & (~PIN_PULL_UD_EN)) \
		) \
	},
	{
		/* My MII_PRUSS1 1 -> pr1_mii_mt1_clk -> R13 */
		PIN_GPMC_A0, (uint16_t)PINMUX_SS_PRU_ICSS_MII1, \
		( \
			PIN_MODE(5) | \
			((PIN_PULL_UD_EN | PIN_RX_ACTIVE) & (~PIN_PULL_TYPE_SEL)) \
		) \
	},
	{
		/* My MII_PRUSS1 1 -> pr1_mii1_txd0 -> R14 */
		PIN_GPMC_A4, (uint16_t)PINMUX_SS_PRU_ICSS_MII1, \
		( \
			PIN_MODE(5) | \
			((0x38) & (~PIN_PULL_UD_EN & ~PIN_PULL_TYPE_SEL & ~PIN_RX_ACTIVE)) \
		) \
	},
	{
		/* My MII_PRUSS1 1 -> pr1_mii1_txd1 -> T14 */
		PIN_GPMC_A3, (uint16_t)PINMUX_SS_PRU_ICSS_MII1, \
		( \
			PIN_MODE(5) | \
			((0x38) & (~PIN_PULL_UD_EN & ~PIN_PULL_TYPE_SEL & ~PIN_RX_ACTIVE)) \
		) \
	},
	{
		/* My MII_PRUSS1 1 -> pr1_mii1_txd2 -> U14 */
		PIN_GPMC_A2, (uint16_t)PINMUX_SS_PRU_ICSS_MII1, \
		( \
			PIN_MODE(5) | \
			((0x38) & (~PIN_PULL_UD_EN & ~PIN_PULL_TYPE_SEL & ~PIN_RX_ACTIVE)) \
		) \
	},
	{
		/* My MII_PRUSS1 1 -> pr1_mii1_txd3 -> V14 */
		PIN_GPMC_A1, (uint16_t)PINMUX_SS_PRU_ICSS_MII1, \
		( \
			PIN_MODE(5) | \
			((0x38) & (~PIN_PULL_UD_EN & ~PIN_PULL_TYPE_SEL & ~PIN_RX_ACTIVE)) \
		) \
	},
	{
		/* My MII_PRUSS1 1 -> pr1_mii1_rxd0 -> V16 */
		PIN_GPMC_A8, (uint16_t)PINMUX_SS_PRU_ICSS_MII1, \
		( \
			PIN_MODE(5) | \
			((PIN_PULL_UD_EN | PIN_RX_ACTIVE) & (~PIN_PULL_TYPE_SEL)) \
		) \
	},
	{
		/* My MII_PRUSS1 1 -> pr1_mii1_rxd1 -> T15 */
		PIN_GPMC_A7, (uint16_t)PINMUX_SS_PRU_ICSS_MII1, \
		( \
			PIN_MODE(5) | \
			((PIN_PULL_UD_EN | PIN_RX_ACTIVE) & (~PIN_PULL_TYPE_SEL)) \
		) \
	},
	{
		/* My MII_PRUSS1 1 -> pr1_mii1_rxd2 -> U15 */
		PIN_GPMC_A6, (uint16_t)PINMUX_SS_PRU_ICSS_MII1, \
		( \
			PIN_MODE(5) | \
			((PIN_PULL_UD_EN | PIN_RX_ACTIVE) & (~PIN_PULL_TYPE_SEL)) \
		) \
	},
	{
		/* My MII_PRUSS1 1 -> pr1_mii1_rxd3 -> V15 */
		PIN_GPMC_A5, (uint16_t)PINMUX_SS_PRU_ICSS_MII1, \
		( \
			PIN_MODE(5) | \
			((PIN_PULL_UD_EN | PIN_RX_ACTIVE) & (~PIN_PULL_TYPE_SEL)) \
		) \
	},
	{
		/* My MII_PRUSS1 1 -> pr1_mii1_txen -> U17 */
		PIN_GPMC_WPN, (uint16_t)PINMUX_SS_PRU_ICSS_MII1, \
		( \
			PIN_MODE(5) | \
			((0x38) & (~PIN_PULL_UD_EN & ~PIN_PULL_TYPE_SEL & ~PIN_RX_ACTIVE)) \
		) \
	},
	{
		/* My MII_PRUSS1 1 -> pr1_mii_mr1_clk -> U16 */
		PIN_GPMC_A9, (uint16_t)PINMUX_SS_PRU_ICSS_MII1, \
		( \
			PIN_MODE(5) | \
			((PIN_PULL_UD_EN | PIN_RX_ACTIVE) & (~PIN_PULL_TYPE_SEL)) \
		) \
	},
	{
		/* My MII_PRUSS1 1 -> pr1_mii1_rxdv -> T16 */
		PIN_GPMC_A10, (uint16_t)PINMUX_SS_PRU_ICSS_MII1, \
		( \
			PIN_MODE(5) | \
			((PIN_PULL_UD_EN | PIN_RX_ACTIVE) & (~PIN_PULL_TYPE_SEL)) \
		) \
	},
	{
		/* My MII_PRUSS1 1 -> pr1_mii1_rxer -> V17 */
		PIN_GPMC_A11, (uint16_t)PINMUX_SS_PRU_ICSS_MII1, \
		( \
			PIN_MODE(5) | \
			((PIN_PULL_UD_EN | PIN_RX_ACTIVE) & (~PIN_PULL_TYPE_SEL)) \
		) \
	},
	{
		/* My MII_PRUSS1 1 -> pr1_mii1_rxlink -> U18 */
		PIN_GPMC_BE1N, (uint16_t)PINMUX_SS_PRU_ICSS_MII1, \
		( \
			PIN_MODE(5) | \
			((PIN_PULL_UD_EN | PIN_RX_ACTIVE) & (~PIN_PULL_TYPE_SEL)) \
		) \
	},
	{
		/* My MII_PRUSS1 1 -> pr1_mii1_crs -> R6 */
		PIN_LCD_AC_BIAS_EN, (uint16_t)PINMUX_SS_PRU_ICSS_MII1, \
		( \
			PIN_MODE(2) | \
			((PIN_PULL_UD_EN | PIN_RX_ACTIVE) & (~PIN_PULL_TYPE_SEL)) \
		) \
	},
	{
		/* My MII_PRUSS1 1 -> pr1_mii1_col -> T17 */
		PIN_GPMC_WAIT0, (uint16_t)PINMUX_SS_PRU_ICSS_MII1, \
		( \
			PIN_MODE(5) | \
			((PIN_RX_ACTIVE) & (~PIN_PULL_UD_EN & ~PIN_PULL_TYPE_SEL)) \
		) \
	},
	{
		/* My MII_PRUSS1 0 -> pr1_mii_mt0_clk -> R1 */
		PIN_LCD_DATA0, (uint16_t)PINMUX_SS_PRU_ICSS_MII0, \
		( \
			PIN_MODE(2) | \
			((PIN_PULL_UD_EN | PIN_RX_ACTIVE) & (~PIN_PULL_TYPE_SEL)) \
		) \
	},
	{
		/* My MII_PRUSS1 0 -> pr1_mii0_txd0 -> T2 */
		PIN_LCD_DATA5, (uint16_t)PINMUX_SS_PRU_ICSS_MII0, \
		( \
			PIN_MODE(2) | \
			((0x38) & (~PIN_PULL_UD_EN & ~PIN_PULL_TYPE_SEL & ~PIN_RX_ACTIVE)) \
		) \
	},
	{
		/* My MII_PRUSS1 0 -> pr1_mii0_txd1 -> T1 */
		PIN_LCD_DATA4, (uint16_t)PINMUX_SS_PRU_ICSS_MII0, \
		( \
			PIN_MODE(2) | \
			((0x38) & (~PIN_PULL_UD_EN & ~PIN_PULL_TYPE_SEL & ~PIN_RX_ACTIVE)) \
		) \
	},
	{
		/* My MII_PRUSS1 0 -> pr1_mii0_txd2 -> R4 */
		PIN_LCD_DATA3, (uint16_t)PINMUX_SS_PRU_ICSS_MII0, \
		( \
			PIN_MODE(2) | \
			((0x38) & (~PIN_PULL_UD_EN & ~PIN_PULL_TYPE_SEL & ~PIN_RX_ACTIVE)) \
		) \
	},
	{
		/* My MII_PRUSS1 0 -> pr1_mii0_txd3 -> R3 */
		PIN_LCD_DATA2, (uint16_t)PINMUX_SS_PRU_ICSS_MII0, \
		( \
			PIN_MODE(2) | \
			((0x38) & (~PIN_PULL_UD_EN & ~PIN_PULL_TYPE_SEL & ~PIN_RX_ACTIVE)) \
		) \
	},
	{
		/* My MII_PRUSS1 0 -> pr1_mii0_rxd0 -> U4 */
		PIN_LCD_DATA11, (uint16_t)PINMUX_SS_PRU_ICSS_MII0, \
		( \
			PIN_MODE(5) | \
			((PIN_PULL_UD_EN | PIN_RX_ACTIVE) & (~PIN_PULL_TYPE_SEL)) \
		) \
	},
	{
		/* My MII_PRUSS1 0 -> pr1_mii0_rxd1 -> U3 */
		PIN_LCD_DATA10, (uint16_t)PINMUX_SS_PRU_ICSS_MII0, \
		( \
			PIN_MODE(5) | \
			((PIN_PULL_UD_EN | PIN_RX_ACTIVE) & (~PIN_PULL_TYPE_SEL)) \
		) \
	},
	{
		/* My MII_PRUSS1 0 -> pr1_mii0_rxd2 -> U2 */
		PIN_LCD_DATA9, (uint16_t)PINMUX_SS_PRU_ICSS_MII0, \
		( \
			PIN_MODE(5) | \
			((PIN_PULL_UD_EN | PIN_RX_ACTIVE) & (~PIN_PULL_TYPE_SEL)) \
		) \
	},
	{
		/* My MII_PRUSS1 0 -> pr1_mii0_rxd3 -> U1 */
		PIN_LCD_DATA8, (uint16_t)PINMUX_SS_PRU_ICSS_MII0, \
		( \
			PIN_MODE(5) | \
			((PIN_PULL_UD_EN | PIN_RX_ACTIVE) & (~PIN_PULL_TYPE_SEL)) \
		) \
	},
	{
		/* My MII_PRUSS1 0 -> pr1_mii0_txen -> R2 */
		PIN_LCD_DATA1, (uint16_t)PINMUX_SS_PRU_ICSS_MII0, \
		( \
			PIN_MODE(2) | \
			((0x38) & (~PIN_PULL_UD_EN & ~PIN_PULL_TYPE_SEL & ~PIN_RX_ACTIVE)) \
		) \
	},
	{
		/* My MII_PRUSS1 0 -> pr1_mii_mr0_clk -> V4 */
		PIN_LCD_DATA14, (uint16_t)PINMUX_SS_PRU_ICSS_MII0, \
		( \
			PIN_MODE(5) | \
			((PIN_PULL_UD_EN | PIN_RX_ACTIVE) & (~PIN_PULL_TYPE_SEL)) \
		) \
	},
	{
		/* My MII_PRUSS1 0 -> pr1_mii0_rxdv -> T5 */
		PIN_LCD_DATA15, (uint16_t)PINMUX_SS_PRU_ICSS_MII0, \
		( \
			PIN_MODE(5) | \
			((PIN_PULL_UD_EN | PIN_RX_ACTIVE) & (~PIN_PULL_TYPE_SEL)) \
		) \
	},
	{
		/* My MII_PRUSS1 0 -> pr1_mii0_rxer -> V3 */
		PIN_LCD_DATA13, (uint16_t)PINMUX_SS_PRU_ICSS_MII0, \
		( \
			PIN_MODE(5) | \
			((PIN_PULL_UD_EN | PIN_RX_ACTIVE) & (~PIN_PULL_TYPE_SEL)) \
		) \
	},
	{
		/* My MII_PRUSS1 0 -> pr1_mii0_rxlink -> V2 */
		PIN_LCD_DATA12, (uint16_t)PINMUX_SS_PRU_ICSS_MII0, \
		( \
			PIN_MODE(5) | \
			((PIN_PULL_UD_EN | PIN_RX_ACTIVE) & (~PIN_PULL_TYPE_SEL)) \
		) \
	},
	{
		/* My MII_PRUSS1 0 -> pr1_mii0_crs -> V5 */
		PIN_LCD_PCLK, (uint16_t)PINMUX_SS_PRU_ICSS_MII0, \
		( \
			PIN_MODE(2) | \
			((PIN_PULL_UD_EN | PIN_RX_ACTIVE) & (~PIN_PULL_TYPE_SEL)) \
		) \
	},
	{
		/* My ECAT_PRUSS1 1 -> pr1_edc_sync0_out -> E18 */
		PIN_UART0_CTSN, (uint16_t)PINMUX_SS_PRU_ICSS_ECAT, \
		( \
			PIN_MODE(6) | \
			((0x38) & (~PIN_PULL_UD_EN & ~PIN_PULL_TYPE_SEL & ~PIN_RX_ACTIVE)) \
		) \
	},
	{
		/* My ECAT_PRUSS1 1 -> pr1_edc_sync1_out -> E17 */
		PIN_UART0_RTSN, (uint16_t)PINMUX_SS_PRU_ICSS_ECAT, \
		( \
			PIN_MODE(6) | \
			((0x38) & (~PIN_PULL_UD_EN & ~PIN_PULL_TYPE_SEL & ~PIN_RX_ACTIVE)) \
		) \
	},
	{
		/* My ECAT_PRUSS1 1 -> pr1_edio_data_out7 -> V9 */
		PIN_GPMC_CSN2, (uint16_t)PINMUX_SS_PRU_ICSS_ECAT, \
		( \
			PIN_MODE(4) | \
			((0x38) & (~PIN_PULL_UD_EN & ~PIN_PULL_TYPE_SEL & ~PIN_RX_ACTIVE)) \
		) \
	},
	{PINMUX_INVALID_PIN}
};

static pinmuxModuleCfg_t gPru_icssPinCfg[] =
{
    {1, TRUE, gPru_icss1PinCfg},
    {CHIPDB_INVALID_INSTANCE_NUM}
};

#endif /* if defined(BUILDCFG_MOD_PRU_ICSS) */

#if defined(BUILDCFG_MOD_I2C)

static pinmuxPerCfg_t gI2c0PinCfg[] =
{
    {
        /* I2C 0 -> I2C0_SCL -> C16 */
        PIN_I2C0_SCL, 0, \
        ( \
            PIN_MODE(0) | \
            ((PIN_PULL_UD_EN | PIN_RX_ACTIVE) & (~PIN_PULL_TYPE_SEL)) \
        ) \
    },
    {
        /* I2C 0 -> I2C0_SDA -> C17 */
        PIN_I2C0_SDA, 0, \
        ( \
            PIN_MODE(0) | \
            ((PIN_PULL_UD_EN | PIN_RX_ACTIVE) & (~PIN_PULL_TYPE_SEL)) \
        ) \
    },
    {PINMUX_INVALID_PIN}
};

static pinmuxModuleCfg_t gI2cPinCfg[] =
{
    {0, TRUE, gI2c0PinCfg},
    {CHIPDB_INVALID_INSTANCE_NUM}
};

#endif /* if defined(BUILDCFG_MOD_I2C) */

#if defined(BUILDCFG_MOD_MCSPI)

static pinmuxPerCfg_t gMcspi0PinCfg[] =
{
	{
		/* My SPI 0 -> spi0_sclk -> A17 */
		PIN_SPI0_SCLK, 0, \
		( \
			PIN_MODE(0) | \
			((PIN_PULL_UD_EN | PIN_RX_ACTIVE) & (~PIN_PULL_TYPE_SEL)) \
		) \
	},
	{
		/* My SPI 0 -> spi0_d0 -> B17 */
		PIN_SPI0_D0, 0, \
		( \
			PIN_MODE(0) | \
			((PIN_PULL_UD_EN | PIN_RX_ACTIVE) & (~PIN_PULL_TYPE_SEL)) \
		) \
	},
	{
		/* My SPI 0 -> spi0_d1 -> B16 */
		PIN_SPI0_D1, 0, \
		( \
			PIN_MODE(0) | \
			((0x38) & (~PIN_PULL_UD_EN & ~PIN_PULL_TYPE_SEL & ~PIN_RX_ACTIVE)) \
		) \
	},
	{
		/* My SPI 0 -> spi0_cs0 -> A16 */
		PIN_SPI0_CS0, 0, \
		( \
			PIN_MODE(0) | \
			((0x38) & (~PIN_PULL_UD_EN & ~PIN_PULL_TYPE_SEL & ~PIN_RX_ACTIVE)) \
		) \
	},
	{
		/* My SPI 0 -> spi0_cs1 -> C15 */
		PIN_SPI0_CS1, 0, \
		( \
			PIN_MODE(0) | \
			((PIN_PULL_UD_EN | PIN_RX_ACTIVE) & (~PIN_PULL_TYPE_SEL)) \
		) \
	},
	{PINMUX_INVALID_PIN}
};
static pinmuxPerCfg_t gMcspi1PinCfg[] =
{
    {
       /* SPI1 -> spi1_sclk -> A13 */
       PIN_MCASP0_ACLKX, 0, \
       ( \
           PIN_MODE(3) | \
           ((PIN_PULL_UD_EN | PIN_RX_ACTIVE) & (~PIN_PULL_TYPE_SEL)) \
       ) \
    },
    {
       /* SPI1 -> spi1_d0 -> B13 */
       PIN_MCASP0_FSX, 0, \
       ( \
           PIN_MODE(3) | \
           ((PIN_PULL_UD_EN | PIN_RX_ACTIVE) & (~PIN_PULL_TYPE_SEL)) \
       ) \
    },
    {
       /* SPI1 -> spi1_d1 -> D12 */
       PIN_MCASP0_AXR0, 0, \
       ( \
           PIN_MODE(3) | \
           ((PIN_PULL_TYPE_SEL | PIN_RX_ACTIVE) & (~PIN_PULL_UD_EN)) \
       ) \
    },
    {
       /* SPI1 -> spi1_cs0 -> C12 */
       PIN_MCASP0_AHCLKR, 0, \
       ( \
           PIN_MODE(3) | \
           ((PIN_PULL_TYPE_SEL | PIN_RX_ACTIVE) & (~PIN_PULL_UD_EN)) \
       ) \
    },
    {PINMUX_INVALID_PIN}
};

static pinmuxModuleCfg_t gMcspiPinCfg[] =
{
    {0, TRUE, gMcspi0PinCfg},
    {1, TRUE, gMcspi1PinCfg},
    {CHIPDB_INVALID_INSTANCE_NUM}
};

#endif /* if defined(BUILDCFG_MOD_SPI) */
#if defined(BUILDCFG_MOD_MMCSD)

static pinmuxPerCfg_t gMmcsd0PinCfg[] =
{
    {
        /* MMC 0 -> mmc0_clk -> G17 */
        PIN_MMC0_CLK, 0, \
        ( \
            PIN_MODE(0) | \
            ((PIN_PULL_TYPE_SEL | PIN_RX_ACTIVE) & (~PIN_PULL_UD_EN)) \
        ) \
    },
    {
        /* MMC 0 -> mmc0_cmd -> G18 */
        PIN_MMC0_CMD, 0, \
        ( \
            PIN_MODE(0) | \
            ((PIN_PULL_TYPE_SEL | PIN_RX_ACTIVE) & (~PIN_PULL_UD_EN)) \
        ) \
    },
    {
        /* MMC 0 -> mmc0_dat0 -> G16 */
        PIN_MMC0_DAT0, 0, \
        ( \
            PIN_MODE(0) | \
            ((PIN_PULL_TYPE_SEL | PIN_RX_ACTIVE) & (~PIN_PULL_UD_EN)) \
        ) \
    },
    {
        /* MMC 0 -> mmc0_dat1 -> G15 */
        PIN_MMC0_DAT1, 0, \
        ( \
            PIN_MODE(0) | \
            ((PIN_PULL_TYPE_SEL | PIN_RX_ACTIVE) & (~PIN_PULL_UD_EN)) \
        ) \
    },
    {
        /* MMC 0 -> mmc0_dat2 -> F18 */
        PIN_MMC0_DAT2, 0, \
        ( \
            PIN_MODE(0) | \
            ((PIN_PULL_TYPE_SEL | PIN_RX_ACTIVE) & (~PIN_PULL_UD_EN)) \
        ) \
    },
    {
        /* MMC 0 -> mmc0_dat3 -> F17 */
        PIN_MMC0_DAT3, 0, \
        ( \
            PIN_MODE(0) | \
            ((PIN_PULL_TYPE_SEL | PIN_RX_ACTIVE) & (~PIN_PULL_UD_EN)) \
        ) \
    },
    {PINMUX_INVALID_PIN}
};

static pinmuxModuleCfg_t gMmcsdPinCfg[] =
{
    {0, TRUE, gMmcsd0PinCfg},
    {CHIPDB_INVALID_INSTANCE_NUM}
};

#endif /* if defined(BUILDCFG_MOD_MMCSD) */

/** EVM pin configurations for EVM */

pinmuxBoardCfg_t gIceV2PinmuxData[] =
{
#if defined(BUILDCFG_MOD_UART)
    {CHIPDB_MOD_ID_UART, gUartPinCfg},
#endif /* if defined(BUILDCFG_MOD_UART) */
#if defined(BUILDCFG_MOD_CPSW)
    {CHIPDB_MOD_ID_CPSW, gCpswPinCfg},
#endif /* if defined(BUILDCFG_MOD_CPSW) */

#if defined(BUILDCFG_MOD_GPMC)
	{CHIPDB_MOD_ID_GPMC, gGpmcPinCfg},
#endif /* if defined(BUILDCFG_MOD_GPMC) */
#if defined(BUILDCFG_MOD_GPIO)
    {CHIPDB_MOD_ID_GPIO, gGpioPinCfg},
#endif /* if defined(BUILDCFG_MOD_GPIO) */
#if defined(BUILDCFG_MOD_PRU_ICSS)
	{CHIPDB_MOD_ID_PRU_ICSS, gPru_icssPinCfg},
#endif /* if defined(BUILDCFG_MOD_PRU_ICSS) */
#if defined(BUILDCFG_MOD_I2C)
    {CHIPDB_MOD_ID_I2C, gI2cPinCfg},
#endif /* if defined(BUILDCFG_MOD_I2C) */
#if defined(BUILDCFG_MOD_MCSPI)
    {CHIPDB_MOD_ID_MCSPI, gMcspiPinCfg},
#endif /* if defined(BUILDCFG_MOD_SPI) */
#if defined(BUILDCFG_MOD_MMCSD)
    {CHIPDB_MOD_ID_MMCSD, gMmcsdPinCfg},
#endif /* if defined(BUILDCFG_MOD_MMCSD) */
    {CHIPDB_MOD_ID_INVALID}
};
