/*
 * dac.c
 *
 *  Created on: Jan 25, 2016
 *      Author: zeiss
 */

#include <stdint.h>
#include "dac.h"


static void output_low(uint16_t val) {

	__R30 &= ~val;
	__delay_cycles(2);
}

static void output_high(uint16_t val) {

	__R30 |= val;
	__delay_cycles(2);
}

static void send_8bit(uint8_t data8) {
	char i;

	for (i = 0; i < 8; i++)
	{
	   // consider leftmost bit
	   // set line high if bit is 1, low if bit is 0
	   if (data8 & 0x80)
		   output_high(SD_DI);
	   else
		   output_low(SD_DI);

	   // pulse clock to indicate that bit value should be read
	   output_low(SD_CLK);
	   output_high(SD_CLK);

	   // shift byte left so next bit will be leftmost
	   data8 <<= 1;
	}
}


static void send_24bit_data(uint16_t data) {

	int i;

	// select device
	output_low(SD_CS);

	// send bits 23..16
	if(data == STOP_DAC)
		send_8bit(0x01);
	else
		send_8bit(0x00);

	for (i = 0; i < 16; i++)
	{
	   // consider leftmost bit
	   // set line high if bit is 1, low if bit is 0
	   if (data & 0x8000)
		   output_high(SD_DI);
	   else
		   output_low(SD_DI);

	   // pulse clock to indicate that bit value should be read
	   output_low(SD_CLK);
	   output_high(SD_CLK);

	   // shift byte left so next bit will be leftmost
	   data <<= 1;
	}

	// deselect device
	output_high(SD_CS);
}


void dac_cmd(uint16_t dac_val) {

	volatile uint16_t dataA = 0;
	volatile uint16_t dataB = 0;

	output_high(SD_CS);
	send_24bit_data(dac_val);
}


