#define RTCSS_REG_BASE_ADDR        (0x44E3E000)
#define RTCSS_CTRL_REG             (RTCSS_REG_BASE_ADDR + 0x40)
#define RTCSS_OSC_REG              (RTCSS_REG_BASE_ADDR + 0x54)

#define DMTIMER1_1MS_BASE_ADDR      (0x44E31000)
#define DMTIMER_1MS_TPIR            (DMTIMER1_1MS_BASE_ADDR + 0x48)
#define DMTIMER_1MS_TNIR            (DMTIMER1_1MS_BASE_ADDR + 0x4C)
#define DMTIMER_1MS_TLDR            (DMTIMER1_1MS_BASE_ADDR + 0x2C)
#define DMTIMER_1MS_TCRR            (DMTIMER1_1MS_BASE_ADDR + 0x28)
#define DMTIMER_1MS_TCLR            (DMTIMER1_1MS_BASE_ADDR + 0x24)

#define CM_DPLL_BASE_ADDR           (0x44DF4200)
#define PRCM_CM_DPLL_DPLL_CLKSEL_TIMER1_CLK    (CM_DPLL_BASE_ADDR + 0x00)

#define CM_WKUP_BASE_ADDR           (0x44DF2800)
#define PRCM_CM_WKUP_TIMER1_CLKCTRL (CM_WKUP_BASE_ADDR + 0x328)

#define CONTROL_MODULE_BASE_ADDR    (0x44E10000)
#define CTRL_CONF_UART0_CTSN        (CONTROL_MODULE_BASE_ADDR + 0x968)
#define CTRL_CONF_ECAP0_IN_PWM0_OUT (CONTROL_MODULE_BASE_ADDR + 0x964)
/**
 * main.c
 */
int main(void)
{

    // init External 32k Clock
    *(volatile unsigned int *)RTCSS_CTRL_REG = 0x00;    // RTC enable
    *(volatile unsigned int *)RTCSS_OSC_REG |= 0x40;    // 32KCLK_EN
    *(volatile unsigned int *)RTCSS_CTRL_REG |= 0x40;   // RTC disable

    *(volatile unsigned int *)PRCM_CM_DPLL_DPLL_CLKSEL_TIMER1_CLK = 4; // set to external 32KHz clock
    while(PRCM_CM_DPLL_DPLL_CLKSEL_TIMER1_CLK & 4 != 4);                // wait for clock reset

    *(volatile unsigned int *)PRCM_CM_WKUP_TIMER1_CLKCTRL |= 2; // enable Timer1 module
    while(PRCM_CM_WKUP_TIMER1_CLKCTRL & 2 != 2);                // wait for enabling

    *(volatile unsigned int *)CTRL_CONF_ECAP0_IN_PWM0_OUT &= 0xFFFFFFF0;
    *(volatile unsigned int *)CTRL_CONF_ECAP0_IN_PWM0_OUT |= 9;        /* L25 pin  DM Timer 1̏o̓sɐݒ */

    *(volatile unsigned int *)DMTIMER_1MS_TPIR = 0x00038A40; //232000;
    *(volatile unsigned int *)DMTIMER_1MS_TNIR = 0xFFF44800; //-768000;
    *(volatile unsigned int *)DMTIMER_1MS_TLDR = 0xFFFFFFE0;
//    *(volatile unsigned int *)DMTIMER_1MS_TCRR = 0xFFFFFFE0;
    *(volatile unsigned int *)DMTIMER_1MS_TCLR |= 0x00001407; // start timer
    *(volatile unsigned int *)DMTIMER_1MS_TCRR |= 0xFFFFFFE0; // start timer

    while(1);
}
