#include <xdc/std.h>

#include <ti/sysbios/BIOS.h>
#include <ti/sysbios/knl/Task.h>
#include <ti/sysbios/hal/Timer.h>
#include <ti/osal/osal.h>


int counter = 0;
int TaskSleepReturned = 0;
unsigned int taskEntered = 0;

#define TIMER_ID  10

TimerP_Params   delayTimerParams;
TimerP_Handle   delayTimerHandle;

unsigned int newvalue, oldvalue = 0, delta[1000];

void TimerFunction(void* arg)
{
  newvalue = ARM_CCNT_Read();
  delta[(counter++)%1000] = newvalue - oldvalue;
  oldvalue = newvalue;
}

void delayTimerSetup()
{
    TimerP_Params_init(&delayTimerParams);

    delayTimerParams.period = 10;  // 1s
    delayTimerParams.periodType = TimerP_PeriodType_MICROSECS;
    delayTimerParams.arg = 0;

    delayTimerParams.startMode = TimerP_StartMode_AUTO;
    delayTimerParams.runMode = TimerP_RunMode_CONTINUOUS;
    delayTimerHandle = TimerP_create(TIMER_ID,
                                     (TimerP_Fxn)&TimerFunction,
                                     &delayTimerParams);

}

Void taskFxn(UArg a0, UArg a1)
{
  taskEntered = 1;
  delayTimerSetup();
  Task_sleep(10000);
  TaskSleepReturned = 1;
}

Int main()
{ 
    ARM_CCNT_Enable();
    BIOS_start();

    return(0);
}
