//---------------------------------------------------------------------------------------------------------------------
// Copyright IEOS Ltd. 2010-2018 Moscow, Russian Federation  (www.ieos.ru)
//    Alexander Norokh 2017-2018
//---------------------------------------------------------------------------------------------------------------------
//    DSS
//   DisplayDSS( void )
//---------------------------------------------------------------------------------------------------------------------
void DSS_Init_Path( void )
{
    DispApp_Obj *appObj = NULL;

    DispApp_init( appObj );
    // ->>> -------------------------------------------------------------
               BspUtils_appDefaultInit( isI2cInitReq );
               // ->>> ---------------------------------------------
                        BspCommonInitParams_init( &commonInitPrms );
                        Bsp_commonInit          ( &commonInitPrms );

                        BspBoardInitParams_init ( &boardInitPrms  );
                        Bsp_boardInit           ( &boardInitPrms  );

                        BspPlatformInitParams_init( &platInitPrms ); //
                        Bsp_platformInit          ( &platInitPrms );

                        //    FVID2
                        //   Display Controller
                        Fvid2_init( NULL );

                        VpsInitParams_init( &vpsInitPrms );

                        Vps_init( &vpsInitPrms );
                            // ->>> ------------------------------------
                            vpsInitTda3xxPlatData();
                            VpsInitParams_init( &localInitPrms ); //    
                            VpsLib_init(&vpsLibInitPrms);

                            //------------------------------------------

                        //  I2C
                        BspUtils_memInit();
                        BspUtils_prfInit();
                        BspUtils_appInit();
                        BspUtils_uartInit();
                        BspOsal_Init( &bspOsalInitPrms );
               //---------------------------------------------------
               appObj->dctrlHandle = Fvid2_create;
               DispApp_configureVideoPllAndClkSrc( appObj, defPixelClk );
               Bsp_platformEnableHdmiPll(TRUE);
               DispApp_LoadBuf( appObj, &gDispDssLoadBufCfg[bufCfgId] );
    //--------------------------------------------------------------------
    Bsp_boardGetId();
    //      
    testId = DispApp_getTestId( appObj );
    //    
    DispApp_runTest( appObj, testPrms );
    //  
    DispApp_deInit( appObj );
};
//---------------------------------------------------------------------------------------------------------------------
[Cortex_M4_IPU1_C0] enter main()
Error Init >>>
Task create >>>
: Sample Application - STARTS !!!
inside DispApp_init -> try BspUtils_appDefaultInit...
Starting BspUtils_appDefaultInit
Starting Bsp_commonInit
...over...start BspBoardInitParams_init
Board Init normal.
BspPlatformInitParams_init done.
       Platform Init done.
       FVID2 Init done.
VpsInitParams_init done.
start Vps_init...
--------------------------------------------
Inside Vps_init - try vpsInitTda3xxPlatData
inside vpsInitTda3xxPlatData...
End vpsInitTda3xxPlatData...
Try VpsLib_init...
Inside VpsLib_init...->BspUtils_memset
VpsHal_init done.




//---------------------------------------------------------------------------------------------------------------------
