//---------------------------------------------------------------------------------------------------------------------
// Copyright IEOS Ltd. 2010-2018 Moscow, Russian Federation  (www.ieos.ru)
//    Alexander Norokh 2017-2018
//---------------------------------------------------------------------------------------------------------------------
//  This file contains Videopll LIB API Implementation.
//---------------------------------------------------------------------------------------------------------------------
#include <stdint.h>
#include "hw_types.h"
#include "soc.h"
#include "pmhal_prcm.h"
#include "pmhal_cm.h"
#include "pm_utils.h"
#include "pmlib_videopll_data.h"
#include "pmlib_videopll.h"
#include "pmlib_clkrate.h"
//---------------------------------------------------------------------------------------------------------------------
int32_t PMLIBVideopllSetFreq(pmhalPrcmNodeId_t videopllId,
                             uint32_t          freq,
                             uint32_t          maxOrMinMN,
                             uint32_t          timeOut)
{
    int32_t retVal = PM_FAIL;

    if ((PMHAL_PRCM_VIDEOPLL_MIN <= videopllId) && (PMHAL_PRCM_VIDEOPLL_COUNT > videopllId))
    {
        /* For TDA3xx the DSS video clock is sourced from the device DPLLs
         * Hence use the PMHAL CM APIs to be able to program the video clock
         * frequency.
         */
        pmhalPrcmDpllConfig_t      pllParams;
        pmhalPrcmPllPostDivValue_t postDivConfig[
            PMLIB_VIDEOPLL_DATA_MAX_POST_DIV_ID];
        uint32_t postdiv = PMHAL_PRCM_DPLL_POST_DIV_INVALID;

        pllParams.postDivConfList = postDivConfig;
        /* For the given frequency find the configuration to program the
         * DPLL.
         */
        retVal = PmlibVideopllGetpllStructure(freq, maxOrMinMN,
                                              &pllParams, &postdiv);

        if (PM_SUCCESS == retVal)
        {
            retVal += PMHALCMDpllConfigure(PMHAL_PRCM_DPLL_EVE_VID_DSP,
                                           &pllParams,
                                           timeOut);

            retVal += PMHALCMDpllSetClockDivider(PMHAL_PRCM_DIV_VID_PIX_CLK,
                                                 postdiv);
        }
    }
    else
    {
        retVal = PM_BADARGS;
    }
    return retVal;
}
//---------------------------------------------------------------------------------------------------------------------
