//---------------------------------------------------------------------------------------------------------------------
// Copyright IEOS Ltd. 2010-2018 Moscow, Russian Federation  (www.ieos.ru)
//    Alexander Norokh 2017-2018
//---------------------------------------------------------------------------------------------------------------------
//  LCD Controller internal header file.
//---------------------------------------------------------------------------------------------------------------------
#ifndef BSP_LCDCTRL_PRIV_H_
#define BSP_LCDCTRL_PRIV_H_
//---------------------------------------------------------------------------------------------------------------------
#include <ti/drv/vps/include/common/bsp_types.h>
#include <ti/drv/vps/include/common/bsp_config.h>
#include <ti/drv/vps/include/common/trace.h>
#include <ti/drv/vps/include/osal/bsp_osal.h>
#include <ti/drv/vps/include/common/bsp_utils.h>
#include "fvid2_dataTypes.h"
#include <ti/drv/vps/include/platforms/bsp_platform.h>
#include <ti/drv/vps/include/devices/bsp_device.h>
#include <ti/drv/vps/include/devices/bsp_lcdController.h>
#include <ti/drv/vps/src/devices/lcdCtrl/bspdrv_lcdCtrl.h>
#include <ti/drv/vps/src/devices/tlc59108/bsp_tlc59108.h>
//---------------------------------------------------------------------------------------------------------------------
#ifdef __cplusplus
extern "C" {
#endif
//---------------------------------------------------------------------------------------------------------------------
#define BSP_LCDCTRL_THREEFIVE_ENBKL       ((UInt32) BSP_TLC59108_PIN0)
#define BSP_LCDCTRL_THREEFIVE_AVDD_EN     ((UInt32) BSP_TLC59108_PIN1)
#define BSP_LCDCTRL_THREEFIVE_PWM         ((UInt32) BSP_TLC59108_PIN2)
#define BSP_LCDCTRL_THREEFIVE_STBYB       ((UInt32) BSP_TLC59108_PIN3)
#define BSP_LCDCTRL_THREEFIVE_UPDN        ((UInt32) BSP_TLC59108_PIN4)
#define BSP_LCDCTRL_THREEFIVE_DITH        ((UInt32) BSP_TLC59108_PIN5)
#define BSP_LCDCTRL_THREEFIVE_MODE3       ((UInt32) BSP_TLC59108_PIN6)
#define BSP_LCDCTRL_THREEFIVE_SHLR        ((UInt32) BSP_TLC59108_PIN7)
#define BSP_LCDCTRL_TLC59108_INST_0       (0x0)
#define BSP_LCDCTRL_TLC59108_INST_1       (0x1)

/** \brief Driver object state - NOT IN USE. */
#define BSP_LCDCTRL_OBJ_STATE_UNUSED    (0U)
/** \brief Driver object state - IN USE and IDLE. */
#define BSP_LCDCTRL_OBJ_STATE_IDLE      (1U)
//---------------------------------------------------------------------------------------------------------------------
/**
 *  \brief TVP5158 driver handle object.
 */
typedef struct
{
    UInt32                  state;
    /**< Handle state - used or free. */
    UInt32                  handleId;
    /**< Handle ID, 0..BSP_DEVICE_MAX_HANDLES-1. */
    BspOsal_SemHandle       lock;
    /**< Driver lock. */
    Bsp_LcdCtrlCreateParams createPrms;
    /**< Create time arguments. */
} Bsp_LcdCtrlHandleObj;

/**
 *  \brief TVP5158 Global driver object.
 */
typedef struct
{
    BspOsal_SemHandle    lock;
    /* Global driver lock. */
    Bsp_LcdCtrlHandleObj handlePool[BSP_DEVICE_MAX_HANDLES];
    /**< Handle objects. */
} Bsp_LcdCtrlObj;

/* ========================================================================== */
/*                          Function Declarations                             */
/* ========================================================================== */
void Tc358778_lcdBridgeInit(UInt32 deviceI2cInstId, UInt32 slaveAddr, UInt32 peripheralCmdOn);
void Tc358778_lcdBridgeDeinit(UInt32 deviceI2cInstId, UInt32 slaveAddr);

#ifdef __cplusplus
}
#endif

#endif  /* #ifndef BSP_LCDCTRL_PRIV_H_ */
