//---------------------------------------------------------------------------------------------------------------------
// Copyright IEOS Ltd. 2010-2018 Moscow, Russian Federation  (www.ieos.ru)
//    Alexander Norokh 2017-2018
//---------------------------------------------------------------------------------------------------------------------
//
//---------------------------------------------------------------------------------------------------------------------
#if defined (BARE_METAL)
#include <ti/csl/tistdtypes.h>
#else
#include <xdc/std.h>
#endif

#include <ti/drv/vps/include/common/bsp_types.h>
#include <ti/drv/vps/include/vps.h>
#include <ti/drv/vps/include/platforms/bsp_platform.h>
#include <ti/drv/vps/examples/utility/bsputils_mem.h>

    #ifdef PLATFORM_ZEBU
#define BSPUTILS_MEM_FRAME_HEAP_SIZE    (64U * MB)
    #else
#define BSPUTILS_MEM_FRAME_HEAP_SIZE    (240U * MB)
    #endif

#define BSPUTILS_MEM_FRAME_HEAP_SIZE_12x12  (48U * MB)

#ifdef CUSTOM_MEM_FRAME_HEAP_SIZE
#undef BSPUTILS_MEM_FRAME_HEAP_SIZE
#define BSPUTILS_MEM_FRAME_HEAP_SIZE    (CUSTOM_MEM_FRAME_HEAP_SIZE * MB)
#endif
//---------------------------------------------------------------------------------------------------------------------
/* Memory pool */
/* Align descriptor memory with that of VPDMA requirement. */
/* Place the frame heap in frame buffer section. */
#ifdef __cplusplus
#pragma DATA_ALIGN(VPS_BUFFER_ALIGNMENT_RECOMMENDED)
#pragma DATA_SECTION(".bss:frameBuffer");
#else
#pragma DATA_ALIGN(gBspUtils_heapMemFrame, VPS_BUFFER_ALIGNMENT_RECOMMENDED)
#pragma DATA_SECTION(gBspUtils_heapMemFrame,".bss:frameBuffer");
#endif  /* #ifdef __cplusplus */
//---------------------------------------------------------------------------------------------------------------------
UInt32 gBspUtils_heapMemFrame[(UInt32) BSPUTILS_MEM_FRAME_HEAP_SIZE / (UInt32) sizeof (UInt32)];
//---------------------------------------------------------------------------------------------------------------------
Int32 BspUtils_memInit(void)
{
    UInt32 memSize;

    memSize = sizeof (gBspUtils_heapMemFrame);
    /* In case of TDA3xx 12x12 package, only 64MB DDR is present */
    if (Bsp_platformGetPackageType() == BSP_PLATFORM_PACKAGE_TYPE_12x12)
    {
        /* Out of 64MB, 16MB is used for code/data/descriptor */
        memSize = BSPUTILS_MEM_FRAME_HEAP_SIZE_12x12;
    }

    BspUtils_memInit_internal(gBspUtils_heapMemFrame, memSize);
    return 0;
}
//---------------------------------------------------------------------------------------------------------------------

