//---------------------------------------------------------------------------------------------------------------------
// Copyright IEOS Ltd. 2010-2018 Moscow, Russian Federation  (www.ieos.ru)
//    Alexander Norokh 2017-2018
//---------------------------------------------------------------------------------------------------------------------
//  Source file for the Resource Manager, for internal data structures.
//---------------------------------------------------------------------------------------------------------------------
/* Resource Manager Internal Header Files */
#include <ti/sdo/edma3/rm/src/edma3resmgr.h>
//---------------------------------------------------------------------------------------------------------------------
/**
 * Maximum Resource Manager Instances supported by the EDMA3 Package.
 * USE THE SAME VALUE FOR BOTH THE #DEFINE AND CONST UNSIGNED INT BELOW.
 */
/* This #define is needed for array declarations. */
#define MAX_EDMA3_RM_INSTANCES (8U)
/* This const is required to access this constant in other header files */
const uint32_t EDMA3_MAX_RM_INSTANCES = 8U;

/**
 * \brief Region Specific Configuration structure for
 * EDMA3 controller, to provide region specific Information.
 *
 * This configuration info can also be provided by the user at run-time,
 * while calling EDMA3_RM_open (). If not provided at run-time,
 * this info will be taken from the config file "edma3_<PLATFORM_NAME>_cfg.c",
 * for the specified platform.
 */
#ifdef BUILD_C6XDSP
#pragma DATA_SECTION(userInstInitConfigArray, ".fardata:.edma3Globals");
#endif
EDMA3_RM_InstanceInitConfig userInstInitConfigArray[EDMA3_MAX_EDMA3_INSTANCES][MAX_EDMA3_RM_INSTANCES];


/**
 * Handles of EDMA3 Resource Manager Instances.
 *
 * Used to maintain information of the EDMA3 RM Instances
 * for each HW controller.
 * There could be a maximum of EDMA3_MAX_RM_INSTANCES instances per
 * EDMA3 HW.
 */
#ifdef BUILD_C6XDSP
#pragma DATA_SECTION(resMgrInstanceArray, ".fardata:.edma3Globals");
#endif
EDMA3_RM_Instance resMgrInstanceArray[EDMA3_MAX_EDMA3_INSTANCES][MAX_EDMA3_RM_INSTANCES];

/* These pointers will be used to refer the above mentioned arrays. */
#ifdef BUILD_C6XDSP
#pragma DATA_SECTION(resMgrInstance, ".fardata:.edma3Globals");
#pragma DATA_SECTION(userInitConfig, ".fardata:.edma3Globals");
#endif
EDMA3_RM_Instance *resMgrInstance = (EDMA3_RM_Instance *)resMgrInstanceArray;
EDMA3_RM_InstanceInitConfig *userInitConfig = (EDMA3_RM_InstanceInitConfig *)userInstInitConfigArray;

/* Pointer to the above mentioned 2-D arrays, used for address calculation purpose */
#ifdef BUILD_C6XDSP
#pragma DATA_SECTION(ptrRMIArray, ".fardata:.edma3Globals");
#pragma DATA_SECTION(ptrInitCfgArray, ".fardata:.edma3Globals");
#endif
EDMA3_RM_Instance *ptrRMIArray = (EDMA3_RM_Instance *)resMgrInstanceArray;
EDMA3_RM_InstanceInitConfig *ptrInitCfgArray = (EDMA3_RM_InstanceInitConfig *)userInstInitConfigArray;
