//---------------------------------------------------------------------------------------------------------------------
// Copyright IEOS Ltd. 2010-2018 Moscow, Russian Federation  (www.ieos.ru)
//    Alexander Norokh 2017-2018
//---------------------------------------------------------------------------------------------------------------------
// BSP device private header file.
//---------------------------------------------------------------------------------------------------------------------
#ifndef BSP_DEVICE_PRIV_H_
#define BSP_DEVICE_PRIV_H_
//---------------------------------------------------------------------------------------------------------------------
//#ifndef VPS_TI_RTOS_I2C
//#include <ti/csl/tistdtypes.h>
//#include <ti/drv/i2c/I2C.h>
//#else
#include <xdc/std.h>
#include <xdc/runtime/Error.h>
#include <xdc/runtime/Memory.h>
#include <xdc/runtime/Log.h>
#include <xdc/runtime/System.h>
#include <ti/sysbios/io/GIO.h>
#include <ti/sysbios/io/IOM.h>
#include <ti/sysbios/syncs/SyncSem.h>
#include <ti/sysbios/knl/Semaphore.h>
//#endif

#include "bsp_types.h"
#include "bsp_utils.h"
#include "bsp_osal.h"
#include "trace.h"
#include "bsp_config.h"
#include "bsp_platform.h"
#include "bsp_board.h"
//---------------------------------------------------------------------------------------------------------------------
#include "bsp_i2c.h"
//---------------------------------------------------------------------------------------------------------------------
#include "bsp_device.h"
//---------------------------------------------------------------------------------------------------------------------
#ifdef __cplusplus
extern "C" {
#endif
//---------------------------------------------------------------------------------------------------------------------
//#if !defined (VPS_TI_RTOS_I2C)
// GIO_Params_init will initialize the async packet to 2.
#define I2C_ASYNC_IOM_PACKET_MAX                                            (2U)
//#endif
//---------------------------------------------------------------------------------------------------------------------
typedef struct
{
    UInt32            i2cDebugEnable;
//#if defined (VPS_TI_RTOS_I2C)
//  I2C_Handle        i2cHndl          [BSP_DEVICE_I2C_INST_ID_MAX];
//#else
    GIO_Handle        i2cHndl          [BSP_DEVICE_I2C_INST_ID_MAX];
    GIO_Struct        i2cGioStruct     [BSP_DEVICE_I2C_INST_ID_MAX];
    SyncSem_Struct    i2cSyncSemStruct [BSP_DEVICE_I2C_INST_ID_MAX];
    Semaphore_Struct  i2cSemStruct     [BSP_DEVICE_I2C_INST_ID_MAX];
    IOM_Packet        i2cIomPacket     [BSP_DEVICE_I2C_INST_ID_MAX][I2C_ASYNC_IOM_PACKET_MAX];
//#endif
    BspOsal_SemHandle i2cHndlLock      [BSP_DEVICE_I2C_INST_ID_MAX];
} Bsp_DeviceObj;
//---------------------------------------------------------------------------------------------------------------------
Int32 Bsp_deviceI2cInit  ( void );
Int32 Bsp_deviceI2cDeInit( void );
//---------------------------------------------------------------------------------------------------------------------
#ifdef __cplusplus
}
#endif
//#endif
#endif /* #ifndef BSP_DEVICE_PRIV_H_ */
