//---------------------------------------------------------------------------------------------------------------------
// Copyright IEOS Ltd. 2010-2018 Moscow, Russian Federation  (www.ieos.ru)
//    Alexander Norokh 2017-2018
//---------------------------------------------------------------------------------------------------------------------
//
//---------------------------------------------------------------------------------------------------------------------
#ifndef BSP_TYPES_H_
#define BSP_TYPES_H_

#ifdef __cplusplus
extern "C" {
#endif
/*
 * =========== Error codes returned by BSP functions ===========
 */
/** \brief BSP return type for OK */
#define BSP_SOK                         (0)
/** \brief BSP return type for FAIL */
#define BSP_EFAIL                       (-1)
/** \brief BSP return type for Bad Arguments */
#define BSP_EBADARGS                    (-2)
/** \brief BSP return type for BInvalid Parameters */
#define BSP_EINVALID_PARAMS             (-3)
/** \brief BSP return type for Device In Use */
#define BSP_EDEVICE_INUSE               (-4)
/** \brief BSP return type for Timeout */
#define BSP_ETIMEOUT                    (-5)
/** \brief BSP return type for Alloc error */
#define BSP_EALLOC                      (-6)
/** \brief BSP return type for Out of Range */
#define BSP_EOUT_OF_RANGE               (-7)
/** \brief BSP return type for Try Again */
#define BSP_EAGAIN                      (-8)
/** \brief BSP return type for Unsupported Command */
#define BSP_EUNSUPPORTED_CMD            (-9)
/** \brief BSP return type for Nomore Buffers */
#define BSP_ENO_MORE_BUFFERS            (-10)
/** \brief BSP return type for Unsupported option */
#define BSP_EUNSUPPORTED_OPS            (-11)
/** \brief BSP return type for Driver in Use */
#define BSP_EDRIVER_INUSE               (-12)
/** \brief BSP return type for Non Recommended parameters */
#define BSP_WNON_RECOMMENDED_PARAMS     (-13)

#ifdef __cplusplus
}
#endif

#endif /* #ifndef BSP_TYPES_H_ */
