//---------------------------------------------------------------------------------------------------------------------
// Copyright IEOS Ltd. 2010-2018 Moscow, Russian Federation  (www.ieos.ru)
//    Alexander Norokh 2017-2018
//---------------------------------------------------------------------------------------------------------------------
//
//---------------------------------------------------------------------------------------------------------------------
/**
 *  \ingroup BSPUTILS_API
 *  \defgroup BSPUTILS_FILEIO_API File IO helper APIs
 *  @{
 */

/**
 *  \file bsputils_fileio.h
 *
 *  \brief Header file to use helper functions for accessing the sd card.
 *
 */

#ifndef BSPUTILS_FILE_IO_H_
#define BSPUTILS_FILE_IO_H_


#include "tistdtypes.h"

#ifdef __cplusplus
extern "C" {
#endif

/**
 *  \brief Function to initialize sd card
 *
 *  \param hEdma            [IN]    handle for edma3lld.
 *
 *  \return BSP_SOK on success else appropiate error code on failure.
 */
Int32 BspUtils_initFileio(void *hEdma);

/**
 *  \brief Function to deinitialize sd card
 *
 *  \return BSP_SOK on success else appropiate error code on failure.
 */
Int32 BspUtils_deinitFileio(void);

/**
 *  \brief Function to load buffers from file in sd card
 *
 *  \param fileName         [IN]    File name string.
 *  \param dirName          [IN]    Directory name string.
 *  \param bufAddr          [IN]    Address of buffer to load the file content.
 *  \param bufSize          [IN]    Size of buffer to load the file content.
 *  \param bytesRead        [OUT]   Returns number of bytes read from file.
 */
Int32 BspUtils_appLoadFileFromSd(const Char *fileName,
                                 const Char *dirName,
                                 void       *bufAddr,
                                 UInt32      bufSize,
                                 UInt32     *bytesRead);

/**
 *  \brief Function to save buffers to file in SD card
 *
 *  \param fileName         [IN]    File name string.
 *  \param dirName          [IN]    Directory name string.
 *  \param bufAddr          [IN]    Address of buffer to save in file
 *  \param bufSize          [IN]    Size of buffer to save the content in file.
 *  \param bytesWritten     [OUT]   Returns number of bytes written to file.
 */
Int32 BspUtils_appSaveFileToSd(const Char *fileName,
                               const Char *dirName,
                               const void *bufAddr,
                               UInt32      bufSize,
                               UInt32     *bytesWritten);

#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif

/* @} */

