//---------------------------------------------------------------------------------------------------------------------
// Copyright IEOS Ltd. 2010-2018 Moscow, Russian Federation  (www.ieos.ru)
//    Alexander Norokh 2017-2018
//---------------------------------------------------------------------------------------------------------------------
// Implements the Tda3xx platform specific functions.
//---------------------------------------------------------------------------------------------------------------------
#ifndef CSL_ARCH_TOP_H_
#define CSL_ARCH_TOP_H_

#include "csl.h"
#include "tistdtypes.h"

#if defined (SOC_AM572x) || defined (SOC_TDA2XX) || defined (SOC_TDA2PX) || defined (SOC_DRA75x) || defined (SOC_AM571x) || defined (SOC_TDA2EX) || defined (SOC_DRA72x) || defined (SOC_TDA3XX) || defined (SOC_DRA78x) || defined (SOC_OMAPL137) || defined (SOC_OMAPL138)

#if defined (__TI_ARM_V7M4__)
#include "interrupt.h"
#include "ipu_wugen.h"
#include "ammu.h"
#include "unicache.h"
#include "ipu_ecc.h"
/* Need DSP SYSCONFIG for PM */
#include "hw_dsp_system.h"
#endif

#if defined (_TMS320C6X)
#include <ti/csl/arch/c66x/hw_dsp_icfg.h>
#include <ti/csl/arch/c66x/hw_dsp_system.h>
#include <ti/csl/arch/c66x/dsp_config.h>
#include <ti/csl/arch/c66x/dsp_wugen.h>
#include <ti/csl/arch/c66x/interrupt.h>
#include <ti/csl/arch/c66x/hw_xmc.h>
#include <ti/csl/arch/c66x/dsp_ecc.h>
#include <ti/csl/arch/c66x/dsp_icfg.h>
#include <ti/csl/arch/c66x/dsp_usrSpvSupport.h>
#include <ti/csl/arch/c66x/dsp_xmc.h>

#endif


#if defined (BUILD_ARP32)
#include <ti/csl/arch/arp32/arp32_wugen.h>
#include <ti/csl/arch/arp32/intctl.h>
#include <ti/csl/arch/arp32/interrupt.h>
#include <ti/csl/arch/arp32/inth.h>
/* Need DSP SYSCONFIG for PM */
#include <ti/csl/arch/c66x/hw_dsp_system.h>
#endif

#endif
#endif

