//---------------------------------------------------------------------------------------------------------------------
// Copyright IEOS Ltd. 2010-2018 Moscow, Russian Federation  (www.ieos.ru)
//    Alexander Norokh 2017-2018
//---------------------------------------------------------------------------------------------------------------------
//
//---------------------------------------------------------------------------------------------------------------------
#ifndef CSL_DEVICE_COMMON_H
#define CSL_DEVICE_COMMON_H

#include <stdlib.h>
#include <stdint.h>

typedef enum
{
    CSL_SOC_SILICON_PACKAGE_TYPE_UNKNOWN = 0,
    /**< Silicon Package type is Invalid */
    CSL_SOC_SILICON_PACKAGE_TYPE_12X12   = 1,
    /**< Silicon Package type is 12x12 */
    CSL_SOC_SILICON_PACKAGE_TYPE_15X15   = 2,
    /**< Silicon Package type is 15x15 */
    CSL_SOC_SILICON_PACKAGE_TYPE_17X17   = 3,
    /**< Silicon Package type is 17x17 */
    CSL_SOC_SILICON_PACKAGE_TYPE_23X23   = 4
    /**< Silicon Package type is 23x23 */
} CSL_SocSiliconPackageType;

#define  CSL_SOC_SILICON_REV_1_0     (0U)
#define  CSL_SOC_SILICON_REV_1_0_A   (1U)
#define  CSL_SOC_SILICON_REV_2_0     (2U)
#define  CSL_SOC_SILICON_REV_UNKNOWN (0xFFFFFFFFU)

uint32_t CSL_getSocSiliconPackageType( void );
uint32_t CSL_getSocSiliconRev        ( void );

#endif
