
#ifndef CSLR_OCMCECC_H
#define CSLR_OCMCECC_H

#ifdef __cplusplus
extern "C"
{
#endif
#include "cslr.h"
#include "tistdtypes.h"


/**************************************************************************
* Register Overlay Structure for CBUF_SETUP_REG_BLOCK
**************************************************************************/
typedef struct {
    volatile Uint32 CBUF_VBUF_START_ADDR;
    volatile Uint32 CBUF_VBUF_END_ADDR;
    volatile Uint32 CBUF_OCMC_START_ADDR;
    volatile Uint32 CBUF_OCMC_BUF_SIZE;
} CSL_OcmceccCbuf_setup_reg_blockRegs;


/**************************************************************************
* Register Overlay Structure for CBUF_LAST_RD_WR_ADDR_REG_BLOCK
**************************************************************************/
typedef struct {
    volatile Uint32 CBUF_LAST_WR_ADDR;
    volatile Uint32 CBUF_LAST_RD_ADDR;
} CSL_OcmceccCbuf_last_rd_wr_addr_reg_blockRegs;


/**************************************************************************
* Register Overlay Structure for LAST_ILLEGAL_OCMC_ADDR_REG_BLOCK
**************************************************************************/
typedef struct {
    volatile Uint32 LAST_ILLEGAL_OCMC_ADDR;
} CSL_OcmceccLast_illegal_ocmc_addr_reg_blockRegs;


/**************************************************************************
* Register Overlay Structure
**************************************************************************/
typedef struct {
    volatile Uint32 OCMC_ECC_PID;
    volatile Uint32 OCMC_SYSCONFIG_PM;
    volatile Uint32 OCMC_SYSCONFIG_RST;
    volatile Uint32 OCMC_MEM_SIZE_READ;
    volatile Uint8  RSVD0[48];
    volatile Uint32 INTR0_STATUS_RAW_SET;
    volatile Uint32 INTR0_STATUS_ENABLED_CLEAR;
    volatile Uint32 INTR0_ENABLE_SET;
    volatile Uint32 INTR0_ENABLE_CLEAR;
    volatile Uint32 INTR0_EOI;
    volatile Uint8  RSVD1[12];
    volatile Uint32 INTR1_STATUS_RAW_SET;
    volatile Uint32 INTR1_STATUS_ENABLED_CLEAR;
    volatile Uint32 INTR1_ENABLE_SET;
    volatile Uint32 INTR1_ENABLE_CLEAR;
    volatile Uint32 INTR1_EOI;
    volatile Uint8  RSVD2[12];
    volatile Uint32 CFG_OCMC_ECC;
    volatile Uint32 CFG_OCMC_ECC_MEM_BLK;
    volatile Uint32 CFG_OCMC_ECC_ERROR;
    volatile Uint32 CFG_OCMC_ECC_CLEAR_HIST;
    volatile Uint32 STATUS_ERROR_CNT;
    volatile Uint32 STATUS_SEC_ERROR_TRACE;
    volatile Uint32 STATUS_DED_ERROR_TRACE;
    volatile Uint32 STATUS_ADDR_TRANSLATION_ERROR_TRACE;
    volatile Uint32 STATUS_SEC_ERROR_DISTR_0;
    volatile Uint32 STATUS_SEC_ERROR_DISTR_1;
    volatile Uint32 STATUS_SEC_ERROR_DISTR_2;
    volatile Uint32 STATUS_SEC_ERROR_DISTR_3;
    volatile Uint32 STATUS_SEC_ERROR_DISTR_4;
    volatile Uint8  RSVD3[332];
    volatile Uint32 CFG_OCMC_CBUF_EN;
    volatile Uint32 CFG_OCMC_CBUF_RESET;
    volatile Uint32 CFG_OCMC_CBUF_ERR_HANDLER;
    volatile Uint32 STATUS_CBUF_WR_OUT_OF_RANGE_ERR;
    volatile Uint32 STATUS_CBUF_WR_VBUF_START_ERR;
    volatile Uint32 STATUS_CBUF_WR_ADDR_SEQ_ERROR;
    volatile Uint32 STATUS_CBUF_RD_OUT_OF_RANGE_ERROR;
    volatile Uint32 STATUS_CBUF_VBUF_RD_START_ERROR;
    volatile Uint32 STATUS_CBUF_RD_ADDR_SEQ_ERROR;
    volatile Uint32 STATUS_CBUF_OVERFLOW_MID;
    volatile Uint32 STATUS_CBUF_OVERFLOW_WRAP;
    volatile Uint32 STATUS_CBUF_UNDERFLOW;
    volatile Uint32 STATUS_CBUF_SHORT_FRAME_DETECT;
    volatile Uint8  RSVD4[12];
    CSL_OcmceccCbuf_setup_reg_blockRegs	CBUF_SETUP_REG_BLOCK[12];
    CSL_OcmceccCbuf_last_rd_wr_addr_reg_blockRegs	CBUF_LAST_RD_WR_ADDR_REG_BLOCK[12];
    CSL_OcmceccLast_illegal_ocmc_addr_reg_blockRegs	LAST_ILLEGAL_OCMC_ADDR_REG_BLOCK;
} CSL_OcmcEccRegs;




/**************************************************************************
* Register Macros
**************************************************************************/

/* OCMC_ECC_PID */
#define CSL_OCMCECC_OCMC_ECC_PID                                (0x0U)

/* OCMC_SYSCONFIG_PM */
#define CSL_OCMCECC_OCMC_SYSCONFIG_PM                           (0x4U)

/* OCMC_SYSCONFIG_RST */
#define CSL_OCMCECC_OCMC_SYSCONFIG_RST                          (0x8U)

/* This register provides the status of the OCMC_ECC compile configuration. 
 * Notes: • Accessing beyond the memory size reported here will result in an 
 * address error interrupt. • If mem_ecc_enable reports a value of “1”, then 
 * all ECC related registers are to be considered as “RESERVED”. • Similarly, 
 * if mem_cbuf_enable reports a value of “1”, then all CBUF related registers 
 * are to be considered as “RESERVED”. */
#define CSL_OCMCECC_OCMC_MEM_SIZE_READ                          (0xCU)

/* This register contains the raw interrupt status as defined in HL0.8 Read 
 * indicates RAW interrupt status (0=inactive, 1=active). Writing 1 will SET 
 * the corresponding raw status bit (soft interrupt set). Writing 0 has no 
 * effect. */
#define CSL_OCMCECC_INTR0_STATUS_RAW_SET                        (0x40U)

/* This register contains the EOI vector register contents as defined by HL0.8 */
#define CSL_OCMCECC_INTR0_EOI                                   (0x50U)

/* Read indicates ENABLED interrupt status (0=inactive, 1=active). Writing 1 
 * will CLEAR the corresponding enabled status bit. Writing 0 has no effect. */
#define CSL_OCMCECC_INTR0_STATUS_ENABLED_CLEAR                  (0x44U)

/* Read indicates interrupt enable (0=disabled, 1=enabled) Writing 1 will set 
 * the corresponding interrupt enable bit. Writing 0 has no effect. 
 * Interrupt_enable_set */
#define CSL_OCMCECC_INTR0_ENABLE_SET                            (0x48U)

/* Read indicates interrupt enable (0=disabled, 1=enabled) Writing 1 will 
 * clear interrupt enabled. Writing 0 has no effect. Interrupt_enable_clear */
#define CSL_OCMCECC_INTR0_ENABLE_CLEAR                          (0x4CU)

/* This register contains the raw interrupt status as defined in HL0.8 Read 
 * indicates RAW interrupt status (0=inactive, 1=active). Writing 1 will SET 
 * the corresponding raw status bit (soft interrupt set). Writing 0 has no 
 * effect. */
#define CSL_OCMCECC_INTR1_STATUS_RAW_SET                        (0x60U)

/* This register contains the EOI vector register contents as defined by HL0.8 */
#define CSL_OCMCECC_INTR1_EOI                                   (0x70U)

/* Read indicates ENABLED interrupt status (0=inactive, 1=active). Writing 1 
 * will CLEAR the corresponding enabled status bit. Writing 0 has no effect. */
#define CSL_OCMCECC_INTR1_STATUS_ENABLED_CLEAR                  (0x64U)

/* Read indicates interrupt enable (0=disabled, 1=enabled) Writing 1 will set 
 * the corresponding interrupt enable bit. Writing 0 has no effect. 
 * Interrupt_enable_set */
#define CSL_OCMCECC_INTR1_ENABLE_SET                            (0x68U)

/* Read indicates interrupt enable (0=disabled, 1=enabled) Writing 1 will 
 * clear interrupt enabled. Writing 0 has no effect. Interrupt_enable_clear */
#define CSL_OCMCECC_INTR1_ENABLE_CLEAR                          (0x6CU)

/* ocmc_ecc error status */
#define CSL_OCMCECC_STATUS_ERROR_CNT                            (0x90U)

/* SEC error 128-bit memory address */
#define CSL_OCMCECC_STATUS_SEC_ERROR_TRACE                      (0x94U)

/* DED error 128-bit memory address */
#define CSL_OCMCECC_STATUS_DED_ERROR_TRACE                      (0x98U)

/* ADDR error 128-bit memory address */
#define CSL_OCMCECC_STATUS_ADDR_TRANSLATION_ERROR_TRACE         (0x9CU)

/* SEC data error bit distribution status [31:0] */
#define CSL_OCMCECC_STATUS_SEC_ERROR_DISTR_0                    (0xA0U)

/* SEC data error bit distribution status [63:32] */
#define CSL_OCMCECC_STATUS_SEC_ERROR_DISTR_1                    (0xA4U)

/* SEC data error bit distribution status [95:64] */
#define CSL_OCMCECC_STATUS_SEC_ERROR_DISTR_2                    (0xA8U)

/* SEC data error bit distribution status [127:96] */
#define CSL_OCMCECC_STATUS_SEC_ERROR_DISTR_3                    (0xACU)

/* SEC ecc code error bit distribution status [7:0] */
#define CSL_OCMCECC_STATUS_SEC_ERROR_DISTR_4                    (0xB0U)

/* CFG_OCMC_ECC */
#define CSL_OCMCECC_CFG_OCMC_ECC                                (0x80U)

/* CFG_OCMC_ECC_MEM_BLK */
#define CSL_OCMCECC_CFG_OCMC_ECC_MEM_BLK                        (0x84U)

/* CFG_OCMC_ECC_ERROR */
#define CSL_OCMCECC_CFG_OCMC_ECC_ERROR                          (0x88U)

/* CFG_OCMC_ECC_CLEAR_HIST */
#define CSL_OCMCECC_CFG_OCMC_ECC_CLEAR_HIST                     (0x8CU)

/* CBUF mode enable register */
#define CSL_OCMCECC_CFG_OCMC_CBUF_EN                            (0x200U)

/* Notes: • Writing 1 to bit n will set a reset bit to clear the corresponding 
 * CBUF_n address translation logic – sliding CBUF frame tracking will be 
 * cleared so that the CBUF now points to the base of the virtual frame 
 * buffer. • Normally, a reset is not required since the CBUF logic will clear 
 * itself when a VBUF access is to the base of the virtual frame. */
#define CSL_OCMCECC_CFG_OCMC_CBUF_RESET                         (0x204U)

/* Notes: Overflow_Write_Handler_Sel [Default: 0] 0 : Writes disabled only on 
 * CBUF_overflow_wrap cases until next write NEW_FRAME event 1 : Writes 
 * disabled on all overflow cases until next write NEW_FRAME event 2 : Writes 
 * serviced with CBUF pointer updated even on overflow condition 
 * Overflow_Read_Handle_Sel [Default: 0]: 0 : Reads serviced with CBUF pointer 
 * updated 1 : Reads disabled until next read NEW_FRAME event 
 * Overflow_check_reenable_Sel [Default: 0] 0 : Overflow check is disabled 
 * until next write and read NEW_FRAME events are found 1 : Overflow check is 
 * disabled until next write NEW_FRAME 2 : Overflow check is disabled until 
 * next read NEW_FRAME 3: Overflow check is re-enabled immediately */
#define CSL_OCMCECC_CFG_OCMC_CBUF_ERR_HANDLER                   (0x208U)

/* STATUS_CBUF_WR_OUT_OF_RANGE_ERR */
#define CSL_OCMCECC_STATUS_CBUF_WR_OUT_OF_RANGE_ERR             (0x20CU)

/* STATUS_CBUF_WR_VBUF_START_ERR */
#define CSL_OCMCECC_STATUS_CBUF_WR_VBUF_START_ERR               (0x210U)

/* STATUS_CBUF_WR_ADDR_SEQ_ERROR */
#define CSL_OCMCECC_STATUS_CBUF_WR_ADDR_SEQ_ERROR               (0x214U)

/* STATUS_CBUF_RD_OUT_OF_RANGE_ERROR */
#define CSL_OCMCECC_STATUS_CBUF_RD_OUT_OF_RANGE_ERROR           (0x218U)

/* STATUS_CBUF_VBUF_RD_START_ERROR */
#define CSL_OCMCECC_STATUS_CBUF_VBUF_RD_START_ERROR             (0x21CU)

/* STATUS_CBUF_RD_ADDR_SEQ_ERROR */
#define CSL_OCMCECC_STATUS_CBUF_RD_ADDR_SEQ_ERROR               (0x220U)

/* STATUS_CBUF_OVERFLOW_MID */
#define CSL_OCMCECC_STATUS_CBUF_OVERFLOW_MID                    (0x224U)

/* STATUS_CBUF_OVERFLOW_WRAP */
#define CSL_OCMCECC_STATUS_CBUF_OVERFLOW_WRAP                   (0x228U)

/* STATUS_CBUF_UNDERFLOW */
#define CSL_OCMCECC_STATUS_CBUF_UNDERFLOW                       (0x22CU)

/* STATUS_CBUF_SHORT_FRAME_DETECT */
#define CSL_OCMCECC_STATUS_CBUF_SHORT_FRAME_DETECT              (0x230U)

/* CBUF_VBUF_START_ADDR */
#define CSL_OCMCECC_CBUF_VBUF_START_ADDR(n)                     (0x240U + ((n) * (0x10U)))

/* CBUF_VBUF_END_ADDR */
#define CSL_OCMCECC_CBUF_VBUF_END_ADDR(n)                       (0x244U + ((n) * (0x10U)))

/* CBUF_OCMC_START_ADDR */
#define CSL_OCMCECC_CBUF_OCMC_START_ADDR(n)                     (0x248U + ((n) * (0x10U)))

/* CBUF_OCMC_BUF_SIZE */
#define CSL_OCMCECC_CBUF_OCMC_BUF_SIZE(n)                       (0x24CU + ((n) * (0x10U)))

/* CBUF_LAST_WR_ADDR */
#define CSL_OCMCECC_CBUF_LAST_WR_ADDR(n)                        (0x300U + ((n) * (0x8U)))

/* CBUF_LAST_RD_ADDR */
#define CSL_OCMCECC_CBUF_LAST_RD_ADDR(n)                        (0x304U + ((n) * (0x8U)))

/* LAST_ILLEGAL_OCMC_ADDR */
#define CSL_OCMCECC_LAST_ILLEGAL_OCMC_ADDR                      (0x360U)


/**************************************************************************
* Field Definition Macros
**************************************************************************/

/* OCMC_ECC_PID */

#define CSL_OCMCECC_OCMC_ECC_PID_MINOR_MASK                     (0x0000003FU)
#define CSL_OCMCECC_OCMC_ECC_PID_MINOR_SHIFT                    (0U)
#define CSL_OCMCECC_OCMC_ECC_PID_MINOR_RESETVAL                 (0x00000009U)
#define CSL_OCMCECC_OCMC_ECC_PID_MINOR_MAX                      (0x0000003fU)

#define CSL_OCMCECC_OCMC_ECC_PID_CUSTOM_MASK                    (0x000000C0U)
#define CSL_OCMCECC_OCMC_ECC_PID_CUSTOM_SHIFT                   (6U)
#define CSL_OCMCECC_OCMC_ECC_PID_CUSTOM_RESETVAL                (0x00000000U)
#define CSL_OCMCECC_OCMC_ECC_PID_CUSTOM_MAX                     (0x00000003U)

#define CSL_OCMCECC_OCMC_ECC_PID_MAJOR_MASK                     (0x00000700U)
#define CSL_OCMCECC_OCMC_ECC_PID_MAJOR_SHIFT                    (8U)
#define CSL_OCMCECC_OCMC_ECC_PID_MAJOR_RESETVAL                 (0x00000000U)
#define CSL_OCMCECC_OCMC_ECC_PID_MAJOR_MAX                      (0x00000007U)

#define CSL_OCMCECC_OCMC_ECC_PID_RTL_MASK                       (0x0000F800U)
#define CSL_OCMCECC_OCMC_ECC_PID_RTL_SHIFT                      (11U)
#define CSL_OCMCECC_OCMC_ECC_PID_RTL_RESETVAL                   (0x00000000U)
#define CSL_OCMCECC_OCMC_ECC_PID_RTL_MAX                        (0x0000001fU)

#define CSL_OCMCECC_OCMC_ECC_PID_FUNC_MASK                      (0x0FFF0000U)
#define CSL_OCMCECC_OCMC_ECC_PID_FUNC_SHIFT                     (16U)
#define CSL_OCMCECC_OCMC_ECC_PID_FUNC_RESETVAL                  (0x00000f30U)
#define CSL_OCMCECC_OCMC_ECC_PID_FUNC_MAX                       (0x00000fffU)

#define CSL_OCMCECC_OCMC_ECC_PID_SCHEME_MASK                    (0xC0000000U)
#define CSL_OCMCECC_OCMC_ECC_PID_SCHEME_SHIFT                   (30U)
#define CSL_OCMCECC_OCMC_ECC_PID_SCHEME_RESETVAL                (0x00000001U)
#define CSL_OCMCECC_OCMC_ECC_PID_SCHEME_MAX                     (0x00000003U)

#define CSL_OCMCECC_OCMC_ECC_PID_RESETVAL                       (0x4f300009U)

/* OCMC_SYSCONFIG_PM */

#define CSL_OCMCECC_OCMC_SYSCONFIG_PM_IDLEMODE_MASK             (0x0000000CU)
#define CSL_OCMCECC_OCMC_SYSCONFIG_PM_IDLEMODE_SHIFT            (2U)
#define CSL_OCMCECC_OCMC_SYSCONFIG_PM_IDLEMODE_RESETVAL         (0x00000002U)
#define CSL_OCMCECC_OCMC_SYSCONFIG_PM_IDLEMODE_FORCE_IDLE       (0x00000000U)
#define CSL_OCMCECC_OCMC_SYSCONFIG_PM_IDLEMODE_NO_IDLE          (0x00000001U)
#define CSL_OCMCECC_OCMC_SYSCONFIG_PM_IDLEMODE_SMART_IDLE       (0x00000002U)
#define CSL_OCMCECC_OCMC_SYSCONFIG_PM_IDLEMODE_SMART_IDLE_WAKEUP_CAPABLE  (0x00000003U)

#define CSL_OCMCECC_OCMC_SYSCONFIG_PM_RESETVAL                  (0x00000008U)

/* OCMC_SYSCONFIG_RST */

#define CSL_OCMCECC_OCMC_SYSCONFIG_RST_SW_RST_MASK              (0x00000001U)
#define CSL_OCMCECC_OCMC_SYSCONFIG_RST_SW_RST_SHIFT             (0U)
#define CSL_OCMCECC_OCMC_SYSCONFIG_RST_SW_RST_RESETVAL          (0x00000000U)
#define CSL_OCMCECC_OCMC_SYSCONFIG_RST_SW_RST_NORMAL_OP         (0x00000000U)
#define CSL_OCMCECC_OCMC_SYSCONFIG_RST_SW_RST_RESET             (0x00000001U)

#define CSL_OCMCECC_OCMC_SYSCONFIG_RST_RESETVAL                 (0x00000000U)

/* OCMC_MEM_SIZE_READ */

#define CSL_OCMCECC_OCMC_MEM_SIZE_READ_MEM_SIZE_128K_CNT_MASK   (0x0000001FU)
#define CSL_OCMCECC_OCMC_MEM_SIZE_READ_MEM_SIZE_128K_CNT_SHIFT  (0U)
#define CSL_OCMCECC_OCMC_MEM_SIZE_READ_MEM_SIZE_128K_CNT_RESETVAL  (0x00000000U)
#define CSL_OCMCECC_OCMC_MEM_SIZE_READ_MEM_SIZE_128K_CNT_MAX    (0x0000001fU)

#define CSL_OCMCECC_OCMC_MEM_SIZE_READ_MEM_ECC_ENABLE_MASK      (0x00000100U)
#define CSL_OCMCECC_OCMC_MEM_SIZE_READ_MEM_ECC_ENABLE_SHIFT     (8U)
#define CSL_OCMCECC_OCMC_MEM_SIZE_READ_MEM_ECC_ENABLE_RESETVAL  (0x00000000U)
#define CSL_OCMCECC_OCMC_MEM_SIZE_READ_MEM_ECC_ENABLE_ECC_OFF   (0x00000000U)
#define CSL_OCMCECC_OCMC_MEM_SIZE_READ_MEM_ECC_ENABLE_ECC_ON    (0x00000001U)

#define CSL_OCMCECC_OCMC_MEM_SIZE_READ_MEM_CBUF_ENABLE_MASK     (0x00000200U)
#define CSL_OCMCECC_OCMC_MEM_SIZE_READ_MEM_CBUF_ENABLE_SHIFT    (9U)
#define CSL_OCMCECC_OCMC_MEM_SIZE_READ_MEM_CBUF_ENABLE_RESETVAL  (0x00000000U)
#define CSL_OCMCECC_OCMC_MEM_SIZE_READ_MEM_CBUF_ENABLE_CBUF_ECC_OFF  (0x00000000U)
#define CSL_OCMCECC_OCMC_MEM_SIZE_READ_MEM_CBUF_ENABLE_CBUF_ECC_ON  (0x00000001U)

#define CSL_OCMCECC_OCMC_MEM_SIZE_READ_RESETVAL                 (0x00000000U)

/* INTR0_STATUS_RAW_SET */

#define CSL_OCMCECC_INTR0_STATUS_RAW_SET_SEC_ERR_FOUND_MASK     (0x00000001U)
#define CSL_OCMCECC_INTR0_STATUS_RAW_SET_SEC_ERR_FOUND_SHIFT    (0U)
#define CSL_OCMCECC_INTR0_STATUS_RAW_SET_SEC_ERR_FOUND_RESETVAL  (0x00000000U)
#define CSL_OCMCECC_INTR0_STATUS_RAW_SET_SEC_ERR_FOUND_MAX      (0x00000001U)

#define CSL_OCMCECC_INTR0_STATUS_RAW_SET_DED_ERR_FOUND_MASK     (0x00000002U)
#define CSL_OCMCECC_INTR0_STATUS_RAW_SET_DED_ERR_FOUND_SHIFT    (1U)
#define CSL_OCMCECC_INTR0_STATUS_RAW_SET_DED_ERR_FOUND_RESETVAL  (0x00000000U)
#define CSL_OCMCECC_INTR0_STATUS_RAW_SET_DED_ERR_FOUND_MAX      (0x00000001U)

#define CSL_OCMCECC_INTR0_STATUS_RAW_SET_ADDR_ERR_FOUND_MASK    (0x00000004U)
#define CSL_OCMCECC_INTR0_STATUS_RAW_SET_ADDR_ERR_FOUND_SHIFT   (2U)
#define CSL_OCMCECC_INTR0_STATUS_RAW_SET_ADDR_ERR_FOUND_RESETVAL  (0x00000000U)
#define CSL_OCMCECC_INTR0_STATUS_RAW_SET_ADDR_ERR_FOUND_MAX     (0x00000001U)

#define CSL_OCMCECC_INTR0_STATUS_RAW_SET_OUT_OF_RANGE_ERR_FOUND_MASK  (0x00000008U)
#define CSL_OCMCECC_INTR0_STATUS_RAW_SET_OUT_OF_RANGE_ERR_FOUND_SHIFT  (3U)
#define CSL_OCMCECC_INTR0_STATUS_RAW_SET_OUT_OF_RANGE_ERR_FOUND_RESETVAL  (0x00000000U)
#define CSL_OCMCECC_INTR0_STATUS_RAW_SET_OUT_OF_RANGE_ERR_FOUND_MAX  (0x00000001U)

#define CSL_OCMCECC_INTR0_STATUS_RAW_SET_CBUF_VIRTUAL_ADDR_ERR_FOUND_MASK  (0x00000010U)
#define CSL_OCMCECC_INTR0_STATUS_RAW_SET_CBUF_VIRTUAL_ADDR_ERR_FOUND_SHIFT  (4U)
#define CSL_OCMCECC_INTR0_STATUS_RAW_SET_CBUF_VIRTUAL_ADDR_ERR_FOUND_RESETVAL  (0x00000000U)
#define CSL_OCMCECC_INTR0_STATUS_RAW_SET_CBUF_VIRTUAL_ADDR_ERR_FOUND_MAX  (0x00000001U)

#define CSL_OCMCECC_INTR0_STATUS_RAW_SET_CBUF_OVERFLOW_MID_ERR_FOUND_MASK  (0x00000800U)
#define CSL_OCMCECC_INTR0_STATUS_RAW_SET_CBUF_OVERFLOW_MID_ERR_FOUND_SHIFT  (11U)
#define CSL_OCMCECC_INTR0_STATUS_RAW_SET_CBUF_OVERFLOW_MID_ERR_FOUND_RESETVAL  (0x00000000U)
#define CSL_OCMCECC_INTR0_STATUS_RAW_SET_CBUF_OVERFLOW_MID_ERR_FOUND_MAX  (0x00000001U)

#define CSL_OCMCECC_INTR0_STATUS_RAW_SET_CBUF_UNDERFLOW_ERR_FOUND_MASK  (0x00002000U)
#define CSL_OCMCECC_INTR0_STATUS_RAW_SET_CBUF_UNDERFLOW_ERR_FOUND_SHIFT  (13U)
#define CSL_OCMCECC_INTR0_STATUS_RAW_SET_CBUF_UNDERFLOW_ERR_FOUND_RESETVAL  (0x00000000U)
#define CSL_OCMCECC_INTR0_STATUS_RAW_SET_CBUF_UNDERFLOW_ERR_FOUND_MAX  (0x00000001U)

#define CSL_OCMCECC_INTR0_STATUS_RAW_SET_CBUF_SHORT_FRAME_DETECT_FOUND_MASK  (0x00004000U)
#define CSL_OCMCECC_INTR0_STATUS_RAW_SET_CBUF_SHORT_FRAME_DETECT_FOUND_SHIFT  (14U)
#define CSL_OCMCECC_INTR0_STATUS_RAW_SET_CBUF_SHORT_FRAME_DETECT_FOUND_RESETVAL  (0x00000000U)
#define CSL_OCMCECC_INTR0_STATUS_RAW_SET_CBUF_SHORT_FRAME_DETECT_FOUND_MAX  (0x00000001U)

#define CSL_OCMCECC_INTR0_STATUS_RAW_SET_CBUF_WR_OUT_OF_RANGE_ERR_FOUND_MASK  (0x00000020U)
#define CSL_OCMCECC_INTR0_STATUS_RAW_SET_CBUF_WR_OUT_OF_RANGE_ERR_FOUND_SHIFT  (5U)
#define CSL_OCMCECC_INTR0_STATUS_RAW_SET_CBUF_WR_OUT_OF_RANGE_ERR_FOUND_RESETVAL  (0x00000000U)
#define CSL_OCMCECC_INTR0_STATUS_RAW_SET_CBUF_WR_OUT_OF_RANGE_ERR_FOUND_MAX  (0x00000001U)

#define CSL_OCMCECC_INTR0_STATUS_RAW_SET_CBUF_VBUF_WRITE_START_ERR_FOUND_MASK  (0x00000040U)
#define CSL_OCMCECC_INTR0_STATUS_RAW_SET_CBUF_VBUF_WRITE_START_ERR_FOUND_SHIFT  (6U)
#define CSL_OCMCECC_INTR0_STATUS_RAW_SET_CBUF_VBUF_WRITE_START_ERR_FOUND_RESETVAL  (0x00000000U)
#define CSL_OCMCECC_INTR0_STATUS_RAW_SET_CBUF_VBUF_WRITE_START_ERR_FOUND_MAX  (0x00000001U)

#define CSL_OCMCECC_INTR0_STATUS_RAW_SET_CBUF_WRITE_SEQUENCE_ERR_FOUND_MASK  (0x00000080U)
#define CSL_OCMCECC_INTR0_STATUS_RAW_SET_CBUF_WRITE_SEQUENCE_ERR_FOUND_SHIFT  (7U)
#define CSL_OCMCECC_INTR0_STATUS_RAW_SET_CBUF_WRITE_SEQUENCE_ERR_FOUND_RESETVAL  (0x00000000U)
#define CSL_OCMCECC_INTR0_STATUS_RAW_SET_CBUF_WRITE_SEQUENCE_ERR_FOUND_MAX  (0x00000001U)

#define CSL_OCMCECC_INTR0_STATUS_RAW_SET_CBUF_READ_OUT_OF_RANGE_ERR_FOUND_MASK  (0x00000100U)
#define CSL_OCMCECC_INTR0_STATUS_RAW_SET_CBUF_READ_OUT_OF_RANGE_ERR_FOUND_SHIFT  (8U)
#define CSL_OCMCECC_INTR0_STATUS_RAW_SET_CBUF_READ_OUT_OF_RANGE_ERR_FOUND_RESETVAL  (0x00000000U)
#define CSL_OCMCECC_INTR0_STATUS_RAW_SET_CBUF_READ_OUT_OF_RANGE_ERR_FOUND_MAX  (0x00000001U)

#define CSL_OCMCECC_INTR0_STATUS_RAW_SET_CBUF_VBUF_READ_START_ERR_FOUND_MASK  (0x00000200U)
#define CSL_OCMCECC_INTR0_STATUS_RAW_SET_CBUF_VBUF_READ_START_ERR_FOUND_SHIFT  (9U)
#define CSL_OCMCECC_INTR0_STATUS_RAW_SET_CBUF_VBUF_READ_START_ERR_FOUND_RESETVAL  (0x00000000U)
#define CSL_OCMCECC_INTR0_STATUS_RAW_SET_CBUF_VBUF_READ_START_ERR_FOUND_MAX  (0x00000001U)

#define CSL_OCMCECC_INTR0_STATUS_RAW_SET_CBUF_READ_SEQUENCE_ERR_FOUND_MASK  (0x00000400U)
#define CSL_OCMCECC_INTR0_STATUS_RAW_SET_CBUF_READ_SEQUENCE_ERR_FOUND_SHIFT  (10U)
#define CSL_OCMCECC_INTR0_STATUS_RAW_SET_CBUF_READ_SEQUENCE_ERR_FOUND_RESETVAL  (0x00000000U)
#define CSL_OCMCECC_INTR0_STATUS_RAW_SET_CBUF_READ_SEQUENCE_ERR_FOUND_MAX  (0x00000001U)

#define CSL_OCMCECC_INTR0_STATUS_RAW_SET_CBUF_OVERFLOW_WRAP_ERR_FOUND_MASK  (0x00001000U)
#define CSL_OCMCECC_INTR0_STATUS_RAW_SET_CBUF_OVERFLOW_WRAP_ERR_FOUND_SHIFT  (12U)
#define CSL_OCMCECC_INTR0_STATUS_RAW_SET_CBUF_OVERFLOW_WRAP_ERR_FOUND_RESETVAL  (0x00000000U)
#define CSL_OCMCECC_INTR0_STATUS_RAW_SET_CBUF_OVERFLOW_WRAP_ERR_FOUND_MAX  (0x00000001U)

#define CSL_OCMCECC_INTR0_STATUS_RAW_SET_RESETVAL               (0x00000000U)

/* INTR0_EOI */

#define CSL_OCMCECC_INTR0_EOI_EOI_VECTOR_MASK                   (0x00000001U)
#define CSL_OCMCECC_INTR0_EOI_EOI_VECTOR_SHIFT                  (0U)
#define CSL_OCMCECC_INTR0_EOI_EOI_VECTOR_RESETVAL               (0x00000000U)
#define CSL_OCMCECC_INTR0_EOI_EOI_VECTOR_MAX                    (0x00000001U)

#define CSL_OCMCECC_INTR0_EOI_RESETVAL                          (0x00000000U)

/* INTR0_STATUS_ENABLED_CLEAR */

#define CSL_OCMCECC_INTR0_STATUS_ENABLED_CLEAR_SEC_ERR_FOUND_MASK  (0x00000001U)
#define CSL_OCMCECC_INTR0_STATUS_ENABLED_CLEAR_SEC_ERR_FOUND_SHIFT  (0U)
#define CSL_OCMCECC_INTR0_STATUS_ENABLED_CLEAR_SEC_ERR_FOUND_RESETVAL  (0x00000000U)
#define CSL_OCMCECC_INTR0_STATUS_ENABLED_CLEAR_SEC_ERR_FOUND_MAX  (0x00000001U)

#define CSL_OCMCECC_INTR0_STATUS_ENABLED_CLEAR_DED_ERR_FOUND_MASK  (0x00000002U)
#define CSL_OCMCECC_INTR0_STATUS_ENABLED_CLEAR_DED_ERR_FOUND_SHIFT  (1U)
#define CSL_OCMCECC_INTR0_STATUS_ENABLED_CLEAR_DED_ERR_FOUND_RESETVAL  (0x00000000U)
#define CSL_OCMCECC_INTR0_STATUS_ENABLED_CLEAR_DED_ERR_FOUND_MAX  (0x00000001U)

#define CSL_OCMCECC_INTR0_STATUS_ENABLED_CLEAR_ADDR_ERR_FOUND_MASK  (0x00000004U)
#define CSL_OCMCECC_INTR0_STATUS_ENABLED_CLEAR_ADDR_ERR_FOUND_SHIFT  (2U)
#define CSL_OCMCECC_INTR0_STATUS_ENABLED_CLEAR_ADDR_ERR_FOUND_RESETVAL  (0x00000000U)
#define CSL_OCMCECC_INTR0_STATUS_ENABLED_CLEAR_ADDR_ERR_FOUND_MAX  (0x00000001U)

#define CSL_OCMCECC_INTR0_STATUS_ENABLED_CLEAR_OUT_OF_RANGE_ERR_FOUND_MASK  (0x00000008U)
#define CSL_OCMCECC_INTR0_STATUS_ENABLED_CLEAR_OUT_OF_RANGE_ERR_FOUND_SHIFT  (3U)
#define CSL_OCMCECC_INTR0_STATUS_ENABLED_CLEAR_OUT_OF_RANGE_ERR_FOUND_RESETVAL  (0x00000000U)
#define CSL_OCMCECC_INTR0_STATUS_ENABLED_CLEAR_OUT_OF_RANGE_ERR_FOUND_MAX  (0x00000001U)

#define CSL_OCMCECC_INTR0_STATUS_ENABLED_CLEAR_CBUF_VIRTUAL_ADDR_ERR_FOUND_MASK  (0x00000010U)
#define CSL_OCMCECC_INTR0_STATUS_ENABLED_CLEAR_CBUF_VIRTUAL_ADDR_ERR_FOUND_SHIFT  (4U)
#define CSL_OCMCECC_INTR0_STATUS_ENABLED_CLEAR_CBUF_VIRTUAL_ADDR_ERR_FOUND_RESETVAL  (0x00000000U)
#define CSL_OCMCECC_INTR0_STATUS_ENABLED_CLEAR_CBUF_VIRTUAL_ADDR_ERR_FOUND_MAX  (0x00000001U)

#define CSL_OCMCECC_INTR0_STATUS_ENABLED_CLEAR_CBUF_OVERFLOW_MID_ERR_FOUND_MASK  (0x00000800U)
#define CSL_OCMCECC_INTR0_STATUS_ENABLED_CLEAR_CBUF_OVERFLOW_MID_ERR_FOUND_SHIFT  (11U)
#define CSL_OCMCECC_INTR0_STATUS_ENABLED_CLEAR_CBUF_OVERFLOW_MID_ERR_FOUND_RESETVAL  (0x00000000U)
#define CSL_OCMCECC_INTR0_STATUS_ENABLED_CLEAR_CBUF_OVERFLOW_MID_ERR_FOUND_MAX  (0x00000001U)

#define CSL_OCMCECC_INTR0_STATUS_ENABLED_CLEAR_CBUF_UNDERFLOW_ERR_FOUND_MASK  (0x00002000U)
#define CSL_OCMCECC_INTR0_STATUS_ENABLED_CLEAR_CBUF_UNDERFLOW_ERR_FOUND_SHIFT  (13U)
#define CSL_OCMCECC_INTR0_STATUS_ENABLED_CLEAR_CBUF_UNDERFLOW_ERR_FOUND_RESETVAL  (0x00000000U)
#define CSL_OCMCECC_INTR0_STATUS_ENABLED_CLEAR_CBUF_UNDERFLOW_ERR_FOUND_MAX  (0x00000001U)

#define CSL_OCMCECC_INTR0_STATUS_ENABLED_CLEAR_CBUF_SHORT_FRAME_DETECT_FOUND_MASK  (0x00004000U)
#define CSL_OCMCECC_INTR0_STATUS_ENABLED_CLEAR_CBUF_SHORT_FRAME_DETECT_FOUND_SHIFT  (14U)
#define CSL_OCMCECC_INTR0_STATUS_ENABLED_CLEAR_CBUF_SHORT_FRAME_DETECT_FOUND_RESETVAL  (0x00000000U)
#define CSL_OCMCECC_INTR0_STATUS_ENABLED_CLEAR_CBUF_SHORT_FRAME_DETECT_FOUND_MAX  (0x00000001U)

#define CSL_OCMCECC_INTR0_STATUS_ENABLED_CLEAR_CBUF_WR_OUT_OF_RANGE_ERR_FOUND_MASK  (0x00000020U)
#define CSL_OCMCECC_INTR0_STATUS_ENABLED_CLEAR_CBUF_WR_OUT_OF_RANGE_ERR_FOUND_SHIFT  (5U)
#define CSL_OCMCECC_INTR0_STATUS_ENABLED_CLEAR_CBUF_WR_OUT_OF_RANGE_ERR_FOUND_RESETVAL  (0x00000000U)
#define CSL_OCMCECC_INTR0_STATUS_ENABLED_CLEAR_CBUF_WR_OUT_OF_RANGE_ERR_FOUND_MAX  (0x00000001U)

#define CSL_OCMCECC_INTR0_STATUS_ENABLED_CLEAR_CBUF_VBUF_WRITE_START_ERR_FOUND_MASK  (0x00000040U)
#define CSL_OCMCECC_INTR0_STATUS_ENABLED_CLEAR_CBUF_VBUF_WRITE_START_ERR_FOUND_SHIFT  (6U)
#define CSL_OCMCECC_INTR0_STATUS_ENABLED_CLEAR_CBUF_VBUF_WRITE_START_ERR_FOUND_RESETVAL  (0x00000000U)
#define CSL_OCMCECC_INTR0_STATUS_ENABLED_CLEAR_CBUF_VBUF_WRITE_START_ERR_FOUND_MAX  (0x00000001U)

#define CSL_OCMCECC_INTR0_STATUS_ENABLED_CLEAR_CBUF_WRITE_SEQUENCE_ERR_FOUND_MASK  (0x00000080U)
#define CSL_OCMCECC_INTR0_STATUS_ENABLED_CLEAR_CBUF_WRITE_SEQUENCE_ERR_FOUND_SHIFT  (7U)
#define CSL_OCMCECC_INTR0_STATUS_ENABLED_CLEAR_CBUF_WRITE_SEQUENCE_ERR_FOUND_RESETVAL  (0x00000000U)
#define CSL_OCMCECC_INTR0_STATUS_ENABLED_CLEAR_CBUF_WRITE_SEQUENCE_ERR_FOUND_MAX  (0x00000001U)

#define CSL_OCMCECC_INTR0_STATUS_ENABLED_CLEAR_CBUF_READ_OUT_OF_RANGE_ERR_FOUND_MASK  (0x00000100U)
#define CSL_OCMCECC_INTR0_STATUS_ENABLED_CLEAR_CBUF_READ_OUT_OF_RANGE_ERR_FOUND_SHIFT  (8U)
#define CSL_OCMCECC_INTR0_STATUS_ENABLED_CLEAR_CBUF_READ_OUT_OF_RANGE_ERR_FOUND_RESETVAL  (0x00000000U)
#define CSL_OCMCECC_INTR0_STATUS_ENABLED_CLEAR_CBUF_READ_OUT_OF_RANGE_ERR_FOUND_MAX  (0x00000001U)

#define CSL_OCMCECC_INTR0_STATUS_ENABLED_CLEAR_CBUF_VBUF_READ_START_ERR_FOUND_MASK  (0x00000200U)
#define CSL_OCMCECC_INTR0_STATUS_ENABLED_CLEAR_CBUF_VBUF_READ_START_ERR_FOUND_SHIFT  (9U)
#define CSL_OCMCECC_INTR0_STATUS_ENABLED_CLEAR_CBUF_VBUF_READ_START_ERR_FOUND_RESETVAL  (0x00000000U)
#define CSL_OCMCECC_INTR0_STATUS_ENABLED_CLEAR_CBUF_VBUF_READ_START_ERR_FOUND_MAX  (0x00000001U)

#define CSL_OCMCECC_INTR0_STATUS_ENABLED_CLEAR_CBUF_READ_SEQUENCE_ERR_FOUND_MASK  (0x00000400U)
#define CSL_OCMCECC_INTR0_STATUS_ENABLED_CLEAR_CBUF_READ_SEQUENCE_ERR_FOUND_SHIFT  (10U)
#define CSL_OCMCECC_INTR0_STATUS_ENABLED_CLEAR_CBUF_READ_SEQUENCE_ERR_FOUND_RESETVAL  (0x00000000U)
#define CSL_OCMCECC_INTR0_STATUS_ENABLED_CLEAR_CBUF_READ_SEQUENCE_ERR_FOUND_MAX  (0x00000001U)

#define CSL_OCMCECC_INTR0_STATUS_ENABLED_CLEAR_CBUF_OVERFLOW_WRAP_ERR_FOUND_MASK  (0x00001000U)
#define CSL_OCMCECC_INTR0_STATUS_ENABLED_CLEAR_CBUF_OVERFLOW_WRAP_ERR_FOUND_SHIFT  (12U)
#define CSL_OCMCECC_INTR0_STATUS_ENABLED_CLEAR_CBUF_OVERFLOW_WRAP_ERR_FOUND_RESETVAL  (0x00000000U)
#define CSL_OCMCECC_INTR0_STATUS_ENABLED_CLEAR_CBUF_OVERFLOW_WRAP_ERR_FOUND_MAX  (0x00000001U)

#define CSL_OCMCECC_INTR0_STATUS_ENABLED_CLEAR_RESETVAL         (0x00000000U)

/* INTR0_ENABLE_SET */

#define CSL_OCMCECC_INTR0_ENABLE_SET_SEC_ERR_FOUND_MASK         (0x00000001U)
#define CSL_OCMCECC_INTR0_ENABLE_SET_SEC_ERR_FOUND_SHIFT        (0U)
#define CSL_OCMCECC_INTR0_ENABLE_SET_SEC_ERR_FOUND_RESETVAL     (0x00000000U)
#define CSL_OCMCECC_INTR0_ENABLE_SET_SEC_ERR_FOUND_MAX          (0x00000001U)

#define CSL_OCMCECC_INTR0_ENABLE_SET_DED_ERR_FOUND_MASK         (0x00000002U)
#define CSL_OCMCECC_INTR0_ENABLE_SET_DED_ERR_FOUND_SHIFT        (1U)
#define CSL_OCMCECC_INTR0_ENABLE_SET_DED_ERR_FOUND_RESETVAL     (0x00000000U)
#define CSL_OCMCECC_INTR0_ENABLE_SET_DED_ERR_FOUND_MAX          (0x00000001U)

#define CSL_OCMCECC_INTR0_ENABLE_SET_ADDR_ERR_FOUND_MASK        (0x00000004U)
#define CSL_OCMCECC_INTR0_ENABLE_SET_ADDR_ERR_FOUND_SHIFT       (2U)
#define CSL_OCMCECC_INTR0_ENABLE_SET_ADDR_ERR_FOUND_RESETVAL    (0x00000000U)
#define CSL_OCMCECC_INTR0_ENABLE_SET_ADDR_ERR_FOUND_MAX         (0x00000001U)

#define CSL_OCMCECC_INTR0_ENABLE_SET_OUT_OF_RANGE_ERR_FOUND_MASK  (0x00000008U)
#define CSL_OCMCECC_INTR0_ENABLE_SET_OUT_OF_RANGE_ERR_FOUND_SHIFT  (3U)
#define CSL_OCMCECC_INTR0_ENABLE_SET_OUT_OF_RANGE_ERR_FOUND_RESETVAL  (0x00000000U)
#define CSL_OCMCECC_INTR0_ENABLE_SET_OUT_OF_RANGE_ERR_FOUND_MAX  (0x00000001U)

#define CSL_OCMCECC_INTR0_ENABLE_SET_CBUF_VIRTUAL_ADDR_ERR_FOUND_MASK  (0x00000010U)
#define CSL_OCMCECC_INTR0_ENABLE_SET_CBUF_VIRTUAL_ADDR_ERR_FOUND_SHIFT  (4U)
#define CSL_OCMCECC_INTR0_ENABLE_SET_CBUF_VIRTUAL_ADDR_ERR_FOUND_RESETVAL  (0x00000000U)
#define CSL_OCMCECC_INTR0_ENABLE_SET_CBUF_VIRTUAL_ADDR_ERR_FOUND_MAX  (0x00000001U)

#define CSL_OCMCECC_INTR0_ENABLE_SET_CBUF_OVERFLOW_MID_ERR_FOUND_MASK  (0x00000800U)
#define CSL_OCMCECC_INTR0_ENABLE_SET_CBUF_OVERFLOW_MID_ERR_FOUND_SHIFT  (11U)
#define CSL_OCMCECC_INTR0_ENABLE_SET_CBUF_OVERFLOW_MID_ERR_FOUND_RESETVAL  (0x00000000U)
#define CSL_OCMCECC_INTR0_ENABLE_SET_CBUF_OVERFLOW_MID_ERR_FOUND_MAX  (0x00000001U)

#define CSL_OCMCECC_INTR0_ENABLE_SET_CBUF_UNDERFLOW_ERR_FOUND_MASK  (0x00002000U)
#define CSL_OCMCECC_INTR0_ENABLE_SET_CBUF_UNDERFLOW_ERR_FOUND_SHIFT  (13U)
#define CSL_OCMCECC_INTR0_ENABLE_SET_CBUF_UNDERFLOW_ERR_FOUND_RESETVAL  (0x00000000U)
#define CSL_OCMCECC_INTR0_ENABLE_SET_CBUF_UNDERFLOW_ERR_FOUND_MAX  (0x00000001U)

#define CSL_OCMCECC_INTR0_ENABLE_SET_CBUF_SHORT_FRAME_DETECT_FOUND_MASK  (0x00004000U)
#define CSL_OCMCECC_INTR0_ENABLE_SET_CBUF_SHORT_FRAME_DETECT_FOUND_SHIFT  (14U)
#define CSL_OCMCECC_INTR0_ENABLE_SET_CBUF_SHORT_FRAME_DETECT_FOUND_RESETVAL  (0x00000000U)
#define CSL_OCMCECC_INTR0_ENABLE_SET_CBUF_SHORT_FRAME_DETECT_FOUND_MAX  (0x00000001U)

#define CSL_OCMCECC_INTR0_ENABLE_SET_CBUF_WR_OUT_OF_RANGE_ERR_FOUND_MASK  (0x00000020U)
#define CSL_OCMCECC_INTR0_ENABLE_SET_CBUF_WR_OUT_OF_RANGE_ERR_FOUND_SHIFT  (5U)
#define CSL_OCMCECC_INTR0_ENABLE_SET_CBUF_WR_OUT_OF_RANGE_ERR_FOUND_RESETVAL  (0x00000000U)
#define CSL_OCMCECC_INTR0_ENABLE_SET_CBUF_WR_OUT_OF_RANGE_ERR_FOUND_MAX  (0x00000001U)

#define CSL_OCMCECC_INTR0_ENABLE_SET_CBUF_VBUF_WRITE_START_ERR_FOUND_MASK  (0x00000040U)
#define CSL_OCMCECC_INTR0_ENABLE_SET_CBUF_VBUF_WRITE_START_ERR_FOUND_SHIFT  (6U)
#define CSL_OCMCECC_INTR0_ENABLE_SET_CBUF_VBUF_WRITE_START_ERR_FOUND_RESETVAL  (0x00000000U)
#define CSL_OCMCECC_INTR0_ENABLE_SET_CBUF_VBUF_WRITE_START_ERR_FOUND_MAX  (0x00000001U)

#define CSL_OCMCECC_INTR0_ENABLE_SET_CBUF_WRITE_SEQUENCE_ERR_FOUND_MASK  (0x00000080U)
#define CSL_OCMCECC_INTR0_ENABLE_SET_CBUF_WRITE_SEQUENCE_ERR_FOUND_SHIFT  (7U)
#define CSL_OCMCECC_INTR0_ENABLE_SET_CBUF_WRITE_SEQUENCE_ERR_FOUND_RESETVAL  (0x00000000U)
#define CSL_OCMCECC_INTR0_ENABLE_SET_CBUF_WRITE_SEQUENCE_ERR_FOUND_MAX  (0x00000001U)

#define CSL_OCMCECC_INTR0_ENABLE_SET_CBUF_READ_OUT_OF_RANGE_ERR_FOUND_MASK  (0x00000100U)
#define CSL_OCMCECC_INTR0_ENABLE_SET_CBUF_READ_OUT_OF_RANGE_ERR_FOUND_SHIFT  (8U)
#define CSL_OCMCECC_INTR0_ENABLE_SET_CBUF_READ_OUT_OF_RANGE_ERR_FOUND_RESETVAL  (0x00000000U)
#define CSL_OCMCECC_INTR0_ENABLE_SET_CBUF_READ_OUT_OF_RANGE_ERR_FOUND_MAX  (0x00000001U)

#define CSL_OCMCECC_INTR0_ENABLE_SET_CBUF_VBUF_READ_START_ERR_FOUND_MASK  (0x00000200U)
#define CSL_OCMCECC_INTR0_ENABLE_SET_CBUF_VBUF_READ_START_ERR_FOUND_SHIFT  (9U)
#define CSL_OCMCECC_INTR0_ENABLE_SET_CBUF_VBUF_READ_START_ERR_FOUND_RESETVAL  (0x00000000U)
#define CSL_OCMCECC_INTR0_ENABLE_SET_CBUF_VBUF_READ_START_ERR_FOUND_MAX  (0x00000001U)

#define CSL_OCMCECC_INTR0_ENABLE_SET_CBUF_READ_SEQUENCE_ERR_FOUND_MASK  (0x00000400U)
#define CSL_OCMCECC_INTR0_ENABLE_SET_CBUF_READ_SEQUENCE_ERR_FOUND_SHIFT  (10U)
#define CSL_OCMCECC_INTR0_ENABLE_SET_CBUF_READ_SEQUENCE_ERR_FOUND_RESETVAL  (0x00000000U)
#define CSL_OCMCECC_INTR0_ENABLE_SET_CBUF_READ_SEQUENCE_ERR_FOUND_MAX  (0x00000001U)

#define CSL_OCMCECC_INTR0_ENABLE_SET_CBUF_OVERFLOW_WRAP_ERR_FOUND_MASK  (0x00001000U)
#define CSL_OCMCECC_INTR0_ENABLE_SET_CBUF_OVERFLOW_WRAP_ERR_FOUND_SHIFT  (12U)
#define CSL_OCMCECC_INTR0_ENABLE_SET_CBUF_OVERFLOW_WRAP_ERR_FOUND_RESETVAL  (0x00000000U)
#define CSL_OCMCECC_INTR0_ENABLE_SET_CBUF_OVERFLOW_WRAP_ERR_FOUND_MAX  (0x00000001U)

#define CSL_OCMCECC_INTR0_ENABLE_SET_RESETVAL                   (0x00000000U)

/* INTR0_ENABLE_CLEAR */

#define CSL_OCMCECC_INTR0_ENABLE_CLEAR_SEC_ERR_FOUND_MASK       (0x00000001U)
#define CSL_OCMCECC_INTR0_ENABLE_CLEAR_SEC_ERR_FOUND_SHIFT      (0U)
#define CSL_OCMCECC_INTR0_ENABLE_CLEAR_SEC_ERR_FOUND_RESETVAL   (0x00000000U)
#define CSL_OCMCECC_INTR0_ENABLE_CLEAR_SEC_ERR_FOUND_MAX        (0x00000001U)

#define CSL_OCMCECC_INTR0_ENABLE_CLEAR_DED_ERR_FOUND_MASK       (0x00000002U)
#define CSL_OCMCECC_INTR0_ENABLE_CLEAR_DED_ERR_FOUND_SHIFT      (1U)
#define CSL_OCMCECC_INTR0_ENABLE_CLEAR_DED_ERR_FOUND_RESETVAL   (0x00000000U)
#define CSL_OCMCECC_INTR0_ENABLE_CLEAR_DED_ERR_FOUND_MAX        (0x00000001U)

#define CSL_OCMCECC_INTR0_ENABLE_CLEAR_ADDR_ERR_FOUND_MASK      (0x00000004U)
#define CSL_OCMCECC_INTR0_ENABLE_CLEAR_ADDR_ERR_FOUND_SHIFT     (2U)
#define CSL_OCMCECC_INTR0_ENABLE_CLEAR_ADDR_ERR_FOUND_RESETVAL  (0x00000000U)
#define CSL_OCMCECC_INTR0_ENABLE_CLEAR_ADDR_ERR_FOUND_MAX       (0x00000001U)

#define CSL_OCMCECC_INTR0_ENABLE_CLEAR_OUT_OF_RANGE_ERR_FOUND_MASK  (0x00000008U)
#define CSL_OCMCECC_INTR0_ENABLE_CLEAR_OUT_OF_RANGE_ERR_FOUND_SHIFT  (3U)
#define CSL_OCMCECC_INTR0_ENABLE_CLEAR_OUT_OF_RANGE_ERR_FOUND_RESETVAL  (0x00000000U)
#define CSL_OCMCECC_INTR0_ENABLE_CLEAR_OUT_OF_RANGE_ERR_FOUND_MAX  (0x00000001U)

#define CSL_OCMCECC_INTR0_ENABLE_CLEAR_CBUF_VIRTUAL_ADDR_ERR_FOUND_MASK  (0x00000010U)
#define CSL_OCMCECC_INTR0_ENABLE_CLEAR_CBUF_VIRTUAL_ADDR_ERR_FOUND_SHIFT  (4U)
#define CSL_OCMCECC_INTR0_ENABLE_CLEAR_CBUF_VIRTUAL_ADDR_ERR_FOUND_RESETVAL  (0x00000000U)
#define CSL_OCMCECC_INTR0_ENABLE_CLEAR_CBUF_VIRTUAL_ADDR_ERR_FOUND_MAX  (0x00000001U)

#define CSL_OCMCECC_INTR0_ENABLE_CLEAR_CBUF_OVERFLOW_MID_ERR_FOUND_MASK  (0x00000800U)
#define CSL_OCMCECC_INTR0_ENABLE_CLEAR_CBUF_OVERFLOW_MID_ERR_FOUND_SHIFT  (11U)
#define CSL_OCMCECC_INTR0_ENABLE_CLEAR_CBUF_OVERFLOW_MID_ERR_FOUND_RESETVAL  (0x00000000U)
#define CSL_OCMCECC_INTR0_ENABLE_CLEAR_CBUF_OVERFLOW_MID_ERR_FOUND_MAX  (0x00000001U)

#define CSL_OCMCECC_INTR0_ENABLE_CLEAR_CBUF_UNDERFLOW_ERR_FOUND_MASK  (0x00002000U)
#define CSL_OCMCECC_INTR0_ENABLE_CLEAR_CBUF_UNDERFLOW_ERR_FOUND_SHIFT  (13U)
#define CSL_OCMCECC_INTR0_ENABLE_CLEAR_CBUF_UNDERFLOW_ERR_FOUND_RESETVAL  (0x00000000U)
#define CSL_OCMCECC_INTR0_ENABLE_CLEAR_CBUF_UNDERFLOW_ERR_FOUND_MAX  (0x00000001U)

#define CSL_OCMCECC_INTR0_ENABLE_CLEAR_CBUF_SHORT_FRAME_DETECT_FOUND_MASK  (0x00004000U)
#define CSL_OCMCECC_INTR0_ENABLE_CLEAR_CBUF_SHORT_FRAME_DETECT_FOUND_SHIFT  (14U)
#define CSL_OCMCECC_INTR0_ENABLE_CLEAR_CBUF_SHORT_FRAME_DETECT_FOUND_RESETVAL  (0x00000000U)
#define CSL_OCMCECC_INTR0_ENABLE_CLEAR_CBUF_SHORT_FRAME_DETECT_FOUND_MAX  (0x00000001U)

#define CSL_OCMCECC_INTR0_ENABLE_CLEAR_CBUF_WR_OUT_OF_RANGE_ERR_FOUND_MASK  (0x00000020U)
#define CSL_OCMCECC_INTR0_ENABLE_CLEAR_CBUF_WR_OUT_OF_RANGE_ERR_FOUND_SHIFT  (5U)
#define CSL_OCMCECC_INTR0_ENABLE_CLEAR_CBUF_WR_OUT_OF_RANGE_ERR_FOUND_RESETVAL  (0x00000000U)
#define CSL_OCMCECC_INTR0_ENABLE_CLEAR_CBUF_WR_OUT_OF_RANGE_ERR_FOUND_MAX  (0x00000001U)

#define CSL_OCMCECC_INTR0_ENABLE_CLEAR_CBUF_VBUF_WRITE_START_ERR_FOUND_MASK  (0x00000040U)
#define CSL_OCMCECC_INTR0_ENABLE_CLEAR_CBUF_VBUF_WRITE_START_ERR_FOUND_SHIFT  (6U)
#define CSL_OCMCECC_INTR0_ENABLE_CLEAR_CBUF_VBUF_WRITE_START_ERR_FOUND_RESETVAL  (0x00000000U)
#define CSL_OCMCECC_INTR0_ENABLE_CLEAR_CBUF_VBUF_WRITE_START_ERR_FOUND_MAX  (0x00000001U)

#define CSL_OCMCECC_INTR0_ENABLE_CLEAR_CBUF_WRITE_SEQUENCE_ERR_FOUND_MASK  (0x00000080U)
#define CSL_OCMCECC_INTR0_ENABLE_CLEAR_CBUF_WRITE_SEQUENCE_ERR_FOUND_SHIFT  (7U)
#define CSL_OCMCECC_INTR0_ENABLE_CLEAR_CBUF_WRITE_SEQUENCE_ERR_FOUND_RESETVAL  (0x00000000U)
#define CSL_OCMCECC_INTR0_ENABLE_CLEAR_CBUF_WRITE_SEQUENCE_ERR_FOUND_MAX  (0x00000001U)

#define CSL_OCMCECC_INTR0_ENABLE_CLEAR_CBUF_READ_OUT_OF_RANGE_ERR_FOUND_MASK  (0x00000100U)
#define CSL_OCMCECC_INTR0_ENABLE_CLEAR_CBUF_READ_OUT_OF_RANGE_ERR_FOUND_SHIFT  (8U)
#define CSL_OCMCECC_INTR0_ENABLE_CLEAR_CBUF_READ_OUT_OF_RANGE_ERR_FOUND_RESETVAL  (0x00000000U)
#define CSL_OCMCECC_INTR0_ENABLE_CLEAR_CBUF_READ_OUT_OF_RANGE_ERR_FOUND_MAX  (0x00000001U)

#define CSL_OCMCECC_INTR0_ENABLE_CLEAR_CBUF_VBUF_READ_START_ERR_FOUND_MASK  (0x00000200U)
#define CSL_OCMCECC_INTR0_ENABLE_CLEAR_CBUF_VBUF_READ_START_ERR_FOUND_SHIFT  (9U)
#define CSL_OCMCECC_INTR0_ENABLE_CLEAR_CBUF_VBUF_READ_START_ERR_FOUND_RESETVAL  (0x00000000U)
#define CSL_OCMCECC_INTR0_ENABLE_CLEAR_CBUF_VBUF_READ_START_ERR_FOUND_MAX  (0x00000001U)

#define CSL_OCMCECC_INTR0_ENABLE_CLEAR_CBUF_READ_SEQUENCE_ERR_FOUND_MASK  (0x00000400U)
#define CSL_OCMCECC_INTR0_ENABLE_CLEAR_CBUF_READ_SEQUENCE_ERR_FOUND_SHIFT  (10U)
#define CSL_OCMCECC_INTR0_ENABLE_CLEAR_CBUF_READ_SEQUENCE_ERR_FOUND_RESETVAL  (0x00000000U)
#define CSL_OCMCECC_INTR0_ENABLE_CLEAR_CBUF_READ_SEQUENCE_ERR_FOUND_MAX  (0x00000001U)

#define CSL_OCMCECC_INTR0_ENABLE_CLEAR_CBUF_OVERFLOW_WRAP_ERR_FOUND_MASK  (0x00001000U)
#define CSL_OCMCECC_INTR0_ENABLE_CLEAR_CBUF_OVERFLOW_WRAP_ERR_FOUND_SHIFT  (12U)
#define CSL_OCMCECC_INTR0_ENABLE_CLEAR_CBUF_OVERFLOW_WRAP_ERR_FOUND_RESETVAL  (0x00000000U)
#define CSL_OCMCECC_INTR0_ENABLE_CLEAR_CBUF_OVERFLOW_WRAP_ERR_FOUND_MAX  (0x00000001U)

#define CSL_OCMCECC_INTR0_ENABLE_CLEAR_RESETVAL                 (0x00000000U)

/* INTR1_STATUS_RAW_SET */

#define CSL_OCMCECC_INTR1_STATUS_RAW_SET_SEC_ERR_FOUND_MASK     (0x00000001U)
#define CSL_OCMCECC_INTR1_STATUS_RAW_SET_SEC_ERR_FOUND_SHIFT    (0U)
#define CSL_OCMCECC_INTR1_STATUS_RAW_SET_SEC_ERR_FOUND_RESETVAL  (0x00000000U)
#define CSL_OCMCECC_INTR1_STATUS_RAW_SET_SEC_ERR_FOUND_MAX      (0x00000001U)

#define CSL_OCMCECC_INTR1_STATUS_RAW_SET_DED_ERR_FOUND_MASK     (0x00000002U)
#define CSL_OCMCECC_INTR1_STATUS_RAW_SET_DED_ERR_FOUND_SHIFT    (1U)
#define CSL_OCMCECC_INTR1_STATUS_RAW_SET_DED_ERR_FOUND_RESETVAL  (0x00000000U)
#define CSL_OCMCECC_INTR1_STATUS_RAW_SET_DED_ERR_FOUND_MAX      (0x00000001U)

#define CSL_OCMCECC_INTR1_STATUS_RAW_SET_ADDR_ERR_FOUND_MASK    (0x00000004U)
#define CSL_OCMCECC_INTR1_STATUS_RAW_SET_ADDR_ERR_FOUND_SHIFT   (2U)
#define CSL_OCMCECC_INTR1_STATUS_RAW_SET_ADDR_ERR_FOUND_RESETVAL  (0x00000000U)
#define CSL_OCMCECC_INTR1_STATUS_RAW_SET_ADDR_ERR_FOUND_MAX     (0x00000001U)

#define CSL_OCMCECC_INTR1_STATUS_RAW_SET_OUT_OF_RANGE_ERR_FOUND_MASK  (0x00000008U)
#define CSL_OCMCECC_INTR1_STATUS_RAW_SET_OUT_OF_RANGE_ERR_FOUND_SHIFT  (3U)
#define CSL_OCMCECC_INTR1_STATUS_RAW_SET_OUT_OF_RANGE_ERR_FOUND_RESETVAL  (0x00000000U)
#define CSL_OCMCECC_INTR1_STATUS_RAW_SET_OUT_OF_RANGE_ERR_FOUND_MAX  (0x00000001U)

#define CSL_OCMCECC_INTR1_STATUS_RAW_SET_CBUF_VIRTUAL_ADDR_ERR_FOUND_MASK  (0x00000010U)
#define CSL_OCMCECC_INTR1_STATUS_RAW_SET_CBUF_VIRTUAL_ADDR_ERR_FOUND_SHIFT  (4U)
#define CSL_OCMCECC_INTR1_STATUS_RAW_SET_CBUF_VIRTUAL_ADDR_ERR_FOUND_RESETVAL  (0x00000000U)
#define CSL_OCMCECC_INTR1_STATUS_RAW_SET_CBUF_VIRTUAL_ADDR_ERR_FOUND_MAX  (0x00000001U)

#define CSL_OCMCECC_INTR1_STATUS_RAW_SET_CBUF_OVERFLOW_MID_ERR_FOUND_MASK  (0x00000800U)
#define CSL_OCMCECC_INTR1_STATUS_RAW_SET_CBUF_OVERFLOW_MID_ERR_FOUND_SHIFT  (11U)
#define CSL_OCMCECC_INTR1_STATUS_RAW_SET_CBUF_OVERFLOW_MID_ERR_FOUND_RESETVAL  (0x00000000U)
#define CSL_OCMCECC_INTR1_STATUS_RAW_SET_CBUF_OVERFLOW_MID_ERR_FOUND_MAX  (0x00000001U)

#define CSL_OCMCECC_INTR1_STATUS_RAW_SET_CBUF_UNDERFLOW_ERR_FOUND_MASK  (0x00002000U)
#define CSL_OCMCECC_INTR1_STATUS_RAW_SET_CBUF_UNDERFLOW_ERR_FOUND_SHIFT  (13U)
#define CSL_OCMCECC_INTR1_STATUS_RAW_SET_CBUF_UNDERFLOW_ERR_FOUND_RESETVAL  (0x00000000U)
#define CSL_OCMCECC_INTR1_STATUS_RAW_SET_CBUF_UNDERFLOW_ERR_FOUND_MAX  (0x00000001U)

#define CSL_OCMCECC_INTR1_STATUS_RAW_SET_CBUF_SHORT_FRAME_DETECT_FOUND_MASK  (0x00004000U)
#define CSL_OCMCECC_INTR1_STATUS_RAW_SET_CBUF_SHORT_FRAME_DETECT_FOUND_SHIFT  (14U)
#define CSL_OCMCECC_INTR1_STATUS_RAW_SET_CBUF_SHORT_FRAME_DETECT_FOUND_RESETVAL  (0x00000000U)
#define CSL_OCMCECC_INTR1_STATUS_RAW_SET_CBUF_SHORT_FRAME_DETECT_FOUND_MAX  (0x00000001U)

#define CSL_OCMCECC_INTR1_STATUS_RAW_SET_CBUF_WR_OUT_OF_RANGE_ERR_FOUND_MASK  (0x00000020U)
#define CSL_OCMCECC_INTR1_STATUS_RAW_SET_CBUF_WR_OUT_OF_RANGE_ERR_FOUND_SHIFT  (5U)
#define CSL_OCMCECC_INTR1_STATUS_RAW_SET_CBUF_WR_OUT_OF_RANGE_ERR_FOUND_RESETVAL  (0x00000000U)
#define CSL_OCMCECC_INTR1_STATUS_RAW_SET_CBUF_WR_OUT_OF_RANGE_ERR_FOUND_MAX  (0x00000001U)

#define CSL_OCMCECC_INTR1_STATUS_RAW_SET_CBUF_VBUF_WRITE_START_ERR_FOUND_MASK  (0x00000040U)
#define CSL_OCMCECC_INTR1_STATUS_RAW_SET_CBUF_VBUF_WRITE_START_ERR_FOUND_SHIFT  (6U)
#define CSL_OCMCECC_INTR1_STATUS_RAW_SET_CBUF_VBUF_WRITE_START_ERR_FOUND_RESETVAL  (0x00000000U)
#define CSL_OCMCECC_INTR1_STATUS_RAW_SET_CBUF_VBUF_WRITE_START_ERR_FOUND_MAX  (0x00000001U)

#define CSL_OCMCECC_INTR1_STATUS_RAW_SET_CBUF_WRITE_SEQUENCE_ERR_FOUND_MASK  (0x00000080U)
#define CSL_OCMCECC_INTR1_STATUS_RAW_SET_CBUF_WRITE_SEQUENCE_ERR_FOUND_SHIFT  (7U)
#define CSL_OCMCECC_INTR1_STATUS_RAW_SET_CBUF_WRITE_SEQUENCE_ERR_FOUND_RESETVAL  (0x00000000U)
#define CSL_OCMCECC_INTR1_STATUS_RAW_SET_CBUF_WRITE_SEQUENCE_ERR_FOUND_MAX  (0x00000001U)

#define CSL_OCMCECC_INTR1_STATUS_RAW_SET_CBUF_READ_OUT_OF_RANGE_ERR_FOUND_MASK  (0x00000100U)
#define CSL_OCMCECC_INTR1_STATUS_RAW_SET_CBUF_READ_OUT_OF_RANGE_ERR_FOUND_SHIFT  (8U)
#define CSL_OCMCECC_INTR1_STATUS_RAW_SET_CBUF_READ_OUT_OF_RANGE_ERR_FOUND_RESETVAL  (0x00000000U)
#define CSL_OCMCECC_INTR1_STATUS_RAW_SET_CBUF_READ_OUT_OF_RANGE_ERR_FOUND_MAX  (0x00000001U)

#define CSL_OCMCECC_INTR1_STATUS_RAW_SET_CBUF_VBUF_READ_START_ERR_FOUND_MASK  (0x00000200U)
#define CSL_OCMCECC_INTR1_STATUS_RAW_SET_CBUF_VBUF_READ_START_ERR_FOUND_SHIFT  (9U)
#define CSL_OCMCECC_INTR1_STATUS_RAW_SET_CBUF_VBUF_READ_START_ERR_FOUND_RESETVAL  (0x00000000U)
#define CSL_OCMCECC_INTR1_STATUS_RAW_SET_CBUF_VBUF_READ_START_ERR_FOUND_MAX  (0x00000001U)

#define CSL_OCMCECC_INTR1_STATUS_RAW_SET_CBUF_READ_SEQUENCE_ERR_FOUND_MASK  (0x00000400U)
#define CSL_OCMCECC_INTR1_STATUS_RAW_SET_CBUF_READ_SEQUENCE_ERR_FOUND_SHIFT  (10U)
#define CSL_OCMCECC_INTR1_STATUS_RAW_SET_CBUF_READ_SEQUENCE_ERR_FOUND_RESETVAL  (0x00000000U)
#define CSL_OCMCECC_INTR1_STATUS_RAW_SET_CBUF_READ_SEQUENCE_ERR_FOUND_MAX  (0x00000001U)

#define CSL_OCMCECC_INTR1_STATUS_RAW_SET_CBUF_OVERFLOW_WRAP_ERR_FOUND_MASK  (0x00001000U)
#define CSL_OCMCECC_INTR1_STATUS_RAW_SET_CBUF_OVERFLOW_WRAP_ERR_FOUND_SHIFT  (12U)
#define CSL_OCMCECC_INTR1_STATUS_RAW_SET_CBUF_OVERFLOW_WRAP_ERR_FOUND_RESETVAL  (0x00000000U)
#define CSL_OCMCECC_INTR1_STATUS_RAW_SET_CBUF_OVERFLOW_WRAP_ERR_FOUND_MAX  (0x00000001U)

#define CSL_OCMCECC_INTR1_STATUS_RAW_SET_RESETVAL               (0x00000000U)

/* INTR1_EOI */

#define CSL_OCMCECC_INTR1_EOI_EOI_VECTOR_MASK                   (0x00000001U)
#define CSL_OCMCECC_INTR1_EOI_EOI_VECTOR_SHIFT                  (0U)
#define CSL_OCMCECC_INTR1_EOI_EOI_VECTOR_RESETVAL               (0x00000000U)
#define CSL_OCMCECC_INTR1_EOI_EOI_VECTOR_MAX                    (0x00000001U)

#define CSL_OCMCECC_INTR1_EOI_RESETVAL                          (0x00000000U)

/* INTR1_STATUS_ENABLED_CLEAR */

#define CSL_OCMCECC_INTR1_STATUS_ENABLED_CLEAR_SEC_ERR_FOUND_MASK  (0x00000001U)
#define CSL_OCMCECC_INTR1_STATUS_ENABLED_CLEAR_SEC_ERR_FOUND_SHIFT  (0U)
#define CSL_OCMCECC_INTR1_STATUS_ENABLED_CLEAR_SEC_ERR_FOUND_RESETVAL  (0x00000000U)
#define CSL_OCMCECC_INTR1_STATUS_ENABLED_CLEAR_SEC_ERR_FOUND_MAX  (0x00000001U)

#define CSL_OCMCECC_INTR1_STATUS_ENABLED_CLEAR_DED_ERR_FOUND_MASK  (0x00000002U)
#define CSL_OCMCECC_INTR1_STATUS_ENABLED_CLEAR_DED_ERR_FOUND_SHIFT  (1U)
#define CSL_OCMCECC_INTR1_STATUS_ENABLED_CLEAR_DED_ERR_FOUND_RESETVAL  (0x00000000U)
#define CSL_OCMCECC_INTR1_STATUS_ENABLED_CLEAR_DED_ERR_FOUND_MAX  (0x00000001U)

#define CSL_OCMCECC_INTR1_STATUS_ENABLED_CLEAR_ADDR_ERR_FOUND_MASK  (0x00000004U)
#define CSL_OCMCECC_INTR1_STATUS_ENABLED_CLEAR_ADDR_ERR_FOUND_SHIFT  (2U)
#define CSL_OCMCECC_INTR1_STATUS_ENABLED_CLEAR_ADDR_ERR_FOUND_RESETVAL  (0x00000000U)
#define CSL_OCMCECC_INTR1_STATUS_ENABLED_CLEAR_ADDR_ERR_FOUND_MAX  (0x00000001U)

#define CSL_OCMCECC_INTR1_STATUS_ENABLED_CLEAR_OUT_OF_RANGE_ERR_FOUND_MASK  (0x00000008U)
#define CSL_OCMCECC_INTR1_STATUS_ENABLED_CLEAR_OUT_OF_RANGE_ERR_FOUND_SHIFT  (3U)
#define CSL_OCMCECC_INTR1_STATUS_ENABLED_CLEAR_OUT_OF_RANGE_ERR_FOUND_RESETVAL  (0x00000000U)
#define CSL_OCMCECC_INTR1_STATUS_ENABLED_CLEAR_OUT_OF_RANGE_ERR_FOUND_MAX  (0x00000001U)

#define CSL_OCMCECC_INTR1_STATUS_ENABLED_CLEAR_CBUF_VIRTUAL_ADDR_ERR_FOUND_MASK  (0x00000010U)
#define CSL_OCMCECC_INTR1_STATUS_ENABLED_CLEAR_CBUF_VIRTUAL_ADDR_ERR_FOUND_SHIFT  (4U)
#define CSL_OCMCECC_INTR1_STATUS_ENABLED_CLEAR_CBUF_VIRTUAL_ADDR_ERR_FOUND_RESETVAL  (0x00000000U)
#define CSL_OCMCECC_INTR1_STATUS_ENABLED_CLEAR_CBUF_VIRTUAL_ADDR_ERR_FOUND_MAX  (0x00000001U)

#define CSL_OCMCECC_INTR1_STATUS_ENABLED_CLEAR_CBUF_OVERFLOW_MID_ERR_FOUND_MASK  (0x00000800U)
#define CSL_OCMCECC_INTR1_STATUS_ENABLED_CLEAR_CBUF_OVERFLOW_MID_ERR_FOUND_SHIFT  (11U)
#define CSL_OCMCECC_INTR1_STATUS_ENABLED_CLEAR_CBUF_OVERFLOW_MID_ERR_FOUND_RESETVAL  (0x00000000U)
#define CSL_OCMCECC_INTR1_STATUS_ENABLED_CLEAR_CBUF_OVERFLOW_MID_ERR_FOUND_MAX  (0x00000001U)

#define CSL_OCMCECC_INTR1_STATUS_ENABLED_CLEAR_CBUF_UNDERFLOW_ERR_FOUND_MASK  (0x00002000U)
#define CSL_OCMCECC_INTR1_STATUS_ENABLED_CLEAR_CBUF_UNDERFLOW_ERR_FOUND_SHIFT  (13U)
#define CSL_OCMCECC_INTR1_STATUS_ENABLED_CLEAR_CBUF_UNDERFLOW_ERR_FOUND_RESETVAL  (0x00000000U)
#define CSL_OCMCECC_INTR1_STATUS_ENABLED_CLEAR_CBUF_UNDERFLOW_ERR_FOUND_MAX  (0x00000001U)

#define CSL_OCMCECC_INTR1_STATUS_ENABLED_CLEAR_CBUF_SHORT_FRAME_DETECT_FOUND_MASK  (0x00004000U)
#define CSL_OCMCECC_INTR1_STATUS_ENABLED_CLEAR_CBUF_SHORT_FRAME_DETECT_FOUND_SHIFT  (14U)
#define CSL_OCMCECC_INTR1_STATUS_ENABLED_CLEAR_CBUF_SHORT_FRAME_DETECT_FOUND_RESETVAL  (0x00000000U)
#define CSL_OCMCECC_INTR1_STATUS_ENABLED_CLEAR_CBUF_SHORT_FRAME_DETECT_FOUND_MAX  (0x00000001U)

#define CSL_OCMCECC_INTR1_STATUS_ENABLED_CLEAR_CBUF_WR_OUT_OF_RANGE_ERR_FOUND_MASK  (0x00000020U)
#define CSL_OCMCECC_INTR1_STATUS_ENABLED_CLEAR_CBUF_WR_OUT_OF_RANGE_ERR_FOUND_SHIFT  (5U)
#define CSL_OCMCECC_INTR1_STATUS_ENABLED_CLEAR_CBUF_WR_OUT_OF_RANGE_ERR_FOUND_RESETVAL  (0x00000000U)
#define CSL_OCMCECC_INTR1_STATUS_ENABLED_CLEAR_CBUF_WR_OUT_OF_RANGE_ERR_FOUND_MAX  (0x00000001U)

#define CSL_OCMCECC_INTR1_STATUS_ENABLED_CLEAR_CBUF_VBUF_WRITE_START_ERR_FOUND_MASK  (0x00000040U)
#define CSL_OCMCECC_INTR1_STATUS_ENABLED_CLEAR_CBUF_VBUF_WRITE_START_ERR_FOUND_SHIFT  (6U)
#define CSL_OCMCECC_INTR1_STATUS_ENABLED_CLEAR_CBUF_VBUF_WRITE_START_ERR_FOUND_RESETVAL  (0x00000000U)
#define CSL_OCMCECC_INTR1_STATUS_ENABLED_CLEAR_CBUF_VBUF_WRITE_START_ERR_FOUND_MAX  (0x00000001U)

#define CSL_OCMCECC_INTR1_STATUS_ENABLED_CLEAR_CBUF_WRITE_SEQUENCE_ERR_FOUND_MASK  (0x00000080U)
#define CSL_OCMCECC_INTR1_STATUS_ENABLED_CLEAR_CBUF_WRITE_SEQUENCE_ERR_FOUND_SHIFT  (7U)
#define CSL_OCMCECC_INTR1_STATUS_ENABLED_CLEAR_CBUF_WRITE_SEQUENCE_ERR_FOUND_RESETVAL  (0x00000000U)
#define CSL_OCMCECC_INTR1_STATUS_ENABLED_CLEAR_CBUF_WRITE_SEQUENCE_ERR_FOUND_MAX  (0x00000001U)

#define CSL_OCMCECC_INTR1_STATUS_ENABLED_CLEAR_CBUF_READ_OUT_OF_RANGE_ERR_FOUND_MASK  (0x00000100U)
#define CSL_OCMCECC_INTR1_STATUS_ENABLED_CLEAR_CBUF_READ_OUT_OF_RANGE_ERR_FOUND_SHIFT  (8U)
#define CSL_OCMCECC_INTR1_STATUS_ENABLED_CLEAR_CBUF_READ_OUT_OF_RANGE_ERR_FOUND_RESETVAL  (0x00000000U)
#define CSL_OCMCECC_INTR1_STATUS_ENABLED_CLEAR_CBUF_READ_OUT_OF_RANGE_ERR_FOUND_MAX  (0x00000001U)

#define CSL_OCMCECC_INTR1_STATUS_ENABLED_CLEAR_CBUF_VBUF_READ_START_ERR_FOUND_MASK  (0x00000200U)
#define CSL_OCMCECC_INTR1_STATUS_ENABLED_CLEAR_CBUF_VBUF_READ_START_ERR_FOUND_SHIFT  (9U)
#define CSL_OCMCECC_INTR1_STATUS_ENABLED_CLEAR_CBUF_VBUF_READ_START_ERR_FOUND_RESETVAL  (0x00000000U)
#define CSL_OCMCECC_INTR1_STATUS_ENABLED_CLEAR_CBUF_VBUF_READ_START_ERR_FOUND_MAX  (0x00000001U)

#define CSL_OCMCECC_INTR1_STATUS_ENABLED_CLEAR_CBUF_READ_SEQUENCE_ERR_FOUND_MASK  (0x00000400U)
#define CSL_OCMCECC_INTR1_STATUS_ENABLED_CLEAR_CBUF_READ_SEQUENCE_ERR_FOUND_SHIFT  (10U)
#define CSL_OCMCECC_INTR1_STATUS_ENABLED_CLEAR_CBUF_READ_SEQUENCE_ERR_FOUND_RESETVAL  (0x00000000U)
#define CSL_OCMCECC_INTR1_STATUS_ENABLED_CLEAR_CBUF_READ_SEQUENCE_ERR_FOUND_MAX  (0x00000001U)

#define CSL_OCMCECC_INTR1_STATUS_ENABLED_CLEAR_CBUF_OVERFLOW_WRAP_ERR_FOUND_MASK  (0x00001000U)
#define CSL_OCMCECC_INTR1_STATUS_ENABLED_CLEAR_CBUF_OVERFLOW_WRAP_ERR_FOUND_SHIFT  (12U)
#define CSL_OCMCECC_INTR1_STATUS_ENABLED_CLEAR_CBUF_OVERFLOW_WRAP_ERR_FOUND_RESETVAL  (0x00000000U)
#define CSL_OCMCECC_INTR1_STATUS_ENABLED_CLEAR_CBUF_OVERFLOW_WRAP_ERR_FOUND_MAX  (0x00000001U)

#define CSL_OCMCECC_INTR1_STATUS_ENABLED_CLEAR_RESETVAL         (0x00000000U)

/* INTR1_ENABLE_SET */

#define CSL_OCMCECC_INTR1_ENABLE_SET_SEC_ERR_FOUND_MASK         (0x00000001U)
#define CSL_OCMCECC_INTR1_ENABLE_SET_SEC_ERR_FOUND_SHIFT        (0U)
#define CSL_OCMCECC_INTR1_ENABLE_SET_SEC_ERR_FOUND_RESETVAL     (0x00000000U)
#define CSL_OCMCECC_INTR1_ENABLE_SET_SEC_ERR_FOUND_MAX          (0x00000001U)

#define CSL_OCMCECC_INTR1_ENABLE_SET_DED_ERR_FOUND_MASK         (0x00000002U)
#define CSL_OCMCECC_INTR1_ENABLE_SET_DED_ERR_FOUND_SHIFT        (1U)
#define CSL_OCMCECC_INTR1_ENABLE_SET_DED_ERR_FOUND_RESETVAL     (0x00000000U)
#define CSL_OCMCECC_INTR1_ENABLE_SET_DED_ERR_FOUND_MAX          (0x00000001U)

#define CSL_OCMCECC_INTR1_ENABLE_SET_ADDR_ERR_FOUND_MASK        (0x00000004U)
#define CSL_OCMCECC_INTR1_ENABLE_SET_ADDR_ERR_FOUND_SHIFT       (2U)
#define CSL_OCMCECC_INTR1_ENABLE_SET_ADDR_ERR_FOUND_RESETVAL    (0x00000000U)
#define CSL_OCMCECC_INTR1_ENABLE_SET_ADDR_ERR_FOUND_MAX         (0x00000001U)

#define CSL_OCMCECC_INTR1_ENABLE_SET_OUT_OF_RANGE_ERR_FOUND_MASK  (0x00000008U)
#define CSL_OCMCECC_INTR1_ENABLE_SET_OUT_OF_RANGE_ERR_FOUND_SHIFT  (3U)
#define CSL_OCMCECC_INTR1_ENABLE_SET_OUT_OF_RANGE_ERR_FOUND_RESETVAL  (0x00000000U)
#define CSL_OCMCECC_INTR1_ENABLE_SET_OUT_OF_RANGE_ERR_FOUND_MAX  (0x00000001U)

#define CSL_OCMCECC_INTR1_ENABLE_SET_CBUF_VIRTUAL_ADDR_ERR_FOUND_MASK  (0x00000010U)
#define CSL_OCMCECC_INTR1_ENABLE_SET_CBUF_VIRTUAL_ADDR_ERR_FOUND_SHIFT  (4U)
#define CSL_OCMCECC_INTR1_ENABLE_SET_CBUF_VIRTUAL_ADDR_ERR_FOUND_RESETVAL  (0x00000000U)
#define CSL_OCMCECC_INTR1_ENABLE_SET_CBUF_VIRTUAL_ADDR_ERR_FOUND_MAX  (0x00000001U)

#define CSL_OCMCECC_INTR1_ENABLE_SET_CBUF_OVERFLOW_MID_ERR_FOUND_MASK  (0x00000800U)
#define CSL_OCMCECC_INTR1_ENABLE_SET_CBUF_OVERFLOW_MID_ERR_FOUND_SHIFT  (11U)
#define CSL_OCMCECC_INTR1_ENABLE_SET_CBUF_OVERFLOW_MID_ERR_FOUND_RESETVAL  (0x00000000U)
#define CSL_OCMCECC_INTR1_ENABLE_SET_CBUF_OVERFLOW_MID_ERR_FOUND_MAX  (0x00000001U)

#define CSL_OCMCECC_INTR1_ENABLE_SET_CBUF_UNDERFLOW_ERR_FOUND_MASK  (0x00002000U)
#define CSL_OCMCECC_INTR1_ENABLE_SET_CBUF_UNDERFLOW_ERR_FOUND_SHIFT  (13U)
#define CSL_OCMCECC_INTR1_ENABLE_SET_CBUF_UNDERFLOW_ERR_FOUND_RESETVAL  (0x00000000U)
#define CSL_OCMCECC_INTR1_ENABLE_SET_CBUF_UNDERFLOW_ERR_FOUND_MAX  (0x00000001U)

#define CSL_OCMCECC_INTR1_ENABLE_SET_CBUF_SHORT_FRAME_DETECT_FOUND_MASK  (0x00004000U)
#define CSL_OCMCECC_INTR1_ENABLE_SET_CBUF_SHORT_FRAME_DETECT_FOUND_SHIFT  (14U)
#define CSL_OCMCECC_INTR1_ENABLE_SET_CBUF_SHORT_FRAME_DETECT_FOUND_RESETVAL  (0x00000000U)
#define CSL_OCMCECC_INTR1_ENABLE_SET_CBUF_SHORT_FRAME_DETECT_FOUND_MAX  (0x00000001U)

#define CSL_OCMCECC_INTR1_ENABLE_SET_CBUF_WR_OUT_OF_RANGE_ERR_FOUND_MASK  (0x00000020U)
#define CSL_OCMCECC_INTR1_ENABLE_SET_CBUF_WR_OUT_OF_RANGE_ERR_FOUND_SHIFT  (5U)
#define CSL_OCMCECC_INTR1_ENABLE_SET_CBUF_WR_OUT_OF_RANGE_ERR_FOUND_RESETVAL  (0x00000000U)
#define CSL_OCMCECC_INTR1_ENABLE_SET_CBUF_WR_OUT_OF_RANGE_ERR_FOUND_MAX  (0x00000001U)

#define CSL_OCMCECC_INTR1_ENABLE_SET_CBUF_VBUF_WRITE_START_ERR_FOUND_MASK  (0x00000040U)
#define CSL_OCMCECC_INTR1_ENABLE_SET_CBUF_VBUF_WRITE_START_ERR_FOUND_SHIFT  (6U)
#define CSL_OCMCECC_INTR1_ENABLE_SET_CBUF_VBUF_WRITE_START_ERR_FOUND_RESETVAL  (0x00000000U)
#define CSL_OCMCECC_INTR1_ENABLE_SET_CBUF_VBUF_WRITE_START_ERR_FOUND_MAX  (0x00000001U)

#define CSL_OCMCECC_INTR1_ENABLE_SET_CBUF_WRITE_SEQUENCE_ERR_FOUND_MASK  (0x00000080U)
#define CSL_OCMCECC_INTR1_ENABLE_SET_CBUF_WRITE_SEQUENCE_ERR_FOUND_SHIFT  (7U)
#define CSL_OCMCECC_INTR1_ENABLE_SET_CBUF_WRITE_SEQUENCE_ERR_FOUND_RESETVAL  (0x00000000U)
#define CSL_OCMCECC_INTR1_ENABLE_SET_CBUF_WRITE_SEQUENCE_ERR_FOUND_MAX  (0x00000001U)

#define CSL_OCMCECC_INTR1_ENABLE_SET_CBUF_READ_OUT_OF_RANGE_ERR_FOUND_MASK  (0x00000100U)
#define CSL_OCMCECC_INTR1_ENABLE_SET_CBUF_READ_OUT_OF_RANGE_ERR_FOUND_SHIFT  (8U)
#define CSL_OCMCECC_INTR1_ENABLE_SET_CBUF_READ_OUT_OF_RANGE_ERR_FOUND_RESETVAL  (0x00000000U)
#define CSL_OCMCECC_INTR1_ENABLE_SET_CBUF_READ_OUT_OF_RANGE_ERR_FOUND_MAX  (0x00000001U)

#define CSL_OCMCECC_INTR1_ENABLE_SET_CBUF_VBUF_READ_START_ERR_FOUND_MASK  (0x00000200U)
#define CSL_OCMCECC_INTR1_ENABLE_SET_CBUF_VBUF_READ_START_ERR_FOUND_SHIFT  (9U)
#define CSL_OCMCECC_INTR1_ENABLE_SET_CBUF_VBUF_READ_START_ERR_FOUND_RESETVAL  (0x00000000U)
#define CSL_OCMCECC_INTR1_ENABLE_SET_CBUF_VBUF_READ_START_ERR_FOUND_MAX  (0x00000001U)

#define CSL_OCMCECC_INTR1_ENABLE_SET_CBUF_READ_SEQUENCE_ERR_FOUND_MASK  (0x00000400U)
#define CSL_OCMCECC_INTR1_ENABLE_SET_CBUF_READ_SEQUENCE_ERR_FOUND_SHIFT  (10U)
#define CSL_OCMCECC_INTR1_ENABLE_SET_CBUF_READ_SEQUENCE_ERR_FOUND_RESETVAL  (0x00000000U)
#define CSL_OCMCECC_INTR1_ENABLE_SET_CBUF_READ_SEQUENCE_ERR_FOUND_MAX  (0x00000001U)

#define CSL_OCMCECC_INTR1_ENABLE_SET_CBUF_OVERFLOW_WRAP_ERR_FOUND_MASK  (0x00001000U)
#define CSL_OCMCECC_INTR1_ENABLE_SET_CBUF_OVERFLOW_WRAP_ERR_FOUND_SHIFT  (12U)
#define CSL_OCMCECC_INTR1_ENABLE_SET_CBUF_OVERFLOW_WRAP_ERR_FOUND_RESETVAL  (0x00000000U)
#define CSL_OCMCECC_INTR1_ENABLE_SET_CBUF_OVERFLOW_WRAP_ERR_FOUND_MAX  (0x00000001U)

#define CSL_OCMCECC_INTR1_ENABLE_SET_RESETVAL                   (0x00000000U)

/* INTR1_ENABLE_CLEAR */

#define CSL_OCMCECC_INTR1_ENABLE_CLEAR_SEC_ERR_FOUND_MASK       (0x00000001U)
#define CSL_OCMCECC_INTR1_ENABLE_CLEAR_SEC_ERR_FOUND_SHIFT      (0U)
#define CSL_OCMCECC_INTR1_ENABLE_CLEAR_SEC_ERR_FOUND_RESETVAL   (0x00000000U)
#define CSL_OCMCECC_INTR1_ENABLE_CLEAR_SEC_ERR_FOUND_MAX        (0x00000001U)

#define CSL_OCMCECC_INTR1_ENABLE_CLEAR_DED_ERR_FOUND_MASK       (0x00000002U)
#define CSL_OCMCECC_INTR1_ENABLE_CLEAR_DED_ERR_FOUND_SHIFT      (1U)
#define CSL_OCMCECC_INTR1_ENABLE_CLEAR_DED_ERR_FOUND_RESETVAL   (0x00000000U)
#define CSL_OCMCECC_INTR1_ENABLE_CLEAR_DED_ERR_FOUND_MAX        (0x00000001U)

#define CSL_OCMCECC_INTR1_ENABLE_CLEAR_ADDR_ERR_FOUND_MASK      (0x00000004U)
#define CSL_OCMCECC_INTR1_ENABLE_CLEAR_ADDR_ERR_FOUND_SHIFT     (2U)
#define CSL_OCMCECC_INTR1_ENABLE_CLEAR_ADDR_ERR_FOUND_RESETVAL  (0x00000000U)
#define CSL_OCMCECC_INTR1_ENABLE_CLEAR_ADDR_ERR_FOUND_MAX       (0x00000001U)

#define CSL_OCMCECC_INTR1_ENABLE_CLEAR_OUT_OF_RANGE_ERR_FOUND_MASK  (0x00000008U)
#define CSL_OCMCECC_INTR1_ENABLE_CLEAR_OUT_OF_RANGE_ERR_FOUND_SHIFT  (3U)
#define CSL_OCMCECC_INTR1_ENABLE_CLEAR_OUT_OF_RANGE_ERR_FOUND_RESETVAL  (0x00000000U)
#define CSL_OCMCECC_INTR1_ENABLE_CLEAR_OUT_OF_RANGE_ERR_FOUND_MAX  (0x00000001U)

#define CSL_OCMCECC_INTR1_ENABLE_CLEAR_CBUF_VIRTUAL_ADDR_ERR_FOUND_MASK  (0x00000010U)
#define CSL_OCMCECC_INTR1_ENABLE_CLEAR_CBUF_VIRTUAL_ADDR_ERR_FOUND_SHIFT  (4U)
#define CSL_OCMCECC_INTR1_ENABLE_CLEAR_CBUF_VIRTUAL_ADDR_ERR_FOUND_RESETVAL  (0x00000000U)
#define CSL_OCMCECC_INTR1_ENABLE_CLEAR_CBUF_VIRTUAL_ADDR_ERR_FOUND_MAX  (0x00000001U)

#define CSL_OCMCECC_INTR1_ENABLE_CLEAR_CBUF_OVERFLOW_MID_ERR_FOUND_MASK  (0x00000800U)
#define CSL_OCMCECC_INTR1_ENABLE_CLEAR_CBUF_OVERFLOW_MID_ERR_FOUND_SHIFT  (11U)
#define CSL_OCMCECC_INTR1_ENABLE_CLEAR_CBUF_OVERFLOW_MID_ERR_FOUND_RESETVAL  (0x00000000U)
#define CSL_OCMCECC_INTR1_ENABLE_CLEAR_CBUF_OVERFLOW_MID_ERR_FOUND_MAX  (0x00000001U)

#define CSL_OCMCECC_INTR1_ENABLE_CLEAR_CBUF_UNDERFLOW_ERR_FOUND_MASK  (0x00002000U)
#define CSL_OCMCECC_INTR1_ENABLE_CLEAR_CBUF_UNDERFLOW_ERR_FOUND_SHIFT  (13U)
#define CSL_OCMCECC_INTR1_ENABLE_CLEAR_CBUF_UNDERFLOW_ERR_FOUND_RESETVAL  (0x00000000U)
#define CSL_OCMCECC_INTR1_ENABLE_CLEAR_CBUF_UNDERFLOW_ERR_FOUND_MAX  (0x00000001U)

#define CSL_OCMCECC_INTR1_ENABLE_CLEAR_CBUF_SHORT_FRAME_DETECT_FOUND_MASK  (0x00004000U)
#define CSL_OCMCECC_INTR1_ENABLE_CLEAR_CBUF_SHORT_FRAME_DETECT_FOUND_SHIFT  (14U)
#define CSL_OCMCECC_INTR1_ENABLE_CLEAR_CBUF_SHORT_FRAME_DETECT_FOUND_RESETVAL  (0x00000000U)
#define CSL_OCMCECC_INTR1_ENABLE_CLEAR_CBUF_SHORT_FRAME_DETECT_FOUND_MAX  (0x00000001U)

#define CSL_OCMCECC_INTR1_ENABLE_CLEAR_CBUF_WR_OUT_OF_RANGE_ERR_FOUND_MASK  (0x00000020U)
#define CSL_OCMCECC_INTR1_ENABLE_CLEAR_CBUF_WR_OUT_OF_RANGE_ERR_FOUND_SHIFT  (5U)
#define CSL_OCMCECC_INTR1_ENABLE_CLEAR_CBUF_WR_OUT_OF_RANGE_ERR_FOUND_RESETVAL  (0x00000000U)
#define CSL_OCMCECC_INTR1_ENABLE_CLEAR_CBUF_WR_OUT_OF_RANGE_ERR_FOUND_MAX  (0x00000001U)

#define CSL_OCMCECC_INTR1_ENABLE_CLEAR_CBUF_VBUF_WRITE_START_ERR_FOUND_MASK  (0x00000040U)
#define CSL_OCMCECC_INTR1_ENABLE_CLEAR_CBUF_VBUF_WRITE_START_ERR_FOUND_SHIFT  (6U)
#define CSL_OCMCECC_INTR1_ENABLE_CLEAR_CBUF_VBUF_WRITE_START_ERR_FOUND_RESETVAL  (0x00000000U)
#define CSL_OCMCECC_INTR1_ENABLE_CLEAR_CBUF_VBUF_WRITE_START_ERR_FOUND_MAX  (0x00000001U)

#define CSL_OCMCECC_INTR1_ENABLE_CLEAR_CBUF_WRITE_SEQUENCE_ERR_FOUND_MASK  (0x00000080U)
#define CSL_OCMCECC_INTR1_ENABLE_CLEAR_CBUF_WRITE_SEQUENCE_ERR_FOUND_SHIFT  (7U)
#define CSL_OCMCECC_INTR1_ENABLE_CLEAR_CBUF_WRITE_SEQUENCE_ERR_FOUND_RESETVAL  (0x00000000U)
#define CSL_OCMCECC_INTR1_ENABLE_CLEAR_CBUF_WRITE_SEQUENCE_ERR_FOUND_MAX  (0x00000001U)

#define CSL_OCMCECC_INTR1_ENABLE_CLEAR_CBUF_READ_OUT_OF_RANGE_ERR_FOUND_MASK  (0x00000100U)
#define CSL_OCMCECC_INTR1_ENABLE_CLEAR_CBUF_READ_OUT_OF_RANGE_ERR_FOUND_SHIFT  (8U)
#define CSL_OCMCECC_INTR1_ENABLE_CLEAR_CBUF_READ_OUT_OF_RANGE_ERR_FOUND_RESETVAL  (0x00000000U)
#define CSL_OCMCECC_INTR1_ENABLE_CLEAR_CBUF_READ_OUT_OF_RANGE_ERR_FOUND_MAX  (0x00000001U)

#define CSL_OCMCECC_INTR1_ENABLE_CLEAR_CBUF_VBUF_READ_START_ERR_FOUND_MASK  (0x00000200U)
#define CSL_OCMCECC_INTR1_ENABLE_CLEAR_CBUF_VBUF_READ_START_ERR_FOUND_SHIFT  (9U)
#define CSL_OCMCECC_INTR1_ENABLE_CLEAR_CBUF_VBUF_READ_START_ERR_FOUND_RESETVAL  (0x00000000U)
#define CSL_OCMCECC_INTR1_ENABLE_CLEAR_CBUF_VBUF_READ_START_ERR_FOUND_MAX  (0x00000001U)

#define CSL_OCMCECC_INTR1_ENABLE_CLEAR_CBUF_READ_SEQUENCE_ERR_FOUND_MASK  (0x00000400U)
#define CSL_OCMCECC_INTR1_ENABLE_CLEAR_CBUF_READ_SEQUENCE_ERR_FOUND_SHIFT  (10U)
#define CSL_OCMCECC_INTR1_ENABLE_CLEAR_CBUF_READ_SEQUENCE_ERR_FOUND_RESETVAL  (0x00000000U)
#define CSL_OCMCECC_INTR1_ENABLE_CLEAR_CBUF_READ_SEQUENCE_ERR_FOUND_MAX  (0x00000001U)

#define CSL_OCMCECC_INTR1_ENABLE_CLEAR_CBUF_OVERFLOW_WRAP_ERR_FOUND_MASK  (0x00001000U)
#define CSL_OCMCECC_INTR1_ENABLE_CLEAR_CBUF_OVERFLOW_WRAP_ERR_FOUND_SHIFT  (12U)
#define CSL_OCMCECC_INTR1_ENABLE_CLEAR_CBUF_OVERFLOW_WRAP_ERR_FOUND_RESETVAL  (0x00000000U)
#define CSL_OCMCECC_INTR1_ENABLE_CLEAR_CBUF_OVERFLOW_WRAP_ERR_FOUND_MAX  (0x00000001U)

#define CSL_OCMCECC_INTR1_ENABLE_CLEAR_RESETVAL                 (0x00000000U)

/* STATUS_ERROR_CNT */

#define CSL_OCMCECC_STATUS_ERROR_CNT_SEC_ERROR_CNT_MASK         (0x0000FFFFU)
#define CSL_OCMCECC_STATUS_ERROR_CNT_SEC_ERROR_CNT_SHIFT        (0U)
#define CSL_OCMCECC_STATUS_ERROR_CNT_SEC_ERROR_CNT_RESETVAL     (0x00000000U)
#define CSL_OCMCECC_STATUS_ERROR_CNT_SEC_ERROR_CNT_MAX          (0x0000ffffU)

#define CSL_OCMCECC_STATUS_ERROR_CNT_DED_ERROR_CNT_MASK         (0x000F0000U)
#define CSL_OCMCECC_STATUS_ERROR_CNT_DED_ERROR_CNT_SHIFT        (16U)
#define CSL_OCMCECC_STATUS_ERROR_CNT_DED_ERROR_CNT_RESETVAL     (0x00000000U)
#define CSL_OCMCECC_STATUS_ERROR_CNT_DED_ERROR_CNT_MAX          (0x0000000fU)

#define CSL_OCMCECC_STATUS_ERROR_CNT_ADDR_ERROR_CNT_MASK        (0x00F00000U)
#define CSL_OCMCECC_STATUS_ERROR_CNT_ADDR_ERROR_CNT_SHIFT       (20U)
#define CSL_OCMCECC_STATUS_ERROR_CNT_ADDR_ERROR_CNT_RESETVAL    (0x00000000U)
#define CSL_OCMCECC_STATUS_ERROR_CNT_ADDR_ERROR_CNT_MAX         (0x0000000fU)

#define CSL_OCMCECC_STATUS_ERROR_CNT_RESETVAL                   (0x00000000U)

/* STATUS_SEC_ERROR_TRACE */

#define CSL_OCMCECC_STATUS_SEC_ERROR_TRACE_ADDRESS_128BIT_MASK  (0x0003FFFFU)
#define CSL_OCMCECC_STATUS_SEC_ERROR_TRACE_ADDRESS_128BIT_SHIFT  (0U)
#define CSL_OCMCECC_STATUS_SEC_ERROR_TRACE_ADDRESS_128BIT_RESETVAL  (0x00000000U)
#define CSL_OCMCECC_STATUS_SEC_ERROR_TRACE_ADDRESS_128BIT_MAX   (0x0003ffffU)

#define CSL_OCMCECC_STATUS_SEC_ERROR_TRACE_VALID_MASK           (0x00040000U)
#define CSL_OCMCECC_STATUS_SEC_ERROR_TRACE_VALID_SHIFT          (18U)
#define CSL_OCMCECC_STATUS_SEC_ERROR_TRACE_VALID_RESETVAL       (0x00000000U)
#define CSL_OCMCECC_STATUS_SEC_ERROR_TRACE_VALID_VALID_ADDRESS_READ  (0x00000001U)
#define CSL_OCMCECC_STATUS_SEC_ERROR_TRACE_VALID_ADDRESS_TRACE_FIFO_EMPTY  (0x00000000U)

#define CSL_OCMCECC_STATUS_SEC_ERROR_TRACE_RESETVAL             (0x00000000U)

/* STATUS_DED_ERROR_TRACE */

#define CSL_OCMCECC_STATUS_DED_ERROR_TRACE_ADDRESS_128BIT_MASK  (0x0003FFFFU)
#define CSL_OCMCECC_STATUS_DED_ERROR_TRACE_ADDRESS_128BIT_SHIFT  (0U)
#define CSL_OCMCECC_STATUS_DED_ERROR_TRACE_ADDRESS_128BIT_RESETVAL  (0x00000000U)
#define CSL_OCMCECC_STATUS_DED_ERROR_TRACE_ADDRESS_128BIT_MAX   (0x0003ffffU)

#define CSL_OCMCECC_STATUS_DED_ERROR_TRACE_VALID_MASK           (0x00040000U)
#define CSL_OCMCECC_STATUS_DED_ERROR_TRACE_VALID_SHIFT          (18U)
#define CSL_OCMCECC_STATUS_DED_ERROR_TRACE_VALID_RESETVAL       (0x00000000U)
#define CSL_OCMCECC_STATUS_DED_ERROR_TRACE_VALID_MAX            (0x00000001U)

#define CSL_OCMCECC_STATUS_DED_ERROR_TRACE_RESETVAL             (0x00000000U)

/* STATUS_ADDR_TRANSLATION_ERROR_TRACE */

#define CSL_OCMCECC_STATUS_ADDR_TRANSLATION_ERROR_TRACE_ADDRESS_128BIT_MASK  (0x0003FFFFU)
#define CSL_OCMCECC_STATUS_ADDR_TRANSLATION_ERROR_TRACE_ADDRESS_128BIT_SHIFT  (0U)
#define CSL_OCMCECC_STATUS_ADDR_TRANSLATION_ERROR_TRACE_ADDRESS_128BIT_RESETVAL  (0x00000000U)
#define CSL_OCMCECC_STATUS_ADDR_TRANSLATION_ERROR_TRACE_ADDRESS_128BIT_MAX  (0x0003ffffU)

#define CSL_OCMCECC_STATUS_ADDR_TRANSLATION_ERROR_TRACE_VALID_MASK  (0x00040000U)
#define CSL_OCMCECC_STATUS_ADDR_TRANSLATION_ERROR_TRACE_VALID_SHIFT  (18U)
#define CSL_OCMCECC_STATUS_ADDR_TRANSLATION_ERROR_TRACE_VALID_RESETVAL  (0x00000000U)
#define CSL_OCMCECC_STATUS_ADDR_TRANSLATION_ERROR_TRACE_VALID_MAX  (0x00000001U)

#define CSL_OCMCECC_STATUS_ADDR_TRANSLATION_ERROR_TRACE_RESETVAL  (0x00000000U)

/* STATUS_SEC_ERROR_DISTR_0 */

#define CSL_OCMCECC_STATUS_SEC_ERROR_DISTR_0_SEC_BIT_ERROR_FOUND_MASK  (0xFFFFFFFFU)
#define CSL_OCMCECC_STATUS_SEC_ERROR_DISTR_0_SEC_BIT_ERROR_FOUND_SHIFT  (0U)
#define CSL_OCMCECC_STATUS_SEC_ERROR_DISTR_0_SEC_BIT_ERROR_FOUND_RESETVAL  (0x00000000U)
#define CSL_OCMCECC_STATUS_SEC_ERROR_DISTR_0_SEC_BIT_ERROR_FOUND_MAX  (0xffffffffU)

#define CSL_OCMCECC_STATUS_SEC_ERROR_DISTR_0_RESETVAL           (0x00000000U)

/* STATUS_SEC_ERROR_DISTR_1 */

#define CSL_OCMCECC_STATUS_SEC_ERROR_DISTR_1_SEC_BIT_ERROR_FOUND_MASK  (0xFFFFFFFFU)
#define CSL_OCMCECC_STATUS_SEC_ERROR_DISTR_1_SEC_BIT_ERROR_FOUND_SHIFT  (0U)
#define CSL_OCMCECC_STATUS_SEC_ERROR_DISTR_1_SEC_BIT_ERROR_FOUND_RESETVAL  (0x00000000U)
#define CSL_OCMCECC_STATUS_SEC_ERROR_DISTR_1_SEC_BIT_ERROR_FOUND_MAX  (0xffffffffU)

#define CSL_OCMCECC_STATUS_SEC_ERROR_DISTR_1_RESETVAL           (0x00000000U)

/* STATUS_SEC_ERROR_DISTR_2 */

#define CSL_OCMCECC_STATUS_SEC_ERROR_DISTR_2_SEC_BIT_ERROR_FOUND_MASK  (0xFFFFFFFFU)
#define CSL_OCMCECC_STATUS_SEC_ERROR_DISTR_2_SEC_BIT_ERROR_FOUND_SHIFT  (0U)
#define CSL_OCMCECC_STATUS_SEC_ERROR_DISTR_2_SEC_BIT_ERROR_FOUND_RESETVAL  (0x00000000U)
#define CSL_OCMCECC_STATUS_SEC_ERROR_DISTR_2_SEC_BIT_ERROR_FOUND_MAX  (0xffffffffU)

#define CSL_OCMCECC_STATUS_SEC_ERROR_DISTR_2_RESETVAL           (0x00000000U)

/* STATUS_SEC_ERROR_DISTR_3 */

#define CSL_OCMCECC_STATUS_SEC_ERROR_DISTR_3_SEC_BIT_ERROR_FOUND_MASK  (0xFFFFFFFFU)
#define CSL_OCMCECC_STATUS_SEC_ERROR_DISTR_3_SEC_BIT_ERROR_FOUND_SHIFT  (0U)
#define CSL_OCMCECC_STATUS_SEC_ERROR_DISTR_3_SEC_BIT_ERROR_FOUND_RESETVAL  (0x00000000U)
#define CSL_OCMCECC_STATUS_SEC_ERROR_DISTR_3_SEC_BIT_ERROR_FOUND_MAX  (0xffffffffU)

#define CSL_OCMCECC_STATUS_SEC_ERROR_DISTR_3_RESETVAL           (0x00000000U)

/* STATUS_SEC_ERROR_DISTR_4 */

#define CSL_OCMCECC_STATUS_SEC_ERROR_DISTR_4_SEC_ECC_CODE_ERROR_FOUND_MASK  (0x000000FFU)
#define CSL_OCMCECC_STATUS_SEC_ERROR_DISTR_4_SEC_ECC_CODE_ERROR_FOUND_SHIFT  (0U)
#define CSL_OCMCECC_STATUS_SEC_ERROR_DISTR_4_SEC_ECC_CODE_ERROR_FOUND_RESETVAL  (0x00000000U)
#define CSL_OCMCECC_STATUS_SEC_ERROR_DISTR_4_SEC_ECC_CODE_ERROR_FOUND_MAX  (0x000000ffU)

#define CSL_OCMCECC_STATUS_SEC_ERROR_DISTR_4_RESETVAL           (0x00000000U)

/* CFG_OCMC_ECC */

#define CSL_OCMCECC_CFG_OCMC_ECC_CFG_OCMC_MODE_MASK             (0x00000007U)
#define CSL_OCMCECC_CFG_OCMC_ECC_CFG_OCMC_MODE_SHIFT            (0U)
#define CSL_OCMCECC_CFG_OCMC_ECC_CFG_OCMC_MODE_RESETVAL         (0x00000000U)
#define CSL_OCMCECC_CFG_OCMC_ECC_CFG_OCMC_MODE_NON_ECC_DATA     (0x00000000U)
#define CSL_OCMCECC_CFG_OCMC_ECC_CFG_OCMC_MODE_NON_ECC_CODE     (0x00000001U)
#define CSL_OCMCECC_CFG_OCMC_ECC_CFG_OCMC_MODE_FULL_ECC         (0x00000002U)
#define CSL_OCMCECC_CFG_OCMC_ECC_CFG_OCMC_MODE_BLOCK_ECC        (0x00000003U)

#define CSL_OCMCECC_CFG_OCMC_ECC_CFG_ECC_SEC_AUTO_CORRECT_MASK  (0x00000008U)
#define CSL_OCMCECC_CFG_OCMC_ECC_CFG_ECC_SEC_AUTO_CORRECT_SHIFT  (3U)
#define CSL_OCMCECC_CFG_OCMC_ECC_CFG_ECC_SEC_AUTO_CORRECT_RESETVAL  (0x00000000U)
#define CSL_OCMCECC_CFG_OCMC_ECC_CFG_ECC_SEC_AUTO_CORRECT_MAX   (0x00000001U)

#define CSL_OCMCECC_CFG_OCMC_ECC_CFG_ECC_ERR_SRESP_EN_MASK      (0x00000010U)
#define CSL_OCMCECC_CFG_OCMC_ECC_CFG_ECC_ERR_SRESP_EN_SHIFT     (4U)
#define CSL_OCMCECC_CFG_OCMC_ECC_CFG_ECC_ERR_SRESP_EN_RESETVAL  (0x00000000U)
#define CSL_OCMCECC_CFG_OCMC_ECC_CFG_ECC_ERR_SRESP_EN_MAX       (0x00000001U)

#define CSL_OCMCECC_CFG_OCMC_ECC_CFG_ECC_OPT_NON_ECC_READ_MASK  (0x00000020U)
#define CSL_OCMCECC_CFG_OCMC_ECC_CFG_ECC_OPT_NON_ECC_READ_SHIFT  (5U)
#define CSL_OCMCECC_CFG_OCMC_ECC_CFG_ECC_OPT_NON_ECC_READ_RESETVAL  (0x00000000U)
#define CSL_OCMCECC_CFG_OCMC_ECC_CFG_ECC_OPT_NON_ECC_READ_MAX   (0x00000001U)

#define CSL_OCMCECC_CFG_OCMC_ECC_RESETVAL                       (0x00000000U)

/* CFG_OCMC_ECC_MEM_BLK */

#define CSL_OCMCECC_CFG_OCMC_ECC_MEM_BLK_CFG_ECC_ENABLED_128K_BLK_MASK  (0x000FFFFFU)
#define CSL_OCMCECC_CFG_OCMC_ECC_MEM_BLK_CFG_ECC_ENABLED_128K_BLK_SHIFT  (0U)
#define CSL_OCMCECC_CFG_OCMC_ECC_MEM_BLK_CFG_ECC_ENABLED_128K_BLK_RESETVAL  (0x00000000U)
#define CSL_OCMCECC_CFG_OCMC_ECC_MEM_BLK_CFG_ECC_ENABLED_128K_BLK_MAX  (0x000fffffU)

#define CSL_OCMCECC_CFG_OCMC_ECC_MEM_BLK_RESETVAL               (0x00000000U)

/* CFG_OCMC_ECC_ERROR */

#define CSL_OCMCECC_CFG_OCMC_ECC_ERROR_CFG_SEC_CNT_MAX_MASK     (0x0000FFFFU)
#define CSL_OCMCECC_CFG_OCMC_ECC_ERROR_CFG_SEC_CNT_MAX_SHIFT    (0U)
#define CSL_OCMCECC_CFG_OCMC_ECC_ERROR_CFG_SEC_CNT_MAX_RESETVAL  (0x00000001U)
#define CSL_OCMCECC_CFG_OCMC_ECC_ERROR_CFG_SEC_CNT_MAX_MAX      (0x0000ffffU)

#define CSL_OCMCECC_CFG_OCMC_ECC_ERROR_CFG_DED_CNT_MAX_MASK     (0x000F0000U)
#define CSL_OCMCECC_CFG_OCMC_ECC_ERROR_CFG_DED_CNT_MAX_SHIFT    (16U)
#define CSL_OCMCECC_CFG_OCMC_ECC_ERROR_CFG_DED_CNT_MAX_RESETVAL  (0x00000001U)
#define CSL_OCMCECC_CFG_OCMC_ECC_ERROR_CFG_DED_CNT_MAX_MAX      (0x0000000fU)

#define CSL_OCMCECC_CFG_OCMC_ECC_ERROR_CFG_ADDR_ERR_CNT_MAX_MASK  (0x00F00000U)
#define CSL_OCMCECC_CFG_OCMC_ECC_ERROR_CFG_ADDR_ERR_CNT_MAX_SHIFT  (20U)
#define CSL_OCMCECC_CFG_OCMC_ECC_ERROR_CFG_ADDR_ERR_CNT_MAX_RESETVAL  (0x00000001U)
#define CSL_OCMCECC_CFG_OCMC_ECC_ERROR_CFG_ADDR_ERR_CNT_MAX_MAX  (0x0000000fU)

#define CSL_OCMCECC_CFG_OCMC_ECC_ERROR_CFG_DISCARD_DUP_ADDR_MASK  (0x01000000U)
#define CSL_OCMCECC_CFG_OCMC_ECC_ERROR_CFG_DISCARD_DUP_ADDR_SHIFT  (24U)
#define CSL_OCMCECC_CFG_OCMC_ECC_ERROR_CFG_DISCARD_DUP_ADDR_RESETVAL  (0x00000000U)
#define CSL_OCMCECC_CFG_OCMC_ECC_ERROR_CFG_DISCARD_DUP_ADDR_MAX  (0x00000001U)

#define CSL_OCMCECC_CFG_OCMC_ECC_ERROR_RESETVAL                 (0x00110001U)

/* CFG_OCMC_ECC_CLEAR_HIST */

#define CSL_OCMCECC_CFG_OCMC_ECC_CLEAR_HIST_CLEAR_SEC_ERR_CNT_MASK  (0x00000001U)
#define CSL_OCMCECC_CFG_OCMC_ECC_CLEAR_HIST_CLEAR_SEC_ERR_CNT_SHIFT  (0U)
#define CSL_OCMCECC_CFG_OCMC_ECC_CLEAR_HIST_CLEAR_SEC_ERR_CNT_RESETVAL  (0x00000000U)
#define CSL_OCMCECC_CFG_OCMC_ECC_CLEAR_HIST_CLEAR_SEC_ERR_CNT_MAX  (0x00000001U)

#define CSL_OCMCECC_CFG_OCMC_ECC_CLEAR_HIST_CLEAR_DED_ERR_CNT_MASK  (0x00000002U)
#define CSL_OCMCECC_CFG_OCMC_ECC_CLEAR_HIST_CLEAR_DED_ERR_CNT_SHIFT  (1U)
#define CSL_OCMCECC_CFG_OCMC_ECC_CLEAR_HIST_CLEAR_DED_ERR_CNT_RESETVAL  (0x00000000U)
#define CSL_OCMCECC_CFG_OCMC_ECC_CLEAR_HIST_CLEAR_DED_ERR_CNT_MAX  (0x00000001U)

#define CSL_OCMCECC_CFG_OCMC_ECC_CLEAR_HIST_CLEAR_ADDR_ERR_CNT_MASK  (0x00000004U)
#define CSL_OCMCECC_CFG_OCMC_ECC_CLEAR_HIST_CLEAR_ADDR_ERR_CNT_SHIFT  (2U)
#define CSL_OCMCECC_CFG_OCMC_ECC_CLEAR_HIST_CLEAR_ADDR_ERR_CNT_RESETVAL  (0x00000000U)
#define CSL_OCMCECC_CFG_OCMC_ECC_CLEAR_HIST_CLEAR_ADDR_ERR_CNT_MAX  (0x00000001U)

#define CSL_OCMCECC_CFG_OCMC_ECC_CLEAR_HIST_CLEAR_SEC_BIT_DISTR_MASK  (0x00000008U)
#define CSL_OCMCECC_CFG_OCMC_ECC_CLEAR_HIST_CLEAR_SEC_BIT_DISTR_SHIFT  (3U)
#define CSL_OCMCECC_CFG_OCMC_ECC_CLEAR_HIST_CLEAR_SEC_BIT_DISTR_RESETVAL  (0x00000000U)
#define CSL_OCMCECC_CFG_OCMC_ECC_CLEAR_HIST_CLEAR_SEC_BIT_DISTR_MAX  (0x00000001U)

#define CSL_OCMCECC_CFG_OCMC_ECC_CLEAR_HIST_RESETVAL            (0x00000000U)

/* CFG_OCMC_CBUF_EN */

#define CSL_OCMCECC_CFG_OCMC_CBUF_EN_CBUF_MODE_EN_MASK          (0x00000001U)
#define CSL_OCMCECC_CFG_OCMC_CBUF_EN_CBUF_MODE_EN_SHIFT         (0U)
#define CSL_OCMCECC_CFG_OCMC_CBUF_EN_CBUF_MODE_EN_RESETVAL      (0x00000000U)
#define CSL_OCMCECC_CFG_OCMC_CBUF_EN_CBUF_MODE_EN_MAX           (0x00000001U)

#define CSL_OCMCECC_CFG_OCMC_CBUF_EN_CBUF_DEBUG_EN_MASK         (0x00000002U)
#define CSL_OCMCECC_CFG_OCMC_CBUF_EN_CBUF_DEBUG_EN_SHIFT        (1U)
#define CSL_OCMCECC_CFG_OCMC_CBUF_EN_CBUF_DEBUG_EN_RESETVAL     (0x00000000U)
#define CSL_OCMCECC_CFG_OCMC_CBUF_EN_CBUF_DEBUG_EN_MAX          (0x00000001U)

#define CSL_OCMCECC_CFG_OCMC_CBUF_EN_CBUF_EN_0_MASK             (0x00010000U)
#define CSL_OCMCECC_CFG_OCMC_CBUF_EN_CBUF_EN_0_SHIFT            (16U)
#define CSL_OCMCECC_CFG_OCMC_CBUF_EN_CBUF_EN_0_RESETVAL         (0x00000000U)
#define CSL_OCMCECC_CFG_OCMC_CBUF_EN_CBUF_EN_0_MAX              (0x00000001U)

#define CSL_OCMCECC_CFG_OCMC_CBUF_EN_CBUF_EN_1_MASK             (0x00020000U)
#define CSL_OCMCECC_CFG_OCMC_CBUF_EN_CBUF_EN_1_SHIFT            (17U)
#define CSL_OCMCECC_CFG_OCMC_CBUF_EN_CBUF_EN_1_RESETVAL         (0x00000000U)
#define CSL_OCMCECC_CFG_OCMC_CBUF_EN_CBUF_EN_1_MAX              (0x00000001U)

#define CSL_OCMCECC_CFG_OCMC_CBUF_EN_CBUF_EN_2_MASK             (0x00040000U)
#define CSL_OCMCECC_CFG_OCMC_CBUF_EN_CBUF_EN_2_SHIFT            (18U)
#define CSL_OCMCECC_CFG_OCMC_CBUF_EN_CBUF_EN_2_RESETVAL         (0x00000000U)
#define CSL_OCMCECC_CFG_OCMC_CBUF_EN_CBUF_EN_2_MAX              (0x00000001U)

#define CSL_OCMCECC_CFG_OCMC_CBUF_EN_CBUF_EN_3_MASK             (0x00080000U)
#define CSL_OCMCECC_CFG_OCMC_CBUF_EN_CBUF_EN_3_SHIFT            (19U)
#define CSL_OCMCECC_CFG_OCMC_CBUF_EN_CBUF_EN_3_RESETVAL         (0x00000000U)
#define CSL_OCMCECC_CFG_OCMC_CBUF_EN_CBUF_EN_3_MAX              (0x00000001U)

#define CSL_OCMCECC_CFG_OCMC_CBUF_EN_CBUF_EN_4_MASK             (0x00100000U)
#define CSL_OCMCECC_CFG_OCMC_CBUF_EN_CBUF_EN_4_SHIFT            (20U)
#define CSL_OCMCECC_CFG_OCMC_CBUF_EN_CBUF_EN_4_RESETVAL         (0x00000000U)
#define CSL_OCMCECC_CFG_OCMC_CBUF_EN_CBUF_EN_4_MAX              (0x00000001U)

#define CSL_OCMCECC_CFG_OCMC_CBUF_EN_CBUF_EN_5_MASK             (0x00200000U)
#define CSL_OCMCECC_CFG_OCMC_CBUF_EN_CBUF_EN_5_SHIFT            (21U)
#define CSL_OCMCECC_CFG_OCMC_CBUF_EN_CBUF_EN_5_RESETVAL         (0x00000000U)
#define CSL_OCMCECC_CFG_OCMC_CBUF_EN_CBUF_EN_5_MAX              (0x00000001U)

#define CSL_OCMCECC_CFG_OCMC_CBUF_EN_CBUF_EN_6_MASK             (0x00400000U)
#define CSL_OCMCECC_CFG_OCMC_CBUF_EN_CBUF_EN_6_SHIFT            (22U)
#define CSL_OCMCECC_CFG_OCMC_CBUF_EN_CBUF_EN_6_RESETVAL         (0x00000000U)
#define CSL_OCMCECC_CFG_OCMC_CBUF_EN_CBUF_EN_6_MAX              (0x00000001U)

#define CSL_OCMCECC_CFG_OCMC_CBUF_EN_CBUF_EN_7_MASK             (0x00800000U)
#define CSL_OCMCECC_CFG_OCMC_CBUF_EN_CBUF_EN_7_SHIFT            (23U)
#define CSL_OCMCECC_CFG_OCMC_CBUF_EN_CBUF_EN_7_RESETVAL         (0x00000000U)
#define CSL_OCMCECC_CFG_OCMC_CBUF_EN_CBUF_EN_7_MAX              (0x00000001U)

#define CSL_OCMCECC_CFG_OCMC_CBUF_EN_CBUF_EN_8_MASK             (0x01000000U)
#define CSL_OCMCECC_CFG_OCMC_CBUF_EN_CBUF_EN_8_SHIFT            (24U)
#define CSL_OCMCECC_CFG_OCMC_CBUF_EN_CBUF_EN_8_RESETVAL         (0x00000000U)
#define CSL_OCMCECC_CFG_OCMC_CBUF_EN_CBUF_EN_8_MAX              (0x00000001U)

#define CSL_OCMCECC_CFG_OCMC_CBUF_EN_CBUF_EN_9_MASK             (0x02000000U)
#define CSL_OCMCECC_CFG_OCMC_CBUF_EN_CBUF_EN_9_SHIFT            (25U)
#define CSL_OCMCECC_CFG_OCMC_CBUF_EN_CBUF_EN_9_RESETVAL         (0x00000000U)
#define CSL_OCMCECC_CFG_OCMC_CBUF_EN_CBUF_EN_9_MAX              (0x00000001U)

#define CSL_OCMCECC_CFG_OCMC_CBUF_EN_CBUF_EN_10_MASK            (0x04000000U)
#define CSL_OCMCECC_CFG_OCMC_CBUF_EN_CBUF_EN_10_SHIFT           (26U)
#define CSL_OCMCECC_CFG_OCMC_CBUF_EN_CBUF_EN_10_RESETVAL        (0x00000000U)
#define CSL_OCMCECC_CFG_OCMC_CBUF_EN_CBUF_EN_10_MAX             (0x00000001U)

#define CSL_OCMCECC_CFG_OCMC_CBUF_EN_CBUF_EN_11_MASK            (0x08000000U)
#define CSL_OCMCECC_CFG_OCMC_CBUF_EN_CBUF_EN_11_SHIFT           (27U)
#define CSL_OCMCECC_CFG_OCMC_CBUF_EN_CBUF_EN_11_RESETVAL        (0x00000000U)
#define CSL_OCMCECC_CFG_OCMC_CBUF_EN_CBUF_EN_11_MAX             (0x00000001U)

#define CSL_OCMCECC_CFG_OCMC_CBUF_EN_RSVD_MASK                  (0xF0000000U)
#define CSL_OCMCECC_CFG_OCMC_CBUF_EN_RSVD_SHIFT                 (28U)
#define CSL_OCMCECC_CFG_OCMC_CBUF_EN_RSVD_RESETVAL              (0x00000000U)
#define CSL_OCMCECC_CFG_OCMC_CBUF_EN_RSVD_MAX                   (0x0000000fU)

#define CSL_OCMCECC_CFG_OCMC_CBUF_EN_NEW_FRAME_SEL_MASK         (0x00000004U)
#define CSL_OCMCECC_CFG_OCMC_CBUF_EN_NEW_FRAME_SEL_SHIFT        (2U)
#define CSL_OCMCECC_CFG_OCMC_CBUF_EN_NEW_FRAME_SEL_RESETVAL     (0x00000000U)
#define CSL_OCMCECC_CFG_OCMC_CBUF_EN_NEW_FRAME_SEL_MAX          (0x00000001U)

#define CSL_OCMCECC_CFG_OCMC_CBUF_EN_RESETVAL                   (0x00000000U)

/* CFG_OCMC_CBUF_RESET */

#define CSL_OCMCECC_CFG_OCMC_CBUF_RESET_CBUF_RESET_0_MASK       (0x00000001U)
#define CSL_OCMCECC_CFG_OCMC_CBUF_RESET_CBUF_RESET_0_SHIFT      (0U)
#define CSL_OCMCECC_CFG_OCMC_CBUF_RESET_CBUF_RESET_0_RESETVAL   (0x00000000U)
#define CSL_OCMCECC_CFG_OCMC_CBUF_RESET_CBUF_RESET_0_MAX        (0x00000001U)

#define CSL_OCMCECC_CFG_OCMC_CBUF_RESET_CBUF_RESET_1_MASK       (0x00000002U)
#define CSL_OCMCECC_CFG_OCMC_CBUF_RESET_CBUF_RESET_1_SHIFT      (1U)
#define CSL_OCMCECC_CFG_OCMC_CBUF_RESET_CBUF_RESET_1_RESETVAL   (0x00000000U)
#define CSL_OCMCECC_CFG_OCMC_CBUF_RESET_CBUF_RESET_1_MAX        (0x00000001U)

#define CSL_OCMCECC_CFG_OCMC_CBUF_RESET_CBUF_RESET_2_MASK       (0x00000004U)
#define CSL_OCMCECC_CFG_OCMC_CBUF_RESET_CBUF_RESET_2_SHIFT      (2U)
#define CSL_OCMCECC_CFG_OCMC_CBUF_RESET_CBUF_RESET_2_RESETVAL   (0x00000000U)
#define CSL_OCMCECC_CFG_OCMC_CBUF_RESET_CBUF_RESET_2_MAX        (0x00000001U)

#define CSL_OCMCECC_CFG_OCMC_CBUF_RESET_CBUF_RESET_3_MASK       (0x00000008U)
#define CSL_OCMCECC_CFG_OCMC_CBUF_RESET_CBUF_RESET_3_SHIFT      (3U)
#define CSL_OCMCECC_CFG_OCMC_CBUF_RESET_CBUF_RESET_3_RESETVAL   (0x00000000U)
#define CSL_OCMCECC_CFG_OCMC_CBUF_RESET_CBUF_RESET_3_MAX        (0x00000001U)

#define CSL_OCMCECC_CFG_OCMC_CBUF_RESET_CBUF_RESET_4_MASK       (0x00000010U)
#define CSL_OCMCECC_CFG_OCMC_CBUF_RESET_CBUF_RESET_4_SHIFT      (4U)
#define CSL_OCMCECC_CFG_OCMC_CBUF_RESET_CBUF_RESET_4_RESETVAL   (0x00000000U)
#define CSL_OCMCECC_CFG_OCMC_CBUF_RESET_CBUF_RESET_4_MAX        (0x00000001U)

#define CSL_OCMCECC_CFG_OCMC_CBUF_RESET_CBUF_RESET_5_MASK       (0x00000020U)
#define CSL_OCMCECC_CFG_OCMC_CBUF_RESET_CBUF_RESET_5_SHIFT      (5U)
#define CSL_OCMCECC_CFG_OCMC_CBUF_RESET_CBUF_RESET_5_RESETVAL   (0x00000000U)
#define CSL_OCMCECC_CFG_OCMC_CBUF_RESET_CBUF_RESET_5_MAX        (0x00000001U)

#define CSL_OCMCECC_CFG_OCMC_CBUF_RESET_CBUF_RESET_6_MASK       (0x00000040U)
#define CSL_OCMCECC_CFG_OCMC_CBUF_RESET_CBUF_RESET_6_SHIFT      (6U)
#define CSL_OCMCECC_CFG_OCMC_CBUF_RESET_CBUF_RESET_6_RESETVAL   (0x00000000U)
#define CSL_OCMCECC_CFG_OCMC_CBUF_RESET_CBUF_RESET_6_MAX        (0x00000001U)

#define CSL_OCMCECC_CFG_OCMC_CBUF_RESET_CBUF_RESET_7_MASK       (0x00000080U)
#define CSL_OCMCECC_CFG_OCMC_CBUF_RESET_CBUF_RESET_7_SHIFT      (7U)
#define CSL_OCMCECC_CFG_OCMC_CBUF_RESET_CBUF_RESET_7_RESETVAL   (0x00000000U)
#define CSL_OCMCECC_CFG_OCMC_CBUF_RESET_CBUF_RESET_7_MAX        (0x00000001U)

#define CSL_OCMCECC_CFG_OCMC_CBUF_RESET_CBUF_RESET_8_MASK       (0x00000100U)
#define CSL_OCMCECC_CFG_OCMC_CBUF_RESET_CBUF_RESET_8_SHIFT      (8U)
#define CSL_OCMCECC_CFG_OCMC_CBUF_RESET_CBUF_RESET_8_RESETVAL   (0x00000000U)
#define CSL_OCMCECC_CFG_OCMC_CBUF_RESET_CBUF_RESET_8_MAX        (0x00000001U)

#define CSL_OCMCECC_CFG_OCMC_CBUF_RESET_CBUF_RESET_9_MASK       (0x00000200U)
#define CSL_OCMCECC_CFG_OCMC_CBUF_RESET_CBUF_RESET_9_SHIFT      (9U)
#define CSL_OCMCECC_CFG_OCMC_CBUF_RESET_CBUF_RESET_9_RESETVAL   (0x00000000U)
#define CSL_OCMCECC_CFG_OCMC_CBUF_RESET_CBUF_RESET_9_MAX        (0x00000001U)

#define CSL_OCMCECC_CFG_OCMC_CBUF_RESET_CBUF_RESET_10_MASK      (0x00000400U)
#define CSL_OCMCECC_CFG_OCMC_CBUF_RESET_CBUF_RESET_10_SHIFT     (10U)
#define CSL_OCMCECC_CFG_OCMC_CBUF_RESET_CBUF_RESET_10_RESETVAL  (0x00000000U)
#define CSL_OCMCECC_CFG_OCMC_CBUF_RESET_CBUF_RESET_10_MAX       (0x00000001U)

#define CSL_OCMCECC_CFG_OCMC_CBUF_RESET_CBUF_RESET_11_MASK      (0x00000800U)
#define CSL_OCMCECC_CFG_OCMC_CBUF_RESET_CBUF_RESET_11_SHIFT     (11U)
#define CSL_OCMCECC_CFG_OCMC_CBUF_RESET_CBUF_RESET_11_RESETVAL  (0x00000000U)
#define CSL_OCMCECC_CFG_OCMC_CBUF_RESET_CBUF_RESET_11_MAX       (0x00000001U)

#define CSL_OCMCECC_CFG_OCMC_CBUF_RESET_RSVD_MASK               (0xFFFFF000U)
#define CSL_OCMCECC_CFG_OCMC_CBUF_RESET_RSVD_SHIFT              (12U)
#define CSL_OCMCECC_CFG_OCMC_CBUF_RESET_RSVD_RESETVAL           (0x00000000U)
#define CSL_OCMCECC_CFG_OCMC_CBUF_RESET_RSVD_MAX                (0x000fffffU)

#define CSL_OCMCECC_CFG_OCMC_CBUF_RESET_RESETVAL                (0x00000000U)

/* CFG_OCMC_CBUF_ERR_HANDLER */

#define CSL_OCMCECC_CFG_OCMC_CBUF_ERR_HANDLER_OVERFLOW_ERR_CHECK_EN_MASK  (0x00000004U)
#define CSL_OCMCECC_CFG_OCMC_CBUF_ERR_HANDLER_OVERFLOW_ERR_CHECK_EN_SHIFT  (2U)
#define CSL_OCMCECC_CFG_OCMC_CBUF_ERR_HANDLER_OVERFLOW_ERR_CHECK_EN_RESETVAL  (0x00000000U)
#define CSL_OCMCECC_CFG_OCMC_CBUF_ERR_HANDLER_OVERFLOW_ERR_CHECK_EN_OVERFLOW_CHECK_ENABLE  (0x00000000U)
#define CSL_OCMCECC_CFG_OCMC_CBUF_ERR_HANDLER_OVERFLOW_ERR_CHECK_EN_OVERFLOW_CHECK_DISABLE  (0x00000001U)

#define CSL_OCMCECC_CFG_OCMC_CBUF_ERR_HANDLER_UNDERFLOW_ERR_CHECK_EN_MASK  (0x00000008U)
#define CSL_OCMCECC_CFG_OCMC_CBUF_ERR_HANDLER_UNDERFLOW_ERR_CHECK_EN_SHIFT  (3U)
#define CSL_OCMCECC_CFG_OCMC_CBUF_ERR_HANDLER_UNDERFLOW_ERR_CHECK_EN_RESETVAL  (0x00000000U)
#define CSL_OCMCECC_CFG_OCMC_CBUF_ERR_HANDLER_UNDERFLOW_ERR_CHECK_EN_UNDERFLOW_CHECK_ENABLE  (0x00000000U)
#define CSL_OCMCECC_CFG_OCMC_CBUF_ERR_HANDLER_UNDERFLOW_ERR_CHECK_EN_UNDERFLOW_CHECK_DISABLE  (0x00000001U)

#define CSL_OCMCECC_CFG_OCMC_CBUF_ERR_HANDLER_SHORT_FRAME_DETECT_CHECK_EN_MASK  (0x00000001U)
#define CSL_OCMCECC_CFG_OCMC_CBUF_ERR_HANDLER_SHORT_FRAME_DETECT_CHECK_EN_SHIFT  (0U)
#define CSL_OCMCECC_CFG_OCMC_CBUF_ERR_HANDLER_SHORT_FRAME_DETECT_CHECK_EN_RESETVAL  (0x00000000U)
#define CSL_OCMCECC_CFG_OCMC_CBUF_ERR_HANDLER_SHORT_FRAME_DETECT_CHECK_EN_SHORT_FRAME_DETECT_ENABLE  (0x00000000U)
#define CSL_OCMCECC_CFG_OCMC_CBUF_ERR_HANDLER_SHORT_FRAME_DETECT_CHECK_EN_SHORT_FRAME_DETECT_DISABLE  (0x00000001U)

#define CSL_OCMCECC_CFG_OCMC_CBUF_ERR_HANDLER_OVERFLOW_WRITE_HANDLER_SEL_MASK  (0x00000030U)
#define CSL_OCMCECC_CFG_OCMC_CBUF_ERR_HANDLER_OVERFLOW_WRITE_HANDLER_SEL_SHIFT  (4U)
#define CSL_OCMCECC_CFG_OCMC_CBUF_ERR_HANDLER_OVERFLOW_WRITE_HANDLER_SEL_RESETVAL  (0x00000000U)
#define CSL_OCMCECC_CFG_OCMC_CBUF_ERR_HANDLER_OVERFLOW_WRITE_HANDLER_SEL_MAX  (0x00000003U)

#define CSL_OCMCECC_CFG_OCMC_CBUF_ERR_HANDLER_OVERFLOW_CHECK_REENABLE_SEL_MASK  (0x000000C0U)
#define CSL_OCMCECC_CFG_OCMC_CBUF_ERR_HANDLER_OVERFLOW_CHECK_REENABLE_SEL_SHIFT  (6U)
#define CSL_OCMCECC_CFG_OCMC_CBUF_ERR_HANDLER_OVERFLOW_CHECK_REENABLE_SEL_RESETVAL  (0x00000000U)
#define CSL_OCMCECC_CFG_OCMC_CBUF_ERR_HANDLER_OVERFLOW_CHECK_REENABLE_SEL_MAX  (0x00000003U)

#define CSL_OCMCECC_CFG_OCMC_CBUF_ERR_HANDLER_UNDERFLOW_LAST_CBUF_SLICE_DISABLE_MASK  (0x00000100U)
#define CSL_OCMCECC_CFG_OCMC_CBUF_ERR_HANDLER_UNDERFLOW_LAST_CBUF_SLICE_DISABLE_SHIFT  (8U)
#define CSL_OCMCECC_CFG_OCMC_CBUF_ERR_HANDLER_UNDERFLOW_LAST_CBUF_SLICE_DISABLE_RESETVAL  (0x00000000U)
#define CSL_OCMCECC_CFG_OCMC_CBUF_ERR_HANDLER_UNDERFLOW_LAST_CBUF_SLICE_DISABLE_MAX  (0x00000001U)

#define CSL_OCMCECC_CFG_OCMC_CBUF_ERR_HANDLER_SHORT_FRAME_PREV_EOF_SEL_MASK  (0x00000002U)
#define CSL_OCMCECC_CFG_OCMC_CBUF_ERR_HANDLER_SHORT_FRAME_PREV_EOF_SEL_SHIFT  (1U)
#define CSL_OCMCECC_CFG_OCMC_CBUF_ERR_HANDLER_SHORT_FRAME_PREV_EOF_SEL_RESETVAL  (0x00000000U)
#define CSL_OCMCECC_CFG_OCMC_CBUF_ERR_HANDLER_SHORT_FRAME_PREV_EOF_SEL_MAX  (0x00000001U)

#define CSL_OCMCECC_CFG_OCMC_CBUF_ERR_HANDLER_RESETVAL          (0x00000000U)

/* STATUS_CBUF_WR_OUT_OF_RANGE_ERR */

#define CSL_OCMCECC_STATUS_CBUF_WR_OUT_OF_RANGE_ERR_CBUF_ERR_MASK  (0x00000FFFU)
#define CSL_OCMCECC_STATUS_CBUF_WR_OUT_OF_RANGE_ERR_CBUF_ERR_SHIFT  (0U)
#define CSL_OCMCECC_STATUS_CBUF_WR_OUT_OF_RANGE_ERR_CBUF_ERR_RESETVAL  (0x00000000U)
#define CSL_OCMCECC_STATUS_CBUF_WR_OUT_OF_RANGE_ERR_CBUF_ERR_MAX  (0x00000fffU)

#define CSL_OCMCECC_STATUS_CBUF_WR_OUT_OF_RANGE_ERR_RESETVAL    (0x00000000U)

/* STATUS_CBUF_WR_VBUF_START_ERR */

#define CSL_OCMCECC_STATUS_CBUF_WR_VBUF_START_ERR_CBUF_ERR_MASK  (0x00000FFFU)
#define CSL_OCMCECC_STATUS_CBUF_WR_VBUF_START_ERR_CBUF_ERR_SHIFT  (0U)
#define CSL_OCMCECC_STATUS_CBUF_WR_VBUF_START_ERR_CBUF_ERR_RESETVAL  (0x00000000U)
#define CSL_OCMCECC_STATUS_CBUF_WR_VBUF_START_ERR_CBUF_ERR_MAX  (0x00000fffU)

#define CSL_OCMCECC_STATUS_CBUF_WR_VBUF_START_ERR_RESETVAL      (0x00000000U)

/* STATUS_CBUF_WR_ADDR_SEQ_ERROR */

#define CSL_OCMCECC_STATUS_CBUF_WR_ADDR_SEQ_ERROR_CBUF_ERR_MASK  (0x00000FFFU)
#define CSL_OCMCECC_STATUS_CBUF_WR_ADDR_SEQ_ERROR_CBUF_ERR_SHIFT  (0U)
#define CSL_OCMCECC_STATUS_CBUF_WR_ADDR_SEQ_ERROR_CBUF_ERR_RESETVAL  (0x00000000U)
#define CSL_OCMCECC_STATUS_CBUF_WR_ADDR_SEQ_ERROR_CBUF_ERR_MAX  (0x00000fffU)

#define CSL_OCMCECC_STATUS_CBUF_WR_ADDR_SEQ_ERROR_RESETVAL      (0x00000000U)

/* STATUS_CBUF_RD_OUT_OF_RANGE_ERROR */

#define CSL_OCMCECC_STATUS_CBUF_RD_OUT_OF_RANGE_ERROR_CBUF_ERR_MASK  (0x00000FFFU)
#define CSL_OCMCECC_STATUS_CBUF_RD_OUT_OF_RANGE_ERROR_CBUF_ERR_SHIFT  (0U)
#define CSL_OCMCECC_STATUS_CBUF_RD_OUT_OF_RANGE_ERROR_CBUF_ERR_RESETVAL  (0x00000000U)
#define CSL_OCMCECC_STATUS_CBUF_RD_OUT_OF_RANGE_ERROR_CBUF_ERR_MAX  (0x00000fffU)

#define CSL_OCMCECC_STATUS_CBUF_RD_OUT_OF_RANGE_ERROR_RESETVAL  (0x00000000U)

/* STATUS_CBUF_VBUF_RD_START_ERROR */

#define CSL_OCMCECC_STATUS_CBUF_VBUF_RD_START_ERROR_CBUF_ERR_MASK  (0x00000FFFU)
#define CSL_OCMCECC_STATUS_CBUF_VBUF_RD_START_ERROR_CBUF_ERR_SHIFT  (0U)
#define CSL_OCMCECC_STATUS_CBUF_VBUF_RD_START_ERROR_CBUF_ERR_RESETVAL  (0x00000000U)
#define CSL_OCMCECC_STATUS_CBUF_VBUF_RD_START_ERROR_CBUF_ERR_MAX  (0x00000fffU)

#define CSL_OCMCECC_STATUS_CBUF_VBUF_RD_START_ERROR_RESETVAL    (0x00000000U)

/* STATUS_CBUF_RD_ADDR_SEQ_ERROR */

#define CSL_OCMCECC_STATUS_CBUF_RD_ADDR_SEQ_ERROR_CBUF_ERR_MASK  (0x00000FFFU)
#define CSL_OCMCECC_STATUS_CBUF_RD_ADDR_SEQ_ERROR_CBUF_ERR_SHIFT  (0U)
#define CSL_OCMCECC_STATUS_CBUF_RD_ADDR_SEQ_ERROR_CBUF_ERR_RESETVAL  (0x00000000U)
#define CSL_OCMCECC_STATUS_CBUF_RD_ADDR_SEQ_ERROR_CBUF_ERR_MAX  (0x00000fffU)

#define CSL_OCMCECC_STATUS_CBUF_RD_ADDR_SEQ_ERROR_RESETVAL      (0x00000000U)

/* STATUS_CBUF_OVERFLOW_MID */

#define CSL_OCMCECC_STATUS_CBUF_OVERFLOW_MID_CBUF_ERR_MASK      (0x00000FFFU)
#define CSL_OCMCECC_STATUS_CBUF_OVERFLOW_MID_CBUF_ERR_SHIFT     (0U)
#define CSL_OCMCECC_STATUS_CBUF_OVERFLOW_MID_CBUF_ERR_RESETVAL  (0x00000000U)
#define CSL_OCMCECC_STATUS_CBUF_OVERFLOW_MID_CBUF_ERR_MAX       (0x00000fffU)

#define CSL_OCMCECC_STATUS_CBUF_OVERFLOW_MID_RESETVAL           (0x00000000U)

/* STATUS_CBUF_OVERFLOW_WRAP */

#define CSL_OCMCECC_STATUS_CBUF_OVERFLOW_WRAP_CBUF_ERR_MASK     (0x00000FFFU)
#define CSL_OCMCECC_STATUS_CBUF_OVERFLOW_WRAP_CBUF_ERR_SHIFT    (0U)
#define CSL_OCMCECC_STATUS_CBUF_OVERFLOW_WRAP_CBUF_ERR_RESETVAL  (0x00000000U)
#define CSL_OCMCECC_STATUS_CBUF_OVERFLOW_WRAP_CBUF_ERR_MAX      (0x00000fffU)

#define CSL_OCMCECC_STATUS_CBUF_OVERFLOW_WRAP_RESETVAL          (0x00000000U)

/* STATUS_CBUF_UNDERFLOW */

#define CSL_OCMCECC_STATUS_CBUF_UNDERFLOW_CBUF_ERR_MASK         (0x00000FFFU)
#define CSL_OCMCECC_STATUS_CBUF_UNDERFLOW_CBUF_ERR_SHIFT        (0U)
#define CSL_OCMCECC_STATUS_CBUF_UNDERFLOW_CBUF_ERR_RESETVAL     (0x00000000U)
#define CSL_OCMCECC_STATUS_CBUF_UNDERFLOW_CBUF_ERR_MAX          (0x00000fffU)

#define CSL_OCMCECC_STATUS_CBUF_UNDERFLOW_RESETVAL              (0x00000000U)

/* STATUS_CBUF_SHORT_FRAME_DETECT */

#define CSL_OCMCECC_STATUS_CBUF_SHORT_FRAME_DETECT_CBUF_ERR_MASK  (0x00000FFFU)
#define CSL_OCMCECC_STATUS_CBUF_SHORT_FRAME_DETECT_CBUF_ERR_SHIFT  (0U)
#define CSL_OCMCECC_STATUS_CBUF_SHORT_FRAME_DETECT_CBUF_ERR_RESETVAL  (0x00000000U)
#define CSL_OCMCECC_STATUS_CBUF_SHORT_FRAME_DETECT_CBUF_ERR_MAX  (0x00000fffU)

#define CSL_OCMCECC_STATUS_CBUF_SHORT_FRAME_DETECT_RESETVAL     (0x00000000U)

/* CBUF_VBUF_START_ADDR */

#define CSL_OCMCECC_CBUF_VBUF_START_ADDR_READ_RETURNS_ZERO_MASK  (0x0000000FU)
#define CSL_OCMCECC_CBUF_VBUF_START_ADDR_READ_RETURNS_ZERO_SHIFT  (0U)
#define CSL_OCMCECC_CBUF_VBUF_START_ADDR_READ_RETURNS_ZERO_RESETVAL  (0x00000000U)
#define CSL_OCMCECC_CBUF_VBUF_START_ADDR_READ_RETURNS_ZERO_MAX  (0x0000000fU)

#define CSL_OCMCECC_CBUF_VBUF_START_ADDR_ADDR_MASK              (0xFFFFFFF0U)
#define CSL_OCMCECC_CBUF_VBUF_START_ADDR_ADDR_SHIFT             (4U)
#define CSL_OCMCECC_CBUF_VBUF_START_ADDR_ADDR_RESETVAL          (0x00000000U)
#define CSL_OCMCECC_CBUF_VBUF_START_ADDR_ADDR_MAX               (0x0fffffffU)

#define CSL_OCMCECC_CBUF_VBUF_START_ADDR_RESETVAL               (0x00000000U)

/* CBUF_VBUF_END_ADDR */

#define CSL_OCMCECC_CBUF_VBUF_END_ADDR_READ_RETURNS_ZERO_MASK   (0x0000000FU)
#define CSL_OCMCECC_CBUF_VBUF_END_ADDR_READ_RETURNS_ZERO_SHIFT  (0U)
#define CSL_OCMCECC_CBUF_VBUF_END_ADDR_READ_RETURNS_ZERO_RESETVAL  (0x00000000U)
#define CSL_OCMCECC_CBUF_VBUF_END_ADDR_READ_RETURNS_ZERO_MAX    (0x0000000fU)

#define CSL_OCMCECC_CBUF_VBUF_END_ADDR_ADDR_MASK                (0xFFFFFFF0U)
#define CSL_OCMCECC_CBUF_VBUF_END_ADDR_ADDR_SHIFT               (4U)
#define CSL_OCMCECC_CBUF_VBUF_END_ADDR_ADDR_RESETVAL            (0x00000000U)
#define CSL_OCMCECC_CBUF_VBUF_END_ADDR_ADDR_MAX                 (0x0fffffffU)

#define CSL_OCMCECC_CBUF_VBUF_END_ADDR_RESETVAL                 (0x00000000U)

/* CBUF_OCMC_START_ADDR */

#define CSL_OCMCECC_CBUF_OCMC_START_ADDR_READ_RETURNS_ZERO_MASK  (0x0000000FU)
#define CSL_OCMCECC_CBUF_OCMC_START_ADDR_READ_RETURNS_ZERO_SHIFT  (0U)
#define CSL_OCMCECC_CBUF_OCMC_START_ADDR_READ_RETURNS_ZERO_RESETVAL  (0x00000000U)
#define CSL_OCMCECC_CBUF_OCMC_START_ADDR_READ_RETURNS_ZERO_MAX  (0x0000000fU)

#define CSL_OCMCECC_CBUF_OCMC_START_ADDR_ADDR_MASK              (0xFFFFFFF0U)
#define CSL_OCMCECC_CBUF_OCMC_START_ADDR_ADDR_SHIFT             (4U)
#define CSL_OCMCECC_CBUF_OCMC_START_ADDR_ADDR_RESETVAL          (0x00000000U)
#define CSL_OCMCECC_CBUF_OCMC_START_ADDR_ADDR_MAX               (0x0fffffffU)

#define CSL_OCMCECC_CBUF_OCMC_START_ADDR_RESETVAL               (0x00000000U)

/* CBUF_OCMC_BUF_SIZE */

#define CSL_OCMCECC_CBUF_OCMC_BUF_SIZE_READ_RETURNS_ZERO_MASK   (0x0000000FU)
#define CSL_OCMCECC_CBUF_OCMC_BUF_SIZE_READ_RETURNS_ZERO_SHIFT  (0U)
#define CSL_OCMCECC_CBUF_OCMC_BUF_SIZE_READ_RETURNS_ZERO_RESETVAL  (0x00000000U)
#define CSL_OCMCECC_CBUF_OCMC_BUF_SIZE_READ_RETURNS_ZERO_MAX    (0x0000000fU)

#define CSL_OCMCECC_CBUF_OCMC_BUF_SIZE_BUF_SIZE_MASK            (0x000FFFF0U)
#define CSL_OCMCECC_CBUF_OCMC_BUF_SIZE_BUF_SIZE_SHIFT           (4U)
#define CSL_OCMCECC_CBUF_OCMC_BUF_SIZE_BUF_SIZE_RESETVAL        (0x00000000U)
#define CSL_OCMCECC_CBUF_OCMC_BUF_SIZE_BUF_SIZE_MAX             (0x0000ffffU)

#define CSL_OCMCECC_CBUF_OCMC_BUF_SIZE_READ_RETURNS_ZERO_P2_MASK  (0xFFF00000U)
#define CSL_OCMCECC_CBUF_OCMC_BUF_SIZE_READ_RETURNS_ZERO_P2_SHIFT  (20U)
#define CSL_OCMCECC_CBUF_OCMC_BUF_SIZE_READ_RETURNS_ZERO_P2_RESETVAL  (0x00000000U)
#define CSL_OCMCECC_CBUF_OCMC_BUF_SIZE_READ_RETURNS_ZERO_P2_MAX  (0x00000fffU)

#define CSL_OCMCECC_CBUF_OCMC_BUF_SIZE_RESETVAL                 (0x00000000U)

/* CBUF_LAST_WR_ADDR */

#define CSL_OCMCECC_CBUF_LAST_WR_ADDR_ADDR_MASK                 (0xFFFFFFFFU)
#define CSL_OCMCECC_CBUF_LAST_WR_ADDR_ADDR_SHIFT                (0U)
#define CSL_OCMCECC_CBUF_LAST_WR_ADDR_ADDR_RESETVAL             (0x00000000U)
#define CSL_OCMCECC_CBUF_LAST_WR_ADDR_ADDR_MAX                  (0xffffffffU)

#define CSL_OCMCECC_CBUF_LAST_WR_ADDR_RESETVAL                  (0x00000000U)

/* CBUF_LAST_RD_ADDR */

#define CSL_OCMCECC_CBUF_LAST_RD_ADDR_ADDR_MASK                 (0xFFFFFFFFU)
#define CSL_OCMCECC_CBUF_LAST_RD_ADDR_ADDR_SHIFT                (0U)
#define CSL_OCMCECC_CBUF_LAST_RD_ADDR_ADDR_RESETVAL             (0x00000000U)
#define CSL_OCMCECC_CBUF_LAST_RD_ADDR_ADDR_MAX                  (0xffffffffU)

#define CSL_OCMCECC_CBUF_LAST_RD_ADDR_RESETVAL                  (0x00000000U)

/* LAST_ILLEGAL_OCMC_ADDR */

#define CSL_OCMCECC_LAST_ILLEGAL_OCMC_ADDR_ADDR_MASK            (0xFFFFFFFFU)
#define CSL_OCMCECC_LAST_ILLEGAL_OCMC_ADDR_ADDR_SHIFT           (0U)
#define CSL_OCMCECC_LAST_ILLEGAL_OCMC_ADDR_ADDR_RESETVAL        (0x00000000U)
#define CSL_OCMCECC_LAST_ILLEGAL_OCMC_ADDR_ADDR_MAX             (0xffffffffU)

#define CSL_OCMCECC_LAST_ILLEGAL_OCMC_ADDR_RESETVAL             (0x00000000U)

#ifdef __cplusplus
}
#endif
#endif
