
/**
 *  \defgroup PM_HAL PMHAL
 *
 *  PMHAL provides low level APIs which allow:
 *      - Programming PRCM registers
 *          - Power Domain Manager (PDM)
 *          - Clock Domain Manager (CM)
 *          - Reset Manager (RM)
 *          - Module Manager (MM)
 *      - Programming Temperature Sensor Registers (Temp)
 *      - Programming Voltage Domain AVS and ABB (VM)
 *      - Programming board specific PMIC
 *
 */
 
/**
 *  \file      pmhal.h
 *
 *  \brief     This file contains all includes related to PM Hardware
 *             abstraction layer.
 *
 */

#ifndef PMHAL_TOP_H_
#define PMHAL_TOP_H_

#include "pm_types.h"
#include "pm_utils.h"
#include "hw_pmhal_data_names.h"
#include "pmhal_bgap.h"
#include "pmhal_clocktree.h"
#include "pmhal_cm.h"
#include "pmhal_i2cComm.h"
#include "pmhal_ina226.h"
#include "pmhal_mm.h"
#include "pmhal_mpu_lprm.h"
#include "pmhal_pdm.h"
#include "pmhal_pmic.h"
#include "pmhal_pmicComm.h"
#include "pmhal_prcm.h"
#include "pmhal_prcm_includes.h"
#include "pmhal_prcm_modinc.h"
#include "pmhal_prcm_stats.h"
#include "pmhal_prm_int.h"
#include "pmhal_rm.h"
#include "pmhal_sd.h"
#include "pmhal_vm.h"

#endif /* PMHAL_TOP_H_ */

