//---------------------------------------------------------------------------------------------------------------------
// Copyright IEOS Ltd. 2010-2018 Moscow, Russian Federation  (www.ieos.ru)
//    Alexander Norokh 2017-2018
//---------------------------------------------------------------------------------------------------------------------
//
//---------------------------------------------------------------------------------------------------------------------
#ifndef SOC_H_
#define SOC_H_

#include "soc_m4_tda2.h"

#ifdef __cplusplus
extern "C"
{
#endif

#define SOC_GPMC_BASE                                                           (0x0U)
#define SOC_IPU1_BOOT_SPACE_BASE                                                ((uint32_t)(0x0U))
#define SOC_IPU1_BITBAND_REGION1_BASE                                           (0x20000000U)
#define SOC_IPU1_BITBAND_ALIAS1_BASE                                            (0x22000000U)
#define SOC_IPU1_BITBAND_REGION2_BASE                                           (0x40000000U)
#define SOC_OCMC_RAM1_BASE                                                      (0x40300000U)
#define SOC_DSP1_L2_SRAM_BASE                                                   (0x40800000U)
#define SOC_DSP1_SYSTEM_BASE                                                    (0x40d00000U)
#define SOC_DSP1_MMU0CFG_BASE                                                   (0x40d01000U)
#define SOC_DSP1_MMU1CFG_BASE                                                   (0x40d02000U)
#define SOC_DSP1_FW0CFG_BASE                                                    (0x40d03000U)
#define SOC_DSP1_FW1CFG_BASE                                                    (0x40d04000U)
#define SOC_DSP1_EDMA_TC0_BASE                                                  (0x40d05000U)
#define SOC_DSP1_EDMA_TC1_BASE                                                  (0x40d06000U)
#define SOC_DSP1_NOC_BASE                                                       (0x40d07000U)
#define SOC_DSP1_DFT_BASE                                                       (0x40d0f000U)
#define SOC_DSP1_EDMA_CC_BASE                                                   (0x40d10000U)
#define SOC_DSP1_L1P_SRAM_BASE                                                  (0x40e00000U)
#define SOC_DSP1_L1D_SRAM_BASE                                                  (0x40f00000U)
#define SOC_DSP2_L2_SRAM_BASE                                                   (0x41000000U)
#define SOC_DSP2_SYSTEM_BASE                                                    (0x41500000U)
#define SOC_DSP2_MMU0CFG_BASE                                                   (0x41501000U)
#define SOC_DSP2_MMU1CFG_BASE                                                   (0x41502000U)
#define SOC_DSP2_FW0CFG_BASE                                                    (0x41503000U)
#define SOC_DSP2_FW1CFG_BASE                                                    (0x41504000U)
#define SOC_DSP2_EDMA_TC0_BASE                                                  (0x41505000U)
#define SOC_DSP2_EDMA_TC1_BASE                                                  (0x41506000U)
#define SOC_DSP2_NOC_BASE                                                       (0x41507000U)
#define SOC_DSP2_DFT_BASE                                                       (0x4150f000U)
#define SOC_DSP2_EDMA_CC_BASE                                                   (0x41510000U)
#define SOC_DSP2_L1P_SRAM_BASE                                                  (0x41600000U)
#define SOC_DSP2_L1D_SRAM_BASE                                                  (0x41700000U)
#define SOC_OCMC_RAM1_CBUF_BASE                                                 (0x41800000U)
#define SOC_IPU1_BITBAND_ALIAS2_BASE                                            (0x42000000U)
#define SOC_EVE1_L3_MBX0_BASE                                                   (0x4208b000U)
#define SOC_EVE1_L3_MBX1_BASE                                                   (0x4208c000U)
#define SOC_EDMA_TPCC_BASE                                                      (0x43300000U)
/*
 * Virtual address for EDMA M4 core is mapped to 0x63300000 as 0x43300000 falls in M4 bitband region
 * Note: This assumes corresponding AMMU configuration from the application
 */
#define SOC_EDMA_TPCC_BASE_VIRT                                                 (SOC_EDMA_TPCC_BASE + 0x20000000U)
#define SOC_EDMA_TC0_BASE                                                       (0x43400000U)
#define SOC_EDMA_TC1_BASE                                                       (0x43500000U)
#define SOC_L3_MAIN_BASE                                                        (0x44000000U)
#define SOC_MCASP1_BASE                                                         (0x45800000U)
/* MCASP2 and MCASP3 base address is valid for TDA3xx SR2.0 and above */
#define SOC_MCASP2_BASE                                                         (0x48436000U)
#define SOC_MCASP3_BASE                                                         (0x4843A000U)
#define SOC_L4_PER_AP_BASE                                                      (0x48000000U)
#define SOC_UART3_BASE                                                          (0x48020000U)
#define SOC_L4_PER_TA_UART3_TARG_BASE                                           (0x48021000U)
#define SOC_TIMER2_BASE                                                         (0x48032000U)
#define SOC_L4_PER_TA_TIMER2_TARG_BASE                                          (0x48033000U)
#define SOC_TIMER3_BASE                                                         (0x48034000U)
#define SOC_L4_PER_TA_TIMER3_TARG_BASE                                          (0x48035000U)
#define SOC_TIMER4_BASE                                                         (0x48036000U)
#define SOC_L4_PER_TA_TIMER4_TARG_BASE                                          (0x48037000U)
#define SOC_GPIO2_BASE                                                          (0x48055000U)
#define SOC_L4_PER_TA_GPIO2_TARG_BASE                                           (0x48056000U)
#define SOC_GPIO3_BASE                                                          (0x48057000U)
#define SOC_L4_PER_TA_GPIO3_TARG_BASE                                           (0x48058000U)
#define SOC_GPIO4_BASE                                                          (0x48059000U)
#define SOC_L4_PER_TA_GPIO4_TARG_BASE                                           (0x4805a000U)
#define SOC_UART1_BASE                                                          (0x4806a000U)
#define SOC_L4_PER_TA_UART1_TARG_BASE                                           (0x4806b000U)
#define SOC_UART2_BASE                                                          (0x4806c000U)
#define SOC_L4_PER_TA_UART2_TARG_BASE                                           (0x4806d000U)
#define SOC_I2C1_BASE                                                           (0x48070000U)
#define SOC_L4_PER_TA_I2C1_TARG_BASE                                            (0x48071000U)
#define SOC_I2C2_BASE                                                           (0x48072000U)
#define SOC_L4_PER_TA_I2C2_TARG_BASE                                            (0x48073000U)
#define SOC_ELM_BASE                                                            (0x48078000U)
#define SOC_L4_PER_TA_ELM_TARG_BASE                                             (0x48079000U)
#define SOC_MCSPI1_BASE                                                         (0x48098000U)
#define SOC_L4_PER_TA_MCSPI1_TARG_BASE                                          (0x48099000U)
#define SOC_MCSPI2_BASE                                                         (0x4809a000U)
#define SOC_L4_PER_TA_MCSPI2_TARG_BASE                                          (0x4809b000U)
#define SOC_MCSPI3_BASE                                                         (0x480b8000U)
#define SOC_L4_PER_TA_MCSPI3_TARG_BASE                                          (0x480b9000U)
#define SOC_MCSPI4_BASE                                                         (0x480ba000U)
#define SOC_L4_PER_TA_MCSPI4_TARG_BASE                                          (0x480bb000U)
#define SOC_MMC4_BASE                                                           (0x480d1000U)
#define SOC_L4_PER_TA_MMC4_TARG_BASE                                            (0x480d2000U)
#define SOC_L4_PER2_AP_BASE                                                     (0x48400000U)
#define SOC_L4_PER2_LA_BASE                                                     (0x48400800U)
#define SOC_L4_PER2_IA_IP0_BASE                                                 (0x48401000U)
#define SOC_GMAC_SW_TARG_BASE                                                   (0x48488000U)
#define SOC_MCASP_CFG_TARG_BASE                                                 (0x48462000U)
#define SOC_PWMSS_TARG_BASE                                                     (0x4843F000U)
#define SOC_DCAN2_TARG_BASE                                                     (0x48482000U)
#define SOC_L4_PER3_AP_BASE                                                     (0x48800000U)
#define SOC_L4_PER3_LA_BASE                                                     (0x48800800U)
#define SOC_L4_PER3_IA_IP1_BASE                                                 (0x48801400U)
#define SOC_L4_PER3_IA_IP2_BASE                                                 (0x48801800U)
#define SOC_TIMER5_TARG_BASE                                                    (0x48821000U)
#define SOC_TIMER6_TARG_BASE                                                    (0x48823000U)
#define SOC_TIMER7_TARG_BASE                                                    (0x48825000U)
#define SOC_TIMER8_TARG_BASE                                                    (0x48827000U)
#define SOC_VIP_TARG_BASE                                                       (0x48980000U)
#define SOC_MAILBOX2_TARG_BASE                                                  (0x4883B000U)
#define SOC_DCC1_TARG_BASE                                                      (0x48828000U)
#define SOC_DCC2_TARG_BASE                                                      (0x4882A000U)
#define SOC_DCC3_TARG_BASE                                                      (0x4882C000U)
#define SOC_DCC4_TARG_BASE                                                      (0x4882E000U)
#define SOC_DCC5_TARG_BASE                                                      (0x4884E000U)
#define SOC_DCC6_TARG_BASE                                                      (0x48852000U)
#define SOC_DCC7_TARG_BASE                                                      (0x48854000U)
#define SOC_OCMC_RAM_CFG_TARG_BASE                                              (0x48805000U)
#define SOC_MMU_TARG_BASE                                                       (0x4881D000U)
#define SOC_L4_CFG_AP_BASE                                                      (0x4A000000U)
#define SOC_L4_CFG_LA_BASE                                                      (0x4A000800U)
#define SOC_L4_CFG_IA_IP0_BASE                                                  (0x4A001000U)
#define SOC_CTRL_MODULE_CORE_TARG_BASE                                          (0x4A004000U)
#define SOC_CM_CORE_AON_TARG_BASE                                               (0x4A006000U)
#define SOC_CM_CORE_TARG_BASE                                                   (0x4A00A000U)
#define SOC_MAILBOX1_TARG_BASE                                                  (0x4A0F5000U)
#define SOC_SPINLOCK_TARG_BASE                                                  (0x4A0F7000U)
#define SOC_OCP_WP_NOC_TARG_BASE                                                (0x4A103000U)
#define SOC_IEEE1500_2_OCP_TARG_BASE                                            (0x4A109000U)
#define SOC_EVE_FW_CFG_TARG_BASE                                                (0x4A152000U)
#define SOC_IPU_FW_CFG_TARG_BASE                                                (0x4A15C000U)
#define SOC_EDMA_TPCC_FW_CFG_TARG_BASE                                          (0x4A162000U)
#define SOC_EDMA_TC0_FW_CFG_TARG_BASE                                           (0x4A164000U)
#define SOC_MCASP_FW_CFG_TARG_BASE                                              (0x4A168000U)
#define SOC_TSC_ADC_FW_CFG_TARG_BASE                                            (0x4A16E000U)
#define SOC_DSP1_FW_CFG_TARG_BASE                                               (0x4A172000U)
#define SOC_DSP2_FW_CFG_TARG_BASE                                               (0x4A174000U)
#define SOC_QSPI_FW_CFG_TARG_BASE                                               (0x4A17A000U)
#define SOC_EMIF_FW_CFG_TARG_BASE                                               (0x4A20D000U)
#define SOC_GPMC_FW_CFG_TARG_BASE                                               (0x4A211000U)
#define SOC_OCMC_RAM_FW_CFG_TARG_BASE                                           (0x4A213000U)
#define SOC_DSS_FW_CFG_TARG_BASE                                                (0x4A21D000U)
#define SOC_DEBUGSS_CT_TBR_FW_CFG_TARG_BASE                                     (0x4A225000U)
#define SOC_L3_INSTR_FW_CFG_TARG_BASE                                           (0x4A227000U)
#define SOC_ESM_TARG_BASE                                                       (0x4A23D000U)
#define SOC_ISS_FW_CFG_TARG_BASE                                                (0x4A23F000U)
#define SOC_TESOC_FW_CFG_TARG_BASE                                              (0x4A241000U)
#define SOC_CRC_FW_CFG_TARG_BASE                                                (0x4A245000U)
#define SOC_CRC_CFG_TARG_BASE                                                   (0x4A261000U)
#define SOC_TSC_ADC_CFG_TARG_BASE                                               (0x4A265000U)
#define SOC_L4_WKUP_AP_BASE                                                     (0x4AE00000U)
#define SOC_L4_WKUP_LA_BASE                                                     (0x4AE00800U)
#define SOC_L4_WKUP_IA_IP0_BASE                                                 (0x4AE01000U)
#define SOC_PRM_TARG_BASE                                                       (0x4AE08000U)
#define SOC_GPIO1_TARG_BASE                                                     (0x4AE11000U)
#define SOC_TIMER1_TARG_BASE                                                    (0x4AE19000U)
#define SOC_COUNTER_32K_TARG_BASE                                               (0x4AE05000U)
#define SOC_CTRL_MODULE_WKUP_TARG_BASE                                          (0x4AE0D000U)
#define SOC_DCAN1_TARG_BASE                                                     (0x4AE3E000U)
#define SOC_RTI1_TARG_BASE                                                      (0x4AE32000U)
#define SOC_RTI2_TARG_BASE                                                      (0x4AE34000U)
#define SOC_RTI3_TARG_BASE                                                      (0x4AE36000U)
#define SOC_RTI4_TARG_BASE                                                      (0x4AE38000U)
#define SOC_RTI5_TARG_BASE                                                      (0x4AE3A000U)
#define SOC_PWMSS1_IPWMSS_BASE                                                  (0x4843e000U)
#define SOC_PWMSS1_IECAP_BASE                                                   (0x4843e100U)
#define SOC_PWMSS1_IEQEP_BASE                                                   (0x4843e180U)
#define SOC_PWMSS1_IEPWM_BASE                                                   (0x4843e200U)
#define SOC_L4_PER2_TA_PWMSS1_TARG_BASE                                         (0x4843f000U)
#define SOC_MCASP1_CFG_BASE                                                     (0x48460000U)
/* SOC_MCASP2_CFG_BASE and SOC_MCASP3_CFG_BASE is valid for TDA3xx SR2.0 and above */
#define SOC_MCASP2_CFG_BASE                                                     (0x4846C000U)
#define SOC_MCASP3_CFG_BASE                                                     (0x48470000U)
/* DCAN 2 base address is valid for TDA3xx SR1.0 only*/
#define SOC_DCAN2_BASE                                                          (0x48480000U)
/* MCAN base address is valid for TDA3xx SR2.0 and above */
#define SOC_MCAN_BASE                                                           (0x48480000U)
#define SOC_DCAN2_MESSAGERAM_BASE                                               (0x48481000U)
#define SOC_L4_PER2_TA_DCAN2_TARG_BASE                                          (0x48482000U)
#define SOC_GMAC_SS_BASE                                                        (0x48484000U)
#define SOC_GMAC_PORT_BASE                                                      (0x48484100U)
#define SOC_GMAC_CPDMA_BASE                                                     (0x48484800U)
#define SOC_GMAC_STATERAM_BASE                                                  (0x48484a00U)
#define SOC_GMAC_CPTS_BASE                                                      (0x48484c00U)
#define SOC_GMAC_ALE_BASE                                                       (0x48484d00U)
#define SOC_GMAC_SL1_BASE                                                       (0x48484d80U)
#define SOC_GMAC_SL2_BASE                                                       (0x48484dc0U)
#define SOC_GMAC_MDIO_BASE                                                      (0x48485000U)
#define SOC_GMAC_WR_BASE                                                        (0x48485200U)
#define SOC_OCMC_RAM1_CFG_BASE                                                  (0x48804000U)
#define SOC_L4_PER3_TA_OCMC_RAM1_CFG_TARG_BASE                                  (0x48805000U)
#define SOC_ESM_BASE                                                            (0x4a23c000U)
#define SOC_L4_PER3_MMU1_BASE                                                   (0x4881c000U)
#define SOC_L4_PER3_TA_MMU1_TARG_BASE                                           (0x4881d000U)
#define SOC_SPARE_MMU2_BASE                                                     (0x4881e000U)
#define SOC_TIMER5_BASE                                                         (0x48820000U)
#define SOC_L4_PER3_TA_TIMER5_TARG_BASE                                         (0x48821000U)
#define SOC_TIMER6_BASE                                                         (0x48822000U)
#define SOC_L4_PER3_TA_TIMER6_TARG_BASE                                         (0x48823000U)
#define SOC_TIMER7_BASE                                                         (0x48824000U)
#define SOC_L4_PER3_TA_TIMER7_TARG_BASE                                         (0x48825000U)
#define SOC_TIMER8_BASE                                                         (0x48826000U)
#define SOC_L4_PER3_TA_TIMER8_TARG_BASE                                         (0x48827000U)
#define SOC_MAILBOX2_BASE                                                       (0x4883a000U)
#define SOC_L4_PER3_TA_MAILBOX2_TARG_BASE                                       (0x4883b000U)
#define SOC_SPARE_MAILBOX3_BASE                                                 (0x4883c000U)
#define SOC_SPARE_MAILBOX4_BASE                                                 (0x4883e000U)
#define SOC_DCC1_BASE                                                           (0x48828000U)
#define SOC_DCC2_BASE                                                           (0x4882A000U)
#define SOC_DCC3_BASE                                                           (0x4882C000U)
#define SOC_DCC4_BASE                                                           (0x4882E000U)
#define SOC_DCC5_BASE                                                           (0x4884E000U)
#define SOC_DCC6_BASE                                                           (0x48852000U)
#define SOC_DCC7_BASE                                                           (0x48854000U)
#define SOC_VIP1_VIP_REGS_BASE                                                  (0x48970000U)
#define SOC_VIP1_VIP_PARSER_SLICE0_REGS_BASE                                    (0x48975500U)
#define SOC_VIP1_VIP_CSC_SLICE0_REGS_BASE                                       (0x48975700U)
#define SOC_VIP1_VIP_SC_SLICE0_REGS_BASE                                        (0x48975800U)
#define SOC_VIP1_VIP_PARSER_SLICE1_REGS_BASE                                    (0x48975a00U)
#define SOC_VIP1_VIP_CSC_SLICE1_REGS_BASE                                       (0x48975c00U)
#define SOC_VIP1_VIP_SC_SLICE1_REGS_BASE                                        (0x48975d00U)
#define SOC_VIP1_VIP_VPDMA_REGS_BASE                                            (0x4897d000U)
#define SOC_L4_PER3_TA_VIP1_TARG_BASE                                           (0x48980000U)
#define SOC_IA_IP0_BASE                                                         (0x4a001000U)
#define SOC_CTRL_MODULE_CORE_BASE                                               (0x4a002000U)
#define SOC_CTRL_MODULE_CORE_CORE_REGISTERS_BASE                                (0x4a002100U)
#define SOC_IRQ_DMARQ_CROSSBAR_REGISTERS_BASE                                   (0x4a0027a0U)
#define SOC_CTRL_MODULE_CORE_CORE_PAD_REGISTERS_BASE                            (0x4a002da0U)
#define SOC_CORE_PAD_IO_REGISTERS_BASE                                          (0x4a003400U)
#define SOC_SEC_EFUSE_REGISTERS_BASE                                            (0x4a003a00U)
#define SOC_TA_CTRL_MODULE_CORE_TARG_BASE                                       (0x4a004000U)
#define SOC_OCP_SOCKET_CM_CORE_AON_BASE                                         (0x4a005000U)
#define SOC_CKGEN_CM_CORE_AON_BASE                                              (0x4a005100U)
#define SOC_MPU_CM_CORE_AON_BASE                                                (0x4a005300U)
#define SOC_DSP1_CM_CORE_AON_BASE                                               (0x4a005400U)
#define SOC_IPU_CM_CORE_AON_BASE                                                (0x4a005500U)
#define SOC_DSP2_CM_CORE_AON_BASE                                               (0x4a005600U)
#define SOC_EVE1_CM_CORE_AON_BASE                                               (0x4a005640U)
#define SOC_EVE2_CM_CORE_AON_BASE                                               (0x4a005680U)
#define SOC_EVE3_CM_CORE_AON_BASE                                               (0x4a0056c0U)
#define SOC_EVE4_CM_CORE_AON_BASE                                               (0x4a005700U)
#define SOC_RTC_CM_CORE_AON_BASE                                                (0x4a005740U)
#define SOC_VPE_CM_CORE_AON_BASE                                                (0x4a005760U)
#define SOC_RESTORE_CM_CORE_AON_BASE                                            (0x4a005e00U)
#define SOC_INSTR_CM_CORE_AON_BASE                                              (0x4a005f00U)
#define SOC_TA_CM_CORE_AON_TARG_BASE                                            (0x4a006000U)
#define SOC_OCP_SOCKET_CM_CORE_BASE                                             (0x4a008000U)
#define SOC_CKGEN_CM_CORE_BASE                                                  (0x4a008100U)
#define SOC_COREAON_CM_CORE_BASE                                                (0x4a008600U)
#define SOC_CORE_CM_CORE_BASE                                                   (0x4a008700U)
#define SOC_IVA_CM_CORE_BASE                                                    (0x4a008f00U)
#define SOC_CAM_CM_CORE_BASE                                                    (0x4a009000U)
#define SOC_DSS_CM_CORE_BASE                                                    (0x4a009100U)
#define SOC_GPU_CM_CORE_BASE                                                    (0x4a009200U)
#define SOC_L3INIT_CM_CORE_BASE                                                 (0x4a009300U)
#define SOC_CUSTEFUSE_CM_CORE_BASE                                              (0x4a009600U)
#define SOC_L4PER_CM_CORE_BASE                                                  (0x4a009700U)
#define SOC_RESTORE_CM_CORE_BASE                                                (0x4a009e18U)
#define SOC_TA_CM_CORE_TARG_BASE                                                (0x4a00a000U)
#define SOC_SPARE_OCP2SCP1_USB_PHY1_CORE_BASE                                   (0x4a084000U)
#define SOC_SPARE_OCP2SCP1_USB3RX_PHY_USB_BASE                                  (0x4a084400U)
#define SOC_SPARE_OCP2SCP1_USB3TX_PHY_USB_BASE                                  (0x4a084800U)
#define SOC_SPARE_OCP2SCP1_USB_PHY2_CORE_BASE                                   (0x4a085000U)
#define SOC_TA_SCP1_TARG_BASE                                                   (0x4a088000U)
#define SOC_SMARTREFLEX_CORE_BASE                                               (0x4a0dd000U)
#define SOC_TA_SMARTREFLEX_CORE_TARG_BASE                                       (0x4a0de000U)
#define SOC_EFUSE_CTRL_CUST_BASE                                                (0x4a0e0000U)
#define SOC_TA_EFUSE_CTRL_CUST_TARG_BASE                                        (0x4a0e1000U)
#define SOC_MAILBOX1_BASE                                                       (0x4a0f4000U)
#define SOC_TA_MAILBOX1_TARG_BASE                                               (0x4a0f5000U)
#define SOC_SPINLOCK_BASE                                                       (0x4a0f6000U)
#define SOC_TA_SPINLOCK_TARG_BASE                                               (0x4a0f7000U)
#define SOC_OCP_WP_NOC_BASE                                                     (0x4a102000U)
#define SOC_TA_OCP_WP_NOC_TARG_BASE                                             (0x4a103000U)
#define SOC_IEEE1500_2_OCP_BASE                                                 (0x4a108000U)
#define SOC_TA_IEEE1500_2_OCP_TARG_BASE                                         (0x4a109000U)
#define SOC_SECURITYCORE_EVE1_BASE                                              (0x4a151000U)
#define SOC_TA_EVE1_FW_CFG_TARG_BASE                                            (0x4a152000U)
#define SOC_SECURITYCORE_IPU1_BASE                                              (0x4a15b000U)
#define SOC_TA_IPU1_FW_CFG_TARG_BASE                                            (0x4a15c000U)
#define SOC_SECURITYCORE_TPCC_BASE                                              (0x4a161000U)
#define SOC_TA_EDMA_TPCC_FW_CFG_TARG_BASE                                       (0x4a162000U)
#define SOC_SECURITYCORE_TPTC_BASE                                              (0x4a163000U)
#define SOC_TA_EDMA_TC0_FW_CFG_TARG_BASE                                        (0x4a164000U)
#define SOC_SECURITYCORE_MCASP1_BASE                                            (0x4a167000U)
#define SOC_TA_MCASP1_FW_CFG_TARG_BASE                                          (0x4a168000U)
#define SOC_SECURITYCORE_TSC_ADC_BASE                                           (0x4a16d000U)
#define SOC_TA_TSC_ADC_FW_CFG_TARG_BASE                                         (0x4a16e000U)
#define SOC_SECURITYCORE_DSP1_SDMA_BASE                                         (0x4a171000U)
#define SOC_TA_DSP1_FW_CFG_TARG_BASE                                            (0x4a172000U)
#define SOC_SECURITYCORE_DSP2_SDMA_BASE                                         (0x4a173000U)
#define SOC_TA_DSP2_FW_CFG_TARG_BASE                                            (0x4a174000U)
#define SOC_SECURITYCORE_QSPI_BASE                                              (0x4a179000U)
#define SOC_TA_QSPI_FW_CFG_TARG_BASE                                            (0x4a17a000U)
#define SOC_SMARTREFLEX_DSPEVE_BASE                                             (0x4a183000U)
#define SOC_TA_SMARTREFLEX_DSPEVE_TARG_BASE                                     (0x4a184000U)
#define SOC_SECURITYCORE_OCMC_ROM_BASE                                          (0x4a200000U)
#define SOC_TA_OCMC_ROM_FW_CFG_TARG_BASE                                        (0x4a201000U)
#define SOC_SECURITYCORE_OCP_FW_EMIF_5430_BASE                                  (0x4a20c000U)
#define SOC_TA_EMIF_OCP_FW_CFG_TARG_BASE                                        (0x4a20d000U)
#define SOC_SECURITYCORE_OCMC_RAM2_BASE                                         (0x4a20e000U)
#define SOC_TA_SPARE_OCMC_RAM2_FW_CFG_TARG_BASE                                 (0x4a20f000U)
#define SOC_SECURITYCORE_GPMC_BASE                                              (0x4a210000U)
#define SOC_TA_GPMC_FW_CFG_TARG_BASE                                            (0x4a211000U)
#define SOC_SECURITYCORE_OCMC_RAM1_BASE                                         (0x4a212000U)
#define SOC_TA_OCMC_RAM1_FW_CFG_TARG_BASE                                       (0x4a213000U)
#define SOC_SECURITYCORE_DSS_BASE                                               (0x4a21c000U)
#define SOC_TA_DSS_FW_CFG_TARG_BASE                                             (0x4a21d000U)
#define SOC_SECURITYCORE_DEBUGSS_CT_TBR_BASE                                    (0x4a224000U)
#define SOC_TA_DEBUGSS_CT_TBR_FW_CFG_TARG_BASE                                  (0x4a225000U)
#define SOC_SECURITYCORE_L3_INSTR_BASE                                          (0x4a226000U)
#define SOC_TA_L3_INSTR_FW_CFG_TARG_BASE                                        (0x4a227000U)
#define SOC_SECURITYCORE_OCMC_RAM3_BASE                                         (0x4a22a000U)
#define SOC_TA_SPARE_OCMC_RAM3_FW_CFG_TARG_BASE                                 (0x4a22b000U)
#define SOC_SECURITYCORE_AES1_BASE                                              (0x4a22c000U)
#define SOC_TA_SPARE_AES1_FW_CFG_TARG_BASE                                      (0x4a22d000U)
#define SOC_SECURITYCORE_AES2_BASE                                              (0x4a22e000U)
#define SOC_TA_SPARE_AES2_FW_CFG_TARG_BASE                                      (0x4a22f000U)
#define SOC_SECURITYCORE_SHA2MD5_P1_BASE                                        (0x4a230000U)
#define SOC_TA_SPARE_SHA2MD5_1_FW_CFG_TARG_BASE                                 (0x4a231000U)
#define SOC_SECURITYCORE_SHA2MD5_P2_BASE                                        (0x4a232000U)
#define SOC_TA_SPARE_SHA2MD5_2_FW_CFG_TARG_BASE                                 (0x4a233000U)
#define SOC_TA_SPARE_UNKNOWN8_TARG_BASE                                         (0x4a23d000U)
#define SOC_SECURITYCORE_ISS_BASE                                               (0x4a23e000U)
#define SOC_TA_ISS_FW_CFG_TARG_BASE                                             (0x4a23f000U)
#define SOC_SECURITYCORE_TESOC_BASE                                             (0x4a240000U)
#define SOC_TA_TESOC_FW_CFG_TARG_BASE                                           (0x4a241000U)
#define SOC_TA_SPARE_JESD_FW_CFG_TARG_BASE                                      (0x4a243000U)
#define SOC_SECURITYCORE_CRC_BASE                                               (0x4a244000U)
#define SOC_TA_CRC_FW_CFG_TARG_BASE                                             (0x4a245000U)
#define SOC_TA_TSC_ADC_DAT_TARG_BASE                                            (0x4a247000U)
#define SOC_TA_SPARE_WD_TIMER3_TARG_BASE                                        (0x4a249000U)
#define SOC_TA_SPARE_WD_TIMER4_TARG_BASE                                        (0x4a24b000U)
#define SOC_TA_SPARE_WD_TIMER5_TARG_BASE                                        (0x4a24d000U)
#define SOC_TA_SPARE_WD_TIMER6_TARG_BASE                                        (0x4a24f000U)
#define SOC_TA_SPARE_WD_TIMER7_TARG_BASE                                        (0x4a251000U)
#define SOC_TA_SPARE_WD_TIMER8_TARG_BASE                                        (0x4a253000U)
#define SOC_TA_SPARE_WD_TIMER9_TARG_BASE                                        (0x4a255000U)
#define SOC_TA_SPARE_WD_TIMER10_TARG_BASE                                       (0x4a257000U)
#define SOC_TA_SPARE_UNKNOWN9_TARG_BASE                                         (0x4a259000U)
#define SOC_TA_SPARE_UNKNOWN10_TARG_BASE                                        (0x4a25b000U)
#define SOC_TA_SPARE_UNKNOWN11_TARG_BASE                                        (0x4a25d000U)
#define SOC_TA_SPARE_UNKNOWN12_TARG_BASE                                        (0x4a25f000U)
#define SOC_TA_CRC_CFG_TARG_BASE                                                (0x4a261000U)
#define SOC_TA_SPARE_EMIF_MPU_TARG_BASE                                         (0x4a263000U)
#define SOC_TSC_ADC_BASE                                                        (0x4a264000U)
#define SOC_TA_TSC_ADC_CFG_TARG_BASE                                            (0x4a265000U)
#define SOC_COUNTER_32K_BASE                                                    (0x4ae04000U)
#define SOC_OCP_SOCKET_PRM_BASE                                                 (0x4ae06000U)
#define SOC_CKGEN_PRM_BASE                                                      (0x4ae06100U)
#define SOC_MPU_PRM_BASE                                                        (0x4ae06300U)
#define SOC_DSP1_PRM_BASE                                                       (0x4ae06400U)
#define SOC_IPU_PRM_BASE                                                        (0x4ae06500U)
#define SOC_COREAON_PRM_BASE                                                    (0x4ae06628U)
#define SOC_CORE_PRM_BASE                                                       (0x4ae06700U)
#define SOC_IVA_PRM_BASE                                                        (0x4ae06f00U)
#define SOC_CAM_PRM_BASE                                                        (0x4ae07000U)
#define SOC_DSS_PRM_BASE                                                        (0x4ae07100U)
#define SOC_GPU_PRM_BASE                                                        (0x4ae07200U)
#define SOC_L3INIT_PRM_BASE                                                     (0x4ae07300U)
#define SOC_L4PER_PRM_BASE                                                      (0x4ae07400U)
#define SOC_CUSTEFUSE_PRM_BASE                                                  (0x4ae07600U)
#define SOC_WKUPAON_PRM_BASE                                                    (0x4ae07724U)
#define SOC_WKUPAON_CM_BASE                                                     (0x4ae07800U)
#define SOC_EMU_PRM_BASE                                                        (0x4ae07900U)
#define SOC_EMU_CM_BASE                                                         (0x4ae07a00U)
#define SOC_DSP2_PRM_BASE                                                       (0x4ae07b00U)
#define SOC_EVE1_PRM_BASE                                                       (0x4ae07b40U)
#define SOC_EVE2_PRM_BASE                                                       (0x4ae07b80U)
#define SOC_EVE3_PRM_BASE                                                       (0x4ae07bc0U)
#define SOC_EVE4_PRM_BASE                                                       (0x4ae07c00U)
#define SOC_RTC_PRM_BASE                                                        (0x4ae07c60U)
#define SOC_VPE_PRM_BASE                                                        (0x4ae07c80U)
#define SOC_DEVICE_PRM_BASE                                                     (0x4ae07d00U)
#define SOC_INSTR_PRM_BASE                                                      (0x4ae07f00U)
#define SOC_CTRL_MODULE_WKUP_BASE                                               (0x4ae0c000U)
#define SOC_CTRL_MODULE_WKUP_CORE_REGISTERS_BASE                                (0x4ae0c100U)
#define SOC_CTRL_MODULE_WKUP_CORE_PAD_REGISTERS_BASE                            (0x4ae0c5a8U)
#define SOC_GPIO1_BASE                                                          (0x4ae10000U)
#define SOC_L4_WKUP_TA_GPIO1_TARG_BASE                                          (0x4ae11000U)
#define SOC_TIMER1_BASE                                                         (0x4ae18000U)
#define SOC_L4_WKUP_TA_TIMER1_TARG_BASE                                         (0x4ae19000U)
#define SOC_RTI1_BASE                                                           (0x4ae31000U)
#define SOC_RTI2_BASE                                                           (0x4ae33000U)
#define SOC_RTI3_BASE                                                           (0x4ae35000U)
#define SOC_RTI4_BASE                                                           (0x4ae37000U)
#define SOC_RTI5_BASE                                                           (0x4ae39000U)
#define SOC_DCAN1_BASE                                                          (0x4ae3c000U)
#define SOC_DCAN1_MESSAGERAM_BASE                                               (0x4ae3d000U)
#define SOC_L4_WKUP_TA_DCAN1_TARG_BASE                                          (0x4ae3e000U)
#define SOC_QSPI_ADDRSP0_BASE                                                   (0x4b300000U)
#define SOC_TESOC_BASE                                                          (0x4b800000U)
#define SOC_CRC_BASE                                                            (0x4bc00000U)
#define SOC_EMIF1_CONF_REGS_BASE                                                (0x4c000000U)
#define SOC_GPMC_CONF_REGS_BASE                                                 (0x50000000U)
#define SOC_ISS_REGS_BASE                                                       (0x52000000U)
#define SOC_I_CSCTI_MPU_C0_BASE                                                 (0x54148000U)
#define SOC_I_CSCTI_MPU_C1_BASE                                                 (0x54149000U)
#define SOC_I_CSTF_BASE                                                         (0x54158000U)
#define SOC_I_DAP_PC_BASE                                                       (0x54159000U)
#define SOC_I_CSSTM_BASE                                                        (0x5415ac04U)
#define SOC_I_SGU_BASE                                                          (0x5415b000U)
#define SOC_I_CSCTI_BASE                                                        (0x5415c000U)
#define SOC_I_DRM_BASE                                                          (0x54160000U)
#define SOC_I_MIPI_STM_BASE                                                     (0x54161000U)
#define SOC_I_CSTPIU_BASE                                                       (0x54163000U)
#define SOC_I_CSTF1_BASE                                                        (0x54164000U)
#define SOC_I_DEBUGSS_OMAP5430_CFGBUS_CT_TBR_BASE                               (0x54167004U)
#define SOC_CT_UART_BASE                                                        (0x54168000U)
#define SOC_CSCTI_BASE                                                          (0x54169000U)
#define SOC_OCP2SCP_BASE                                                        (0x54171000U)
#define SOC_I_DEBUGSS_OMAP5430_CFGBUS_PLLCTRL_BASE                              (0x54171800U)
#define SOC_CT_TBR_BASE                                                         (0x54800000U)
#define SOC_IPU1_ROM_BASE                                                       (0x55000000U)
#define SOC_IPU1_RAM_BASE                                                       (0x55020000U)
#define SOC_IPU1_UNICACHE_MMU_CONF_REGS_BASE                                    (0x55080000U)
#define SOC_IPU1_UNICACHE_MMU_BASE                                              (0x55080800U)
#define SOC_IPU1_WUGEN_BASE                                                     (0x55081000U)
#define SOC_IPU1_MMU_BASE                                                       (0x55082000U)
#define SOC_DSSREG_BASE                                                         (0x58000000U)
#define SOC_VENC_BASE                                                           (0x58005000U)
#define SOC_DISPC_COMMON_BASE                                                   (0x58010000U)
#define SOC_DISPC_GFX1_BASE                                                     (0x58011000U)
#define SOC_DISPC_WB_BASE                                                       (0x58015000U)
#define SOC_DISPC_VID1_BASE                                                     (0x58017000U)
#define SOC_DISPC_VID2_BASE                                                     (0x58018000U)
#define SOC_DISPC_OVR1_BASE                                                     (0x5801a800U)
#define SOC_DISPC_OVR2_BASE                                                     (0x5801a900U)
#define SOC_DISPC_VP1_BASE                                                      (0x5801ac00U)
#define SOC_IPU_TARGET_BASE                                                     (0x58800000U)
#define SOC_UNICACHE_MMU_BASE                                                   (0x58880800U)
#define SOC_L2_MMU_BASE                                                         (0x58882000U)
#define SOC_QSPI_ADDRSP1_BASE                                                   (0x5c000000U)
#define SOC_EMIF1_BASE                                                          (0x80000000U)
#define SOC_IPU1_C0_DWT_BASE                                                    (0xe0001000U)
#define SOC_IPU1_C1_DWT_BASE                                                    (0xe0001000U)
#define SOC_IPU1_C1_FPB_BASE                                                    (0xe0002000U)
#define SOC_IPU1_C0_FPB_BASE                                                    (0xe0002000U)
#define SOC_IPU1_C0_INTC_BASE                                                   (0xe000e000U)
#define SOC_IPU1_C1_INTC_BASE                                                   (0xe000e004U)
#define SOC_IPU1_C0_ICECRUSHER_BASE                                             (0xe0042000U)
#define SOC_IPU1_C1_ICECRUSHER_BASE                                             (0xe0042000U)
#define SOC_IPU1_C0_RW_TABLE_BASE                                               (0xe00fe000U)
#define SOC_IPU1_C1_RW_TABLE_BASE                                               (0xe00fe000U)
#define SOC_IPU1_C0_ROM_TABLE_BASE                                              (0xe00ff000U)
#define SOC_IPU1_C1_ROM_TABLE_BASE                                              (0xe00ff000U)


/* Alias definitions required to reuse higher layer code across SoCs */
#define CSL_IPU_IPU1_UNICACHE_MMU_CONF_REGS_REGS                                (SOC_IPU1_UNICACHE_MMU_CONF_REGS_BASE)


#ifdef __cplusplus
}
#endif
#endif /* SOC_H_ */
