//---------------------------------------------------------------------------------------------------------------------
// Copyright IEOS Ltd. 2010-2018 Moscow, Russian Federation  (www.ieos.ru)
//    Alexander Norokh 2017-2018
//---------------------------------------------------------------------------------------------------------------------
//
//---------------------------------------------------------------------------------------------------------------------
#ifndef SOC_H_2
#define SOC_H_2

#ifdef __cplusplus
extern "C"
{
#endif

#define SOC_GPMC_BASE                                                           (0x0U)
#define SOC_IPU1_BOOT_SPACE_BASE                                                ((uint32_t)(0x0U))
#define SOC_IPU1_BITBAND_REGION1_BASE                                           (0x20000000U)
#define SOC_IPU1_BITBAND_ALIAS1_BASE                                            (0x22000000U)
#define SOC_PCIE_SS1_BASE                                                       (0x24000000U)
#define SOC_PCIE_SS2_BASE                                                       (0x30000000U)
#define SOC_PCIE_SS1_DAT_BASE                                                   (0x24000000U)
#define SOC_PCIE_SS2_DAT_BASE                                                   (0x30000000U)
#define SOC_IPU1_BITBAND_REGION2_BASE                                           (0x40000000U)
#define SOC_OCMC_RAM1_BASE                                                      (0x40300000U)
#if defined (SOC_TDA2EX) || defined (SOC_DRA72x) || defined (SOC_AM571x)
 /* Not applicable */
#else
#define SOC_OCMC_RAM2_BASE                                                      (0x40400000U)
#define SOC_OCMC_RAM3_BASE                                                      (0x40500000U)
#endif
#define SOC_DSP1_L2_SRAM_BASE                                                   (0x40800000U)
#define SOC_DSP1_SYSTEM_BASE                                                    (0x40d00000U)
#define SOC_DSP1_MMU0CFG_BASE                                                   (0x40d01000U)
#define SOC_DSP1_MMU1CFG_BASE                                                   (0x40d02000U)
#define SOC_DSP1_FW0CFG_BASE                                                    (0x40d03000U)
#define SOC_DSP1_FW1CFG_BASE                                                    (0x40d04000U)
#define SOC_DSP1_EDMA_TC0_BASE                                                  (0x40d05000U)
#define SOC_DSP1_EDMA_TC1_BASE                                                  (0x40d06000U)
#define SOC_DSP1_NOC_BASE                                                       (0x40d07000U)
#define SOC_DSP1_DFT_BASE                                                       (0x40d0f000U)
#define SOC_DSP1_EDMA_CC_BASE                                                   (0x40d10000U)
#define SOC_DSP1_L1P_SRAM_BASE                                                  (0x40e00000U)
#define SOC_DSP1_L1D_SRAM_BASE                                                  (0x40f00000U)
#if defined (SOC_TDA2EX) || defined (SOC_DRA72x) || defined (SOC_AM571x)
 /* Not applicable */
#else
#define SOC_DSP2_L2_SRAM_BASE                                                   (0x41000000U)
#define SOC_DSP2_SYSTEM_BASE                                                    (0x41500000U)
#define SOC_DSP2_MMU0CFG_BASE                                                   (0x41501000U)
#define SOC_DSP2_MMU1CFG_BASE                                                   (0x41502000U)
#define SOC_DSP2_FW0CFG_BASE                                                    (0x41503000U)
#define SOC_DSP2_FW1CFG_BASE                                                    (0x41504000U)
#define SOC_DSP2_EDMA_TC0_BASE                                                  (0x41505000U)
#define SOC_DSP2_EDMA_TC1_BASE                                                  (0x41506000U)
#define SOC_DSP2_NOC_BASE                                                       (0x41507000U)
#define SOC_DSP2_DFT_BASE                                                       (0x4150f000U)
#define SOC_DSP2_EDMA_CC_BASE                                                   (0x41510000U)
#define SOC_DSP2_L1P_SRAM_BASE                                                  (0x41600000U)
#define SOC_DSP2_L1D_SRAM_BASE                                                  (0x41700000U)
#endif
#define SOC_OCMC_RAM1_CBUF_BASE                                                 (0x41800000U)
#define SOC_IPU1_BITBAND_ALIAS2_BASE                                            (0x42000000U)
/* Below EVE memories fall in IPU Bit-band region. User has to take care of AMMU mapping
 * in oder to access these memories
 */

#define SOC_EVE1_DMEM_BASE                                                      (0x42020000U)
#define SOC_EVE1_WBUF_BASE                                                      (0x42040000U)
#define SOC_EVE1_IBUFLA_BASE                                                    (0x42050000U)
#define SOC_EVE1_IBUFHA_BASE                                                    (0x42054000U)
#define SOC_EVE1_IBUFLB_BASE                                                    (0x42070000U)
#define SOC_EVE1_IBUFHB_BASE                                                    (0x42074000U)
#define SOC_EVE1_EVE_CONTROL_BASE                                               (0x42080000U)
#define SOC_EVE1_MMU0_BASE                                                      (0x42081000U)
#define SOC_EVE1_TPTC0_BASE                                                     (0x42086000U)
#define SOC_EVE1_TPTC1_BASE                                                     (0x42087000U)
#define SOC_EVE1_L3_MBX0_BASE                                                   (0x4208b000U)
#define SOC_EVE1_L3_MBX1_BASE                                                   (0x4208c000U)
#define SOC_EVE1_L3_MBX2_BASE                                                   (0x4208d000U)
#define SOC_EVE2_DMEM_BASE                                                      (0x42120000U)
#define SOC_EVE2_WBUF_BASE                                                      (0x42140000U)
#define SOC_EVE2_IBUFLA_BASE                                                    (0x42150000U)
#define SOC_EVE2_IBUFHA_BASE                                                    (0x42154000U)
#define SOC_EVE2_IBUFLB_BASE                                                    (0x42170000U)
#define SOC_EVE2_IBUFHB_BASE                                                    (0x42174000U)
#define SOC_EVE2_MMU0_BASE                                                      (0x42181000U)
#define SOC_EVE2_TPTC0_BASE                                                     (0x42186000U)
#define SOC_EVE2_TPTC1_BASE                                                     (0x42187000U)
#define SOC_EVE2_L3_MBX0_BASE                                                   (0x4218b000U)
#define SOC_EVE2_L3_MBX1_BASE                                                   (0x4218c000U)
#define SOC_EVE2_L3_MBX2_BASE                                                   (0x4218d000U)
#define SOC_EVE3_DMEM_BASE                                                      (0x42220000U)
#define SOC_EVE3_WBUF_BASE                                                      (0x42240000U)
#define SOC_EVE3_IBUFLA_BASE                                                    (0x42250000U)
#define SOC_EVE3_IBUFHA_BASE                                                    (0x42254000U)
#define SOC_EVE3_IBUFLB_BASE                                                    (0x42270000U)
#define SOC_EVE3_IBUFHB_BASE                                                    (0x42274000U)
#define SOC_EVE3_MMU0_BASE                                                      (0x42281000U)
#define SOC_EVE3_TPTC0_BASE                                                     (0x42286000U)
#define SOC_EVE3_TPTC1_BASE                                                     (0x42287000U)
#define SOC_EVE3_L3_MBX0_BASE                                                   (0x4228b000U)
#define SOC_EVE3_L3_MBX1_BASE                                                   (0x4228c000U)
#define SOC_EVE3_L3_MBX2_BASE                                                   (0x4228d000U)
#define SOC_EVE4_DMEM_BASE                                                      (0x42320000U)
#define SOC_EVE4_WBUF_BASE                                                      (0x42340000U)
#define SOC_EVE4_IBUFLA_BASE                                                    (0x42350000U)
#define SOC_EVE4_IBUFHA_BASE                                                    (0x42354000U)
#define SOC_EVE4_IBUFLB_BASE                                                    (0x42370000U)
#define SOC_EVE4_IBUFHB_BASE                                                    (0x42374000U)
#define SOC_EVE4_MMU0_BASE                                                      (0x42381000U)
#define SOC_EVE4_TPTC0_BASE                                                     (0x42386000U)
#define SOC_EVE4_TPTC1_BASE                                                     (0x42387000U)
#define SOC_EVE4_L3_MBX0_BASE                                                   (0x4238b000U)
#define SOC_EVE4_L3_MBX1_BASE                                                   (0x4238c000U)
#define SOC_EVE4_L3_MBX2_BASE                                                   (0x4238d000U)
#define SOC_EDMA_TPCC_BASE                                                      (0x43300000U)
/*
 * Virtual address for EDMA M4 core is mapped to 0x63300000 as 0x43300000 falls in M4 bitband region
 * Note: This assumes corresponding AMMU configuration from the application
 */
#define SOC_EDMA_TPCC_BASE_VIRT                                                 (SOC_EDMA_TPCC_BASE + 0x20000000U)
#define SOC_EDMA_TC0_BASE                                                       (0x43400000U)
#define SOC_EDMA_TC1_BASE                                                       (0x43500000U)
#define SOC_L3_MAIN_BASE                                                        (0x44000000U)
#define SOC_MCASP1_BASE                                                         (0x45800000U)
#define SOC_MCASP4_BASE                                                         (0x48436000U)
#define SOC_MCASP5_BASE                                                         (0x4843a000U)
#define SOC_MCASP6_BASE                                                         (0x4844c000U)
#define SOC_MCASP7_BASE                                                         (0x48450000U)
#define SOC_MCASP8_BASE                                                         (0x48454000U)
#define SOC_VCP1_BASE                                                           (0x46400000U)
#define SOC_VCP2_BASE                                                           (0x46800000U)
#define SOC_L4_PER_AP_BASE                                                      (0x48000000U)
#define SOC_L4_PER_LA_BASE                                                      (0x48000800U)
#define SOC_L4_PER_IA_IP0_BASE                                                  (0x48001000U)
#define SOC_L4_PER_IA_IP1_BASE                                                  (0x48001400U)
#define SOC_L4_PER_IA_IP2_BASE                                                  (0x48001800U)
#define SOC_L4_PER_IA_IP3_BASE                                                  (0x48001c00U)
#define SOC_UART3_BASE                                                          (0x48020000U)
#define SOC_L4_PER_TA_UART3_TARG_BASE                                           (0x48021000U)
#define SOC_TIMER2_BASE                                                         (0x48032000U)
#define SOC_L4_PER_TA_TIMER2_TARG_BASE                                          (0x48033000U)
#define SOC_TIMER3_BASE                                                         (0x48034000U)
#define SOC_L4_PER_TA_TIMER3_TARG_BASE                                          (0x48035000U)
#define SOC_TIMER4_BASE                                                         (0x48036000U)
#define SOC_L4_PER_TA_TIMER4_TARG_BASE                                          (0x48037000U)
#define SOC_TIMER9_BASE                                                         (0x4803e000U)
#define SOC_L4_PER_TA_TIMER9_TARG_BASE                                          (0x4803f000U)
#define SOC_GPIO7_BASE                                                          (0x48051000U)
#define SOC_L4_PER_TA_GPIO7_TARG_BASE                                           (0x48052000U)
#define SOC_GPIO8_BASE                                                          (0x48053000U)
#define SOC_L4_PER_TA_GPIO8_TARG_BASE                                           (0x48054000U)
#define SOC_GPIO2_BASE                                                          (0x48055000U)
#define SOC_L4_PER_TA_GPIO2_TARG_BASE                                           (0x48056000U)
#define SOC_GPIO3_BASE                                                          (0x48057000U)
#define SOC_L4_PER_TA_GPIO3_TARG_BASE                                           (0x48058000U)
#define SOC_GPIO4_BASE                                                          (0x48059000U)
#define SOC_L4_PER_TA_GPIO4_TARG_BASE                                           (0x4805a000U)
#define SOC_GPIO5_BASE                                                          (0x4805b000U)
#define SOC_L4_PER_TA_GPIO5_TARG_BASE                                           (0x4805c000U)
#define SOC_GPIO6_BASE                                                          (0x4805d000U)
#define SOC_L4_PER_TA_GPIO6_TARG_BASE                                           (0x4805e000U)
#define SOC_I2C3_BASE                                                           (0x48060000U)
#define SOC_L4_PER_TA_I2C3_TARG_BASE                                            (0x48061000U)
#define SOC_UART5_BASE                                                          (0x48066000U)
#define SOC_L4_PER_TA_UART5_TARG_BASE                                           (0x48067000U)
#define SOC_UART6_BASE                                                          (0x48068000U)
#define SOC_L4_PER_TA_UART6_TARG_BASE                                           (0x48069000U)
#define SOC_UART1_BASE                                                          (0x4806a000U)
#define SOC_L4_PER_TA_UART1_TARG_BASE                                           (0x4806b000U)
#define SOC_UART2_BASE                                                          (0x4806c000U)
#define SOC_L4_PER_TA_UART2_TARG_BASE                                           (0x4806d000U)
#define SOC_UART4_BASE                                                          (0x4806e000U)
#define SOC_L4_PER_TA_UART4_TARG_BASE                                           (0x4806f000U)
#define SOC_I2C1_BASE                                                           (0x48070000U)
#define SOC_L4_PER_TA_I2C1_TARG_BASE                                            (0x48071000U)
#define SOC_I2C2_BASE                                                           (0x48072000U)
#define SOC_L4_PER_TA_I2C2_TARG_BASE                                            (0x48073000U)
#define SOC_ELM_BASE                                                            (0x48078000U)
#define SOC_L4_PER_TA_ELM_TARG_BASE                                             (0x48079000U)
#define SOC_I2C4_BASE                                                           (0x4807a000U)
#define SOC_L4_PER_TA_I2C4_TARG_BASE                                            (0x4807b000U)
#define SOC_I2C5_BASE                                                           (0x4807c000U)
#define SOC_L4_PER_TA_I2C5_TARG_BASE                                            (0x4807d000U)
#if defined (SOC_TDA2EX) || defined (SOC_DRA72x) || defined (SOC_AM571x)
#define SOC_I2C6_BASE                                                           (0x48458000U)
#define SOC_L4_PER_TA_I2C6_TARG_BASE                                            (0x4845AFFFU)
#endif
#define SOC_TIMER10_BASE                                                        (0x48086000U)
#define SOC_L4_PER_TA_TIMER10_TARG_BASE                                         (0x48087000U)
#define SOC_TIMER11_BASE                                                        (0x48088000U)
#define SOC_L4_PER_TA_TIMER11_TARG_BASE                                         (0x48089000U)
#define SOC_RNG_BASE                                                            (0x48090000U)
#define SOC_L4_PER_TA_RNG_TARG_BASE                                             (0x48092000U)
#define SOC_MCSPI1_BASE                                                         (0x48098000U)
#define SOC_L4_PER_TA_MCSPI1_TARG_BASE                                          (0x48099000U)
#define SOC_MCSPI2_BASE                                                         (0x4809a000U)
#define SOC_L4_PER_TA_MCSPI2_TARG_BASE                                          (0x4809b000U)
#define SOC_MMC1_BASE                                                           (0x4809c000U)
#define SOC_L4_PER_TA_MMC1_TARG_BASE                                            (0x4809d000U)
#define SOC_DMA_CRYPTO_BASE                                                     (0x480a2000U)
#define SOC_L4_PER_TA_DMA_CRYPTO_TARG_BASE                                      (0x480a3000U)
#define SOC_DES3DES_ADDRSP0_BASE                                                (0x480a4000U)
#define SOC_DES3DES_ADDRSP1_BASE                                                (0x480a5000U)
#define SOC_L4_PER_TA_DES3DES_TARG_BASE                                         (0x480a6000U)
#define SOC_FPKA_BASE                                                           (0x480a8080U)
#define SOC_L4_PER_TA_FPKA_TARG_BASE                                            (0x480ac000U)
#define SOC_MMC3_BASE                                                           (0x480ad000U)
#define SOC_L4_PER_TA_MMC3_TARG_BASE                                            (0x480ae000U)
#define SOC_HDQ1W_BASE                                                          (0x480b2000U)
#define SOC_L4_PER_TA_HDQ1W_TARG_BASE                                           (0x480b3000U)
#define SOC_MMC2_BASE                                                           (0x480b4000U)
#define SOC_L4_PER_TA_MMC2_TARG_BASE                                            (0x480b5000U)
#define SOC_MCSPI3_BASE                                                         (0x480b8000U)
#define SOC_L4_PER_TA_MCSPI3_TARG_BASE                                          (0x480b9000U)
#define SOC_MCSPI4_BASE                                                         (0x480ba000U)
#define SOC_L4_PER_TA_MCSPI4_TARG_BASE                                          (0x480bb000U)
#define SOC_MMC4_BASE                                                           (0x480d1000U)
#define SOC_L4_PER_TA_MMC4_TARG_BASE                                            (0x480d2000U)
#define SOC_L4_PER2_AP_BASE                                                     (0x48400000U)
#define SOC_L4_PER2_LA_BASE                                                     (0x48400800U)
#define SOC_L4_PER2_IA_IP0_BASE                                                 (0x48401000U)
#define SOC_L4_PER2_IA_IP1_BASE                                                 (0x48401400U)
#define SOC_L4_PER2_IA_IP2_BASE                                                 (0x48401800U)
#define SOC_UART7_BASE                                                          (0x48420000U)
#define SOC_L4_PER2_TA_UART7_TARG_BASE                                          (0x48421000U)
#define SOC_UART8_BASE                                                          (0x48422000U)
#define SOC_L4_PER2_TA_UART8_TARG_BASE                                          (0x48423000U)
#define SOC_UART9_BASE                                                          (0x48424000U)
#define SOC_L4_PER2_TA_UART9_TARG_BASE                                          (0x48425000U)
#define SOC_MLB_BASE                                                            (0x4842c000U)
#define SOC_L4_PER2_TA_MLB_TARG_BASE                                            (0x4842d000U)
#define SOC_MCASP4_DAT_BASE                                                     (0x48436000U)
#define SOC_L4_PER2_TA_MCASP4_DAT_TARG_BASE                                     (0x48437000U)
#define SOC_MCASP5_DAT_BASE                                                     (0x4843a000U)
#define SOC_L4_PER2_TA_MCASP5_DAT_TARG_BASE                                     (0x4843b000U)
#define SOC_ATL_BASE                                                            (0x4843c000U)
#define SOC_L4_PER2_TA_ALT_TARG_BASE                                            (0x4843d000U)
#define SOC_PWMSS1_IPWMSS_BASE                                                  (0x4843e000U)
#define SOC_PWMSS1_IECAP_BASE                                                   (0x4843e100U)
#define SOC_PWMSS1_IEQEP_BASE                                                   (0x4843e180U)
#define SOC_PWMSS1_IEPWM_BASE                                                   (0x4843e200U)
#define SOC_L4_PER2_TA_PWMSS1_TARG_BASE                                         (0x4843f000U)
#define SOC_PWMSS2_IPWMSS_BASE                                                  (0x48440000U)
#define SOC_PWMSS2_IECAP_BASE                                                   (0x48440100U)
#define SOC_PWMSS2_IEQEP_BASE                                                   (0x48440180U)
#define SOC_PWMSS2_IEPWM_BASE                                                   (0x48440200U)
#define SOC_L4_PER2_TA_PWMSS2_TARG_BASE                                         (0x48441000U)
#define SOC_PWMSS3_IPWMSS_BASE                                                  (0x48442000U)
#define SOC_PWMSS3_IECAP_BASE                                                   (0x48442100U)
#define SOC_PWMSS3_IEQEP_BASE                                                   (0x48442180U)
#define SOC_PWMSS3_IEPWM_BASE                                                   (0x48442200U)
#define SOC_L4_PER2_TA_PWMSS3_TARG_BASE                                         (0x48443000U)
#define SOC_VCP1_CFG_BASE                                                       (0x48446000U)
#define SOC_L4_PER2_TA_VCP1_CFG_TARG_BASE                                       (0x48447000U)
#define SOC_VCP2_CFG_BASE                                                       (0x48448000U)
#define SOC_L4_PER2_TA_VCP2_CFG_TARG_BASE                                       (0x48449000U)
#define SOC_DELAYLINE_BASE                                                      (0x4844a000U)
#define SOC_L4_PER2_TA_DELAYLINE_TARG_BASE                                      (0x4844b000U)
#define SOC_MCASP6_DAT_BASE                                                     (0x4844c000U)
#define SOC_L4_PER2_TA_MCASP6_DAT_TARG_BASE                                     (0x4844d000U)
#define SOC_MCASP7_DAT_BASE                                                     (0x48450000U)
#define SOC_L4_PER2_TA_MCASP7_DAT_TARG_BASE                                     (0x48451000U)
#define SOC_MCASP8_DAT_BASE                                                     (0x48454000U)
#define SOC_L4_PER2_TA_MCASP8_DAT_TARG_BASE                                     (0x48455000U)
#define SOC_SPARE_UNKNOWN4_BASE                                                 (0x48458000U)
#define SOC_L4_PER2_TA_SPARE_UNKNOWN4_TARG_BASE                                 (0x4845a000U)
#if defined (SOC_TDA2EX) || defined (SOC_DRA72x) || defined (SOC_AM571x)
#define SOC_CAL_INST_0_BASE                                                     (0x4845b000U)
#else
#define SOC_SPARE_UNKNOWN5_BASE                                                 (0x4845b000U)
#endif
#define SOC_L4_PER2_TA_SPARE_UNKNOWN5_TARG_BASE                                 (0x4845c000U)
#define SOC_SPARE_UNKNOWN6_BASE                                                 (0x4845d000U)
#define SOC_L4_PER2_TA_SPARE_UNKNOWN6_TARG_BASE                                 (0x4845e000U)
#define SOC_MCASP1_CFG_BASE                                                     (0x48460000U)
#define SOC_L4_PER2_TA_MCASP1_CFG_TARG_BASE                                     (0x48462000U)

#define SOC_L4_PER2_TA_MCASP2_CFG_TARG_BASE                                     (0x48466000U)

#define SOC_L4_PER2_TA_MCASP3_CFG_TARG_BASE                                     (0x4846a000U)
#define SOC_MCASP4_CFG_BASE                                                     (0x4846c000U)
#define SOC_L4_PER2_TA_MCASP4_CFG_TARG_BASE                                     (0x4846e000U)
#define SOC_MCASP5_CFG_BASE                                                     (0x48470000U)
#define SOC_L4_PER2_TA_MCASP5_CFG_TARG_BASE                                     (0x48472000U)
#define SOC_MCASP6_CFG_BASE                                                     (0x48474000U)
#define SOC_L4_PER2_TA_MCASP6_CFG_TARG_BASE                                     (0x48476000U)
#define SOC_MCASP7_CFG_BASE                                                     (0x48478000U)
#define SOC_L4_PER2_TA_MCASP7_CFG_TARG_BASE                                     (0x4847a000U)
#define SOC_MCASP8_CFG_BASE                                                     (0x4847c000U)
#define SOC_L4_PER2_TA_MCASP8_CFG_TARG_BASE                                     (0x4847e000U)
#define SOC_DCAN2_BASE                                                          (0x48480000U)
#define SOC_DCAN2_MESSAGERAM_BASE                                               (0x48481000U)
#define SOC_L4_PER2_TA_DCAN2_TARG_BASE                                          (0x48482000U)
#define SOC_GMAC_SS_BASE                                                        (0x48484000U)
#define SOC_GMAC_PORT_BASE                                                      (0x48484100U)
#define SOC_GMAC_CPDMA_BASE                                                     (0x48484800U)
#define SOC_GMAC_STATERAM_BASE                                                  (0x48484a00U)
#define SOC_GMAC_CPTS_BASE                                                      (0x48484c00U)
#define SOC_GMAC_ALE_BASE                                                       (0x48484d00U)
#define SOC_GMAC_SL1_BASE                                                       (0x48484d80U)
#define SOC_GMAC_SL2_BASE                                                       (0x48484dc0U)
#define SOC_GMAC_MDIO_BASE                                                      (0x48485000U)
#define SOC_GMAC_WR_BASE                                                        (0x48485200U)
#define SOC_L4_PER2_TA_GMAC_TARG_BASE                                           (0x48488000U)
#define SOC_L4_PER3_AP_BASE                                                     (0x48800000U)
#define SOC_L4_PER3_LA_BASE                                                     (0x48800800U)
#define SOC_L4_PER3_IA_IP0_BASE                                                 (0x48801000U)
#define SOC_L4_PER3_IA_IP1_BASE                                                 (0x48801400U)
#define SOC_L4_PER3_IA_IP2_BASE                                                 (0x48801800U)
#define SOC_MAILBOX13_BASE                                                      (0x48802000U)
#define SOC_L4_PER3_TA_MAILBOX13_TARG_BASE                                      (0x48803000U)
#define SOC_OCMC_RAM1_CFG_BASE                                                  (0x48804000U)
#define SOC_L4_PER3_TA_OCMC_RAM1_CFG_TARG_BASE                                  (0x48805000U)
#if defined (SOC_TDA2EX) || defined (SOC_DRA72x) || defined (SOC_AM571x)
 /* Not applicable */
#else
#define SOC_OCMC_RAM2_CFG_BASE                                                  (0x4880a000U)
#define SOC_L4_PER3_TA_OCMC_RAM2_CFG_TARG_BASE                                  (0x4880b000U)
#define SOC_OCMC_RAM3_CFG_BASE                                                  (0x48810000U)
#define SOC_L4_PER3_TA_OCMC_RAM3_CFG_TARG_BASE                                  (0x48811000U)
#endif
#define SOC_SPARE_SATA2_BASE                                                    (0x48816000U)
#define SOC_L4_PER3_TA_SPARE_SATA2_TARG_BASE                                    (0x48817000U)
#define SOC_L4_PER3_MMU1_BASE                                                   (0x4881c000U)
#define SOC_L4_PER3_TA_MMU1_TARG_BASE                                           (0x4881d000U)
#define SOC_MMU2_BASE                                                           (0x4881e000U)
#define SOC_L4_PER3_TA_MMU2_TARG_BASE                                           (0x4881f000U)
#define SOC_TIMER5_BASE                                                         (0x48820000U)
#define SOC_L4_PER3_TA_TIMER5_TARG_BASE                                         (0x48821000U)
#define SOC_TIMER6_BASE                                                         (0x48822000U)
#define SOC_L4_PER3_TA_TIMER6_TARG_BASE                                         (0x48823000U)
#define SOC_TIMER7_BASE                                                         (0x48824000U)
#define SOC_L4_PER3_TA_TIMER7_TARG_BASE                                         (0x48825000U)
#define SOC_TIMER8_BASE                                                         (0x48826000U)
#define SOC_L4_PER3_TA_TIMER8_TARG_BASE                                         (0x48827000U)
#define SOC_TIMER13_BASE                                                        (0x48828000U)
#define SOC_L4_PER3_TA_TIMER13_TARG_BASE                                        (0x48829000U)
#define SOC_TIMER14_BASE                                                        (0x4882a000U)
#define SOC_L4_PER3_TA_TIMER14_TARG_BASE                                        (0x4882b000U)
#define SOC_TIMER15_BASE                                                        (0x4882c000U)
#define SOC_L4_PER3_TA_TIMER15_TARG_BASE                                        (0x4882d000U)
#define SOC_TIMER16_BASE                                                        (0x4882e000U)
#define SOC_L4_PER3_TA_TIMER16_TARG_BASE                                        (0x4882f000U)
#define SOC_RTC_SS_BASE                                                         (0x48838000U)
#define SOC_L4_PER3_TA_RTC_SS_TARG_BASE                                         (0x48839000U)
#define SOC_MAILBOX2_BASE                                                       (0x4883a000U)
#define SOC_L4_PER3_TA_MAILBOX2_TARG_BASE                                       (0x4883b000U)
#define SOC_MAILBOX3_BASE                                                       (0x4883c000U)
#define SOC_L4_PER3_TA_MAILBOX3_TARG_BASE                                       (0x4883d000U)
#define SOC_MAILBOX4_BASE                                                       (0x4883e000U)
#define SOC_L4_PER3_TA_MAILBOX4_TARG_BASE                                       (0x4883f000U)
#define SOC_MAILBOX5_BASE                                                       (0x48840000U)
#define SOC_L4_PER3_TA_MAILBOX5_TARG_BASE                                       (0x48841000U)
#define SOC_MAILBOX6_BASE                                                       (0x48842000U)
#define SOC_L4_PER3_TA_MAILBOX6_TARG_BASE                                       (0x48843000U)
#define SOC_MAILBOX7_BASE                                                       (0x48844000U)
#define SOC_L4_PER3_TA_MAILBOX7_TARG_BASE                                       (0x48845000U)
#define SOC_MAILBOX8_BASE                                                       (0x48846000U)
#define SOC_L4_PER3_TA_MAILBOX8_TARG_BASE                                       (0x48847000U)
#define SOC_SPARE_ICM_BASE                                                      (0x48848000U)
#define SOC_L4_PER3_TA_SPARE_ICM_TARG_BASE                                      (0x48849000U)
#define SOC_SPARE_HDMI_RX_BASE                                                  (0x4884a000U)
#define SOC_L4_PER3_TA_SPARE_HDMI_RX_TARG_BASE                                  (0x4884b000U)
#define SOC_SPARE_LVDS_TX1_BASE                                                 (0x4884c000U)
#define SOC_L4_PER3_TA_SPARE_LVDS_TX1_TARG_BASE                                 (0x4884d000U)
#define SOC_CSI2_2_BASE                                                         (0x4884e000U)
#define SOC_L4_PER3_TA_CSI2_2_TARG_BASE                                         (0x4884f000U)
#define SOC_SPARE_VENC_BASE                                                     (0x48850000U)
#define SOC_L4_PER3_TA_SPARE_VENC_TARG_BASE                                     (0x48851000U)
#define SOC_LVDS_RX_BASE                                                        (0x48852000U)
#define SOC_L4_PER3_TA_LVDS_RX_TARG_BASE                                        (0x48853000U)
#define SOC_CSI2_1_BASE                                                         (0x48854000U)
#define SOC_L4_PER3_TA_CSI2_1_TARG_BASE                                         (0x48855000U)
#define SOC_SPARE_VIDEOPLL1_BASE                                                (0x48856000U)
#define SOC_L4_PER3_TA_SPARE_VIDEOPLL1_TARG_BASE                                (0x48857000U)
#define SOC_SPARE_VIDEOPLL2_BASE                                                (0x48858000U)
#define SOC_L4_PER3_TA_SPARE_VIDEOPLL2_TARG_BASE                                (0x48859000U)
#define SOC_SPARE_VIDEOPLL3_BASE                                                (0x4885a000U)
#define SOC_L4_PER3_TA_SPARE_VIDEOPLL3_TARG_BASE                                (0x4885b000U)
#define SOC_SPARE_CME_BASE                                                      (0x4885c000U)
#define SOC_L4_PER3_TA_SPARE_CME_TARG_BASE                                      (0x4885d000U)
#define SOC_MAILBOX9_BASE                                                       (0x4885e000U)
#define SOC_L4_PER3_TA_MAILBOX9_TARG_BASE                                       (0x4885f000U)
#define SOC_MAILBOX10_BASE                                                      (0x48860000U)
#define SOC_L4_PER3_TA_MAILBOX10_TARG_BASE                                      (0x48861000U)
#define SOC_MAILBOX11_BASE                                                      (0x48862000U)
#define SOC_L4_PER3_TA_MAILBOX11_TARG_BASE                                      (0x48863000U)
#define SOC_MAILBOX12_BASE                                                      (0x48864000U)
#define SOC_L4_PER3_TA_MAILBOX12_TARG_BASE                                      (0x48865000U)
#define SOC_USB1_CFG_USBOTGSS_WRAPPER_BASE                                      (0x48880000U)
#define SOC_USB1_CFG_DWC_USB3_BASE                                              (0x48890000U)
#define SOC_L4_PER3_TA_USB1_CFG_TARG_BASE                                       (0x488a0000U)
#define SOC_USB2_CFG_USBOTGSS_WRAPPER_BASE                                      (0x488c0000U)
#define SOC_USB2_CFG_DWC_USB3_BASE                                              (0x488d0000U)
#define SOC_L4_PER3_TA_USB2_CFG_TARG_BASE                                       (0x488e0000U)
#define SOC_USB3_CFG_USBOTGSS_WRAPPER_BASE                                      (0x48900000U)
#define SOC_USB3_CFG_DWC_USB3_BASE                                              (0x48910000U)
#define SOC_L4_PER3_TA_USB3_CFG_TARG_BASE                                       (0x48920000U)
#if defined (SOC_TDA2EX) || defined (SOC_DRA72x) || defined (SOC_AM571x)
 /* Not applicable */
#else
#define SOC_USB4_CFG_USBOTGSS_WRAPPER_BASE                                      (0x48940000U)
#define SOC_USB4_CFG_DWC_USB3_BASE                                              (0x48950000U)
#define SOC_L4_PER3_TA_USB4_CFG_TARG_BASE                                       (0x48960000U)
#endif
#define SOC_VIP1_VIP_REGS_BASE                                                  (0x48970000U)
#define SOC_VIP1_VIP_PARSER_SLICE0_REGS_BASE                                    (0x48975500U)
#define SOC_VIP1_VIP_CSC_SLICE0_REGS_BASE                                       (0x48975700U)
#define SOC_VIP1_VIP_SC_SLICE0_REGS_BASE                                        (0x48975800U)
#define SOC_VIP1_VIP_PARSER_SLICE1_REGS_BASE                                    (0x48975a00U)
#define SOC_VIP1_VIP_CSC_SLICE1_REGS_BASE                                       (0x48975c00U)
#define SOC_VIP1_VIP_SC_SLICE1_REGS_BASE                                        (0x48975d00U)
#define SOC_VIP1_VIP_VPDMA_REGS_BASE                                            (0x4897d000U)
#define SOC_L4_PER3_TA_VIP1_TARG_BASE                                           (0x48980000U)
#if defined (SOC_TDA2EX) || defined (SOC_DRA72x) || defined (SOC_AM571x)
 /* Not applicable */
#else
#define SOC_VIP2_VIP_REGS_BASE                                                  (0x48990000U)
#define SOC_VIP2_VIP_PARSER_SLICE0_REGS_BASE                                    (0x48995500U)
#define SOC_VIP2_VIP_CSC_SLICE0_REGS_BASE                                       (0x48995700U)
#define SOC_VIP2_VIP_SC_SLICE0_REGS_BASE                                        (0x48995800U)
#define SOC_VIP2_VIP_PARSER_SLICE1_REGS_BASE                                    (0x48995a00U)
#define SOC_VIP2_VIP_CSC_SLICE1_REGS_BASE                                       (0x48995c00U)
#define SOC_VIP2_VIP_SC_SLICE1_REGS_BASE                                        (0x48995d00U)
#define SOC_VIP2_VIP_VPDMA_REGS_BASE                                            (0x4899d000U)
#define SOC_L4_PER3_TA_VIP2_TARG_BASE                                           (0x489a0000U)
#define SOC_VIP3_VIP_REGS_BASE                                                  (0x489b0000U)
#define SOC_VIP3_VIP_PARSER_SLICE0_REGS_BASE                                    (0x489b5500U)
#define SOC_VIP3_VIP_CSC_SLICE0_REGS_BASE                                       (0x489b5700U)
#define SOC_VIP3_VIP_SC_SLICE0_REGS_BASE                                        (0x489b5800U)
#define SOC_VIP3_VIP_PARSER_SLICE1_REGS_BASE                                    (0x489b5a00U)
#define SOC_VIP3_VIP_CSC_SLICE1_REGS_BASE                                       (0x489b5c00U)
#define SOC_VIP3_VIP_SC_SLICE1_REGS_BASE                                        (0x489b5d00U)
#define SOC_VIP3_VIP_VPDMA_REGS_BASE                                            (0x489bd000U)
#define SOC_L4_PER3_TA_VIP3_TARG_BASE                                           (0x489c0000U)
#endif
#define SOC_VPE_REGS_BASE                                                       (0x489d0000U)
#define SOC_VPE_CHR_US_INST0_REGS_BASE                                          (0x489d0300U)
#define SOC_VPE_CHR_US_INST1_REGS_BASE                                          (0x489d0400U)
#define SOC_VPE_CHR_US_INST2_REGS_BASE                                          (0x489d0500U)
#define SOC_VPE_DEI_REGS_BASE                                                   (0x489d0600U)
#define SOC_VPE_SC_REGS_BASE                                                    (0x489d0700U)
#define SOC_VPE_CSC_REGS_BASE                                                   (0x489d5700U)
#define SOC_VPE_VPDMA_REGS_BASE                                                 (0x489dd000U)
#define SOC_L4_PER3_TA_VPE_TARG_BASE                                            (0x489e0000U)
#if defined (SOC_TDA2EX) || defined (SOC_DRA72x) || defined (SOC_AM571x)
 /* Not applicable */
#else
#define SOC_OCMC_RAM2_CBUF_BASE                                                 (0x49000000U)
#define SOC_OCMC_RAM3_CBUF_BASE                                                 (0x49800000U)
#endif
#define SOC_IA_IP0_BASE                                                         (0x4a001000U)
#define SOC_CTRL_MODULE_CORE_BASE                                               (0x4a002000U)
#define SOC_CTRL_MODULE_CORE_CORE_REGISTERS_BASE                                (0x4a002100U)
#define SOC_IRQ_DMARQ_CROSSBAR_REGISTERS_BASE                                   (0x4a0027a0U)
#define SOC_CTRL_MODULE_CORE_CORE_PAD_REGISTERS_BASE                            (0x4a002da0U)
#define SOC_CORE_PAD_IO_REGISTERS_BASE                                          (0x4a003400U)
#define SOC_SEC_EFUSE_REGISTERS_BASE                                            (0x4a003a00U)
#define SOC_TA_CTRL_MODULE_CORE_TARG_BASE                                       (0x4a004000U)
#define SOC_OCP_SOCKET_CM_CORE_AON_BASE                                         (0x4a005000U)
#define SOC_CKGEN_CM_CORE_AON_BASE                                              (0x4a005100U)
#define SOC_MPU_CM_CORE_AON_BASE                                                (0x4a005300U)
#define SOC_DSP1_CM_CORE_AON_BASE                                               (0x4a005400U)
#define SOC_IPU_CM_CORE_AON_BASE                                                (0x4a005500U)
#if defined (SOC_TDA2EX) || defined (SOC_DRA72x) || defined (SOC_AM571x)
 /* Not applicable */
#else
#define SOC_DSP2_CM_CORE_AON_BASE                                               (0x4a005600U)
#define SOC_EVE1_CM_CORE_AON_BASE                                               (0x4a005640U)
#define SOC_EVE2_CM_CORE_AON_BASE                                               (0x4a005680U)
#define SOC_EVE3_CM_CORE_AON_BASE                                               (0x4a0056c0U)
#define SOC_EVE4_CM_CORE_AON_BASE                                               (0x4a005700U)
#endif
#define SOC_RTC_CM_CORE_AON_BASE                                                (0x4a005740U)
#define SOC_VPE_CM_CORE_AON_BASE                                                (0x4a005760U)
#define SOC_RESTORE_CM_CORE_AON_BASE                                            (0x4a005e00U)
#define SOC_INSTR_CM_CORE_AON_BASE                                              (0x4a005f00U)
#define SOC_TA_CM_CORE_AON_TARG_BASE                                            (0x4a006000U)
#define SOC_OCP_SOCKET_CM_CORE_BASE                                             (0x4a008000U)
#define SOC_CKGEN_CM_CORE_BASE                                                  (0x4a008100U)
#define SOC_COREAON_CM_CORE_BASE                                                (0x4a008600U)
#define SOC_CORE_CM_CORE_BASE                                                   (0x4a008700U)
#define SOC_IVA_CM_CORE_BASE                                                    (0x4a008f00U)
#define SOC_CAM_CM_CORE_BASE                                                    (0x4a009000U)
#define SOC_DSS_CM_CORE_BASE                                                    (0x4a009100U)
#define SOC_GPU_CM_CORE_BASE                                                    (0x4a009200U)
#define SOC_L3INIT_CM_CORE_BASE                                                 (0x4a009300U)
#define SOC_CUSTEFUSE_CM_CORE_BASE                                              (0x4a009600U)
#define SOC_L4PER_CM_CORE_BASE                                                  (0x4a009700U)
#define SOC_RESTORE_CM_CORE_BASE                                                (0x4a009e18U)
#define SOC_TA_CM_CORE_TARG_BASE                                                (0x4a00a000U)
#define SOC_DMA_SYSTEM_BASE                                                     (0x4a056000U)
#define SOC_TA_DMA_SYSTEM_TARG_BASE                                             (0x4a057000U)
#define SOC_SAR_ROM_BASE                                                        (0x4a05e000U)
#define SOC_TA_SAR_ROM_TARG_BASE                                                (0x4a060000U)
#define SOC_OCP2SCP1_BASE                                                       (0x4a080000U)
#define SOC_OCP2SCP1_USB_PHY1_CORE_BASE                                         (0x4a084000U)
#define SOC_OCP2SCP1_USB3RX_PHY_USB_BASE                                        (0x4a084400U)
#define SOC_OCP2SCP1_USB3TX_PHY_USB_BASE                                        (0x4a084800U)
#define SOC_OCP2SCP1_DPLLCTRL_USB_OTG_SS_BASE                                   (0x4a084c00U)
#define SOC_OCP2SCP1_USB_PHY2_CORE_BASE                                         (0x4a085000U)
#define SOC_TA_OCP2SCP1_TARG_BASE                                               (0x4a088000U)
#define SOC_OCP2SCP3_BASE                                                       (0x4a090000U)
#define SOC_OCP2SCP3_USB3RX_PHY_PCIE1_BASE                                      (0x4a094000U)
#define SOC_OCP2SCP3_USB3TX_PHY_PCIE1_BASE                                      (0x4a094400U)
#define SOC_OCP2SCP3_DPLLCTRL_PCIE1_BASE                                        (0x4a094800U)
#define SOC_OCP2SCP3_USB3RX_PHY_PCIE2_BASE                                      (0x4a095000U)
#define SOC_OCP2SCP3_USB3TX_PHY_PCIE2_BASE                                      (0x4a095400U)
#define SOC_OCP2SCP3_USB3RX_PHY_SATA_BASE                                       (0x4a096000U)
#define SOC_OCP2SCP3_USB3TX_PHY_SATA_BASE                                       (0x4a096400U)
#define SOC_OCP2SCP3_DPLLCTRL_SATA_BASE                                         (0x4a096800U)
#define SOC_TA_OCP2SCP3_TARG_BASE                                               (0x4a098000U)
#define SOC_OCP2SCP2_BASE                                                       (0x4a0a0000U)
#define SOC_OCP2SCP2_DPLLCTRL_VIDEO1_BASE                                       (0x4a0a4000U)
#define SOC_OCP2SCP2_DPLLCTRL_VIDEO2_BASE                                       (0x4a0a5000U)
#define SOC_OCP2SCP2_DPLLCTRL_HDMI_BASE                                         (0x4a0a6000U)
#define SOC_TA_OCP2SCP2_TARG_BASE                                               (0x4a0a8000U)
#define SOC_SMARTREFLEX_MPU_BASE                                                (0x4a0d9000U)
#define SOC_TA_SMARTREFLEX_MPU_TARG_BASE                                        (0x4a0da000U)
#define SOC_SMARTREFLEX_CORE_BASE                                               (0x4a0dd000U)
#define SOC_TA_SMARTREFLEX_CORE_TARG_BASE                                       (0x4a0de000U)
#define SOC_EFUSE_CTRL_CUST_BASE                                                (0x4a0e0000U)
#define SOC_TA_EFUSE_CTRL_CUST_TARG_BASE                                        (0x4a0e1000U)
#define SOC_MAILBOX1_BASE                                                       (0x4a0f4000U)
#define SOC_TA_MAILBOX1_TARG_BASE                                               (0x4a0f5000U)
#define SOC_SPINLOCK_BASE                                                       (0x4a0f6000U)
#define SOC_TA_SPINLOCK_TARG_BASE                                               (0x4a0f7000U)
#define SOC_OCP_WP_NOC_BASE                                                     (0x4a102000U)
#define SOC_TA_OCP_WP_NOC_TARG_BASE                                             (0x4a103000U)
#define SOC_IEEE1500_2_OCP_BASE                                                 (0x4a108000U)
#define SOC_TA_IEEE1500_2_OCP_TARG_BASE                                         (0x4a109000U)
#define SOC_DWC_AHSATA_BASE                                                     (0x4a140000U)
#define SOC_SATAMAC_WRAPPER_BASE                                                (0x4a141100U)
#define SOC_TA_SATA_TARG_BASE                                                   (0x4a150000U)
#if defined (SOC_TDA2EX) || defined (SOC_DRA72x) || defined (SOC_AM571x)
 /* Not applicable */
#else
#define SOC_SECURITYCORE_EVE1_BASE                                              (0x4a151000U)
#define SOC_TA_EVE1_FW_CFG_TARG_BASE                                            (0x4a152000U)
#define SOC_SECURITYCORE_EVE2_BASE                                              (0x4a153000U)
#define SOC_TA_EVE2_FW_CFG_TARG_BASE                                            (0x4a154000U)
#define SOC_SECURITYCORE_EVE3_BASE                                              (0x4a155000U)
#define SOC_TA_EVE3_FW_CFG_TARG_BASE                                            (0x4a156000U)
#define SOC_SECURITYCORE_EVE4_BASE                                              (0x4a157000U)
#define SOC_TA_EVE4_FW_CFG_TARG_BASE                                            (0x4a158000U)
#endif
#define SOC_SECURITYCORE_PCIE2_BASE                                             (0x4a159000U)
#define SOC_TA_PCIE_SS2_FW_CFG_TARG_BASE                                        (0x4a15a000U)
#define SOC_SECURITYCORE_IPU1_BASE                                              (0x4a15b000U)
#define SOC_TA_IPU1_FW_CFG_TARG_BASE                                            (0x4a15c000U)
#define SOC_SECURITYCORE_VCP1_BASE                                              (0x4a15d000U)
#define SOC_TA_VCP1_FW_CFG_TARG_BASE                                            (0x4a15e000U)
#define SOC_SECURITYCORE_VCP2_BASE                                              (0x4a15f000U)
#define SOC_TA_VCP2_FW_CFG_TARG_BASE                                            (0x4a160000U)
#define SOC_SECURITYCORE_TPCC_BASE                                              (0x4a161000U)
#define SOC_TA_EDMA_TPCC_FW_CFG_TARG_BASE                                       (0x4a162000U)
#define SOC_SECURITYCORE_TPTC_BASE                                              (0x4a163000U)
#define SOC_TA_EDMA_TC0_FW_CFG_TARG_BASE                                        (0x4a164000U)
#define SOC_SECURITYCORE_PCIE1_BASE                                             (0x4a165000U)
#define SOC_TA_PCIE_SS1_FW_CFG_TARG_BASE                                        (0x4a166000U)
#define SOC_SECURITYCORE_MCASP1_BASE                                            (0x4a167000U)
#define SOC_TA_MCASP1_FW_CFG_TARG_BASE                                          (0x4a168000U)
#define SOC_SECURITYCORE_MCASP2_BASE                                            (0x4a169000U)
#define SOC_TA_MCASP2_FW_CFG_TARG_BASE                                          (0x4a16a000U)
#define SOC_SECURITYCORE_MCASP3_BASE                                            (0x4a16b000U)
#define SOC_TA_MCASP3_FW_CFG_TARG_BASE                                          (0x4a16c000U)
#define SOC_SECURITYCORE_TSC_ADC_BASE                                           (0x4a16d000U)
#define SOC_TA_SPARE_TSC_ADC_FW_CFG_TARG_BASE                                   (0x4a16e000U)
#define SOC_SECURITYCORE_DSP1_SDMA_BASE                                         (0x4a171000U)
#define SOC_TA_DSP1_FW_CFG_TARG_BASE                                            (0x4a172000U)
#if defined (SOC_TDA2EX) || defined (SOC_DRA72x) || defined (SOC_AM571x)
 /* Not applicable */
#else
#define SOC_SECURITYCORE_DSP2_SDMA_BASE                                         (0x4a173000U)
#define SOC_TA_DSP2_FW_CFG_TARG_BASE                                            (0x4a174000U)
#endif
#define SOC_SECURITYCORE_PRUSS1_BASE                                            (0x4a175000U)
#define SOC_TA_PRUSS1_FW_CFG_TARG_BASE                                          (0x4a176000U)
#define SOC_SECURITYCORE_PRUSS2_BASE                                            (0x4a177000U)
#define SOC_TA_PRUSS2_FW_CFG_TARG_BASE                                          (0x4a178000U)
#define SOC_SECURITYCORE_QSPI_BASE                                              (0x4a179000U)
#define SOC_TA_QSPI_FW_CFG_TARG_BASE                                            (0x4a17a000U)
#define SOC_SPARE_SMARTREFLEX_RTC_BASE                                          (0x4a17b000U)
#define SOC_TA_SPARE_SMARTREFLEX_RTC_TARG_BASE                                  (0x4a17c000U)
#define SOC_SPARE_SMARTREFLEX_WKUP_BASE                                         (0x4a17d000U)
#define SOC_TA_SPARE_SMARTREFLEX_WKUP_TARG_BASE                                 (0x4a17e000U)
#define SOC_SPARE_SMARTREFLEX_SDRAM_BASE                                        (0x4a181000U)
#define SOC_TA_SPARE_SMARTREFLEX_SDRAM_TARG_BASE                                (0x4a182000U)
#define SOC_SMARTREFLEX_DSPEVE_BASE                                             (0x4a183000U)
#define SOC_TA_SMARTREFLEX_DSPEVE_TARG_BASE                                     (0x4a184000U)
#define SOC_SMARTREFLEX_GPU_BASE                                                (0x4a185000U)
#define SOC_TA_SMARTREFLEX_GPU_TARG_BASE                                        (0x4a186000U)
#define SOC_SMARTREFLEX_IVA_BASE                                                (0x4a187000U)
#define SOC_TA_SMARTREFLEX_IVA_TARG_BASE                                        (0x4a188000U)
#define SOC_SECURITYCORE_OCMC_ROM_BASE                                          (0x4a200000U)
#define SOC_TA_OCMC_ROM_FW_CFG_TARG_BASE                                        (0x4a201000U)
#define SOC_MA_MPU_NTTP_FW_CFG_BASE                                             (0x4a20a000U)
#define SOC_TA_MA_MPU_NTTP_FW_CFG_TARG_BASE                                     (0x4a20b000U)
#define SOC_SECURITYCORE_OCP_FW_EMIF_5430_BASE                                  (0x4a20c000U)
#define SOC_TA_EMIF_OCP_FW_CFG_TARG_BASE                                        (0x4a20d000U)
#if defined (SOC_TDA2EX) || defined (SOC_DRA72x) || defined (SOC_AM571x)
 /* Not applicable */
#else
#define SOC_SECURITYCORE_OCMC_RAM2_BASE                                         (0x4a20e000U)
#define SOC_TA_OCMC_RAM2_FW_CFG_TARG_BASE                                       (0x4a20f000U)
#endif
#define SOC_SECURITYCORE_GPMC_BASE                                              (0x4a210000U)
#define SOC_TA_GPMC_FW_CFG_TARG_BASE                                            (0x4a211000U)
#define SOC_SECURITYCORE_OCMC_RAM1_BASE                                         (0x4a212000U)
#define SOC_TA_OCMC_RAM1_FW_CFG_TARG_BASE                                       (0x4a213000U)
#define SOC_SECURITYCORE_GPU_BASE                                               (0x4a214000U)
#define SOC_TA_GPU_FW_CFG_TARG_BASE                                             (0x4a215000U)
#define SOC_SECURITYCORE_IPU2_BASE                                              (0x4a218000U)
#define SOC_TA_IPU2_FW_CFG_TARG_BASE                                            (0x4a219000U)
#define SOC_SECURITYCORE_GRPX2D_BASE                                            (0x4a21a000U)
#define SOC_TA_BB2D_FW_CFG_TARG_BASE                                            (0x4a21b000U)
#define SOC_SECURITYCORE_DSS_BASE                                               (0x4a21c000U)
#define SOC_TA_DSS_FW_CFG_TARG_BASE                                             (0x4a21d000U)
#define SOC_SECURITYCORE_IVA1_SL2IF_BASE                                        (0x4a21e000U)
#define SOC_TA_IVA_SL2IF_FW_CFG_TARG_BASE                                       (0x4a21f000U)
#define SOC_SECURITYCORE_IVA1_CONFIG_BASE                                       (0x4a220000U)
#define SOC_TA_IVA_CONFIG_FW_CFG_TARG_BASE                                      (0x4a221000U)
#define SOC_SECURITYCORE_DEBUGSS_CT_TBR_BASE                                    (0x4a224000U)
#define SOC_TA_DEBUGSS_CT_TBR_FW_CFG_TARG_BASE                                  (0x4a225000U)
#define SOC_SECURITYCORE_L3_INSTR_BASE                                          (0x4a226000U)
#define SOC_TA_L3_INSTR_FW_CFG_TARG_BASE                                        (0x4a227000U)
#if defined (SOC_TDA2EX) || defined (SOC_DRA72x) || defined (SOC_AM571x)
 /* Not applicable */
#else
#define SOC_SECURITYCORE_OCMC_RAM3_BASE                                         (0x4a22a000U)
#define SOC_TA_OCMC_RAM3_FW_CFG_TARG_BASE                                       (0x4a22b000U)
#endif
#define SOC_SECURITYCORE_AES1_BASE                                              (0x4a22c000U)
#define SOC_TA_AES1_FW_CFG_TARG_BASE                                            (0x4a22d000U)
#define SOC_SECURITYCORE_AES2_BASE                                              (0x4a22e000U)
#define SOC_TA_AES2_FW_CFG_TARG_BASE                                            (0x4a22f000U)
#define SOC_SECURITYCORE_SHA2MD5_P1_BASE                                        (0x4a230000U)
#define SOC_TA_SHA2MD5_1_FW_CFG_TARG_BASE                                       (0x4a231000U)
#define SOC_SECURITYCORE_SHA2MD5_P2_BASE                                        (0x4a232000U)
#define SOC_TA_SHA2MD5_2_FW_CFG_TARG_BASE                                       (0x4a233000U)
#define SOC_SECURITYCORE_IVA2_SL2IF_BASE                                        (0x4a234000U)
#define SOC_TA_SPARE_IVA2_SL2IF_FW_CFG_TARG_BASE                                (0x4a235000U)
#define SOC_SECURITYCORE_IVA2_CONFIG_BASE                                       (0x4a236000U)
#define SOC_TA_SPARE_IVA2_CONFIG_FW_CFG_TARG_BASE                               (0x4a237000U)
#define SOC_COUNTER_32K_BASE                                                    (0x4ae04000U)
#define SOC_L4_WKUP_TA_COUNTER_32K_TARG_BASE                                    (0x4ae05000U)
#define SOC_OCP_SOCKET_PRM_BASE                                                 (0x4ae06000U)
#define SOC_CKGEN_PRM_BASE                                                      (0x4ae06100U)
#define SOC_MPU_PRM_BASE                                                        (0x4ae06300U)
#define SOC_DSP1_PRM_BASE                                                       (0x4ae06400U)
#define SOC_IPU_PRM_BASE                                                        (0x4ae06500U)
#define SOC_COREAON_PRM_BASE                                                    (0x4ae06628U)
#define SOC_CORE_PRM_BASE                                                       (0x4ae06700U)
#define SOC_IVA_PRM_BASE                                                        (0x4ae06f00U)
#define SOC_CAM_PRM_BASE                                                        (0x4ae07000U)
#define SOC_DSS_PRM_BASE                                                        (0x4ae07100U)
#define SOC_GPU_PRM_BASE                                                        (0x4ae07200U)
#define SOC_L3INIT_PRM_BASE                                                     (0x4ae07300U)
#define SOC_L4PER_PRM_BASE                                                      (0x4ae07400U)
#define SOC_CUSTEFUSE_PRM_BASE                                                  (0x4ae07600U)
#define SOC_WKUPAON_PRM_BASE                                                    (0x4ae07724U)
#define SOC_WKUPAON_CM_BASE                                                     (0x4ae07800U)
#define SOC_EMU_PRM_BASE                                                        (0x4ae07900U)
#define SOC_EMU_CM_BASE                                                         (0x4ae07a00U)
#if defined (SOC_TDA2EX) || defined (SOC_DRA72x) || defined (SOC_AM571x)
 /* Not applicable */
#else
#define SOC_DSP2_PRM_BASE                                                       (0x4ae07b00U)
#define SOC_EVE1_PRM_BASE                                                       (0x4ae07b40U)
#define SOC_EVE2_PRM_BASE                                                       (0x4ae07b80U)
#define SOC_EVE3_PRM_BASE                                                       (0x4ae07bc0U)
#define SOC_EVE4_PRM_BASE                                                       (0x4ae07c00U)
#endif
#define SOC_RTC_PRM_BASE                                                        (0x4ae07c60U)
#define SOC_VPE_PRM_BASE                                                        (0x4ae07c80U)
#define SOC_DEVICE_PRM_BASE                                                     (0x4ae07d00U)
#define SOC_INSTR_PRM_BASE                                                      (0x4ae07f00U)
#define SOC_L4_WKUP_TA_PRM_TARG_BASE                                            (0x4ae08000U)
#define SOC_CTRL_MODULE_WKUP_BASE                                               (0x4ae0c000U)
#define SOC_CTRL_MODULE_WKUP_CORE_REGISTERS_BASE                                (0x4ae0c100U)
#define SOC_CTRL_MODULE_WKUP_CORE_PAD_REGISTERS_BASE                            (0x4ae0c5a8U)
#define SOC_L4_WKUP_TA_CTRL_MODULE_WKUP_TARG_BASE                               (0x4ae0d000U)
#define SOC_GPIO1_BASE                                                          (0x4ae10000U)
#define SOC_L4_WKUP_TA_GPIO1_TARG_BASE                                          (0x4ae11000U)
#define SOC_WD_TIMER2_BASE                                                      (0x4ae14000U)
#define SOC_L4_WKUP_TA_WD_TIMER2_TARG_BASE                                      (0x4ae15000U)
#define SOC_TIMER1_BASE                                                         (0x4ae18000U)
#define SOC_L4_WKUP_TA_TIMER1_TARG_BASE                                         (0x4ae19000U)
#define SOC_KBD_BASE                                                            (0x4ae1c000U)
#define SOC_L4_WKUP_TA_KBD_TARG_BASE                                            (0x4ae1d000U)
#define SOC_TIMER12_BASE                                                        (0x4ae20000U)
#define SOC_L4_WKUP_TA_TIMER12_TARG_BASE                                        (0x4ae21000U)
#define SOC_WD_TIMER1_BASE                                                      (0x4ae22000U)
#define SOC_L4_WKUP_TA_WD_TIMER1_TARG_BASE                                      (0x4ae23000U)
#define SOC_SAR_RAM_SPACE1_BASE                                                 (0x4ae26000U)
#define SOC_SAR_RAM_SPACE2_BASE                                                 (0x4ae27000U)
#define SOC_SAR_RAM_SPACE3_BASE                                                 (0x4ae28000U)
#define SOC_SAR_RAM_SPACE4_BASE                                                 (0x4ae29000U)
#define SOC_L4_WKUP_TA_SAR_RAM_TARG_BASE                                        (0x4ae2a000U)
#define SOC_UART10_BASE                                                         (0x4ae2b000U)
#define SOC_L4_WKUP_TA_UART10_TARG_BASE                                         (0x4ae2c000U)
#define SOC_SPARE_SAFETY1_BASE                                                  (0x4ae2f000U)
#define SOC_L4_WKUP_TA_SPARE_SAFETY1_TARG_BASE                                  (0x4ae30000U)
#define SOC_SPARE_SAFETY2_BASE                                                  (0x4ae31000U)
#define SOC_L4_WKUP_TA_SPARE_SAFETY2_TARG_BASE                                  (0x4ae32000U)
#define SOC_SPARE_SAFETY3_BASE                                                  (0x4ae33000U)
#define SOC_L4_WKUP_TA_SPARE_SAFETY3_TARG_BASE                                  (0x4ae34000U)
#define SOC_SPARE_SAFETY4_BASE                                                  (0x4ae35000U)
#define SOC_L4_WKUP_TA_SPARE_SAFETY4_TARG_BASE                                  (0x4ae36000U)
#define SOC_SPARE_UNKNOWN2_BASE                                                 (0x4ae37000U)
#define SOC_L4_WKUP_TA_SPARE_UNKNOWN2_TARG_BASE                                 (0x4ae38000U)
#define SOC_SPARE_UNKNOWN3_BASE                                                 (0x4ae39000U)
#define SOC_L4_WKUP_TA_SPARE_UNKNOWN3_TARG_BASE                                 (0x4ae3a000U)
#define SOC_DCAN1_BASE                                                          (0x4ae3c000U)
#define SOC_DCAN1_MESSAGERAM_BASE                                               (0x4ae3d000U)
#define SOC_L4_WKUP_TA_DCAN1_TARG_BASE                                          (0x4ae3e000U)
#define SOC_SHA2MD5_1_ADDRSP0_BASE                                              (0x4b000000U)
#define SOC_SHA2MD5_1_ADDRSP1_BASE                                              (0x4b100000U)
#define SOC_PRUSS1_U_INTC_BASE                                                  (0x4b220000U)
#define SOC_PRUSS1_U_PRU0_CTRL_BASE                                             (0x4b222000U)
#define SOC_PRUSS1_U_PRU0_DEBUG_BASE                                            (0x4b222400U)
#define SOC_PRUSS1_U_PRU1_CTRL_BASE                                             (0x4b224000U)
#define SOC_PRUSS1_U_PRU1_DEBUG_BASE                                            (0x4b224400U)
#define SOC_PRUSS1_U_CFG_BASE                                                   (0x4b226000U)
#define SOC_PRUSS1_U_UART_BASE                                                  (0x4b228000U)
#define SOC_PRUSS1_U_IEP_BASE                                                   (0x4b22e000U)
#define SOC_PRUSS1_U_ECAP_BASE                                                  (0x4b230000U)
#define SOC_PRUSS1_U_MII_RT_CFG_BASE                                            (0x4b232000U)
#define SOC_PRUSS1_U_MII_MDIO_BASE                                              (0x4b232400U)
#define SOC_PRUSS2_U_INTC_BASE                                                  (0x4b2a0000U)
#define SOC_PRUSS2_U_PRU0_CTRL_BASE                                             (0x4b2a2000U)
#define SOC_PRUSS2_U_PRU0_DEBUG_BASE                                            (0x4b2a2400U)
#define SOC_PRUSS2_U_PRU1_CTRL_BASE                                             (0x4b2a4000U)
#define SOC_PRUSS2_U_PRU1_DEBUG_BASE                                            (0x4b2a4400U)
#define SOC_PRUSS2_U_CFG_BASE                                                   (0x4b2a6000U)
#define SOC_PRUSS2_U_UART_BASE                                                  (0x4b2a8000U)
#define SOC_PRUSS2_U_IEP_BASE                                                   (0x4b2ae000U)
#define SOC_PRUSS2_U_ECAP_BASE                                                  (0x4b2b0000U)
#define SOC_PRUSS2_U_MII_RT_CFG_BASE                                            (0x4b2b2000U)
#define SOC_PRUSS2_U_MII_MDIO_BASE                                              (0x4b2b2400U)
#define SOC_QSPI_ADDRSP0_BASE                                                   (0x4b300000U)
#define SOC_AES1_ADDRSP0_BASE                                                   (0x4b400000U)
#define SOC_AES1_ADDRSP1_BASE                                                   (0x4b500000U)
#define SOC_AES2_ADDRSP0_BASE                                                   (0x4b600000U)
#define SOC_AES2_ADDRSP1_BASE                                                   (0x4b700000U)
#define SOC_EMIF1_CONF_REGS_BASE                                                (0x4c000000U)
#if defined (SOC_TDA2EX) || defined (SOC_DRA72x) || defined (SOC_AM571x)
 /* Not applicable */
#else
#define SOC_EMIF2_CONF_REGS_BASE                                                (0x4d000000U)
#endif
#define SOC_DMM_CONF_REGS_BASE                                                  (0x4e000000U)
#define SOC_GPMC_CONF_REGS_BASE                                                 (0x50000000U)
#define SOC_PCIE_SS1_CONF_BASE                                                  (0x51000000U)
#define SOC_PCIE_SS2_CONF_BASE                                                  (0x51800000U)
#define SOC_PCIE_SS1_CONF_REGS_I_RC_CFG_DBICS_BASE                              (0x51000000U)
#define SOC_PCIE_SS1_CONF_REGS_I_PL_CONF_BASE                                   (0x51000700U)
#define SOC_PCIE_SS1_CONF_REGS_I_RC_CFG_DBICS2_BASE                             (0x51001000U)
#define SOC_PCIE_SS1_CONF_REGS_I_TI_CONF_BASE                                   (0x51002000U)
#define SOC_PCIE_SS2_CONF_REGS_I_RC_CFG_DBICS_BASE                              (0x51800000U)
#define SOC_PCIE_SS2_CONF_REGS_I_PL_CONF_BASE                                   (0x51800700U)
#define SOC_PCIE_SS2_CONF_REGS_I_RC_CFG_DBICS2_BASE                             (0x51801000U)
#define SOC_PCIE_SS2_CONF_REGS_I_TI_CONF_BASE                                   (0x51802000U)
#define SOC_I_CSCTI_MPU_C0_BASE                                                 (0x54148000U)
#define SOC_I_CSCTI_MPU_C1_BASE                                                 (0x54149000U)
#define SOC_I_CSTF_BASE                                                         (0x54158000U)
#define SOC_I_DAP_PC_BASE                                                       (0x54159000U)
#define SOC_I_CSSTM_BASE                                                        (0x5415ac04U)
#define SOC_I_SGU_BASE                                                          (0x5415b000U)
#define SOC_I_CSCTI_BASE                                                        (0x5415c000U)
#define SOC_I_DRM_BASE                                                          (0x54160000U)
#define SOC_I_MIPI_STM_BASE                                                     (0x54161000U)
#define SOC_I_CSTPIU_BASE                                                       (0x54163000U)
#define SOC_I_CSTF1_BASE                                                        (0x54164000U)
#define SOC_I_DEBUGSS_OMAP5430_CFGBUS_CT_TBR_BASE                               (0x54167004U)
#define SOC_CT_UART_BASE                                                        (0x54168000U)
#define SOC_CSCTI_BASE                                                          (0x54169000U)
#define SOC_OCP2SCP_BASE                                                        (0x54171000U)
#define SOC_I_DEBUGSS_OMAP5430_CFGBUS_PLLCTRL_BASE                              (0x54171800U)
#define SOC_CT_TBR_BASE                                                         (0x54800000U)
#define SOC_IPU1_ROM_BASE                                                       (0x55000000U)
#define SOC_IPU1_RAM_BASE                                                       (0x55020000U)
#define SOC_IPU1_UNICACHE_MMU_CONF_REGS_BASE                                    (0x55080000U)
#define SOC_IPU1_UNICACHE_MMU_BASE                                              (0x55080800U)
#define SOC_IPU1_WUGEN_BASE                                                     (0x55081000U)
#define SOC_IPU1_MMU_BASE                                                       (0x55082000U)
#define SOC_KLIO_BASE                                                           (0x56000000U)
#define SOC_HYDRA2_BASE                                                         (0x56004000U)
#define SOC_KLIO_0_BASE                                                         (0x56008000U)
#define SOC_KLIO_1_BASE                                                         (0x5600c000U)
#define SOC_KLIO_HL_BASE                                                        (0x5600fe00U)
#define SOC_DSS_FAMILY_BASE                                                     (0x58000000U)
#define SOC_DISPC_BASE                                                          (0x58001000U)
#define SOC_RFBI_BASE                                                           (0x58002000U)
#define SOC_DSI_PROTOCOL_ENGINE1_BASE                                           (0x58004000U)
#define SOC_DSI_PHY1_BASE                                                       (0x58004200U)
#define SOC_PLLCTRL1_BASE                                                       (0x58004300U)
#define SOC_DSI_PROTOCOL_ENGINE2_BASE                                           (0x58005000U)
#define SOC_DSI_PHY2_BASE                                                       (0x58005200U)
#define SOC_PLLCTRL2_BASE                                                       (0x58005300U)
#define SOC_DESHDCP_BASE                                                        (0x58007000U)
#define SOC_DSI_PROTOCOL_ENGINE3_BASE                                           (0x58009000U)
#define SOC_DSI_PHY3_BASE                                                       (0x58009200U)
#define SOC_PLLCTRL3_BASE                                                       (0x58009300U)
#define SOC_HDMI_WP_BASE                                                        (0x58040000U)
#define SOC_HDMI_PLLCTRL_BASE                                                   (0x58040200U)
#define SOC_HDMI_PHY_BASE                                                       (0x58040300U)
#define SOC_HDMI_DWC_TX_BASE                                                    (0x58060000U)
#define SOC_IPU1_TARGET_BASE                                                    (0x58800000U)
#define SOC_UNICACHE_MMU_BASE                                                   (0x58880800U)
#define SOC_L2_MMU_BASE                                                         (0x58882000U)
#define SOC_BB2DIP_GC320_BASE                                                   (0x59000000U)
#define SOC_IVA_CONFIG_BASE                                                     (0x5a000000U)
#define SOC_ICONT1_DMEM_BASE                                                    (0x5a000000U)
#define SOC_ICONT1_IMEM_BASE                                                    (0x5a008000U)
#define SOC_ICONT2_DMEM_BASE                                                    (0x5a010000U)
#define SOC_ICONT2_IMEM_BASE                                                    (0x5a018000U)
#define SOC_ECD3_MEM_BASE                                                       (0x5a020000U)
#define SOC_CALC3_MEM_BASE                                                      (0x5a028000U)
#define SOC_MC3_MEM_BASE                                                        (0x5a030000U)
#define SOC_IPE3_MEM_BASE                                                       (0x5a038000U)
#define SOC_ICECRUSHER1_CFG_IC968_BASE                                          (0x5a040000U)
#define SOC_CONF_BASE                                                           (0x5a041000U)
#define SOC_VDMA_CFG_BASE                                                       (0x5a050000U)
#define SOC_ILF3_CFG_BASE                                                       (0x5a052000U)
#define SOC_IME3_CFG_BASE                                                       (0x5a054000U)
#define SOC_CALC3_CFG_MMR_BASE                                                  (0x5a058000U)
#define SOC_CALC3_CFG_BFSW_BASE                                                 (0x5a058200U)
#define SOC_CALC3_CFG_LSE_BASE                                                  (0x5a058300U)
#define SOC_CALC3_CFG_IPGW_BASE                                                 (0x5a058408U)
#define SOC_IPE3_CFG_MMR_BASE                                                   (0x5a058800U)
#define SOC_IPE3_CFG_BFSW_BASE                                                  (0x5a058a00U)
#define SOC_IPE3_CFG_LSE_BASE                                                   (0x5a058b00U)
#define SOC_IPE3_CFG_IPGW_BASE                                                  (0x5a058c08U)
#define SOC_MC3_CFG_MMR_BASE                                                    (0x5a059000U)
#define SOC_MC3_CFG_BFSW_BASE                                                   (0x5a059200U)
#define SOC_MC3_CFG_LSE_BASE                                                    (0x5a059300U)
#define SOC_MC3_CFG_IPGW_BASE                                                   (0x5a059408U)
#define SOC_ECD3_CFG_MMR_BASE                                                   (0x5a059800U)
#define SOC_ECD3_CFG_BFSW_BASE                                                  (0x5a059a00U)
#define SOC_ECD3_CFG_LSE_BASE                                                   (0x5a059b00U)
#define SOC_ECD3_CFG_IPGW_BASE                                                  (0x5a059c08U)
#define SOC_SYSCTRL_BASE                                                        (0x5a05a400U)
#define SOC_MAILBOX_BASE                                                        (0x5a05a800U)
#define SOC_ICONT1_SB_SYNCBOX_BASE                                              (0x5a060000U)
#define SOC_ICONT1_MMR_CFG_BASE                                                 (0x5a070000U)
#define SOC_ICONT1_MMR_IRQ_BASE                                                 (0x5a070420U)
#define SOC_ICONT1_MMR_DM_BASE                                                  (0x5a070820U)
#define SOC_ICONT1_MMR_SBH_BASE                                                 (0x5a070c00U)
#define SOC_ICONT2_MMR_CFG_BASE                                                 (0x5a071000U)
#define SOC_ICONT2_MMR_IRQ_BASE                                                 (0x5a071420U)
#define SOC_ICONT2_MMR_DM_BASE                                                  (0x5a071820U)
#define SOC_ICONT2_MMR_SBH_BASE                                                 (0x5a071c00U)
#define SOC_SPARE_IVA2_CONFIG_BASE                                              (0x5a400000U)
#define SOC_IVA_SL2IF_BASE                                                      (0x5b000000U)
#define SOC_SL2_MEM_BASE                                                        (0x5b000000U)
#define SOC_SPARE_IVA2_SL2IF_BASE                                               (0x5b400000U)
#define SOC_QSPI_ADDRSP1_BASE                                                   (0x5c000000U)
#define SOC_TILER_BASE                                                          (0x60000000U)
#define SOC_EMIF1_BASE                                                          (0x80000000U)
#if defined (SOC_TDA2EX) || defined (SOC_DRA72x) || defined (SOC_AM571x)
 /* Not applicable */
#else
#define SOC_EMIF2_BASE                                                          (0x80000000U)
#endif
#define SOC_IPU1_C0_DWT_BASE                                                    (0xe0001000U)
#define SOC_IPU1_C1_DWT_BASE                                                    (0xe0001000U)
#define SOC_IPU1_C1_FPB_BASE                                                    (0xe0002000U)
#define SOC_IPU1_C0_FPB_BASE                                                    (0xe0002000U)
#define SOC_IPU1_C0_INTC_BASE                                                   (0xe000e000U)
#define SOC_IPU1_C1_INTC_BASE                                                   (0xe000e004U)
#define SOC_IPU1_C0_ICECRUSHER_BASE                                             (0xe0042000U)
#define SOC_IPU1_C1_ICECRUSHER_BASE                                             (0xe0042000U)
#define SOC_IPU1_C0_RW_TABLE_BASE                                               (0xe00fe000U)
#define SOC_IPU1_C1_RW_TABLE_BASE                                               (0xe00fe000U)
#define SOC_IPU1_C0_ROM_TABLE_BASE                                              (0xe00ff000U)
#define SOC_IPU1_C1_ROM_TABLE_BASE                                              (0xe00ff000U)

/* Alias definitions required to reuse higher layer code across SoCs */
#define CSL_IPU_IPU1_UNICACHE_MMU_CONF_REGS_REGS                                (SOC_IPU1_UNICACHE_MMU_CONF_REGS_BASE)

#ifdef __cplusplus
}
#endif
#endif /* SOC_H_ */
