//---------------------------------------------------------------------------------------------------------------------
// Copyright IEOS Ltd. 2010-2018 Moscow, Russian Federation  (www.ieos.ru)
//    Alexander Norokh 2017-2018
//---------------------------------------------------------------------------------------------------------------------
// File containing the VPS capture driver APIs.
//---------------------------------------------------------------------------------------------------------------------
#include <stdint.h>
#include <stddef.h>
#include "tistdtypes.h"
#include "vps_common.h"
#include "bsp_utils.h"

#ifdef VPS_VIP_BUILD
#include "vps_vipDrv.h"
#endif

#include "vps_dssDrv.h"
#include "vps_dctrlDrv.h"
//---------------------------------------------------------------------------------------------------------------------
extern UInt32 gDssDrvInit;


#ifdef VPS_VIP_BUILD
extern const VpsDrv_VipPlatformData *VpsDrv_getVipPlatformData(void);
#endif

extern const VpsDrv_DssPlatformData *VpsDrv_getDssPlatformData(void);

#ifdef VPS_VIP_BUILD
extern Int32 VpsDrv_captInit(UInt32                       numInst,
                             const VpsDrv_CaptInitParams *initPrms);
extern Int32 VpsDrv_captDeInit(void);
#endif

extern Int32 VpsDrv_dssInit(UInt32                       numInst, const VpsDrv_DispInitParams *initPrms);
extern Int32 VpsDrv_dssDeInit(void);
//---------------------------------------------------------------------------------------------------------------------
/**
 *  Vps_init
 *  \brief Initializes all HAL/CORE/DRIVER SW modules for VPS starterware
 *
 *  \param none
 *
 *  \return                   success    0
 *                            failure    error value
 *
 */
Int32 Vps_init2(Ptr args)
{
#ifdef VPS_VIP_BUILD
    VpsDrv_CaptInitParams         captDrvInitPrms[VPS_CAPT_VIP_INST_MAX];
    const VpsDrv_VipPlatformData *drvVipPlatData;
#endif

    VpsDrv_DispInitParams         dssDrvInitPrms[VPS_DISP_INST_MAX];
    VpsDrv_DctrlInitParams        dctrlDrvInitPrms;
    const VpsDrv_DssPlatformData *drvDssPlatData;

    UInt32 instCnt;
    Int32 retVal;

    const VpsLib_PlatformData    *libPlatData;

    retVal = VpsLib_init(NULL);

    gDssDrvInit = 1U;
    dctrlDrvInitPrms.coreInstObj = VpsLib_getDctrlCoreInstObj();
    dctrlDrvInitPrms.coreOps     = VpsCore_dctrlGetCoreOps();
    VpsDrv_dctrlInit(&dctrlDrvInitPrms);

    if (BSP_SOK == retVal)
    {
        /* Get Platform data */
        libPlatData = VpsLib_getPlatformData();

        drvDssPlatData = VpsDrv_getDssPlatformData();
        for (instCnt = 0U; instCnt < libPlatData->hal->numVidPipe; instCnt++)
        {
            dssDrvInitPrms[instCnt].drvInstId =
                drvDssPlatData->DispDrvInitPrms[instCnt].drvInstId;
            dssDrvInitPrms[instCnt].coreInstObj = VpsLib_getDssCoreInstObj();
            dssDrvInitPrms[instCnt].coreOps     = VpsCore_dssGetCoreOps();
        }

        /* Call display init only if required */
        if (libPlatData->hal->numVidPipe > 0U)
        {
            retVal = VpsDrv_dssInit(libPlatData->hal->numVidPipe,
                                    &dssDrvInitPrms[0U]);
        }
    }

    return retVal;
}
//---------------------------------------------------------------------------------------------------------------------
/**
 *  Vps_deInit
 *  \brief Initializes all HAL/CORE/DRIVER SW modules for VPS starterware
 *
 *  \param none
 *
 *  \return                   success    0
 *                            failure    error value
 *
 */
Int32 Vps_deInit2(Ptr args)
{
    Int32 retVal = BSP_SOK;

#ifdef VPS_VIP_BUILD
    retVal = VpsDrv_captDeInit();
#endif

    retVal     += VpsDrv_dssDeInit();
    retVal     += VpsDrv_dctrlDeInit();
    gDssDrvInit = 0;

    retVal += VpsLib_deInit(NULL);

    return retVal;
}

