
/**
 *  \file bsp_common.c
 *
 *  \brief Interface file to the common utility function.
 *
 */

#include <string.h>
#include "tistdtypes.h"
#include "bsp_types.h"
#include "trace.h"
#include "bsp_config.h"
#include "bsp_common.h"
#include "bsp_commonPriv.h"

Int32 Bsp_commonInit(const Bsp_CommonInitParams *initPrms)
{
    Int32 retVal = BSP_SOK;

    if (NULL == initPrms)
    {
        GT_0trace(BspUtilsTrace, GT_ERR, "NULL init params!!\r\n");
        retVal = BSP_EBADARGS;
    }
    else
    {
        retVal = BspUtils_init();
    }

    return (retVal);
}

Int32 Bsp_commonDeInit(Ptr args)
{
    Int32 retVal = BSP_SOK;

    retVal = BspUtils_deInit(NULL);

    return (retVal);
}

/**
 *  Bsp_getVersionString
 *  \brief Get the BSP package version in string form. This API can be
 *  called before calling #Bsp_commonInit().
 *
 *  \return             Returns pointer to BSP version string.
 */
const Char *Bsp_getVersionString(void)
{
    return (BSP_VERSION_STRING);
}

/**
 *  Bsp_getVersionNumber
 *  \brief Get the BSP package version in number form. This API can be
 *  called before calling #Bsp_commonInit().
 *
 *  \return             BSP version number.
 */
UInt32 Bsp_getVersionNumber(void)
{
    return (BSP_VERSION_NUMBER);
}

