//---------------------------------------------------------------------------------------------------------------------
// Copyright IEOS Ltd. 2010-2018 Moscow, Russian Federation  (www.ieos.ru)
//    Alexander Norokh 2017-2018
//---------------------------------------------------------------------------------------------------------------------
// This is the main Header File for the GPIO Module which defines all
// the data structures and exported API.
//---------------------------------------------------------------------------------------------------------------------
#ifndef CSL_GPIO_H
#define CSL_GPIO_H

#ifdef __cplusplus
extern "C" {
#endif

#include "soc.h"
#include "csl.h"
#include "cslr_gpio.h"

/** @defgroup CSL_GPIO_API GPIO
 *
 * @section Introduction
 *
 * @subsection 
 *  None
 *
 * @subsection References
 *  None
 *
 */

/**
@defgroup CSL_GPIO_DATASTRUCT  GPIO Data structures
@ingroup  CSL_GPIO_API
*/

/**
@defgroup CSL_GPIO_FUNCTION  GPIO Functions
@ingroup  CSL_GPIO_API
*/

/**
@addtogroup CSL_GPIO_DATASTRUCT  
@{
*/

/** @brief This is the handle to the GPIO instance */
typedef volatile CSL_GpioRegs*   CSL_GpioHandle;

/**
@}
*/

/* Device specific API which opens the GPIO instance and returns a handle used in all subsequent calls */
extern CSL_GpioHandle CSL_GPIO_open (Int32 instNum);
        
#ifdef __cplusplus
}
#endif

#endif /* CSL_GPIO_H */



