/*
 *  Copyright (C) 2013 Texas Instruments Incorporated - http://www.ti.com/
 *
 *  Redistribution and use in source and binary forms, with or without
 *  modification, are permitted provided that the following conditions
 *  are met:
 *
 *    Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 *    Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the
 *    distribution.
 *
 *    Neither the name of Texas Instruments Incorporated nor the names of
 *    its contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
*/

/**
 *  \file   hw_l4per_cm_core.h
 *
 *  \brief  Register-level header file for PRCM
 *
**/

#ifndef HW_L4PER_CM_CORE_H_
#define HW_L4PER_CM_CORE_H_

#ifdef __cplusplus
extern "C"
{
#endif


/****************************************************************************************************
* Register Definitions
****************************************************************************************************/

#define CM_L4PER_CLKSTCTRL                                     (0x0U)
#define CM_L4PER_DYNAMICDEP                                    (0x8U)
#define CM_L4PER2_L4_PER2_CLKCTRL                              (0xcU)
#define CM_L4PER3_L4_PER3_CLKCTRL                              (0x14U)
#define CM_L4PER_DCC6_CLKCTRL                                  (0x28U)
#define CM_L4PER_DCC7_CLKCTRL                                  (0x30U)
#define CM_L4PER_TIMER2_CLKCTRL                                (0x38U)
#define CM_L4PER_TIMER3_CLKCTRL                                (0x40U)
#define CM_L4PER_TIMER4_CLKCTRL                                (0x48U)
#define CM_L4PER_DCC5_CLKCTRL                                  (0x50U)
#define CM_L4PER_ELM_CLKCTRL                                   (0x58U)
#define CM_L4PER_GPIO2_CLKCTRL                                 (0x60U)
#define CM_L4PER_GPIO3_CLKCTRL                                 (0x68U)
#define CM_L4PER_GPIO4_CLKCTRL                                 (0x70U)
#define CM_L4PER_ESM_CLKCTRL                                   (0x88U)
#define CM_L4PER_I2C1_CLKCTRL                                  (0xa0U)
#define CM_L4PER_I2C2_CLKCTRL                                  (0xa8U)
#define CM_L4PER_L4_PER1_CLKCTRL                               (0xc0U)
#define CM_L4PER2_PWMSS1_CLKCTRL                               (0xc4U)
#define CM_L4PER3_DCC1_CLKCTRL                                 (0xc8U)
#define CM_L4PER3_DCC2_CLKCTRL                                 (0xd0U)
#define CM_L4PER3_DCC3_CLKCTRL                                 (0xd8U)
#define CM_L4PER_MCSPI1_CLKCTRL                                (0xf0U)
#define CM_L4PER_MCSPI2_CLKCTRL                                (0xf8U)
#define CM_L4PER_MCSPI3_CLKCTRL                                (0x100U)
#define CM_L4PER_MCSPI4_CLKCTRL                                (0x108U)
#define CM_L4PER_MMC4_CLKCTRL                                  (0x128U)
#define CM_L4PER3_DCC4_CLKCTRL                                 (0x130U)
#define CM_L4PER2_QSPI_CLKCTRL                                 (0x138U)
#define CM_L4PER_UART1_CLKCTRL                                 (0x140U)
#define CM_L4PER_UART2_CLKCTRL                                 (0x148U)
#define CM_L4PER_UART3_CLKCTRL                                 (0x150U)
#define CM_L4PER2_ADC_CLKCTRL                                  (0x160U)
#define CM_L4PER2_ATL_CLKCTRL                                  (0x168U)
#define CM_L4PER2_MCASP5_CLKCTRL                               (0x178U)
#define CM_L4SEC_CLKSTCTRL                                     (0x180U)
#define CM_L4SEC_STATICDEP                                     (0x184U)
#define CM_L4SEC_DYNAMICDEP                                    (0x188U)
#define CM_L4PER2_MCASP4_CLKCTRL                               (0x198U)
#define CM_L4SEC_DMA_CRYPTO_CLKCTRL                            (0x1d8U)
#define CM_L4PER2_DCAN2_CLKCTRL                                (0x1f0U)
#define CM_L4PER2_CLKSTCTRL                                    (0x1fcU)
#define CM_L4PER2_DYNAMICDEP                                   (0x200U)
#define CM_L4PER2_MCASP6_CLKCTRL                               (0x204U)
#define CM_L4PER2_MCASP7_CLKCTRL                               (0x208U)
#define CM_L4PER2_STATICDEP                                    (0x20cU)
#define CM_L4PER3_CLKSTCTRL                                    (0x210U)
#define CM_L4PER3_DYNAMICDEP                                   (0x214U)

/****************************************************************************************************
* Field Definition Macros
****************************************************************************************************/

#define CM_L4PER_CLKSTCTRL_CLKTRCTRL_SHIFT                                              (0U)
#define CM_L4PER_CLKSTCTRL_CLKTRCTRL_MASK                                               (0x00000003U)
#define CM_L4PER_CLKSTCTRL_CLKTRCTRL_NO_SLEEP                                            (0U)
#define CM_L4PER_CLKSTCTRL_CLKTRCTRL_SW_SLEEP                                            (1U)
#define CM_L4PER_CLKSTCTRL_CLKTRCTRL_SW_WKUP                                             (2U)
#define CM_L4PER_CLKSTCTRL_CLKTRCTRL_HW_AUTO                                             (3U)

#define CM_L4PER_CLKSTCTRL_CLKACTIVITY_TIMER2_GFCLK_SHIFT                               (11U)
#define CM_L4PER_CLKSTCTRL_CLKACTIVITY_TIMER2_GFCLK_MASK                                (0x00000800U)
#define CM_L4PER_CLKSTCTRL_CLKACTIVITY_TIMER2_GFCLK_INACT                                (0U)
#define CM_L4PER_CLKSTCTRL_CLKACTIVITY_TIMER2_GFCLK_ACT                                  (1U)

#define CM_L4PER_CLKSTCTRL_CLKACTIVITY_TIMER3_GFCLK_SHIFT                               (12U)
#define CM_L4PER_CLKSTCTRL_CLKACTIVITY_TIMER3_GFCLK_MASK                                (0x00001000U)
#define CM_L4PER_CLKSTCTRL_CLKACTIVITY_TIMER3_GFCLK_INACT                                (0U)
#define CM_L4PER_CLKSTCTRL_CLKACTIVITY_TIMER3_GFCLK_ACT                                  (1U)

#define CM_L4PER_CLKSTCTRL_CLKACTIVITY_TIMER4_GFCLK_SHIFT                               (13U)
#define CM_L4PER_CLKSTCTRL_CLKACTIVITY_TIMER4_GFCLK_MASK                                (0x00002000U)
#define CM_L4PER_CLKSTCTRL_CLKACTIVITY_TIMER4_GFCLK_INACT                                (0U)
#define CM_L4PER_CLKSTCTRL_CLKACTIVITY_TIMER4_GFCLK_ACT                                  (1U)

#define CM_L4PER_CLKSTCTRL_CLKACTIVITY_PER_48M_GFCLK_SHIFT                              (20U)
#define CM_L4PER_CLKSTCTRL_CLKACTIVITY_PER_48M_GFCLK_MASK                               (0x00100000U)
#define CM_L4PER_CLKSTCTRL_CLKACTIVITY_PER_48M_GFCLK_INACT                               (0U)
#define CM_L4PER_CLKSTCTRL_CLKACTIVITY_PER_48M_GFCLK_ACT                                 (1U)

#define CM_L4PER_CLKSTCTRL_CLKACTIVITY_UART1_GFCLK_SHIFT                                (15U)
#define CM_L4PER_CLKSTCTRL_CLKACTIVITY_UART1_GFCLK_MASK                                 (0x00008000U)
#define CM_L4PER_CLKSTCTRL_CLKACTIVITY_UART1_GFCLK_INACT                                 (0U)
#define CM_L4PER_CLKSTCTRL_CLKACTIVITY_UART1_GFCLK_ACT                                   (1U)

#define CM_L4PER_CLKSTCTRL_CLKACTIVITY_UART2_GFCLK_SHIFT                                (16U)
#define CM_L4PER_CLKSTCTRL_CLKACTIVITY_UART2_GFCLK_MASK                                 (0x00010000U)
#define CM_L4PER_CLKSTCTRL_CLKACTIVITY_UART2_GFCLK_INACT                                 (0U)
#define CM_L4PER_CLKSTCTRL_CLKACTIVITY_UART2_GFCLK_ACT                                   (1U)

#define CM_L4PER_CLKSTCTRL_CLKACTIVITY_UART3_GFCLK_SHIFT                                (17U)
#define CM_L4PER_CLKSTCTRL_CLKACTIVITY_UART3_GFCLK_MASK                                 (0x00020000U)
#define CM_L4PER_CLKSTCTRL_CLKACTIVITY_UART3_GFCLK_INACT                                 (0U)
#define CM_L4PER_CLKSTCTRL_CLKACTIVITY_UART3_GFCLK_ACT                                   (1U)

#define CM_L4PER_CLKSTCTRL_CLKACTIVITY_MMC4_GFCLK_SHIFT                                 (23U)
#define CM_L4PER_CLKSTCTRL_CLKACTIVITY_MMC4_GFCLK_MASK                                  (0x00800000U)
#define CM_L4PER_CLKSTCTRL_CLKACTIVITY_MMC4_GFCLK_INACT                                  (0U)
#define CM_L4PER_CLKSTCTRL_CLKACTIVITY_MMC4_GFCLK_ACT                                    (1U)

#define CM_L4PER_CLKSTCTRL_CLKACTIVITY_PER_96M_GFCLK_SHIFT                              (21U)
#define CM_L4PER_CLKSTCTRL_CLKACTIVITY_PER_96M_GFCLK_MASK                               (0x00200000U)
#define CM_L4PER_CLKSTCTRL_CLKACTIVITY_PER_96M_GFCLK_INACT                               (0U)
#define CM_L4PER_CLKSTCTRL_CLKACTIVITY_PER_96M_GFCLK_ACT                                 (1U)

#define CM_L4PER_CLKSTCTRL_CLKACTIVITY_GPIO_GFCLK_SHIFT                                 (24U)
#define CM_L4PER_CLKSTCTRL_CLKACTIVITY_GPIO_GFCLK_MASK                                  (0x01000000U)
#define CM_L4PER_CLKSTCTRL_CLKACTIVITY_GPIO_GFCLK_INACT                                  (0U)
#define CM_L4PER_CLKSTCTRL_CLKACTIVITY_GPIO_GFCLK_ACT                                    (1U)

#define CM_L4PER_CLKSTCTRL_CLKACTIVITY_PER_192M_GFCLK_SHIFT                             (25U)
#define CM_L4PER_CLKSTCTRL_CLKACTIVITY_PER_192M_GFCLK_MASK                              (0x02000000U)
#define CM_L4PER_CLKSTCTRL_CLKACTIVITY_PER_192M_GFCLK_INACT                              (0U)
#define CM_L4PER_CLKSTCTRL_CLKACTIVITY_PER_192M_GFCLK_ACT                                (1U)

#define CM_L4PER_CLKSTCTRL_CLKACTIVITY_L4PER_L3_GICLK_SHIFT                                                 (8U)
#define CM_L4PER_CLKSTCTRL_CLKACTIVITY_L4PER_L3_GICLK_MASK                                                  (0x00000100U)
#define CM_L4PER_CLKSTCTRL_CLKACTIVITY_L4PER_L3_GICLK_INACT                                                  (0U)
#define CM_L4PER_CLKSTCTRL_CLKACTIVITY_L4PER_L3_GICLK_ACT                                                    (1U)

#define CM_L4PER_CLKSTCTRL_CLKACTIVITY_L4PER_32K_GFCLK_SHIFT                                                (27U)
#define CM_L4PER_CLKSTCTRL_CLKACTIVITY_L4PER_32K_GFCLK_MASK                                                 (0x08000000U)
#define CM_L4PER_CLKSTCTRL_CLKACTIVITY_L4PER_32K_GFCLK_INACT                                                 (0U)
#define CM_L4PER_CLKSTCTRL_CLKACTIVITY_L4PER_32K_GFCLK_ACT                                                   (1U)

#define CM_L4PER_DYNAMICDEP_L3INIT_DYNDEP_SHIFT                                         (7U)
#define CM_L4PER_DYNAMICDEP_L3INIT_DYNDEP_MASK                                          (0x00000080U)
#define CM_L4PER_DYNAMICDEP_L3INIT_DYNDEP_ENABLED                                        (1U)

#define CM_L4PER_DYNAMICDEP_DSS_DYNDEP_SHIFT                                            (8U)
#define CM_L4PER_DYNAMICDEP_DSS_DYNDEP_MASK                                             (0x00000100U)
#define CM_L4PER_DYNAMICDEP_DSS_DYNDEP_ENABLED                                           (1U)

#define CM_L4PER_DYNAMICDEP_L4SEC_DYNDEP_SHIFT                                          (14U)
#define CM_L4PER_DYNAMICDEP_L4SEC_DYNDEP_MASK                                           (0x00004000U)
#define CM_L4PER_DYNAMICDEP_L4SEC_DYNDEP_ENABLED                                         (1U)

#define CM_L4PER_DYNAMICDEP_WINDOWSIZE_SHIFT                                            (24U)
#define CM_L4PER_DYNAMICDEP_WINDOWSIZE_MASK                                             (0x0f000000U)

#define CM_L4PER_DYNAMICDEP_IPU_DYNDEP_SHIFT                                            (3U)
#define CM_L4PER_DYNAMICDEP_IPU_DYNDEP_MASK                                             (0x00000008U)
#define CM_L4PER_DYNAMICDEP_IPU_DYNDEP_ENABLED                                           (1U)

#define CM_L4PER2_L4_PER2_CLKCTRL_MODULEMODE_SHIFT                                 (0U)
#define CM_L4PER2_L4_PER2_CLKCTRL_MODULEMODE_MASK                                  (0x00000003U)
#define CM_L4PER2_L4_PER2_CLKCTRL_MODULEMODE_AUTO                                   (1U)

#define CM_L4PER2_L4_PER2_CLKCTRL_IDLEST_SHIFT                                     (16U)
#define CM_L4PER2_L4_PER2_CLKCTRL_IDLEST_MASK                                      (0x00030000U)
#define CM_L4PER2_L4_PER2_CLKCTRL_IDLEST_DISABLE                                    (3U)
#define CM_L4PER2_L4_PER2_CLKCTRL_IDLEST_IDLE                                       (2U)
#define CM_L4PER2_L4_PER2_CLKCTRL_IDLEST_FUNC                                       (0U)
#define CM_L4PER2_L4_PER2_CLKCTRL_IDLEST_TRANS                                      (1U)

#define CM_L4PER3_L4_PER3_CLKCTRL_MODULEMODE_SHIFT                                 (0U)
#define CM_L4PER3_L4_PER3_CLKCTRL_MODULEMODE_MASK                                  (0x00000003U)
#define CM_L4PER3_L4_PER3_CLKCTRL_MODULEMODE_AUTO                                   (1U)

#define CM_L4PER3_L4_PER3_CLKCTRL_IDLEST_SHIFT                                     (16U)
#define CM_L4PER3_L4_PER3_CLKCTRL_IDLEST_MASK                                      (0x00030000U)
#define CM_L4PER3_L4_PER3_CLKCTRL_IDLEST_DISABLE                                    (3U)
#define CM_L4PER3_L4_PER3_CLKCTRL_IDLEST_IDLE                                       (2U)
#define CM_L4PER3_L4_PER3_CLKCTRL_IDLEST_FUNC                                       (0U)
#define CM_L4PER3_L4_PER3_CLKCTRL_IDLEST_TRANS                                      (1U)

#define CM_L4PER_DCC6_CLKCTRL_CLKSEL_SHIFT                                              (24U)
#define CM_L4PER_DCC6_CLKCTRL_CLKSEL_MASK                                               (0x0f000000U)
#define CM_L4PER_DCC6_CLKCTRL_CLKSEL_SEL_TIMER_SYS_CLK                                   (0U)
#define CM_L4PER_DCC6_CLKCTRL_CLKSEL_SEL_SYS_CLK1_32K_CLK                                (1U)
#define CM_L4PER_DCC6_CLKCTRL_CLKSEL_SEL_SYS_CLK2                                        (2U)
#define CM_L4PER_DCC6_CLKCTRL_CLKSEL_SEL_XREF_CLK0                                       (3U)
#define CM_L4PER_DCC6_CLKCTRL_CLKSEL_SEL_XREF_CLK1                                       (4U)
#define CM_L4PER_DCC6_CLKCTRL_CLKSEL_SEL_XREF_CLK2                                       (5U)
#define CM_L4PER_DCC6_CLKCTRL_CLKSEL_SEL_XREF_CLK3                                       (6U)
#define CM_L4PER_DCC6_CLKCTRL_CLKSEL_SEL_ABE_GICLK                                       (7U)
#define CM_L4PER_DCC6_CLKCTRL_CLKSEL_SEL_VIDEO1_CLK                                      (8U)
#define CM_L4PER_DCC6_CLKCTRL_CLKSEL_SEL_VIDEO2_CLK                                      (9U)
#define CM_L4PER_DCC6_CLKCTRL_CLKSEL_SEL_HDMI_CLK                                        (10U)
#define CM_L4PER_DCC6_CLKCTRL_CLKSEL_RESERVED                                            (11U)
#define CM_L4PER_DCC6_CLKCTRL_CLKSEL_RESERVED1                                           (12U)
#define CM_L4PER_DCC6_CLKCTRL_CLKSEL_RESERVED2                                           (13U)
#define CM_L4PER_DCC6_CLKCTRL_CLKSEL_RESERVED3                                           (14U)
#define CM_L4PER_DCC6_CLKCTRL_CLKSEL_RESERVED4                                           (15U)

#define CM_L4PER_DCC6_CLKCTRL_IDLEST_SHIFT                                              (16U)
#define CM_L4PER_DCC6_CLKCTRL_IDLEST_MASK                                               (0x00030000U)
#define CM_L4PER_DCC6_CLKCTRL_IDLEST_DISABLE                                             (3U)
#define CM_L4PER_DCC6_CLKCTRL_IDLEST_IDLE                                                (2U)
#define CM_L4PER_DCC6_CLKCTRL_IDLEST_FUNC                                                (0U)
#define CM_L4PER_DCC6_CLKCTRL_IDLEST_TRANS                                               (1U)

#define CM_L4PER_DCC6_CLKCTRL_MODULEMODE_SHIFT                                          (0U)
#define CM_L4PER_DCC6_CLKCTRL_MODULEMODE_MASK                                           (0x00000003U)
#define CM_L4PER_DCC6_CLKCTRL_MODULEMODE_DISABLED                                        (0U)
#define CM_L4PER_DCC6_CLKCTRL_MODULEMODE_RESERVED_1                                      (1U)
#define CM_L4PER_DCC6_CLKCTRL_MODULEMODE_ENABLE                                          (2U)
#define CM_L4PER_DCC6_CLKCTRL_MODULEMODE_RESERVED                                        (3U)

#define CM_L4PER_DCC7_CLKCTRL_IDLEST_SHIFT                                              (16U)
#define CM_L4PER_DCC7_CLKCTRL_IDLEST_MASK                                               (0x00030000U)
#define CM_L4PER_DCC7_CLKCTRL_IDLEST_DISABLE                                             (3U)
#define CM_L4PER_DCC7_CLKCTRL_IDLEST_IDLE                                                (2U)
#define CM_L4PER_DCC7_CLKCTRL_IDLEST_FUNC                                                (0U)
#define CM_L4PER_DCC7_CLKCTRL_IDLEST_TRANS                                               (1U)

#define CM_L4PER_DCC7_CLKCTRL_MODULEMODE_SHIFT                                          (0U)
#define CM_L4PER_DCC7_CLKCTRL_MODULEMODE_MASK                                           (0x00000003U)
#define CM_L4PER_DCC7_CLKCTRL_MODULEMODE_DISABLED                                        (0U)
#define CM_L4PER_DCC7_CLKCTRL_MODULEMODE_RESERVED_1                                      (1U)
#define CM_L4PER_DCC7_CLKCTRL_MODULEMODE_ENABLE                                          (2U)
#define CM_L4PER_DCC7_CLKCTRL_MODULEMODE_RESERVED                                        (3U)

#define CM_L4PER_DCC7_CLKCTRL_CLKSEL_SHIFT                                              (24U)
#define CM_L4PER_DCC7_CLKCTRL_CLKSEL_MASK                                               (0x0f000000U)
#define CM_L4PER_DCC7_CLKCTRL_CLKSEL_SEL_TIMER_SYS_CLK                                   (0U)
#define CM_L4PER_DCC7_CLKCTRL_CLKSEL_SEL_SYS_CLK1_32K_CLK                                (1U)
#define CM_L4PER_DCC7_CLKCTRL_CLKSEL_SEL_SYS_CLK2                                        (2U)
#define CM_L4PER_DCC7_CLKCTRL_CLKSEL_SEL_XREF_CLK0                                       (3U)
#define CM_L4PER_DCC7_CLKCTRL_CLKSEL_SEL_XREF_CLK1                                       (4U)
#define CM_L4PER_DCC7_CLKCTRL_CLKSEL_SEL_XREF_CLK2                                       (5U)
#define CM_L4PER_DCC7_CLKCTRL_CLKSEL_SEL_XREF_CLK3                                       (6U)
#define CM_L4PER_DCC7_CLKCTRL_CLKSEL_SEL_ABE_GICLK                                       (7U)
#define CM_L4PER_DCC7_CLKCTRL_CLKSEL_SEL_VIDEO1_CLK                                      (8U)
#define CM_L4PER_DCC7_CLKCTRL_CLKSEL_SEL_VIDEO2_CLK                                      (9U)
#define CM_L4PER_DCC7_CLKCTRL_CLKSEL_SEL_HDMI_CLK                                        (10U)
#define CM_L4PER_DCC7_CLKCTRL_CLKSEL_RESERVED                                            (11U)
#define CM_L4PER_DCC7_CLKCTRL_CLKSEL_RESERVED1                                           (12U)
#define CM_L4PER_DCC7_CLKCTRL_CLKSEL_RESERVED2                                           (13U)
#define CM_L4PER_DCC7_CLKCTRL_CLKSEL_RESERVED3                                           (14U)
#define CM_L4PER_DCC7_CLKCTRL_CLKSEL_RESERVED4                                           (15U)

#define CM_L4PER_TIMER2_CLKCTRL_IDLEST_SHIFT                                       (16U)
#define CM_L4PER_TIMER2_CLKCTRL_IDLEST_MASK                                        (0x00030000U)
#define CM_L4PER_TIMER2_CLKCTRL_IDLEST_DISABLE                                      (3U)
#define CM_L4PER_TIMER2_CLKCTRL_IDLEST_IDLE                                         (2U)
#define CM_L4PER_TIMER2_CLKCTRL_IDLEST_FUNC                                         (0U)
#define CM_L4PER_TIMER2_CLKCTRL_IDLEST_TRANS                                        (1U)

#define CM_L4PER_TIMER2_CLKCTRL_MODULEMODE_SHIFT                                   (0U)
#define CM_L4PER_TIMER2_CLKCTRL_MODULEMODE_MASK                                    (0x00000003U)
#define CM_L4PER_TIMER2_CLKCTRL_MODULEMODE_DISABLED                                 (0U)
#define CM_L4PER_TIMER2_CLKCTRL_MODULEMODE_RESERVED_1                               (1U)
#define CM_L4PER_TIMER2_CLKCTRL_MODULEMODE_ENABLE                                   (2U)
#define CM_L4PER_TIMER2_CLKCTRL_MODULEMODE_RESERVED                                 (3U)

#define CM_L4PER_TIMER2_CLKCTRL_CLKSEL_SHIFT                                       (24U)
#define CM_L4PER_TIMER2_CLKCTRL_CLKSEL_MASK                                        (0x0f000000U)
#define CM_L4PER_TIMER2_CLKCTRL_CLKSEL_SEL_TIMER_SYS_CLK                            (0U)
#define CM_L4PER_TIMER2_CLKCTRL_CLKSEL_SEL_SYS_CLK1_32K_CLK                         (1U)
#define CM_L4PER_TIMER2_CLKCTRL_CLKSEL_SEL_SYS_CLK2                                 (2U)
#define CM_L4PER_TIMER2_CLKCTRL_CLKSEL_SEL_XREF_CLK0                                (3U)
#define CM_L4PER_TIMER2_CLKCTRL_CLKSEL_SEL_XREF_CLK1                                (4U)
#define CM_L4PER_TIMER2_CLKCTRL_CLKSEL_SEL_XREF_CLK2                                (5U)
#define CM_L4PER_TIMER2_CLKCTRL_CLKSEL_SEL_XREF_CLK3                                (6U)
#define CM_L4PER_TIMER2_CLKCTRL_CLKSEL_SEL_ABE_GICLK                                                         (7U)
#define CM_L4PER_TIMER2_CLKCTRL_CLKSEL_SEL_VIDEO1_CLK                               (8U)
#define CM_L4PER_TIMER2_CLKCTRL_CLKSEL_SEL_VIDEO2_CLK                               (9U)
#define CM_L4PER_TIMER2_CLKCTRL_CLKSEL_SEL_HDMI_CLK                                 (10U)
#define CM_L4PER_TIMER2_CLKCTRL_CLKSEL_RESERVED                                     (11U)
#define CM_L4PER_TIMER2_CLKCTRL_CLKSEL_RESERVED1                                    (12U)
#define CM_L4PER_TIMER2_CLKCTRL_CLKSEL_RESERVED2                                    (13U)
#define CM_L4PER_TIMER2_CLKCTRL_CLKSEL_RESERVED3                                    (14U)
#define CM_L4PER_TIMER2_CLKCTRL_CLKSEL_RESERVED4                                    (15U)

#define CM_L4PER_TIMER3_CLKCTRL_IDLEST_SHIFT                                       (16U)
#define CM_L4PER_TIMER3_CLKCTRL_IDLEST_MASK                                        (0x00030000U)
#define CM_L4PER_TIMER3_CLKCTRL_IDLEST_DISABLE                                      (3U)
#define CM_L4PER_TIMER3_CLKCTRL_IDLEST_IDLE                                         (2U)
#define CM_L4PER_TIMER3_CLKCTRL_IDLEST_FUNC                                         (0U)
#define CM_L4PER_TIMER3_CLKCTRL_IDLEST_TRANS                                        (1U)

#define CM_L4PER_TIMER3_CLKCTRL_MODULEMODE_SHIFT                                   (0U)
#define CM_L4PER_TIMER3_CLKCTRL_MODULEMODE_MASK                                    (0x00000003U)
#define CM_L4PER_TIMER3_CLKCTRL_MODULEMODE_DISABLED                                 (0U)
#define CM_L4PER_TIMER3_CLKCTRL_MODULEMODE_RESERVED_1                               (1U)
#define CM_L4PER_TIMER3_CLKCTRL_MODULEMODE_ENABLE                                   (2U)
#define CM_L4PER_TIMER3_CLKCTRL_MODULEMODE_RESERVED                                 (3U)

#define CM_L4PER_TIMER3_CLKCTRL_CLKSEL_SHIFT                                       (24U)
#define CM_L4PER_TIMER3_CLKCTRL_CLKSEL_MASK                                        (0x0f000000U)
#define CM_L4PER_TIMER3_CLKCTRL_CLKSEL_SEL_TIMER_SYS_CLK                            (0U)
#define CM_L4PER_TIMER3_CLKCTRL_CLKSEL_SEL_SYS_CLK1_32K_CLK                         (1U)
#define CM_L4PER_TIMER3_CLKCTRL_CLKSEL_SEL_SYS_CLK2                                 (2U)
#define CM_L4PER_TIMER3_CLKCTRL_CLKSEL_SEL_XREF_CLK0                                (3U)
#define CM_L4PER_TIMER3_CLKCTRL_CLKSEL_SEL_XREF_CLK1                                (4U)
#define CM_L4PER_TIMER3_CLKCTRL_CLKSEL_SEL_XREF_CLK2                                (5U)
#define CM_L4PER_TIMER3_CLKCTRL_CLKSEL_SEL_XREF_CLK3                                (6U)
#define CM_L4PER_TIMER3_CLKCTRL_CLKSEL_SEL_PER_ABE_X1_GFCLK                         (7U)
#define CM_L4PER_TIMER3_CLKCTRL_CLKSEL_SEL_VIDEO1_CLK                               (8U)
#define CM_L4PER_TIMER3_CLKCTRL_CLKSEL_SEL_VIDEO2_CLK                               (9U)
#define CM_L4PER_TIMER3_CLKCTRL_CLKSEL_SEL_HDMI_CLK                                 (10U)
#define CM_L4PER_TIMER3_CLKCTRL_CLKSEL_RESERVED                                     (11U)
#define CM_L4PER_TIMER3_CLKCTRL_CLKSEL_RESERVED1                                    (12U)
#define CM_L4PER_TIMER3_CLKCTRL_CLKSEL_RESERVED2                                    (13U)
#define CM_L4PER_TIMER3_CLKCTRL_CLKSEL_RESERVED3                                    (14U)
#define CM_L4PER_TIMER3_CLKCTRL_CLKSEL_RESERVED4                                    (15U)

#define CM_L4PER_TIMER4_CLKCTRL_IDLEST_SHIFT                                       (16U)
#define CM_L4PER_TIMER4_CLKCTRL_IDLEST_MASK                                        (0x00030000U)
#define CM_L4PER_TIMER4_CLKCTRL_IDLEST_DISABLE                                      (3U)
#define CM_L4PER_TIMER4_CLKCTRL_IDLEST_IDLE                                         (2U)
#define CM_L4PER_TIMER4_CLKCTRL_IDLEST_FUNC                                         (0U)
#define CM_L4PER_TIMER4_CLKCTRL_IDLEST_TRANS                                        (1U)

#define CM_L4PER_TIMER4_CLKCTRL_MODULEMODE_SHIFT                                   (0U)
#define CM_L4PER_TIMER4_CLKCTRL_MODULEMODE_MASK                                    (0x00000003U)
#define CM_L4PER_TIMER4_CLKCTRL_MODULEMODE_DISABLED                                 (0U)
#define CM_L4PER_TIMER4_CLKCTRL_MODULEMODE_RESERVED_1                               (1U)
#define CM_L4PER_TIMER4_CLKCTRL_MODULEMODE_ENABLE                                   (2U)
#define CM_L4PER_TIMER4_CLKCTRL_MODULEMODE_RESERVED                                 (3U)

#define CM_L4PER_TIMER4_CLKCTRL_CLKSEL_SHIFT                                       (24U)
#define CM_L4PER_TIMER4_CLKCTRL_CLKSEL_MASK                                        (0x0f000000U)
#define CM_L4PER_TIMER4_CLKCTRL_CLKSEL_SEL_TIMER_SYS_CLK                            (0U)
#define CM_L4PER_TIMER4_CLKCTRL_CLKSEL_SEL_SYS_CLK1_32K_CLK                         (1U)
#define CM_L4PER_TIMER4_CLKCTRL_CLKSEL_SEL_SYS_CLK2                                 (2U)
#define CM_L4PER_TIMER4_CLKCTRL_CLKSEL_SEL_XREF_CLK0                                (3U)
#define CM_L4PER_TIMER4_CLKCTRL_CLKSEL_SEL_XREF_CLK1                                (4U)
#define CM_L4PER_TIMER4_CLKCTRL_CLKSEL_SEL_XREF_CLK2                                (5U)
#define CM_L4PER_TIMER4_CLKCTRL_CLKSEL_SEL_XREF_CLK3                                (6U)
#define CM_L4PER_TIMER4_CLKCTRL_CLKSEL_SEL_PER_ABE_X1_GFCLK                                                  (7U)
#define CM_L4PER_TIMER4_CLKCTRL_CLKSEL_SEL_VIDEO1_CLK                               (8U)
#define CM_L4PER_TIMER4_CLKCTRL_CLKSEL_SEL_VIDEO2_CLK                               (9U)
#define CM_L4PER_TIMER4_CLKCTRL_CLKSEL_SEL_HDMI_CLK                                 (10U)
#define CM_L4PER_TIMER4_CLKCTRL_CLKSEL_RESERVED                                     (11U)
#define CM_L4PER_TIMER4_CLKCTRL_CLKSEL_RESERVED1                                    (12U)
#define CM_L4PER_TIMER4_CLKCTRL_CLKSEL_RESERVED2                                    (13U)
#define CM_L4PER_TIMER4_CLKCTRL_CLKSEL_RESERVED3                                    (14U)
#define CM_L4PER_TIMER4_CLKCTRL_CLKSEL_RESERVED4                                    (15U)

#define CM_L4PER_DCC5_CLKCTRL_IDLEST_SHIFT                                              (16U)
#define CM_L4PER_DCC5_CLKCTRL_IDLEST_MASK                                               (0x00030000U)
#define CM_L4PER_DCC5_CLKCTRL_IDLEST_DISABLE                                             (3U)
#define CM_L4PER_DCC5_CLKCTRL_IDLEST_IDLE                                                (2U)
#define CM_L4PER_DCC5_CLKCTRL_IDLEST_FUNC                                                (0U)
#define CM_L4PER_DCC5_CLKCTRL_IDLEST_TRANS                                               (1U)

#define CM_L4PER_DCC5_CLKCTRL_MODULEMODE_SHIFT                                          (0U)
#define CM_L4PER_DCC5_CLKCTRL_MODULEMODE_MASK                                           (0x00000003U)
#define CM_L4PER_DCC5_CLKCTRL_MODULEMODE_DISABLED                                        (0U)
#define CM_L4PER_DCC5_CLKCTRL_MODULEMODE_RESERVED_1                                      (1U)
#define CM_L4PER_DCC5_CLKCTRL_MODULEMODE_ENABLE                                          (2U)
#define CM_L4PER_DCC5_CLKCTRL_MODULEMODE_RESERVED                                        (3U)

#define CM_L4PER_DCC5_CLKCTRL_CLKSEL_SHIFT                                              (24U)
#define CM_L4PER_DCC5_CLKCTRL_CLKSEL_MASK                                               (0x0f000000U)
#define CM_L4PER_DCC5_CLKCTRL_CLKSEL_SEL_TIMER_SYS_CLK                                   (0U)
#define CM_L4PER_DCC5_CLKCTRL_CLKSEL_SEL_SYS_CLK1_32K_CLK                                (1U)
#define CM_L4PER_DCC5_CLKCTRL_CLKSEL_SEL_SYS_CLK2                                        (2U)
#define CM_L4PER_DCC5_CLKCTRL_CLKSEL_SEL_XREF_CLK0                                       (3U)
#define CM_L4PER_DCC5_CLKCTRL_CLKSEL_SEL_XREF_CLK1                                       (4U)
#define CM_L4PER_DCC5_CLKCTRL_CLKSEL_SEL_XREF_CLK2                                       (5U)
#define CM_L4PER_DCC5_CLKCTRL_CLKSEL_SEL_XREF_CLK3                                       (6U)
#define CM_L4PER_DCC5_CLKCTRL_CLKSEL_SEL_PER_ABE_X1_GFCLK                                (7U)
#define CM_L4PER_DCC5_CLKCTRL_CLKSEL_SEL_VIDEO1_CLK                                      (8U)
#define CM_L4PER_DCC5_CLKCTRL_CLKSEL_SEL_VIDEO2_CLK                                      (9U)
#define CM_L4PER_DCC5_CLKCTRL_CLKSEL_SEL_HDMI_CLK                                        (10U)
#define CM_L4PER_DCC5_CLKCTRL_CLKSEL_RESERVED                                            (11U)
#define CM_L4PER_DCC5_CLKCTRL_CLKSEL_RESERVED1                                           (12U)
#define CM_L4PER_DCC5_CLKCTRL_CLKSEL_RESERVED2                                           (13U)
#define CM_L4PER_DCC5_CLKCTRL_CLKSEL_RESERVED3                                           (14U)
#define CM_L4PER_DCC5_CLKCTRL_CLKSEL_RESERVED4                                           (15U)

#define CM_L4PER_ELM_CLKCTRL_IDLEST_SHIFT                                          (16U)
#define CM_L4PER_ELM_CLKCTRL_IDLEST_MASK                                           (0x00030000U)
#define CM_L4PER_ELM_CLKCTRL_IDLEST_DISABLE                                         (3U)
#define CM_L4PER_ELM_CLKCTRL_IDLEST_IDLE                                            (2U)
#define CM_L4PER_ELM_CLKCTRL_IDLEST_FUNC                                            (0U)
#define CM_L4PER_ELM_CLKCTRL_IDLEST_TRANS                                           (1U)

#define CM_L4PER_ELM_CLKCTRL_MODULEMODE_SHIFT                                      (0U)
#define CM_L4PER_ELM_CLKCTRL_MODULEMODE_MASK                                       (0x00000003U)
#define CM_L4PER_ELM_CLKCTRL_MODULEMODE_AUTO                                        (1U)

#define CM_L4PER_GPIO2_CLKCTRL_IDLEST_SHIFT                                        (16U)
#define CM_L4PER_GPIO2_CLKCTRL_IDLEST_MASK                                         (0x00030000U)
#define CM_L4PER_GPIO2_CLKCTRL_IDLEST_DISABLE                                       (3U)
#define CM_L4PER_GPIO2_CLKCTRL_IDLEST_IDLE                                          (2U)
#define CM_L4PER_GPIO2_CLKCTRL_IDLEST_FUNC                                          (0U)
#define CM_L4PER_GPIO2_CLKCTRL_IDLEST_TRANS                                         (1U)

#define CM_L4PER_GPIO2_CLKCTRL_OPTFCLKEN_DBCLK_SHIFT                               (8U)
#define CM_L4PER_GPIO2_CLKCTRL_OPTFCLKEN_DBCLK_MASK                                (0x00000100U)
#define CM_L4PER_GPIO2_CLKCTRL_OPTFCLKEN_DBCLK_FCLK_EN                              (1U)
#define CM_L4PER_GPIO2_CLKCTRL_OPTFCLKEN_DBCLK_FCLK_DIS                             (0U)

#define CM_L4PER_GPIO2_CLKCTRL_MODULEMODE_SHIFT                                    (0U)
#define CM_L4PER_GPIO2_CLKCTRL_MODULEMODE_MASK                                     (0x00000003U)
#define CM_L4PER_GPIO2_CLKCTRL_MODULEMODE_DISABLED                                  (0U)
#define CM_L4PER_GPIO2_CLKCTRL_MODULEMODE_AUTO                                      (1U)
#define CM_L4PER_GPIO2_CLKCTRL_MODULEMODE_RESERVED_2                                (2U)
#define CM_L4PER_GPIO2_CLKCTRL_MODULEMODE_RESERVED                                  (3U)

#define CM_L4PER_GPIO3_CLKCTRL_IDLEST_SHIFT                                        (16U)
#define CM_L4PER_GPIO3_CLKCTRL_IDLEST_MASK                                         (0x00030000U)
#define CM_L4PER_GPIO3_CLKCTRL_IDLEST_DISABLE                                       (3U)
#define CM_L4PER_GPIO3_CLKCTRL_IDLEST_IDLE                                          (2U)
#define CM_L4PER_GPIO3_CLKCTRL_IDLEST_FUNC                                          (0U)
#define CM_L4PER_GPIO3_CLKCTRL_IDLEST_TRANS                                         (1U)

#define CM_L4PER_GPIO3_CLKCTRL_OPTFCLKEN_DBCLK_SHIFT                               (8U)
#define CM_L4PER_GPIO3_CLKCTRL_OPTFCLKEN_DBCLK_MASK                                (0x00000100U)
#define CM_L4PER_GPIO3_CLKCTRL_OPTFCLKEN_DBCLK_FCLK_EN                              (1U)
#define CM_L4PER_GPIO3_CLKCTRL_OPTFCLKEN_DBCLK_FCLK_DIS                             (0U)

#define CM_L4PER_GPIO3_CLKCTRL_MODULEMODE_SHIFT                                    (0U)
#define CM_L4PER_GPIO3_CLKCTRL_MODULEMODE_MASK                                     (0x00000003U)
#define CM_L4PER_GPIO3_CLKCTRL_MODULEMODE_DISABLED                                  (0U)
#define CM_L4PER_GPIO3_CLKCTRL_MODULEMODE_AUTO                                      (1U)
#define CM_L4PER_GPIO3_CLKCTRL_MODULEMODE_RESERVED_2                                (2U)
#define CM_L4PER_GPIO3_CLKCTRL_MODULEMODE_RESERVED                                  (3U)

#define CM_L4PER_GPIO4_CLKCTRL_IDLEST_SHIFT                                        (16U)
#define CM_L4PER_GPIO4_CLKCTRL_IDLEST_MASK                                         (0x00030000U)
#define CM_L4PER_GPIO4_CLKCTRL_IDLEST_DISABLE                                       (3U)
#define CM_L4PER_GPIO4_CLKCTRL_IDLEST_IDLE                                          (2U)
#define CM_L4PER_GPIO4_CLKCTRL_IDLEST_FUNC                                          (0U)
#define CM_L4PER_GPIO4_CLKCTRL_IDLEST_TRANS                                         (1U)

#define CM_L4PER_GPIO4_CLKCTRL_OPTFCLKEN_DBCLK_SHIFT                               (8U)
#define CM_L4PER_GPIO4_CLKCTRL_OPTFCLKEN_DBCLK_MASK                                (0x00000100U)
#define CM_L4PER_GPIO4_CLKCTRL_OPTFCLKEN_DBCLK_FCLK_EN                              (1U)
#define CM_L4PER_GPIO4_CLKCTRL_OPTFCLKEN_DBCLK_FCLK_DIS                             (0U)

#define CM_L4PER_GPIO4_CLKCTRL_MODULEMODE_SHIFT                                    (0U)
#define CM_L4PER_GPIO4_CLKCTRL_MODULEMODE_MASK                                     (0x00000003U)
#define CM_L4PER_GPIO4_CLKCTRL_MODULEMODE_DISABLED                                  (0U)
#define CM_L4PER_GPIO4_CLKCTRL_MODULEMODE_AUTO                                      (1U)
#define CM_L4PER_GPIO4_CLKCTRL_MODULEMODE_RESERVED_2                                (2U)
#define CM_L4PER_GPIO4_CLKCTRL_MODULEMODE_RESERVED                                  (3U)

#define CM_L4PER_ESM_CLKCTRL_IDLEST_SHIFT                                               (16U)
#define CM_L4PER_ESM_CLKCTRL_IDLEST_MASK                                                (0x00030000U)
#define CM_L4PER_ESM_CLKCTRL_IDLEST_DISABLE                                              (3U)
#define CM_L4PER_ESM_CLKCTRL_IDLEST_IDLE                                                 (2U)
#define CM_L4PER_ESM_CLKCTRL_IDLEST_FUNC                                                 (0U)
#define CM_L4PER_ESM_CLKCTRL_IDLEST_TRANS                                                (1U)

#define CM_L4PER_ESM_CLKCTRL_MODULEMODE_SHIFT                                           (0U)
#define CM_L4PER_ESM_CLKCTRL_MODULEMODE_MASK                                            (0x00000003U)
#define CM_L4PER_ESM_CLKCTRL_MODULEMODE_DISABLED                                         (0U)
#define CM_L4PER_ESM_CLKCTRL_MODULEMODE_RESERVED_1                                       (1U)
#define CM_L4PER_ESM_CLKCTRL_MODULEMODE_ENABLE                                           (2U)
#define CM_L4PER_ESM_CLKCTRL_MODULEMODE_RESERVED                                         (3U)

#define CM_L4PER_I2C1_CLKCTRL_IDLEST_SHIFT                                         (16U)
#define CM_L4PER_I2C1_CLKCTRL_IDLEST_MASK                                          (0x00030000U)
#define CM_L4PER_I2C1_CLKCTRL_IDLEST_DISABLE                                        (3U)
#define CM_L4PER_I2C1_CLKCTRL_IDLEST_IDLE                                           (2U)
#define CM_L4PER_I2C1_CLKCTRL_IDLEST_FUNC                                           (0U)
#define CM_L4PER_I2C1_CLKCTRL_IDLEST_TRANS                                          (1U)

#define CM_L4PER_I2C1_CLKCTRL_MODULEMODE_SHIFT                                     (0U)
#define CM_L4PER_I2C1_CLKCTRL_MODULEMODE_MASK                                      (0x00000003U)
#define CM_L4PER_I2C1_CLKCTRL_MODULEMODE_DISABLED                                   (0U)
#define CM_L4PER_I2C1_CLKCTRL_MODULEMODE_RESERVED_1                                 (1U)
#define CM_L4PER_I2C1_CLKCTRL_MODULEMODE_ENABLE                                     (2U)
#define CM_L4PER_I2C1_CLKCTRL_MODULEMODE_RESERVED                                   (3U)

#define CM_L4PER_I2C2_CLKCTRL_IDLEST_SHIFT                                         (16U)
#define CM_L4PER_I2C2_CLKCTRL_IDLEST_MASK                                          (0x00030000U)
#define CM_L4PER_I2C2_CLKCTRL_IDLEST_DISABLE                                        (3U)
#define CM_L4PER_I2C2_CLKCTRL_IDLEST_IDLE                                           (2U)
#define CM_L4PER_I2C2_CLKCTRL_IDLEST_FUNC                                           (0U)
#define CM_L4PER_I2C2_CLKCTRL_IDLEST_TRANS                                          (1U)

#define CM_L4PER_I2C2_CLKCTRL_MODULEMODE_SHIFT                                     (0U)
#define CM_L4PER_I2C2_CLKCTRL_MODULEMODE_MASK                                      (0x00000003U)
#define CM_L4PER_I2C2_CLKCTRL_MODULEMODE_DISABLED                                   (0U)
#define CM_L4PER_I2C2_CLKCTRL_MODULEMODE_RESERVED_1                                 (1U)
#define CM_L4PER_I2C2_CLKCTRL_MODULEMODE_ENABLE                                     (2U)
#define CM_L4PER_I2C2_CLKCTRL_MODULEMODE_RESERVED                                   (3U)

#define CM_L4PER_L4_PER1_CLKCTRL_MODULEMODE_SHIFT                                  (0U)
#define CM_L4PER_L4_PER1_CLKCTRL_MODULEMODE_MASK                                   (0x00000003U)
#define CM_L4PER_L4_PER1_CLKCTRL_MODULEMODE_AUTO                                    (1U)

#define CM_L4PER_L4_PER1_CLKCTRL_IDLEST_SHIFT                                      (16U)
#define CM_L4PER_L4_PER1_CLKCTRL_IDLEST_MASK                                       (0x00030000U)
#define CM_L4PER_L4_PER1_CLKCTRL_IDLEST_DISABLE                                     (3U)
#define CM_L4PER_L4_PER1_CLKCTRL_IDLEST_IDLE                                        (2U)
#define CM_L4PER_L4_PER1_CLKCTRL_IDLEST_FUNC                                        (0U)
#define CM_L4PER_L4_PER1_CLKCTRL_IDLEST_TRANS                                       (1U)

#define CM_L4PER2_PWMSS1_CLKCTRL_IDLEST_SHIFT                                      (16U)
#define CM_L4PER2_PWMSS1_CLKCTRL_IDLEST_MASK                                       (0x00030000U)
#define CM_L4PER2_PWMSS1_CLKCTRL_IDLEST_DISABLE                                     (3U)
#define CM_L4PER2_PWMSS1_CLKCTRL_IDLEST_IDLE                                        (2U)
#define CM_L4PER2_PWMSS1_CLKCTRL_IDLEST_FUNC                                        (0U)
#define CM_L4PER2_PWMSS1_CLKCTRL_IDLEST_TRANS                                       (1U)

#define CM_L4PER2_PWMSS1_CLKCTRL_MODULEMODE_SHIFT                                  (0U)
#define CM_L4PER2_PWMSS1_CLKCTRL_MODULEMODE_MASK                                   (0x00000003U)
#define CM_L4PER2_PWMSS1_CLKCTRL_MODULEMODE_DISABLED                                (0U)
#define CM_L4PER2_PWMSS1_CLKCTRL_MODULEMODE_RESERVED_1                              (1U)
#define CM_L4PER2_PWMSS1_CLKCTRL_MODULEMODE_ENABLE                                  (2U)
#define CM_L4PER2_PWMSS1_CLKCTRL_MODULEMODE_RESERVED                                (3U)

#define CM_L4PER3_DCC1_CLKCTRL_IDLEST_SHIFT                                             (16U)
#define CM_L4PER3_DCC1_CLKCTRL_IDLEST_MASK                                              (0x00030000U)
#define CM_L4PER3_DCC1_CLKCTRL_IDLEST_DISABLE                                            (3U)
#define CM_L4PER3_DCC1_CLKCTRL_IDLEST_IDLE                                               (2U)
#define CM_L4PER3_DCC1_CLKCTRL_IDLEST_FUNC                                               (0U)
#define CM_L4PER3_DCC1_CLKCTRL_IDLEST_TRANS                                              (1U)

#define CM_L4PER3_DCC1_CLKCTRL_MODULEMODE_SHIFT                                         (0U)
#define CM_L4PER3_DCC1_CLKCTRL_MODULEMODE_MASK                                          (0x00000003U)
#define CM_L4PER3_DCC1_CLKCTRL_MODULEMODE_DISABLED                                       (0U)
#define CM_L4PER3_DCC1_CLKCTRL_MODULEMODE_RESERVED_1                                     (1U)
#define CM_L4PER3_DCC1_CLKCTRL_MODULEMODE_ENABLE                                         (2U)
#define CM_L4PER3_DCC1_CLKCTRL_MODULEMODE_RESERVED                                       (3U)

#define CM_L4PER3_DCC1_CLKCTRL_CLKSEL_SHIFT                                             (24U)
#define CM_L4PER3_DCC1_CLKCTRL_CLKSEL_MASK                                              (0x0f000000U)
#define CM_L4PER3_DCC1_CLKCTRL_CLKSEL_SEL_TIMER_SYS_CLK                                  (0U)
#define CM_L4PER3_DCC1_CLKCTRL_CLKSEL_SEL_SYS_CLK1_32K_CLK                               (1U)
#define CM_L4PER3_DCC1_CLKCTRL_CLKSEL_SEL_SYS_CLK2                                       (2U)
#define CM_L4PER3_DCC1_CLKCTRL_CLKSEL_SEL_XREF_CLK0                                      (3U)
#define CM_L4PER3_DCC1_CLKCTRL_CLKSEL_SEL_XREF_CLK1                                      (4U)
#define CM_L4PER3_DCC1_CLKCTRL_CLKSEL_SEL_XREF_CLK2                                      (5U)
#define CM_L4PER3_DCC1_CLKCTRL_CLKSEL_SEL_XREF_CLK3                                      (6U)
#define CM_L4PER3_DCC1_CLKCTRL_CLKSEL_SEL_PER_ABE_X1_GFCLK                               (7U)
#define CM_L4PER3_DCC1_CLKCTRL_CLKSEL_SEL_VIDEO1_CLK                                     (8U)
#define CM_L4PER3_DCC1_CLKCTRL_CLKSEL_SEL_VIDEO2_CLK                                     (9U)
#define CM_L4PER3_DCC1_CLKCTRL_CLKSEL_SEL_HDMI_CLK                                       (10U)
#define CM_L4PER3_DCC1_CLKCTRL_CLKSEL_RESERVED                                           (11U)
#define CM_L4PER3_DCC1_CLKCTRL_CLKSEL_RESERVED1                                          (12U)
#define CM_L4PER3_DCC1_CLKCTRL_CLKSEL_RESERVED2                                          (13U)
#define CM_L4PER3_DCC1_CLKCTRL_CLKSEL_RESERVED3                                          (14U)
#define CM_L4PER3_DCC1_CLKCTRL_CLKSEL_RESERVED4                                          (15U)

#define CM_L4PER3_DCC2_CLKCTRL_IDLEST_SHIFT                                             (16U)
#define CM_L4PER3_DCC2_CLKCTRL_IDLEST_MASK                                              (0x00030000U)
#define CM_L4PER3_DCC2_CLKCTRL_IDLEST_DISABLE                                            (3U)
#define CM_L4PER3_DCC2_CLKCTRL_IDLEST_IDLE                                               (2U)
#define CM_L4PER3_DCC2_CLKCTRL_IDLEST_FUNC                                               (0U)
#define CM_L4PER3_DCC2_CLKCTRL_IDLEST_TRANS                                              (1U)

#define CM_L4PER3_DCC2_CLKCTRL_MODULEMODE_SHIFT                                         (0U)
#define CM_L4PER3_DCC2_CLKCTRL_MODULEMODE_MASK                                          (0x00000003U)
#define CM_L4PER3_DCC2_CLKCTRL_MODULEMODE_DISABLED                                       (0U)
#define CM_L4PER3_DCC2_CLKCTRL_MODULEMODE_RESERVED_1                                     (1U)
#define CM_L4PER3_DCC2_CLKCTRL_MODULEMODE_ENABLE                                         (2U)
#define CM_L4PER3_DCC2_CLKCTRL_MODULEMODE_RESERVED                                       (3U)

#define CM_L4PER3_DCC2_CLKCTRL_CLKSEL_SHIFT                                             (24U)
#define CM_L4PER3_DCC2_CLKCTRL_CLKSEL_MASK                                              (0x0f000000U)
#define CM_L4PER3_DCC2_CLKCTRL_CLKSEL_SEL_TIMER_SYS_CLK                                  (0U)
#define CM_L4PER3_DCC2_CLKCTRL_CLKSEL_SEL_SYS_CLK1_32K_CLK                               (1U)
#define CM_L4PER3_DCC2_CLKCTRL_CLKSEL_SEL_SYS_CLK2                                       (2U)
#define CM_L4PER3_DCC2_CLKCTRL_CLKSEL_SEL_XREF_CLK0                                      (3U)
#define CM_L4PER3_DCC2_CLKCTRL_CLKSEL_SEL_XREF_CLK1                                      (4U)
#define CM_L4PER3_DCC2_CLKCTRL_CLKSEL_SEL_XREF_CLK2                                      (5U)
#define CM_L4PER3_DCC2_CLKCTRL_CLKSEL_SEL_XREF_CLK3                                      (6U)
#define CM_L4PER3_DCC2_CLKCTRL_CLKSEL_SEL_PER_ABE_X1_GFCLK                               (7U)
#define CM_L4PER3_DCC2_CLKCTRL_CLKSEL_SEL_VIDEO1_CLK                                     (8U)
#define CM_L4PER3_DCC2_CLKCTRL_CLKSEL_SEL_VIDEO2_CLK                                     (9U)
#define CM_L4PER3_DCC2_CLKCTRL_CLKSEL_SEL_HDMI_CLK                                       (10U)
#define CM_L4PER3_DCC2_CLKCTRL_CLKSEL_RESERVED                                           (11U)
#define CM_L4PER3_DCC2_CLKCTRL_CLKSEL_RESERVED1                                          (12U)
#define CM_L4PER3_DCC2_CLKCTRL_CLKSEL_RESERVED2                                          (13U)
#define CM_L4PER3_DCC2_CLKCTRL_CLKSEL_RESERVED3                                          (14U)
#define CM_L4PER3_DCC2_CLKCTRL_CLKSEL_RESERVED4                                          (15U)

#define CM_L4PER3_DCC3_CLKCTRL_IDLEST_SHIFT                                             (16U)
#define CM_L4PER3_DCC3_CLKCTRL_IDLEST_MASK                                              (0x00030000U)
#define CM_L4PER3_DCC3_CLKCTRL_IDLEST_DISABLE                                            (3U)
#define CM_L4PER3_DCC3_CLKCTRL_IDLEST_IDLE                                               (2U)
#define CM_L4PER3_DCC3_CLKCTRL_IDLEST_FUNC                                               (0U)
#define CM_L4PER3_DCC3_CLKCTRL_IDLEST_TRANS                                              (1U)

#define CM_L4PER3_DCC3_CLKCTRL_MODULEMODE_SHIFT                                         (0U)
#define CM_L4PER3_DCC3_CLKCTRL_MODULEMODE_MASK                                          (0x00000003U)
#define CM_L4PER3_DCC3_CLKCTRL_MODULEMODE_DISABLED                                       (0U)
#define CM_L4PER3_DCC3_CLKCTRL_MODULEMODE_RESERVED_1                                     (1U)
#define CM_L4PER3_DCC3_CLKCTRL_MODULEMODE_ENABLE                                         (2U)
#define CM_L4PER3_DCC3_CLKCTRL_MODULEMODE_RESERVED                                       (3U)

#define CM_L4PER3_DCC3_CLKCTRL_CLKSEL_SHIFT                                             (24U)
#define CM_L4PER3_DCC3_CLKCTRL_CLKSEL_MASK                                              (0x0f000000U)
#define CM_L4PER3_DCC3_CLKCTRL_CLKSEL_SEL_TIMER_SYS_CLK                                  (0U)
#define CM_L4PER3_DCC3_CLKCTRL_CLKSEL_SEL_SYS_CLK1_32K_CLK                               (1U)
#define CM_L4PER3_DCC3_CLKCTRL_CLKSEL_SEL_SYS_CLK2                                       (2U)
#define CM_L4PER3_DCC3_CLKCTRL_CLKSEL_SEL_XREF_CLK0                                      (3U)
#define CM_L4PER3_DCC3_CLKCTRL_CLKSEL_SEL_XREF_CLK1                                      (4U)
#define CM_L4PER3_DCC3_CLKCTRL_CLKSEL_SEL_XREF_CLK2                                      (5U)
#define CM_L4PER3_DCC3_CLKCTRL_CLKSEL_SEL_XREF_CLK3                                      (6U)
#define CM_L4PER3_DCC3_CLKCTRL_CLKSEL_SEL_PER_ABE_X1_GFCLK                               (7U)
#define CM_L4PER3_DCC3_CLKCTRL_CLKSEL_SEL_VIDEO1_CLK                                     (8U)
#define CM_L4PER3_DCC3_CLKCTRL_CLKSEL_SEL_VIDEO2_CLK                                     (9U)
#define CM_L4PER3_DCC3_CLKCTRL_CLKSEL_SEL_HDMI_CLK                                       (10U)
#define CM_L4PER3_DCC3_CLKCTRL_CLKSEL_RESERVED                                           (11U)
#define CM_L4PER3_DCC3_CLKCTRL_CLKSEL_RESERVED1                                          (12U)
#define CM_L4PER3_DCC3_CLKCTRL_CLKSEL_RESERVED2                                          (13U)
#define CM_L4PER3_DCC3_CLKCTRL_CLKSEL_RESERVED3                                          (14U)
#define CM_L4PER3_DCC3_CLKCTRL_CLKSEL_RESERVED4                                          (15U)

#define CM_L4PER_MCSPI1_CLKCTRL_IDLEST_SHIFT                                       (16U)
#define CM_L4PER_MCSPI1_CLKCTRL_IDLEST_MASK                                        (0x00030000U)
#define CM_L4PER_MCSPI1_CLKCTRL_IDLEST_DISABLE                                      (3U)
#define CM_L4PER_MCSPI1_CLKCTRL_IDLEST_IDLE                                         (2U)
#define CM_L4PER_MCSPI1_CLKCTRL_IDLEST_FUNC                                         (0U)
#define CM_L4PER_MCSPI1_CLKCTRL_IDLEST_TRANS                                        (1U)

#define CM_L4PER_MCSPI1_CLKCTRL_MODULEMODE_SHIFT                                   (0U)
#define CM_L4PER_MCSPI1_CLKCTRL_MODULEMODE_MASK                                    (0x00000003U)
#define CM_L4PER_MCSPI1_CLKCTRL_MODULEMODE_DISABLED                                 (0U)
#define CM_L4PER_MCSPI1_CLKCTRL_MODULEMODE_RESERVED_1                               (1U)
#define CM_L4PER_MCSPI1_CLKCTRL_MODULEMODE_ENABLE                                   (2U)
#define CM_L4PER_MCSPI1_CLKCTRL_MODULEMODE_RESERVED                                 (3U)

#define CM_L4PER_MCSPI2_CLKCTRL_IDLEST_SHIFT                                       (16U)
#define CM_L4PER_MCSPI2_CLKCTRL_IDLEST_MASK                                        (0x00030000U)
#define CM_L4PER_MCSPI2_CLKCTRL_IDLEST_DISABLE                                      (3U)
#define CM_L4PER_MCSPI2_CLKCTRL_IDLEST_IDLE                                         (2U)
#define CM_L4PER_MCSPI2_CLKCTRL_IDLEST_FUNC                                         (0U)
#define CM_L4PER_MCSPI2_CLKCTRL_IDLEST_TRANS                                        (1U)

#define CM_L4PER_MCSPI2_CLKCTRL_MODULEMODE_SHIFT                                   (0U)
#define CM_L4PER_MCSPI2_CLKCTRL_MODULEMODE_MASK                                    (0x00000003U)
#define CM_L4PER_MCSPI2_CLKCTRL_MODULEMODE_DISABLED                                 (0U)
#define CM_L4PER_MCSPI2_CLKCTRL_MODULEMODE_RESERVED_1                               (1U)
#define CM_L4PER_MCSPI2_CLKCTRL_MODULEMODE_ENABLE                                   (2U)
#define CM_L4PER_MCSPI2_CLKCTRL_MODULEMODE_RESERVED                                 (3U)

#define CM_L4PER_MCSPI3_CLKCTRL_IDLEST_SHIFT                                       (16U)
#define CM_L4PER_MCSPI3_CLKCTRL_IDLEST_MASK                                        (0x00030000U)
#define CM_L4PER_MCSPI3_CLKCTRL_IDLEST_DISABLE                                      (3U)
#define CM_L4PER_MCSPI3_CLKCTRL_IDLEST_IDLE                                         (2U)
#define CM_L4PER_MCSPI3_CLKCTRL_IDLEST_FUNC                                         (0U)
#define CM_L4PER_MCSPI3_CLKCTRL_IDLEST_TRANS                                        (1U)

#define CM_L4PER_MCSPI3_CLKCTRL_MODULEMODE_SHIFT                                   (0U)
#define CM_L4PER_MCSPI3_CLKCTRL_MODULEMODE_MASK                                    (0x00000003U)
#define CM_L4PER_MCSPI3_CLKCTRL_MODULEMODE_DISABLED                                 (0U)
#define CM_L4PER_MCSPI3_CLKCTRL_MODULEMODE_RESERVED_1                               (1U)
#define CM_L4PER_MCSPI3_CLKCTRL_MODULEMODE_ENABLE                                   (2U)
#define CM_L4PER_MCSPI3_CLKCTRL_MODULEMODE_RESERVED                                 (3U)

#define CM_L4PER_MCSPI4_CLKCTRL_IDLEST_SHIFT                                       (16U)
#define CM_L4PER_MCSPI4_CLKCTRL_IDLEST_MASK                                        (0x00030000U)
#define CM_L4PER_MCSPI4_CLKCTRL_IDLEST_DISABLE                                      (3U)
#define CM_L4PER_MCSPI4_CLKCTRL_IDLEST_IDLE                                         (2U)
#define CM_L4PER_MCSPI4_CLKCTRL_IDLEST_FUNC                                         (0U)
#define CM_L4PER_MCSPI4_CLKCTRL_IDLEST_TRANS                                        (1U)

#define CM_L4PER_MCSPI4_CLKCTRL_MODULEMODE_SHIFT                                   (0U)
#define CM_L4PER_MCSPI4_CLKCTRL_MODULEMODE_MASK                                    (0x00000003U)
#define CM_L4PER_MCSPI4_CLKCTRL_MODULEMODE_DISABLED                                 (0U)
#define CM_L4PER_MCSPI4_CLKCTRL_MODULEMODE_RESERVED_1                               (1U)
#define CM_L4PER_MCSPI4_CLKCTRL_MODULEMODE_ENABLE                                   (2U)
#define CM_L4PER_MCSPI4_CLKCTRL_MODULEMODE_RESERVED                                 (3U)

#define CM_L4PER_MMC4_CLKCTRL_IDLEST_SHIFT                                         (16U)
#define CM_L4PER_MMC4_CLKCTRL_IDLEST_MASK                                          (0x00030000U)
#define CM_L4PER_MMC4_CLKCTRL_IDLEST_DISABLE                                        (3U)
#define CM_L4PER_MMC4_CLKCTRL_IDLEST_IDLE                                           (2U)
#define CM_L4PER_MMC4_CLKCTRL_IDLEST_FUNC                                           (0U)
#define CM_L4PER_MMC4_CLKCTRL_IDLEST_TRANS                                          (1U)

#define CM_L4PER_MMC4_CLKCTRL_MODULEMODE_SHIFT                                     (0U)
#define CM_L4PER_MMC4_CLKCTRL_MODULEMODE_MASK                                      (0x00000003U)
#define CM_L4PER_MMC4_CLKCTRL_MODULEMODE_DISABLED                                   (0U)
#define CM_L4PER_MMC4_CLKCTRL_MODULEMODE_RESERVED_1                                 (1U)
#define CM_L4PER_MMC4_CLKCTRL_MODULEMODE_ENABLE                                     (2U)
#define CM_L4PER_MMC4_CLKCTRL_MODULEMODE_RESERVED                                   (3U)

#define CM_L4PER_MMC4_CLKCTRL_CLKSEL_MUX_SHIFT                                     (24U)
#define CM_L4PER_MMC4_CLKCTRL_CLKSEL_MUX_MASK                                      (0x01000000U)
#define CM_L4PER_MMC4_CLKCTRL_CLKSEL_MUX_SEL_FUNC_48M_CLK                           (0U)
#define CM_L4PER_MMC4_CLKCTRL_CLKSEL_MUX_SEL_FUNC_192M_CLK                          (1U)

#define CM_L4PER_MMC4_CLKCTRL_CLKSEL_DIV_SHIFT                                                              (25U)
#define CM_L4PER_MMC4_CLKCTRL_CLKSEL_DIV_MASK                                                               (0x06000000U)
#define CM_L4PER_MMC4_CLKCTRL_CLKSEL_DIV_MMCCLK_DIV_1                                                        (0U)
#define CM_L4PER_MMC4_CLKCTRL_CLKSEL_DIV_MMCCLK_DIV_2                                                        (1U)
#define CM_L4PER_MMC4_CLKCTRL_CLKSEL_DIV_MMCCLK_DIV_4                                                        (2U)
#define CM_L4PER_MMC4_CLKCTRL_CLKSEL_DIV_RESERVED                                                            (3U)

#define CM_L4PER_MMC4_CLKCTRL_OPTFCLKEN_CLK32K_SHIFT                               (8U)
#define CM_L4PER_MMC4_CLKCTRL_OPTFCLKEN_CLK32K_MASK                                (0x00000100U)
#define CM_L4PER_MMC4_CLKCTRL_OPTFCLKEN_CLK32K_FCLK_EN                              (1U)
#define CM_L4PER_MMC4_CLKCTRL_OPTFCLKEN_CLK32K_FCLK_DIS                             (0U)

#define CM_L4PER3_DCC4_CLKCTRL_IDLEST_SHIFT                                             (16U)
#define CM_L4PER3_DCC4_CLKCTRL_IDLEST_MASK                                              (0x00030000U)
#define CM_L4PER3_DCC4_CLKCTRL_IDLEST_DISABLE                                            (3U)
#define CM_L4PER3_DCC4_CLKCTRL_IDLEST_IDLE                                               (2U)
#define CM_L4PER3_DCC4_CLKCTRL_IDLEST_FUNC                                               (0U)
#define CM_L4PER3_DCC4_CLKCTRL_IDLEST_TRANS                                              (1U)

#define CM_L4PER3_DCC4_CLKCTRL_MODULEMODE_SHIFT                                         (0U)
#define CM_L4PER3_DCC4_CLKCTRL_MODULEMODE_MASK                                          (0x00000003U)
#define CM_L4PER3_DCC4_CLKCTRL_MODULEMODE_DISABLED                                       (0U)
#define CM_L4PER3_DCC4_CLKCTRL_MODULEMODE_RESERVED_1                                     (1U)
#define CM_L4PER3_DCC4_CLKCTRL_MODULEMODE_ENABLE                                         (2U)
#define CM_L4PER3_DCC4_CLKCTRL_MODULEMODE_RESERVED                                       (3U)

#define CM_L4PER3_DCC4_CLKCTRL_CLKSEL_SHIFT                                             (24U)
#define CM_L4PER3_DCC4_CLKCTRL_CLKSEL_MASK                                              (0x0f000000U)
#define CM_L4PER3_DCC4_CLKCTRL_CLKSEL_SEL_TIMER_SYS_CLK                                  (0U)
#define CM_L4PER3_DCC4_CLKCTRL_CLKSEL_SEL_SYS_CLK1_32K_CLK                               (1U)
#define CM_L4PER3_DCC4_CLKCTRL_CLKSEL_SEL_SYS_CLK2                                       (2U)
#define CM_L4PER3_DCC4_CLKCTRL_CLKSEL_SEL_XREF_CLK0                                      (3U)
#define CM_L4PER3_DCC4_CLKCTRL_CLKSEL_SEL_XREF_CLK1                                      (4U)
#define CM_L4PER3_DCC4_CLKCTRL_CLKSEL_SEL_XREF_CLK2                                      (5U)
#define CM_L4PER3_DCC4_CLKCTRL_CLKSEL_SEL_XREF_CLK3                                      (6U)
#define CM_L4PER3_DCC4_CLKCTRL_CLKSEL_SEL_PER_ABE_X1_GFCLK                               (7U)
#define CM_L4PER3_DCC4_CLKCTRL_CLKSEL_SEL_VIDEO1_CLK                                     (8U)
#define CM_L4PER3_DCC4_CLKCTRL_CLKSEL_SEL_VIDEO2_CLK                                     (9U)
#define CM_L4PER3_DCC4_CLKCTRL_CLKSEL_SEL_HDMI_CLK                                       (10U)
#define CM_L4PER3_DCC4_CLKCTRL_CLKSEL_RESERVED                                           (11U)
#define CM_L4PER3_DCC4_CLKCTRL_CLKSEL_RESERVED1                                          (12U)
#define CM_L4PER3_DCC4_CLKCTRL_CLKSEL_RESERVED2                                          (13U)
#define CM_L4PER3_DCC4_CLKCTRL_CLKSEL_RESERVED3                                          (14U)
#define CM_L4PER3_DCC4_CLKCTRL_CLKSEL_RESERVED4                                          (15U)

#define CM_L4PER2_QSPI_CLKCTRL_CLKSEL_SOURCE_SHIFT                                 (24U)
#define CM_L4PER2_QSPI_CLKCTRL_CLKSEL_SOURCE_MASK                                  (0x01000000U)
#define CM_L4PER2_QSPI_CLKCTRL_CLKSEL_SOURCE_SEL_FUNC_128M_CLK                      (0U)
#define CM_L4PER2_QSPI_CLKCTRL_CLKSEL_SOURCE_SEL_PER_QSPI_CLK                                                (1U)

#define CM_L4PER2_QSPI_CLKCTRL_IDLEST_SHIFT                                        (16U)
#define CM_L4PER2_QSPI_CLKCTRL_IDLEST_MASK                                         (0x00030000U)
#define CM_L4PER2_QSPI_CLKCTRL_IDLEST_DISABLE                                       (3U)
#define CM_L4PER2_QSPI_CLKCTRL_IDLEST_IDLE                                          (2U)
#define CM_L4PER2_QSPI_CLKCTRL_IDLEST_FUNC                                          (0U)
#define CM_L4PER2_QSPI_CLKCTRL_IDLEST_TRANS                                         (1U)

#define CM_L4PER2_QSPI_CLKCTRL_MODULEMODE_SHIFT                                    (0U)
#define CM_L4PER2_QSPI_CLKCTRL_MODULEMODE_MASK                                     (0x00000003U)
#define CM_L4PER2_QSPI_CLKCTRL_MODULEMODE_DISABLED                                  (0U)
#define CM_L4PER2_QSPI_CLKCTRL_MODULEMODE_RESERVED_1                                (1U)
#define CM_L4PER2_QSPI_CLKCTRL_MODULEMODE_ENABLED                                   (2U)
#define CM_L4PER2_QSPI_CLKCTRL_MODULEMODE_RESERVED                                  (3U)

#define CM_L4PER2_QSPI_CLKCTRL_CLKSEL_DIV_SHIFT                                    (25U)
#define CM_L4PER2_QSPI_CLKCTRL_CLKSEL_DIV_MASK                                     (0x06000000U)
#define CM_L4PER2_QSPI_CLKCTRL_CLKSEL_DIV_DIV1                                      (0U)
#define CM_L4PER2_QSPI_CLKCTRL_CLKSEL_DIV_DIV2                                      (1U)
#define CM_L4PER2_QSPI_CLKCTRL_CLKSEL_DIV_DIV4                                      (2U)
#define CM_L4PER2_QSPI_CLKCTRL_CLKSEL_DIV_RESERVED                                  (3U)

#define CM_L4PER_UART1_CLKCTRL_IDLEST_SHIFT                                        (16U)
#define CM_L4PER_UART1_CLKCTRL_IDLEST_MASK                                         (0x00030000U)
#define CM_L4PER_UART1_CLKCTRL_IDLEST_DISABLE                                       (3U)
#define CM_L4PER_UART1_CLKCTRL_IDLEST_IDLE                                          (2U)
#define CM_L4PER_UART1_CLKCTRL_IDLEST_FUNC                                          (0U)
#define CM_L4PER_UART1_CLKCTRL_IDLEST_TRANS                                         (1U)

#define CM_L4PER_UART1_CLKCTRL_MODULEMODE_SHIFT                                    (0U)
#define CM_L4PER_UART1_CLKCTRL_MODULEMODE_MASK                                     (0x00000003U)
#define CM_L4PER_UART1_CLKCTRL_MODULEMODE_DISABLED                                  (0U)
#define CM_L4PER_UART1_CLKCTRL_MODULEMODE_RESERVED_1                                (1U)
#define CM_L4PER_UART1_CLKCTRL_MODULEMODE_ENABLE                                    (2U)
#define CM_L4PER_UART1_CLKCTRL_MODULEMODE_RESERVED                                  (3U)

#define CM_L4PER_UART1_CLKCTRL_CLKSEL_SHIFT                                        (24U)
#define CM_L4PER_UART1_CLKCTRL_CLKSEL_MASK                                         (0x01000000U)
#define CM_L4PER_UART1_CLKCTRL_CLKSEL_SEL_FUNC_48M_CLK                              (0U)
#define CM_L4PER_UART1_CLKCTRL_CLKSEL_SEL_FUNC_192M_CLK                             (1U)

#define CM_L4PER_UART2_CLKCTRL_IDLEST_SHIFT                                        (16U)
#define CM_L4PER_UART2_CLKCTRL_IDLEST_MASK                                         (0x00030000U)
#define CM_L4PER_UART2_CLKCTRL_IDLEST_DISABLE                                       (3U)
#define CM_L4PER_UART2_CLKCTRL_IDLEST_IDLE                                          (2U)
#define CM_L4PER_UART2_CLKCTRL_IDLEST_FUNC                                          (0U)
#define CM_L4PER_UART2_CLKCTRL_IDLEST_TRANS                                         (1U)

#define CM_L4PER_UART2_CLKCTRL_MODULEMODE_SHIFT                                    (0U)
#define CM_L4PER_UART2_CLKCTRL_MODULEMODE_MASK                                     (0x00000003U)
#define CM_L4PER_UART2_CLKCTRL_MODULEMODE_DISABLED                                  (0U)
#define CM_L4PER_UART2_CLKCTRL_MODULEMODE_RESERVED_1                                (1U)
#define CM_L4PER_UART2_CLKCTRL_MODULEMODE_ENABLE                                    (2U)
#define CM_L4PER_UART2_CLKCTRL_MODULEMODE_RESERVED                                  (3U)

#define CM_L4PER_UART2_CLKCTRL_CLKSEL_SHIFT                                        (24U)
#define CM_L4PER_UART2_CLKCTRL_CLKSEL_MASK                                         (0x01000000U)
#define CM_L4PER_UART2_CLKCTRL_CLKSEL_SEL_FUNC_48M_CLK                              (0U)
#define CM_L4PER_UART2_CLKCTRL_CLKSEL_SEL_FUNC_192M_CLK                             (1U)

#define CM_L4PER_UART3_CLKCTRL_IDLEST_SHIFT                                        (16U)
#define CM_L4PER_UART3_CLKCTRL_IDLEST_MASK                                         (0x00030000U)
#define CM_L4PER_UART3_CLKCTRL_IDLEST_DISABLE                                       (3U)
#define CM_L4PER_UART3_CLKCTRL_IDLEST_IDLE                                          (2U)
#define CM_L4PER_UART3_CLKCTRL_IDLEST_FUNC                                          (0U)
#define CM_L4PER_UART3_CLKCTRL_IDLEST_TRANS                                         (1U)

#define CM_L4PER_UART3_CLKCTRL_MODULEMODE_SHIFT                                    (0U)
#define CM_L4PER_UART3_CLKCTRL_MODULEMODE_MASK                                     (0x00000003U)
#define CM_L4PER_UART3_CLKCTRL_MODULEMODE_DISABLED                                  (0U)
#define CM_L4PER_UART3_CLKCTRL_MODULEMODE_RESERVED_1                                (1U)
#define CM_L4PER_UART3_CLKCTRL_MODULEMODE_ENABLE                                    (2U)
#define CM_L4PER_UART3_CLKCTRL_MODULEMODE_RESERVED                                  (3U)

#define CM_L4PER_UART3_CLKCTRL_CLKSEL_SHIFT                                        (24U)
#define CM_L4PER_UART3_CLKCTRL_CLKSEL_MASK                                         (0x01000000U)
#define CM_L4PER_UART3_CLKCTRL_CLKSEL_SEL_FUNC_48M_CLK                              (0U)
#define CM_L4PER_UART3_CLKCTRL_CLKSEL_SEL_FUNC_192M_CLK                             (1U)

#define CM_L4PER2_ADC_CLKCTRL_CLKSEL_AUX_CLK_SHIFT                                      (22U)
#define CM_L4PER2_ADC_CLKCTRL_CLKSEL_AUX_CLK_MASK                                       (0x00c00000U)
#define CM_L4PER2_ADC_CLKCTRL_CLKSEL_AUX_CLK_SEL_PER_ABE_X1_GFCLK                        (0U)
#define CM_L4PER2_ADC_CLKCTRL_CLKSEL_AUX_CLK_SEL_VIDEO1_CLK                                  (1U)
#define CM_L4PER2_ADC_CLKCTRL_CLKSEL_AUX_CLK_SEL_VIDEO2_CLK                                  (2U)
#define CM_L4PER2_ADC_CLKCTRL_CLKSEL_AUX_CLK_SEL_HDMI_CLK                                    (3U)

#define CM_L4PER2_ADC_CLKCTRL_IDLEST_SHIFT                                              (16U)
#define CM_L4PER2_ADC_CLKCTRL_IDLEST_MASK                                               (0x00030000U)
#define CM_L4PER2_ADC_CLKCTRL_IDLEST_DISABLE                                             (3U)
#define CM_L4PER2_ADC_CLKCTRL_IDLEST_IDLE                                                (2U)
#define CM_L4PER2_ADC_CLKCTRL_IDLEST_FUNC                                                (0U)
#define CM_L4PER2_ADC_CLKCTRL_IDLEST_TRANS                                               (1U)

#define CM_L4PER2_ADC_CLKCTRL_MODULEMODE_SHIFT                                          (0U)
#define CM_L4PER2_ADC_CLKCTRL_MODULEMODE_MASK                                           (0x00000003U)
#define CM_L4PER2_ADC_CLKCTRL_MODULEMODE_DISABLED                                        (0U)
#define CM_L4PER2_ADC_CLKCTRL_MODULEMODE_RESERVED_1                                      (1U)
#define CM_L4PER2_ADC_CLKCTRL_MODULEMODE_ENABLE                                          (2U)
#define CM_L4PER2_ADC_CLKCTRL_MODULEMODE_RESERVED                                        (3U)

#define CM_L4PER2_ADC_CLKCTRL_CLKSEL_AHCLKX_SHIFT                                       (24U)
#define CM_L4PER2_ADC_CLKCTRL_CLKSEL_AHCLKX_MASK                                        (0x0f000000U)
#define CM_L4PER2_ADC_CLKCTRL_CLKSEL_AHCLKX_SEL_ABE_24M_GFCLK                            (0U)
#define CM_L4PER2_ADC_CLKCTRL_CLKSEL_AHCLKX_SEL_ABE_SYS_CLK                              (1U)
#define CM_L4PER2_ADC_CLKCTRL_CLKSEL_AHCLKX_SEL_FUNC_24M_GFCLK                           (2U)
#define CM_L4PER2_ADC_CLKCTRL_CLKSEL_AHCLKX_SEL_SYS_SLK2                                 (7U)
#define CM_L4PER2_ADC_CLKCTRL_CLKSEL_AHCLKX_SEL_XREF_CLK0                                (8U)
#define CM_L4PER2_ADC_CLKCTRL_CLKSEL_AHCLKX_SEL_XREF_CLK1                                (9U)
#define CM_L4PER2_ADC_CLKCTRL_CLKSEL_AHCLKX_SEL_XREF_CLK2                                (10U)
#define CM_L4PER2_ADC_CLKCTRL_CLKSEL_AHCLKX_SEL_XREF_CLK3                                (11U)
#define CM_L4PER2_ADC_CLKCTRL_CLKSEL_AHCLKX_RESERVED                                     (14U)
#define CM_L4PER2_ADC_CLKCTRL_CLKSEL_AHCLKX_RESERVED1                                    (15U)

#define CM_L4PER2_ADC_CLKCTRL_CLKSEL_AHCLKR_SHIFT                                       (28U)
#define CM_L4PER2_ADC_CLKCTRL_CLKSEL_AHCLKR_MASK                                        (0xf0000000U)
#define CM_L4PER2_ADC_CLKCTRL_CLKSEL_AHCLKR_SEL_ABE_24M_GFCLK                            (0U)
#define CM_L4PER2_ADC_CLKCTRL_CLKSEL_AHCLKR_SEL_ABE_SYS_CLK                              (1U)
#define CM_L4PER2_ADC_CLKCTRL_CLKSEL_AHCLKR_SEL_FUNC_24M_GFCLK                           (2U)
#define CM_L4PER2_ADC_CLKCTRL_CLKSEL_AHCLKR_SEL_SYS_SLK2                                 (7U)
#define CM_L4PER2_ADC_CLKCTRL_CLKSEL_AHCLKR_SEL_XREF_CLK0                                (8U)
#define CM_L4PER2_ADC_CLKCTRL_CLKSEL_AHCLKR_SEL_XREF_CLK1                                (9U)
#define CM_L4PER2_ADC_CLKCTRL_CLKSEL_AHCLKR_SEL_XREF_CLK2                                (10U)
#define CM_L4PER2_ADC_CLKCTRL_CLKSEL_AHCLKR_SEL_XREF_CLK3                                (11U)
#define CM_L4PER2_ADC_CLKCTRL_CLKSEL_AHCLKR_RESERVED                                     (14U)
#define CM_L4PER2_ADC_CLKCTRL_CLKSEL_AHCLKR_RESERVED1                                    (15U)

#define CM_L4PER2_ATL_CLKCTRL_IDLEST_SHIFT                                              (16U)
#define CM_L4PER2_ATL_CLKCTRL_IDLEST_MASK                                               (0x00030000U)
#define CM_L4PER2_ATL_CLKCTRL_IDLEST_DISABLE                                             (3U)
#define CM_L4PER2_ATL_CLKCTRL_IDLEST_IDLE                                                (2U)
#define CM_L4PER2_ATL_CLKCTRL_IDLEST_FUNC                                                (0U)
#define CM_L4PER2_ATL_CLKCTRL_IDLEST_TRANS                                               (1U)

#define CM_L4PER2_ATL_CLKCTRL_MODULEMODE_SHIFT                                          (0U)
#define CM_L4PER2_ATL_CLKCTRL_MODULEMODE_MASK                                           (0x00000003U)
#define CM_L4PER2_ATL_CLKCTRL_MODULEMODE_DISABLED                                        (0U)
#define CM_L4PER2_ATL_CLKCTRL_MODULEMODE_RESERVED_1                                      (1U)
#define CM_L4PER2_ATL_CLKCTRL_MODULEMODE_ENABLE                                          (2U)
#define CM_L4PER2_ATL_CLKCTRL_MODULEMODE_RESERVED                                        (3U)

#define CM_L4PER2_MCASP5_CLKCTRL_CLKSEL_AUX_CLK_SHIFT                               (22U)
#define CM_L4PER2_MCASP5_CLKCTRL_CLKSEL_AUX_CLK_MASK                                (0x00C00000U)
#define CM_L4PER2_MCASP5_CLKCTRL_CLKSEL_AUX_CLK_SEL_L4_ICLK                         (0U)
#define CM_L4PER2_MCASP5_CLKCTRL_CLKSEL_AUX_CLK_SEL_VIDEO1_CLK                      (1U)
#define CM_L4PER2_MCASP5_CLKCTRL_CLKSEL_AUX_CLK_SEL_VIDEO2_CLK                      (2U)
#define CM_L4PER2_MCASP5_CLKCTRL_CLKSEL_AUX_CLK_SEL_HDMI_CLK                        (3U)

#define CM_L4PER2_MCASP5_CLKCTRL_CLKSEL_AHCLKX_CLK_SHIFT                            (24U)
#define CM_L4PER2_MCASP5_CLKCTRL_CLKSEL_AHCLKX_CLK_MASK                             (0x0F000000U)
#define CM_L4PER2_MCASP5_CLKCTRL_CLKSEL_AHCLKX_SEL_ABE_24M_GFCLK                    (0U)
#define CM_L4PER2_MCASP5_CLKCTRL_CLKSEL_AHCLKX_SEL_ABE_SYS_CLK                      (1U)
#define CM_L4PER2_MCASP5_CLKCTRL_CLKSEL_AHCLKX_SEL_FUNC_24M_GFCLK                   (2U)
#define CM_L4PER2_MCASP5_CLKCTRL_CLKSEL_AHCLKX_SEL_ATL_CLK3                         (3U)
#define CM_L4PER2_MCASP5_CLKCTRL_CLKSEL_AHCLKX_SEL_ATL_CLK2                         (4U)
#define CM_L4PER2_MCASP5_CLKCTRL_CLKSEL_AHCLKX_SEL_ATL_CLK1                         (5U)
#define CM_L4PER2_MCASP5_CLKCTRL_CLKSEL_AHCLKX_SEL_ATL_CLK0                         (6U)
#define CM_L4PER2_MCASP5_CLKCTRL_CLKSEL_AHCLKX_SEL_SYS_CLK2                         (7U)
#define CM_L4PER2_MCASP5_CLKCTRL_CLKSEL_AHCLKX_SEL_XREF_CLK0                        (8U)
#define CM_L4PER2_MCASP5_CLKCTRL_CLKSEL_AHCLKX_SEL_XREF_CLK1                        (9U)
#define CM_L4PER2_MCASP5_CLKCTRL_CLKSEL_AHCLKX_SEL_XREF_CLK2                        (10U)
#define CM_L4PER2_MCASP5_CLKCTRL_CLKSEL_AHCLKX_SEL_MLB_CLK                          (12U)
#define CM_L4PER2_MCASP5_CLKCTRL_CLKSEL_AHCLKX_SEL_MLBP_CLK                         (13U)

#define CM_L4SEC_CLKSTCTRL_CLKACTIVITY_L4SEC_L3_GICLK_SHIFT                                                 (8U)
#define CM_L4SEC_CLKSTCTRL_CLKACTIVITY_L4SEC_L3_GICLK_MASK                                                  (0x00000100U)
#define CM_L4SEC_CLKSTCTRL_CLKACTIVITY_L4SEC_L3_GICLK_INACT                                                  (0U)
#define CM_L4SEC_CLKSTCTRL_CLKACTIVITY_L4SEC_L3_GICLK_ACT                                                    (1U)

#define CM_L4SEC_CLKSTCTRL_CLKTRCTRL_SHIFT                                         (0U)
#define CM_L4SEC_CLKSTCTRL_CLKTRCTRL_MASK                                          (0x00000003U)
#define CM_L4SEC_CLKSTCTRL_CLKTRCTRL_NO_SLEEP                                       (0U)
#define CM_L4SEC_CLKSTCTRL_CLKTRCTRL_SW_SLEEP                                       (1U)
#define CM_L4SEC_CLKSTCTRL_CLKTRCTRL_SW_WKUP                                        (2U)
#define CM_L4SEC_CLKSTCTRL_CLKTRCTRL_HW_AUTO                                        (3U)

#define CM_L4SEC_STATICDEP_EMIF_STATDEP_SHIFT                                      (4U)
#define CM_L4SEC_STATICDEP_EMIF_STATDEP_MASK                                       (0x00000010U)
#define CM_L4SEC_STATICDEP_EMIF_STATDEP_ENABLED                                     (1U)
#define CM_L4SEC_STATICDEP_EMIF_STATDEP_DISABLED                                    (0U)

#define CM_L4SEC_STATICDEP_L3MAIN1_STATDEP_SHIFT                                   (5U)
#define CM_L4SEC_STATICDEP_L3MAIN1_STATDEP_MASK                                    (0x00000020U)
#define CM_L4SEC_STATICDEP_L3MAIN1_STATDEP_ENABLED                                  (1U)

#define CM_L4SEC_STATICDEP_L4PER_STATDEP_SHIFT                                     (13U)
#define CM_L4SEC_STATICDEP_L4PER_STATDEP_MASK                                      (0x00002000U)
#define CM_L4SEC_STATICDEP_L4PER_STATDEP_ENABLED                                    (1U)
#define CM_L4SEC_STATICDEP_L4PER_STATDEP_DISABLED                                   (0U)

#define CM_L4SEC_DYNAMICDEP_L3MAIN1_DYNDEP_SHIFT                                   (5U)
#define CM_L4SEC_DYNAMICDEP_L3MAIN1_DYNDEP_MASK                                    (0x00000020U)
#define CM_L4SEC_DYNAMICDEP_L3MAIN1_DYNDEP_DISABLED                                 (0U)

#define CM_L4PER2_MCASP4_CLKCTRL_CLKSEL_AUX_CLK_SHIFT                               (22U)
#define CM_L4PER2_MCASP4_CLKCTRL_CLKSEL_AUX_CLK_MASK                                (0x00C00000U)
#define CM_L4PER2_MCASP4_CLKCTRL_CLKSEL_AUX_CLK_SEL_L4_ICLK                             (0U)
#define CM_L4PER2_MCASP4_CLKCTRL_CLKSEL_AUX_CLK_SEL_VIDEO1_CLK                          (1U)
#define CM_L4PER2_MCASP4_CLKCTRL_CLKSEL_AUX_CLK_SEL_VIDEO2_CLK                          (2U)
#define CM_L4PER2_MCASP4_CLKCTRL_CLKSEL_AUX_CLK_SEL_HDMI_CLK                            (3U)

#define CM_L4PER2_MCASP4_CLKCTRL_CLKSEL_AHCLKX_CLK_SHIFT                            (24U)
#define CM_L4PER2_MCASP4_CLKCTRL_CLKSEL_AHCLKX_CLK_MASK                             (0x0F000000U)
#define CM_L4PER2_MCASP4_CLKCTRL_CLKSEL_AHCLKX_SEL_ABE_24M_GFCLK                    (0U)
#define CM_L4PER2_MCASP4_CLKCTRL_CLKSEL_AHCLKX_SEL_ABE_SYS_CLK                      (1U)
#define CM_L4PER2_MCASP4_CLKCTRL_CLKSEL_AHCLKX_SEL_FUNC_24M_GFCLK                   (2U)
#define CM_L4PER2_MCASP4_CLKCTRL_CLKSEL_AHCLKX_SEL_ATL_CLK3                         (3U)
#define CM_L4PER2_MCASP4_CLKCTRL_CLKSEL_AHCLKX_SEL_ATL_CLK2                         (4U)
#define CM_L4PER2_MCASP4_CLKCTRL_CLKSEL_AHCLKX_SEL_ATL_CLK1                         (5U)
#define CM_L4PER2_MCASP4_CLKCTRL_CLKSEL_AHCLKX_SEL_ATL_CLK0                         (6U)
#define CM_L4PER2_MCASP4_CLKCTRL_CLKSEL_AHCLKX_SEL_SYS_CLK2                         (7U)
#define CM_L4PER2_MCASP4_CLKCTRL_CLKSEL_AHCLKX_SEL_XREF_CLK0                        (8U)
#define CM_L4PER2_MCASP4_CLKCTRL_CLKSEL_AHCLKX_SEL_XREF_CLK1                        (9U)
#define CM_L4PER2_MCASP4_CLKCTRL_CLKSEL_AHCLKX_SEL_XREF_CLK2                        (10U)
#define CM_L4PER2_MCASP4_CLKCTRL_CLKSEL_AHCLKX_SEL_MLB_CLK                          (12U)
#define CM_L4PER2_MCASP4_CLKCTRL_CLKSEL_AHCLKX_SEL_MLBP_CLK                         (13U)

#define CM_L4SEC_DMA_CRYPTO_CLKCTRL_IDLEST_SHIFT                                   (16U)
#define CM_L4SEC_DMA_CRYPTO_CLKCTRL_IDLEST_MASK                                    (0x00030000U)
#define CM_L4SEC_DMA_CRYPTO_CLKCTRL_IDLEST_DISABLE                                  (3U)
#define CM_L4SEC_DMA_CRYPTO_CLKCTRL_IDLEST_IDLE                                     (2U)
#define CM_L4SEC_DMA_CRYPTO_CLKCTRL_IDLEST_FUNC                                     (0U)
#define CM_L4SEC_DMA_CRYPTO_CLKCTRL_IDLEST_TRANS                                    (1U)

#define CM_L4SEC_DMA_CRYPTO_CLKCTRL_STBYST_SHIFT                                   (18U)
#define CM_L4SEC_DMA_CRYPTO_CLKCTRL_STBYST_MASK                                    (0x00040000U)
#define CM_L4SEC_DMA_CRYPTO_CLKCTRL_STBYST_FUNC                                     (0U)
#define CM_L4SEC_DMA_CRYPTO_CLKCTRL_STBYST_STANDBY                                  (1U)

#define CM_L4SEC_DMA_CRYPTO_CLKCTRL_MODULEMODE_SHIFT                               (0U)
#define CM_L4SEC_DMA_CRYPTO_CLKCTRL_MODULEMODE_MASK                                (0x00000003U)
#define CM_L4SEC_DMA_CRYPTO_CLKCTRL_MODULEMODE_AUTO                                 (1U)

#define CM_L4PER2_DCAN2_CLKCTRL_IDLEST_SHIFT                                       (16U)
#define CM_L4PER2_DCAN2_CLKCTRL_IDLEST_MASK                                        (0x00030000U)
#define CM_L4PER2_DCAN2_CLKCTRL_IDLEST_DISABLE                                      (3U)
#define CM_L4PER2_DCAN2_CLKCTRL_IDLEST_IDLE                                         (2U)
#define CM_L4PER2_DCAN2_CLKCTRL_IDLEST_FUNC                                         (0U)
#define CM_L4PER2_DCAN2_CLKCTRL_IDLEST_TRANS                                        (1U)

#define CM_L4PER2_DCAN2_CLKCTRL_MODULEMODE_SHIFT                                   (0U)
#define CM_L4PER2_DCAN2_CLKCTRL_MODULEMODE_MASK                                    (0x00000003U)
#define CM_L4PER2_DCAN2_CLKCTRL_MODULEMODE_DISABLED                                 (0U)
#define CM_L4PER2_DCAN2_CLKCTRL_MODULEMODE_RESERVED_1                               (1U)
#define CM_L4PER2_DCAN2_CLKCTRL_MODULEMODE_ENABLE                                   (2U)
#define CM_L4PER2_DCAN2_CLKCTRL_MODULEMODE_RESERVED                                 (3U)

#define CM_L4PER2_CLKSTCTRL_CLKTRCTRL_SHIFT                                             (0U)
#define CM_L4PER2_CLKSTCTRL_CLKTRCTRL_MASK                                              (0x00000003U)
#define CM_L4PER2_CLKSTCTRL_CLKTRCTRL_NO_SLEEP                                           (0U)
#define CM_L4PER2_CLKSTCTRL_CLKTRCTRL_SW_SLEEP                                           (1U)
#define CM_L4PER2_CLKSTCTRL_CLKTRCTRL_SW_WKUP                                            (2U)
#define CM_L4PER2_CLKSTCTRL_CLKTRCTRL_HW_AUTO                                            (3U)

#define CM_L4PER2_CLKSTCTRL_CLKACTIVITY_PER_192M_GFCLK_SHIFT                            (13U)
#define CM_L4PER2_CLKSTCTRL_CLKACTIVITY_PER_192M_GFCLK_MASK                             (0x00002000U)
#define CM_L4PER2_CLKSTCTRL_CLKACTIVITY_PER_192M_GFCLK_INACT                             (0U)
#define CM_L4PER2_CLKSTCTRL_CLKACTIVITY_PER_192M_GFCLK_ACT                               (1U)

#define CM_L4PER2_CLKSTCTRL_CLKACTIVITY_ICSS_IEP_CLK_SHIFT                              (14U)
#define CM_L4PER2_CLKSTCTRL_CLKACTIVITY_ICSS_IEP_CLK_MASK                               (0x00004000U)
#define CM_L4PER2_CLKSTCTRL_CLKACTIVITY_ICSS_IEP_CLK_INACT                              (0U)
#define CM_L4PER2_CLKSTCTRL_CLKACTIVITY_ICSS_IEP_CLK_ACT                                (1U)

#define CM_L4PER2_CLKSTCTRL_CLKACTIVITY_DCAN2_SYS_CLK_SHIFT                             (15U)
#define CM_L4PER2_CLKSTCTRL_CLKACTIVITY_DCAN2_SYS_CLK_MASK                              (0x00008000U)
#define CM_L4PER2_CLKSTCTRL_CLKACTIVITY_DCAN2_SYS_CLK_INACT                             (0U)
#define CM_L4PER2_CLKSTCTRL_CLKACTIVITY_DCAN2_SYS_CLK_ACT                               (1U)

#define CM_L4PER2_CLKSTCTRL_CLKACTIVITY_L4PER2_L3_GICLK_SHIFT                           (16U)
#define CM_L4PER2_CLKSTCTRL_CLKACTIVITY_L4PER2_L3_GICLK_MASK                            (0x00010000U)
#define CM_L4PER2_CLKSTCTRL_CLKACTIVITY_L4PER2_L3_GICLK_INACT                           (0U)
#define CM_L4PER2_CLKSTCTRL_CLKACTIVITY_L4PER2_L3_GICLK_ACT                             (1U)

#define CM_L4PER2_CLKSTCTRL_CLKACTIVITY_ICSS_CLK_SHIFT                                  (8U)
#define CM_L4PER2_CLKSTCTRL_CLKACTIVITY_ICSS_CLK_MASK                                   (0x00000100U)
#define CM_L4PER2_CLKSTCTRL_CLKACTIVITY_ICSS_CLK_INACT                                  (0U)
#define CM_L4PER2_CLKSTCTRL_CLKACTIVITY_ICSS_CLK_ACT                                    (1U)

#define CM_L4PER2_CLKSTCTRL_CLKACTIVITY_QSPI_GFCLK_SHIFT                                (12U)
#define CM_L4PER2_CLKSTCTRL_CLKACTIVITY_QSPI_GFCLK_MASK                                 (0x00001000U)
#define CM_L4PER2_CLKSTCTRL_CLKACTIVITY_QSPI_GFCLK_INACT                                (0U)
#define CM_L4PER2_CLKSTCTRL_CLKACTIVITY_QSPI_GFCLK_ACT                                  (1U)

#define CM_L4PER2_CLKSTCTRL_CLKACTIVITY_MCASP4_AHCLKX_SHIFT                             (22U)
#define CM_L4PER2_CLKSTCTRL_CLKACTIVITY_MCASP4_AHCLKX_MASK                              (0x00400000U)
#define CM_L4PER2_CLKSTCTRL_CLKACTIVITY_MCASP4_AHCLKX_INACT                             (0U)
#define CM_L4PER2_CLKSTCTRL_CLKACTIVITY_MCASP4_AHCLKX_ACT                               (1U)

#define CM_L4PER2_CLKSTCTRL_CLKACTIVITY_MCASP4_AUX_GFCLK_SHIFT                          (23U)
#define CM_L4PER2_CLKSTCTRL_CLKACTIVITY_MCASP4_AUX_GFCLK_MASK                           (0x00800000U)
#define CM_L4PER2_CLKSTCTRL_CLKACTIVITY_MCASP4_AUX_GFCLK_INACT                          (0U)
#define CM_L4PER2_CLKSTCTRL_CLKACTIVITY_MCASP4_AUX_GFCLK_ACT                            (1U)

#define CM_L4PER2_CLKSTCTRL_CLKACTIVITY_MCASP5_AUX_GFCLK_SHIFT                          (24U)
#define CM_L4PER2_CLKSTCTRL_CLKACTIVITY_MCASP5_AUX_GFCLK_MASK                           (0x01000000U)
#define CM_L4PER2_CLKSTCTRL_CLKACTIVITY_MCASP5_AUX_GFCLK_INACT                          (0U)
#define CM_L4PER2_CLKSTCTRL_CLKACTIVITY_MCASP5_AUX_GFCLK_ACT                            (1U)

#define CM_L4PER2_CLKSTCTRL_CLKACTIVITY_MCASP5_AHCLKX_SHIFT                             (25U)
#define CM_L4PER2_CLKSTCTRL_CLKACTIVITY_MCASP5_AHCLKX_MASK                              (0x02000000U)
#define CM_L4PER2_CLKSTCTRL_CLKACTIVITY_MCASP5_AHCLKX_INACT                             (0U)
#define CM_L4PER2_CLKSTCTRL_CLKACTIVITY_MCASP5_AHCLKX_ACT                               (1U)

#define CM_L4PER2_CLKSTCTRL_CLKACTIVITY_MCASP6_AHCLKX_SHIFT                             (26U)
#define CM_L4PER2_CLKSTCTRL_CLKACTIVITY_MCASP6_AHCLKX_MASK                              (0x04000000U)
#define CM_L4PER2_CLKSTCTRL_CLKACTIVITY_MCASP6_AHCLKX_INACT                             (0U)
#define CM_L4PER2_CLKSTCTRL_CLKACTIVITY_MCASP6_AHCLKX_ACT                               (1U)

#define CM_L4PER2_CLKSTCTRL_CLKACTIVITY_MCASP7_AHCLKX_SHIFT                             (28U)
#define CM_L4PER2_CLKSTCTRL_CLKACTIVITY_MCASP7_AHCLKX_MASK                              (0x10000000U)
#define CM_L4PER2_CLKSTCTRL_CLKACTIVITY_MCASP7_AHCLKX_INACT                             (0U)
#define CM_L4PER2_CLKSTCTRL_CLKACTIVITY_MCASP7_AHCLKX_ACT                               (1U)

#define CM_L4PER2_DYNAMICDEP_L3INIT_DYNDEP_SHIFT                                        (7U)
#define CM_L4PER2_DYNAMICDEP_L3INIT_DYNDEP_MASK                                         (0x00000080U)
#define CM_L4PER2_DYNAMICDEP_L3INIT_DYNDEP_ENABLED                                       (1U)

#define CM_L4PER2_DYNAMICDEP_WINDOWSIZE_SHIFT                                           (24U)
#define CM_L4PER2_DYNAMICDEP_WINDOWSIZE_MASK                                            (0x0f000000U)

#define CM_L4PER2_DYNAMICDEP_IPU_DYNDEP_SHIFT                                           (3U)
#define CM_L4PER2_DYNAMICDEP_IPU_DYNDEP_MASK                                            (0x00000008U)
#define CM_L4PER2_DYNAMICDEP_IPU_DYNDEP_ENABLED                                          (1U)

#define CM_L4PER2_DYNAMICDEP_GMAC_DYNDEP_SHIFT                                          (22U)
#define CM_L4PER2_DYNAMICDEP_GMAC_DYNDEP_MASK                                           (0x00400000U)
#define CM_L4PER2_DYNAMICDEP_GMAC_DYNDEP_ENABLED                                         (1U)

#define CM_L4PER2_DYNAMICDEP_CRC_DYNDEP_SHIFT                                           (6U)
#define CM_L4PER2_DYNAMICDEP_CRC_DYNDEP_MASK                                            (0x00000040U)
#define CM_L4PER2_DYNAMICDEP_CRC_DYNDEP_ENABLED                                          (1U)

#define CM_L4PER2_DYNAMICDEP_L4CFG_DYNDEP_SHIFT                                         (12U)
#define CM_L4PER2_DYNAMICDEP_L4CFG_DYNDEP_MASK                                          (0x00001000U)
#define CM_L4PER2_DYNAMICDEP_L4CFG_DYNDEP_ENABLED                                        (1U)

#define CM_L4PER2_MCASP6_CLKCTRL_CLKSEL_AHCLKR_CLK_SHIFT                            (24U)
#define CM_L4PER2_MCASP6_CLKCTRL_CLKSEL_AHCLKR_CLK_MASK                             (0x0F000000U)
#define CM_L4PER2_MCASP6_CLKCTRL_CLKSEL_AHCLKR_SEL_ABE_24M_GFCLK                    (0U)
#define CM_L4PER2_MCASP6_CLKCTRL_CLKSEL_AHCLKR_SEL_ABE_SYS_CLK                      (1U)
#define CM_L4PER2_MCASP6_CLKCTRL_CLKSEL_AHCLKR_SEL_FUNC_24M_GFCLK                   (2U)
#define CM_L4PER2_MCASP6_CLKCTRL_CLKSEL_AHCLKR_SEL_ATL_CLK3                         (3U)
#define CM_L4PER2_MCASP6_CLKCTRL_CLKSEL_AHCLKR_SEL_ATL_CLK2                         (4U)
#define CM_L4PER2_MCASP6_CLKCTRL_CLKSEL_AHCLKR_SEL_ATL_CLK1                         (5U)
#define CM_L4PER2_MCASP6_CLKCTRL_CLKSEL_AHCLKR_SEL_ATL_CLK0                         (6U)
#define CM_L4PER2_MCASP6_CLKCTRL_CLKSEL_AHCLKR_SEL_SYS_CLK2                         (7U)
#define CM_L4PER2_MCASP6_CLKCTRL_CLKSEL_AHCLKR_SEL_XREF_CLK0                        (8U)
#define CM_L4PER2_MCASP6_CLKCTRL_CLKSEL_AHCLKR_SEL_XREF_CLK1                        (9U)
#define CM_L4PER2_MCASP6_CLKCTRL_CLKSEL_AHCLKR_SEL_XREF_CLK2                        (10U)
#define CM_L4PER2_MCASP6_CLKCTRL_CLKSEL_AHCLKR_SEL_MLB_CLK                          (12U)
#define CM_L4PER2_MCASP6_CLKCTRL_CLKSEL_AHCLKR_SEL_MLBP_CLK                         (13U)

#define CM_L4PER2_MCASP7_CLKCTRL_CLKSEL_AHCLKR_CLK_SHIFT                            (24U)
#define CM_L4PER2_MCASP7_CLKCTRL_CLKSEL_AHCLKR_CLK_MASK                             (0x0F000000U)
#define CM_L4PER2_MCASP7_CLKCTRL_CLKSEL_AHCLKR_SEL_ABE_24M_GFCLK                    (0U)
#define CM_L4PER2_MCASP7_CLKCTRL_CLKSEL_AHCLKR_SEL_ABE_SYS_CLK                      (1U)
#define CM_L4PER2_MCASP7_CLKCTRL_CLKSEL_AHCLKR_SEL_FUNC_24M_GFCLK                   (2U)
#define CM_L4PER2_MCASP7_CLKCTRL_CLKSEL_AHCLKR_SEL_ATL_CLK3                         (3U)
#define CM_L4PER2_MCASP7_CLKCTRL_CLKSEL_AHCLKR_SEL_ATL_CLK2                         (4U)
#define CM_L4PER2_MCASP7_CLKCTRL_CLKSEL_AHCLKR_SEL_ATL_CLK1                         (5U)
#define CM_L4PER2_MCASP7_CLKCTRL_CLKSEL_AHCLKR_SEL_ATL_CLK0                         (6U)
#define CM_L4PER2_MCASP7_CLKCTRL_CLKSEL_AHCLKR_SEL_SYS_CLK2                         (7U)
#define CM_L4PER2_MCASP7_CLKCTRL_CLKSEL_AHCLKR_SEL_XREF_CLK0                        (8U)
#define CM_L4PER2_MCASP7_CLKCTRL_CLKSEL_AHCLKR_SEL_XREF_CLK1                        (9U)
#define CM_L4PER2_MCASP7_CLKCTRL_CLKSEL_AHCLKR_SEL_XREF_CLK2                        (10U)
#define CM_L4PER2_MCASP7_CLKCTRL_CLKSEL_AHCLKR_SEL_MLB_CLK                          (12U)
#define CM_L4PER2_MCASP7_CLKCTRL_CLKSEL_AHCLKR_SEL_MLBP_CLK                         (13U)

#define CM_L4PER2_STATICDEP_DSP1_STATDEP_SHIFT                                          (1U)
#define CM_L4PER2_STATICDEP_DSP1_STATDEP_MASK                                           (0x00000002U)
#define CM_L4PER2_STATICDEP_DSP1_STATDEP_ENABLED                                         (1U)
#define CM_L4PER2_STATICDEP_DSP1_STATDEP_DISABLED                                        (0U)

#define CM_L4PER2_STATICDEP_DSP2_STATDEP_SHIFT                                          (18U)
#define CM_L4PER2_STATICDEP_DSP2_STATDEP_MASK                                           (0x00040000U)
#define CM_L4PER2_STATICDEP_DSP2_STATDEP_ENABLED                                         (1U)
#define CM_L4PER2_STATICDEP_DSP2_STATDEP_DISABLED                                        (0U)

#define CM_L4PER2_STATICDEP_IPU1_STATDEP_SHIFT                                          (23U)
#define CM_L4PER2_STATICDEP_IPU1_STATDEP_MASK                                           (0x00800000U)
#define CM_L4PER2_STATICDEP_IPU1_STATDEP_ENABLED                                         (1U)
#define CM_L4PER2_STATICDEP_IPU1_STATDEP_DISABLED                                        (0U)

#define CM_L4PER2_STATICDEP_L3MAIN1_STATDEP_SHIFT                                       (5U)
#define CM_L4PER2_STATICDEP_L3MAIN1_STATDEP_MASK                                        (0x00000020U)
#define CM_L4PER2_STATICDEP_L3MAIN1_STATDEP_ENABLED                                      (1U)

#define CM_L4PER3_CLKSTCTRL_CLKTRCTRL_SHIFT                                             (0U)
#define CM_L4PER3_CLKSTCTRL_CLKTRCTRL_MASK                                              (0x00000003U)
#define CM_L4PER3_CLKSTCTRL_CLKTRCTRL_NO_SLEEP                                           (0U)
#define CM_L4PER3_CLKSTCTRL_CLKTRCTRL_SW_SLEEP                                           (1U)
#define CM_L4PER3_CLKSTCTRL_CLKTRCTRL_SW_WKUP                                            (2U)
#define CM_L4PER3_CLKSTCTRL_CLKTRCTRL_HW_AUTO                                            (3U)

#define CM_L4PER3_CLKSTCTRL_CLKACTIVITY_L4PER3_L3_GICLK_SHIFT                                               (8U)
#define CM_L4PER3_CLKSTCTRL_CLKACTIVITY_L4PER3_L3_GICLK_MASK                                                (0x00000100U)
#define CM_L4PER3_CLKSTCTRL_CLKACTIVITY_L4PER3_L3_GICLK_INACT                                                (0U)
#define CM_L4PER3_CLKSTCTRL_CLKACTIVITY_L4PER3_L3_GICLK_ACT                                                  (1U)

#define CM_L4PER3_DYNAMICDEP_WINDOWSIZE_SHIFT                                           (24U)
#define CM_L4PER3_DYNAMICDEP_WINDOWSIZE_MASK                                            (0x0f000000U)

#define CM_L4PER3_DYNAMICDEP_L3MAIN1_DYNDEP_SHIFT                                       (5U)
#define CM_L4PER3_DYNAMICDEP_L3MAIN1_DYNDEP_MASK                                        (0x00000020U)
#define CM_L4PER3_DYNAMICDEP_L3MAIN1_DYNDEP_ENABLED                                      (1U)

#define CM_L4PER3_DYNAMICDEP_CAM_DYNDEP_SHIFT                                           (9U)
#define CM_L4PER3_DYNAMICDEP_CAM_DYNDEP_MASK                                            (0x00000200U)
#define CM_L4PER3_DYNAMICDEP_CAM_DYNDEP_ENABLED                                          (1U)

#define CM_L4PER3_DYNAMICDEP_IPU_DYNDEP_SHIFT                                           (3U)
#define CM_L4PER3_DYNAMICDEP_IPU_DYNDEP_MASK                                            (0x00000008U)
#define CM_L4PER3_DYNAMICDEP_IPU_DYNDEP_ENABLED                                          (1U)

#define CM_L4PER3_DYNAMICDEP_L3INIT_DYNDEP_SHIFT                                        (7U)
#define CM_L4PER3_DYNAMICDEP_L3INIT_DYNDEP_MASK                                         (0x00000080U)
#define CM_L4PER3_DYNAMICDEP_L3INIT_DYNDEP_ENABLED                                       (1U)

#define CM_L4PER3_DYNAMICDEP_ISS_DYNDEP_SHIFT                                           (31U)
#define CM_L4PER3_DYNAMICDEP_ISS_DYNDEP_MASK                                            (0x80000000U)
#define CM_L4PER3_DYNAMICDEP_ISS_DYNDEP_ENABLED                                          (1U)

#define CM_L4PER3_DYNAMICDEP_L4CFG_DYNDEP_SHIFT                                         (12U)
#define CM_L4PER3_DYNAMICDEP_L4CFG_DYNDEP_MASK                                          (0x00001000U)
#define CM_L4PER3_DYNAMICDEP_L4CFG_DYNDEP_ENABLED                                        (1U)

#ifdef __cplusplus
}
#endif
#endif  /* HW_L4PER_CM_CORE_H_ */

