//---------------------------------------------------------------------------------------------------------------------
// Copyright IEOS Ltd. 2010-2018 Moscow, Russian Federation  (www.ieos.ru)
//    Alexander Norokh 2017-2018
//---------------------------------------------------------------------------------------------------------------------
//
//---------------------------------------------------------------------------------------------------------------------
#ifndef _TI_STD_TYPES
#define _TI_STD_TYPES
#include "stdint.h"

#ifndef xdc_target_types__
/*
 * This '#ifndef STD_' is needed to protect from duplicate definitions
 * of Int, Uns, etc. in DSP/BIOS v4.x (e.g. 4.90, 4.80) since these versions
 * of DSP/BIOS or linux/include/ti/ipc/Std.h did not contain the
 * '#ifndef_TI_STD_TYPES' logic.
 */
#if !defined(STD_) && !defined(STD_H)

/*
 * Aliases for standard C types
 */
#ifndef Int
typedef int			Int;
#endif

#ifndef Uns
typedef unsigned		Uns;
#endif

#ifndef Char
typedef char			Char;
#endif

/* pointer to null-terminated character sequence */
#ifndef String
typedef char			*String;
#endif

#ifndef Ptr
typedef void			*Ptr;		/* pointer to arbitrary type */
#endif

#ifndef Bool
typedef unsigned short		Bool;		/* boolean */
#endif

/* Define TRUE/FALSE to go with Bool */
#ifndef TRUE

#define TRUE		((Bool) 1)
#define FALSE		((Bool) 0)

#endif

#endif /* STD_ */

#ifndef NULL
#define NULL (0)
#endif

/* Unsigned integer definitions (32bit, 16bit, 8bit) follow... */
#ifndef Uint32
typedef uint32_t    Uint32;
#endif
#ifndef Uint16
typedef uint16_t    Uint16;
#endif
#ifndef Uint8
typedef uint8_t     Uint8;
#endif

/* Signed integer definitions (32bit, 16bit, 8bit) follow... */
#ifndef Int32
typedef int32_t     Int32;
#endif
#ifndef Int16
typedef int16_t     Int16;
#endif
#ifndef Int8
typedef int8_t      Int8;
#endif

/* Below typedefs aliases are needed for VPS Lib */
#ifndef UInt32
typedef uint32_t      UInt32;
#endif
#ifndef UInt16
typedef uint16_t      UInt16;
#endif
#ifndef UInt8
typedef uint8_t       UInt8;
#endif
#ifndef UInt64
typedef uint64_t      UInt64;
#endif
#ifndef Float32
typedef float         Float32;
#endif
#ifndef Double
typedef double        Double;
#endif

#else
    #include <xdc/std.h>
#endif /* xdc_target_types__ */

#endif  /* _TI_STD_TYPES */

#ifndef TI_TYPES_SOC_ALIASES
#define TI_TYPES_SOC_ALIASES
    /* SOC Alias Defines for backward compatibility */
    #if defined(DEVICE_K2K)
    #ifndef SOC_K2K
    #define SOC_K2K
    #endif
    #elif defined(DEVICE_K2H)
    #ifndef SOC_K2H
    #define SOC_K2H
    #endif
    #elif defined(DEVICE_K2E)
    #ifndef SOC_K2E
    #define SOC_K2E
    #endif
    #elif defined(DEVICE_K2L)
    #ifndef SOC_K2L
    #define SOC_K2L
    #endif
    /* Temporary to be removed */
    #elif defined(DEVICE_K2G)
    #ifndef SOC_K2G
    #define SOC_K2G
    #endif
    #elif defined(DEVICE_AM572x)
    #ifndef SOC_AM572x
    #define SOC_AM572x
    #endif
    #elif defined(DEVICE_AM571x)
    #ifndef SOC_AM571x
    #define SOC_AM571x
    #endif
    #elif defined(DEVICE_C6678)
    #ifndef SOC_C6678
    #define SOC_C6678
    #endif
    #elif defined(DEVICE_C6657)
    #ifndef SOC_C6657
    #define SOC_C6657
    #endif

    #endif /* DEVICE_XXXXX */
#endif
