//---------------------------------------------------------------------------------------------------------------------
// Copyright IEOS Ltd. 2010-2018 Moscow, Russian Federation  (www.ieos.ru)
//    Alexander Norokh 2017-2018
//---------------------------------------------------------------------------------------------------------------------
//
//---------------------------------------------------------------------------------------------------------------------
/**
 *  \file vps_cfgcnf.h
 *
 *  \brief
 *
 */

#ifndef VPS_CFG_CNF_H_
#define VPS_CFG_CNF_H_

#include "vps_cfgnsf3.h"

#ifdef __cplusplus
extern "C" {
#endif


/**
 *  \brief Ioctl for getting cnf parameters
 */
#define VPS_ISS_CNF_IOCTL_GET_CONFIG       (VPS_ISS_IOCTL_CNF_IOCTL_BASE + 0U)

/**
 *  \brief Ioctl for getting cnf parameters
 */
#define VPS_ISS_CNF_IOCTL_SET_CONFIG       (VPS_ISS_CNF_IOCTL_GET_CONFIG + 1U)

/* ========================================================================== */
/*                         Structure Declarations                             */
/* ========================================================================== */

/**
 *  \brief Configuration parameters of CNF.
 */
typedef struct vpsissCnfConfig
{
    uint32_t                            enable;
    /**< enable/disables CNF module */

    uint32_t                            enableCds;
    /**< Enable/Disable Chroma Down sampling before CNF */

    vpsissNsf3Config_t                  nsf3Cfg;
    /**< NSF3 Configuration */
} vpsissCnfConfig_t;

/* ========================================================================== */
/*                          Function Declarations                             */
/* ========================================================================== */

/* None */

#ifdef __cplusplus
}
#endif

#endif /* VPS_CFG_CNF_H_ */

