//---------------------------------------------------------------------------------------------------------------------
// Copyright IEOS Ltd. 2010-2018 Moscow, Russian Federation  (www.ieos.ru)
//    Alexander Norokh 2017-2018
//---------------------------------------------------------------------------------------------------------------------
// HAL APIs of the SD-VENC module
//---------------------------------------------------------------------------------------------------------------------
#ifndef VPSHAL_SDVENC_H_
#define VPSHAL_SDVENC_H_

#include "stdint.h"
#include "vpshal.h"
#include "vps_cfgDss.h"

#ifdef __cplusplus
extern "C"
{
#endif
/**
 *  VpsHal_dssSdVencInit
 *  \brief SDVENC HAL init function.
 *  This function should be called before calling any of SD-VENC HAL API's.
 *  \return                   success    0
 *                            failure    error value
 */
int32_t VpsHal_dssSdVencInit(void);
/**
 *  VpsHal_dssSdVencDeInit
 *  \brief SDVENC HAL Deinit function.
 *  \return                success    0
 *                            failure    error value
 */
int32_t VpsHal_dssSdVencDeInit(void);
/**
 *  VpsHal_dssSdVencConfigure
 *  \brief Configures SDVENC for a particular video standard
 *  This function will configure the SD-VENC for a particular video mode.
 *  \return                   success    0
 *                            failure    error value
 */
int32_t VpsHal_dssSdVencConfigure(UInt32 videoStandard);
/**
 *  VpsHal_dssGetDefAdvSdVencParams
 *  \brief Initialize the config object with default parameters.
 *  This function will initialize the Vps_DssDispcSdVencAdvConfig object with
 *  the default settings based on the config.videoStandard variable.
 *  The initialized object can be passed to the
 *  VpsHal_dssSetAdvSdVencParams function.
 *
 *  \param                  pointer to Vps_DssDispcSdVencAdvConfig structure
 *                          Vps_DssDispcSdVencAdvConfig->videoStandard
 *                          should be set to get proper default values
 *  \return                 success    0
 *                          failure    error value
 */
int32_t VpsHal_dssGetDefAdvSdVencParams(Vps_DssDispcSdVencAdvConfig *config);
/**
 *  VpsHal_dssSetAdvSdVencParams
 *  \brief Configures SDVENC with the user passed configuration
 *  This function will configure the SD-VENC for user passed settings.
 *
 *  \param                  pointer to Vps_DssDispcSdVencAdvConfig structure
 *  \return                 success    0
 *                          failure    error value
 */
int32_t VpsHal_dssSetAdvSdVencParams(const Vps_DssDispcSdVencAdvConfig *config);

#ifdef __cplusplus
}
#endif

#endif
