//---------------------------------------------------------------------------------------------------------------------
// Copyright IEOS Ltd. 2010-2018 Moscow, Russian Federation  (www.ieos.ru)
//    Alexander Norokh 2017-2018
//---------------------------------------------------------------------------------------------------------------------
//
//---------------------------------------------------------------------------------------------------------------------
#include  "stdio.h"
#include  "stdint.h"
//---------------------------------------------------------------------------------------------------------------------
#include  "vpshal_dssSdVenc.h"
#include  "fvid2_dataTypes.h"
#include  "hw_dss_venc.h"
#include  "vps_dssDrv.h"
//---------------------------------------------------------------------------------------------------------------------
#include <xdc/std.h>
#include <xdc/runtime/Error.h>
#include <xdc/runtime/System.h>
#include <ti/sysbios/BIOS.h>
#include <ti/sysbios/knl/Task.h>
//---------------------------------------------------------------------------------------------------------------------
#include "DisplayDss.h"
//---------------------------------------------------------------------------------------------------------------------
//
//---------------------------------------------------------------------------------------------------------------------
int  DisplayApp( void )
{
    uint32_t VStandard, res;

    VpsDrv_DispInitParams        *VPS_Param;
    Vps_DssDispcSdVencAdvConfig  *PAL_Cfg;
    VpsDrv_DispInstObj           *VpsDriver;

// DSS must be enabled first before VENC, in order the source clocks feeding
// VENC to be running before enabling the VENC.
// VENC must be disabled before DSS, in order the source clocks feeding the
// VENC to be running before disabling the VENC. If DSS is disabled before
// VENC, the functional clocks will stop abruptly.

    typedef struct
    {
        UInt32             drvInstId;
        /**< Instance ID. */
        /* Dc_NodeNum              dctrlNodeNum; */
        /**< Node number for registering to display controller. */
        VpsCore_Inst       coreInstObj;
        /**< Core instance object used in core open. */
        const VpsCore_Ops *coreOps;
        /**< Core function pointers. */
    } VpsDrv_DispInitParams;


res = VpsDrv_dssInit( 1, VPS_Param );
if( res==0 ) printf(" VPS Driver inited (ON) \n");

res = VpsDrv_dssStart( VpsDriver );

//  PAL
res = VpsHal_dssSdVencInit();
if( res==0 ) printf(" VENC inited (ON) \n");
//  720x576 30FPS interlaced PAL standard
VStandard = FVID2_STD_PAL;
res = VpsHal_dssSdVencConfigure( VStandard );
if( res==0 ) printf(" Video Standard PAL is set \n");
//---------------------------------------------------------------------------------------------------------------------
//  
//---------------------------------------------------------------------------------------------------------------------

//---------------------------------------------------------------------------------------------------------------------
res = VpsHal_dssGetDefAdvSdVencParams( PAL_Cfg );
if( res==0 ) printf(" PAL Parameters is got from set...\n");

//    
PAL_Cfg->vencFCtrl = (PAL_Cfg->vencFCtrl | ( 0x00000040U ));
//---------------------------------------------------------------------------------------------------------------------
res = VpsHal_dssSetAdvSdVencParams( PAL_Cfg );
if( res==0 ) printf(" PAL Parameters is set properly \n");
//---------------------------------------------------------------------------------------------------------------------
DisplayDSS();

while(1){;};

//  PAL
res = VpsHal_dssSdVencDeInit();
if( res==0 ) printf(" VENC is OFF \n");

    return 0;
};
//---------------------------------------------------------------------------------------------------------------------
Void taskFxn(UArg a0, UArg a1)
{
    System_printf("enter taskFxn()\n");
    Task_sleep(10);

    DisplayApp();

    System_printf("exit taskFxn()\n");
    System_flush(); // force SysMin output to console
}
//---------------------------------------------------------------------------------------------------------------------
//
//---------------------------------------------------------------------------------------------------------------------
Int main()
{ 
    Task_Handle task;
    Error_Block eb;

    System_printf("enter main()\n");

    Error_init(&eb);
    task = Task_create(taskFxn, NULL, &eb);

    if( task == NULL )
    {
        System_printf("Task_create() failed!\n");
        BIOS_exit(0);
    }

    BIOS_start();    // does not return

    return(0);
}
//---------------------------------------------------------------------------------------------------------------------
//
//---------------------------------------------------------------------------------------------------------------------

