*****************************************************************************
*  Copyright (c) 2005  Texas Instruments, Inc. All Rights Reserved          *
*  This is proprietary information, not to be published -- TI INTERNAL DATA *
*****************************************************************************

         .mmregs
         .include "lpva200.inc"
         
         
         .C54CM_off
         .CPL_off
         .ARMS_off
   
;**********************************************************************************
;        predefined stack operation modes  
;**********************************************************************************
;        USE_RETA     : 2x16-bit fast return mode (RETA used)
;        NO_RETA      : 2x16-bit slow return mode (RETA not used)
;        C54X_STK     : 32-bit fast return mode 

;**********************************************************************************    
        ;.global _Timer_isr
        ;.global _SPI_isr
		.global _RTC_isr
             
;**********************************************************************************
        .sect "vector"
        .align  256         
;**********************************************************************************

;****************************************************************************
;* Other interrupt vector definitions go here
;****************************************************************************
	.def	_RST
_RST:		.ivec    reset_isr, USE_RETA; Reset / Software Interrupt #0

NMI:		.ivec    dummy_isr				; Nonmaskable Interrupt

INT0:		.ivec    dummy_isr				; External User Interrupt #0 

INT1:		.ivec    dummy_isr				; External User Interrupt #1

TINT0:		.ivec    dummy_isr				; Timer #0 / Software Interrupt #4

PROG0:		.ivec    dummy_isr			; Programmable 0 Interrupt

UART:		.ivec    dummy_isr				; IIS #1 Receive Interrupt

PROG1:		.ivec    dummy_isr				; Programmable 1 Interrupt

DMA:		.ivec    dummy_isr                ; DMA Interrupt

PROG2:		.ivec    dummy_isr			; Programmable 2 Interrupt

COPROCFFT:  .ivec    dummy_isr			; Coprocessor FFT Module Interrupt

PROG3:		.ivec    dummy_isr			; Programmable 3 Interrupt

LCD:		.ivec	 dummy_isr				; LCD Interrupt

SARADC:		.ivec    dummy_isr				; SAR ADC Interrupt

XMIT2:		.ivec	 dummy_isr		    ; I2S2 Tx Interrupt

RCV2:		.ivec	 dummy_isr		    ; I2S2 Rx Interrupt

XMIT3:		.ivec	 dummy_isr		    ; I2S3 Tx Interrupt

RCV3:		.ivec	 dummy_isr		    ; I2S3 Rx Interrupt

RTC:		.ivec    _RTC_isr				; RTC interrupt

SPI:    	.ivec    dummy_isr				; SPI Receive Interrupt

USB:		.ivec    dummy_isr				; USB Transmit Interrupt

GPIO:		.ivec    dummy_isr				; GPIO Interrupt

EMIF:	    .ivec    dummy_isr			    ; EMIF Interrupt

I2C:		.ivec    dummy_isr				; IIC interrupt

BERRIV:
IV24:		.ivec	 dummy_isr   ; Bus error interrupt

;    .ref  _DLOGINT_isr 
DLOGIV:
IV25:		.ivec   dummy_isr  ; Data log (RTDX) interrupt

;	.ref _RTOSINT_isr
RTOSIV:
IV26:		.ivec dummy_isr  ; Real-time OS interrupt
IV27:		.ivec dummy_isr  ; General-purpose software-only interrupt
IV28:		.ivec dummy_isr  ; General-purpose software-only interrupt
IV29:		.ivec dummy_isr  ; General-purpose software-only interrupt
IV30:		.ivec dummy_isr  ; General-purpose software-only interrupt
IV31:		.ivec dummy_isr  ; General-purpose software-only interrupt


;****************************************************************************
;* Reset 
;****************************************************************************

		.text
		.def reset_isr
		.ref _c_int00
reset_isr:
		bit (ST1, #11) = #1					; Disable interrupts
    	@IVPD_L = #(_RST >> 8) || mmap()
    	@IVPH_L = #(_RST >> 8) || mmap()
	   	 ;bit(ST3,#7) = #0		; Clear bus error interrupts
	   	 ;bit(ST3,#2) = #1		; shut off clockout port
	   	 ;bit(ST1,#13) = #0		; shut off XF port

		@#IFR0_L = #0xffff || mmap() ; clear all pending interrupts
		@#IFR1_L = #0xffff || mmap()
		bit (ST1, #11) = #0					; Enable interrupts

	goto	_c_int00

********************************************************************************
** Name     : no_isr                                                          **
**                                                                            **
** Purpose  : Spurious interrupt handler                                      **
**                                                                            **
** Author   :                                                                 **
**                                                                            **
********************************************************************************
             .text   
no_isr:      goto no_isr 


dummy_isr:
    return_int
 

    .end