/**********************************************************************
**+-----------------------------------------------------------------+**
**|                            ****                                 |**
**|                            ****                                 |**
**|                            ******o***                           |**
**|                      ********_///_****                          |**
**|                      ***** /_//_/ ****                          |**
**|                       ** ** (__/ ****                           |**
**|                           *********                             |**
**|                            ****                                 |**
**|                            ***                                  |**
**|                                                                 |**
**|   Copyright (c) 2006 - 2010    Texas Instruments Incorporated   |**
**|                        ALL RIGHTS RESERVED                      |**
**|                                                                 |**
**| Permission is hereby granted to licensees of Texas Instruments  |**
**| Incorporated (TI) products to use this computer program for     |**
**| the sole purpose of implementing a licensee product based       |**
**| on TI products.No other rights to reproduce, use, or            |**
**| disseminate this computer program, whether in part or in whole, |**
**| are granted.TI makes no representation or warranties with       |**
**| respect to the performance of this computer program, and        |**
**| specifically disclaims any responsibility for any damages,      |**
**| special or consequential,connected with the use of this program.|**
**|                                                                 |**
**+-----------------------------------------------------------------+**
**********************************************************************/


#include <stdio.h>
//#include <std.h>		//MM - std.h missing in CCS4 build environment, replaced with tistdtypes.h
#include "tistdtypes.h"


interrupt void RTC_isr (void);
#if 1
interrupt void RTC_isr (void)
{
	asm("	@#IFR1_L = #0xffff || mmap() "); // clear int flags
	asm("	*port(#0x1920) = #0x803F "); // clear flags
	asm("	*port(#0x1930) = #0x0006 "); //WU_DIR input & LDO & BG shutdown
	asm("	*port(#0x1920) = #0x803F "); // clear flags
	asm("	*port(#0x1924) = #0x0020 "); // enable external interrupt

// For Debugging only
	// asm(" bit(ST1,#13) = #0 "); // toggle XF
	// asm("	repeat(0x0083)	");
	// asm("		nop		");
	// asm(" bit(ST1,#13) = #1 "); // toggle XF
	// asm("	repeat(0x0083)	");
	// asm("		nop		");

}
#endif


void main(void)
{
	Uint16 temp1920, temp1924;

	asm("	@#IFR0_L = #0xffff || mmap() "); // clear int flags
	asm("	@#IER0_L = #0x0000 || mmap() "); // set RTC int
	asm("	@#IFR1_L = #0xffff || mmap() "); // clear int flags
	asm("	@#IER1_L = #0x0004 || mmap() "); // set RTC int
	asm(" bit(ST1,#11) = #0 "); // GLOBAL INTERRUPT ENABLE

// For Debugging only
	asm(" bit(ST1,#13) = #0 "); // Turn OFF XF
//	asm(" bit(ST1,#13) = #1 "); // Turn ON XF
//	asm(" bit(ST3,#2) = #0 "); // Turn ON CLKOUT
//	asm("	*port(#0x1c00) = #0x5800 "); //EBSR PPM=mode5 SP1=mode1
//	asm("	*port(#0x1c06) = #0x0041 "); //GPIO DIR GP6/GP0 = Output
//	asm("	*port(#0x1c0A) = #0x0041 "); //GPIO GP6/GP1 = High


// PLL configure
// FYI - PLL should be already locked from bootloader --> Do not have to bypass PLL or wait 4ms if changing output divider only?
	// Bypass the PLL as the system clock source
	asm("	*port(#0x1C1F) = #0x0 "); //Clock Configuration MSW reg
    //  program PLL to 1MHz
	asm("	*port(#0x1c20) = #0x8724 "); //PLL Control 1 reg
	asm("	*port(#0x1c21) = #0x8000 "); //PLL Control 2 reg	
	asm("	*port(#0x1c22) = #0x0806 "); //PLL Control 3 reg
	// /59 (023B) = 1MHz; /4 (0204) = 12MHz
	// asm("	*port(#0x1C23) = #0x023B "); //PLL Control 4 reg	//MM - 1MHz divider val
	asm("	*port(#0x1C23) = #0x02FF "); //PLL Control 4 reg	//MM - 234kHz divider val
	// wait 4 milli sec @ 32.768kHz = 4000000/30517.57 = 131 (0x83)
	asm("	repeat(0x0083)	");
	asm("		nop		");
	asm("	*port(#0x1c1F) = #0x0001 "); // Clock configuration MSW reg

// RTC configure
	asm("	*port(#0x1920) = #0x803F "); //clear interrupt flags
	asm("	*port(#0x1900) = #0x0001 "); //RTCINTEN enabled
//	asm("	*port(#0x1909) = #0x0030 "); //Set 3sec alarm
//	asm("	*port(#0x1924) = #0x8022 "); //RTC
	asm("	*port(#0x1924) = #0x0020 ");
	asm("	*port(#0x1930) = #0x0000 "); //WU_DIR input

	asm("	*port(#0x1924) = #0x0020 "); //EXTINTEN enabled	(must)
	asm("	*port(#0x1930) = #0x0000 "); //WU_DIR input
	do
	{
		temp1924 = *(volatile ioport unsigned int *) (0x1924);
	}	while ((temp1924&0x0020)==0);

	temp1920 = *(volatile ioport unsigned int *) (0x1920);
	if ((temp1920&0x0020)!=0)
	{
	asm("	*port(#0x1920) = #0x803F "); //clear interrupt flags
	}
	asm("	*port(#0x1930) = #0x0006 "); //WU_DIR input & LDO & BG shutdown
	asm("	*port(#0x1920) = #0x803F "); //clear interrupt flags
	// Enter RTC-only
	while (1)
	{

		temp1920 = *(volatile ioport unsigned int *) (0x1920);
		if ((temp1920&0x0020)!=0)
		{
			asm("	*port(#0x1920) = #0x803F "); //clear interrupt flags
			asm("	*port(#0x1930) = #0x0006 "); //WU_DIR input & LDO & BG shutdown
			asm("	*port(#0x1920) = #0x803F "); //clear interrupt flags
		}

	}
}
