/*
 * C6713Helper.h
 *
 *  Created on: 2013-10-18
 *      Author: Paul Charette
 *      Modifi par Daniel Gaucher 8 sept. 2017 les dfinitions et les dclations 'extern'
 *                              se trouvent dans ce .h au lieu du .c
 */

#ifndef C6713HELPER_H_
#define C6713HELPER_H_

#include "dsk6713_aic23.h"

extern far void vectors(); //external function
extern Uint16 inputsource; //= DSK6713_AIC23_INPUT_LINE;
extern Uint32 fs;          //= DSK6713_AIC23_FREQ_48KHZ;   //set sampling rate
extern DSK6713_AIC23_Config config;

#define using_bios
#define DSK6713_AIC23_INPUT_LINE 0x0011
#define DSK6713_AIC23_INPUT_MIC 0x0015
#define LEFT  1                  //data structure for union of 32-bit data
#define RIGHT 0                  //into two 16-bit data

static Uint32 CODECEventId, poll;

void comm_poll();
void CODEC_start();
void CODEC_stop();
void output_sample(int);
void output_left_sample(short);
void output_right_sample(short);
Uint32 input_sample();
short input_left_sample();
short input_right_sample();
void comm_intr();

#endif /* C6713HELPER_H_ */
