// Xover: test pour filtre FIR en point flottant
//
// Daniel Gaucher, sept. 2017


#include <csl_gpio.h>
#include <stdint.h>
#include "C6713Helper_UdeS.h"
#include <edma_helper.h>
#include <dsk6713.h>
#include <dsk6713_aic23.h>
#include <csl_edma.h>
#include <math.h>

Uint32 fs=DSK6713_AIC23_FREQ_16KHZ;  //set sampling rate
union {Uint32 uint; int16_t channel[2];} AIC23_data;





#define pi 3.141592653589
#define SZ_TABLE 512

typedef union {Uint32 uint; int16_t channel[2];}table;
#pragma DATA_SECTION (Signal_data,".EXT_RAM");
// #pragma DATA_ALIGN(Signal_data, 2)
table Signal_data[SZ_TABLE];





EDMA_Handle hEdmaXmt;            // EDMA channel handles
EDMA_Handle hEdmaReloadXmt;

int16_t gXmtChan;                  // TCC code (see initEDMA())

/* Transmit side EDMA configuration */
EDMA_Config gEdmaConfigXmt = {
    EDMA_FMKS(OPT, PRI, HIGH)          |  // Priority
    EDMA_FMKS(OPT, ESIZE, 16BIT)       |  // Element size  DG 16BUT sonne la vrai frquence voulu
    EDMA_FMKS(OPT, 2DS, NO)            |  // 1 dimensional source
    EDMA_FMKS(OPT, SUM, INC)           |  // Src update mode
    EDMA_FMKS(OPT, 2DD, NO)            |  // 1 dimensional dest
    EDMA_FMKS(OPT, DUM, NONE)          |  // Dest update mode  DG AD converter data in address
    EDMA_FMKS(OPT, TCINT, NO)          |  // Cause EDMA interrupt?
    EDMA_FMKS(OPT, TCC, OF(0))         |  // Transfer complete code
    EDMA_FMKS(OPT, LINK, YES)          |  // Enable link parameters?
    EDMA_FMKS(OPT, FS, NO),               // Use frame sync?
                                            // EDMA only moves one element per trigger event
     (uint32_t) Signal_data,                       // Src address

    EDMA_FMK(CNT, FRMCNT, NULL )       |  // Frame count   continuous
    EDMA_FMK(CNT, ELECNT, SZ_TABLE),     // Element count

    EDMA_FMKS(DST, DST, OF(0)),           //Dest address

    EDMA_FMKS(IDX, FRMIDX, DEFAULT)    |  // Frame index value
    EDMA_FMKS(IDX, ELEIDX, DEFAULT),      // Element index value

    EDMA_FMK (RLD, ELERLD, NULL)       |  // Reload element
    EDMA_FMK (RLD, LINK, NULL)            // Reload link
};


GPIO_Handle gpio_handle;

//GPIO_Handle gpio_handle;  /* handle para el GPIO */

    //Config des GPIO

    GPIO_Config gpio_config = {

        0x00000000, // gpgc =
        0x0000FFFF, // gpen =
        0x00000000, // gdir =
        0x00000000, // gpval =
        0x00000000, // gphm all interrupts disabled for io pins
        0x00000000, // gplm all interrupts to cpu or edma disabled
        0x00000000  // gppol -- default state */

    };

interrupt void c_int11()    //interrupt service routine
{
    //AIC23_data.channel[RIGHT]=(int) (sine_table_right[loopindex]/gain); //for right channel;
    //AIC23_data.channel[LEFT]= (int) (sine_table_left[loopindex]/gain); //for leftchannel;
    GPIO_pinWrite(gpio_handle,GPIO_PIN0,1);

    //AIC23_data.uint =  input_sample();  // input samples from both channels
    // AIC23_data.channel[1] = AIC23_data.channel[1];
    // AIC23_data.channel[0] = AIC23_data.channel[0];
   // output_sample(AIC23_data.uint); //output to both channels


    GPIO_pinWrite(gpio_handle,GPIO_PIN0,0);

    return;
}

interrupt void c_int08()    //interrupt service routine edma pas utilisee
{
return;
}

    /*******************************************************/
    /* Create a table where upper 16-bits are samples of   */
    /* a sine wave with frequency f_left, and the lower 16 */
    /* bits are samples of a sine wave with frequency      */
    /* f_right.                                            */
    /*******************************************************/

    void create_table(void){
   //   Put your code to generate the sine table here.
       uint32_t N = 512;
       uint32_t i = 0;
       uint32_t f1 = 128;
       uint32_t f2 = 128;

#pragma MUST_ITERATE(512,512,)

       for (i=0; i < 512; i++)
            {
               Signal_data[i].channel[0] =  (int16_t) (sin(2*pi*f1*i/N) * 2500);
               Signal_data[i].channel[1] =  (int16_t) (sin(2*pi*f2*(i+1)/N) * 2500);

            }

    }

    /*
     *  initEdma() - Initialize the DMA controller.  Use linked transfers to
     *               automatically restart at beginning of sine table.
     */

    void initEdma(void)
    {
     /* Configure transmit channel */

      // get hEdmaXmt handle and reset channel for McBSP1 writes
        hEdmaXmt = EDMA_open(EDMA_CHA_XEVT1, EDMA_OPEN_RESET);

      // get handle for reload table
        hEdmaReloadXmt = EDMA_allocTable(-1); // any free table (DG)

      // Get the address of DXR for McBSP1
        gEdmaConfigXmt.dst = MCBSP_getXmtAddr(DSK6713_AIC23_DATAHANDLE);

      // then configure the Xmt table
        EDMA_config(hEdmaXmt, &gEdmaConfigXmt);

      // Configure the Xmt reload table
        EDMA_config(hEdmaReloadXmt, &gEdmaConfigXmt);

      // link back to table start
        EDMA_link(hEdmaXmt,hEdmaReloadXmt);
        EDMA_link(hEdmaReloadXmt, hEdmaReloadXmt);

      // enable EDMA channel
        EDMA_enableChannel(hEdmaXmt);

        /* Do a dummy write to generate the first McBSP transmit event */

         MCBSP_write(DSK6713_AIC23_DATAHANDLE, 0);

    }

void main()
{
        DSK6713_AIC23_CodecHandle hAIC23_handle;
        DSK6713_init();



        gpio_handle = GPIO_open( GPIO_DEV0, GPIO_OPEN_RESET );
        GPIO_config(gpio_handle,&gpio_config);
        GPIO_pinDirection(gpio_handle , GPIO_PIN0, GPIO_OUTPUT);
        GPIO_pinWrite(gpio_handle,GPIO_PIN0,0);


        hAIC23_handle = DSK6713_AIC23_openCodec(0, &config);

        DSK6713_AIC23_setFreq(hAIC23_handle, DSK6713_AIC23_FREQ_44KHZ);
        create_table();
        initEdma();



        while(1) ;

}

