/*
 *
 * Copyright (c) 2020 Texas Instruments Incorporated
 *
 * All rights reserved not granted herein.
 *
 * Limited License.
 *
 * Texas Instruments Incorporated grants a world-wide, royalty-free, non-exclusive
 * license under copyrights and patents it now or hereafter owns or controls to make,
 * have made, use, import, offer to sell and sell ("Utilize") this software subject to the
 * terms herein.  With respect to the foregoing patent license, such license is granted
 * solely to the extent that any such patent is necessary to Utilize the software alone.
 * The patent license shall not apply to any combinations which include this software,
 * other than combinations with devices manufactured by or for TI ("TI Devices").
 * No hardware patent is licensed hereunder.
 *
 * Redistributions must preserve existing copyright notices and reproduce this license
 * (including the above copyright notice and the disclaimer and (if applicable) source
 * code license limitations below) in the documentation and/or other materials provided
 * with the distribution
 *
 * Redistribution and use in binary form, without modification, are permitted provided
 * that the following conditions are met:
 *
 * *       No reverse engineering, decompilation, or disassembly of this software is
 * permitted with respect to any software provided in binary form.
 *
 * *       any redistribution and use are licensed by TI for use only with TI Devices.
 *
 * *       Nothing shall obligate TI to provide you with source code for the software
 * licensed and provided to you in object code.
 *
 * If software source code is provided to you, modification and redistribution of the
 * source code are permitted provided that the following conditions are met:
 *
 * *       any redistribution and use of the source code, including any resulting derivative
 * works, are licensed by TI for use only with TI Devices.
 *
 * *       any redistribution and use of any object code compiled from the source code
 * and any resulting derivative works, are licensed by TI for use only with TI Devices.
 *
 * Neither the name of Texas Instruments Incorporated nor the names of its suppliers
 *
 * may be used to endorse or promote products derived from this software without
 * specific prior written permission.
 *
 * DISCLAIMER.
 *
 * THIS SOFTWARE IS PROVIDED BY TI AND TI'S LICENSORS "AS IS" AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL TI AND TI'S LICENSORS BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
 * BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY
 * OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE
 * OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
 * OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */
#ifndef _APP_AEWB_MODULE_H_
#define _APP_AEWB_MODULE_H_

// #include <TI/j7.h>
#include <TI/j7_imaging_aewb.h>

#include "app_utils_module.h"
#include "app_sensor_module.h"
#include "app_common_module.h"

#ifdef __cplusplus
extern "C" {
#endif

typedef struct {
    APP_COMMON_MEMBERS

    vx_object_array i_config_arr;
    tivx_aewb_config_t i_params;
    vx_object_array r_input_h3a_stats_arr;
    vx_object_array i_dcc_config_arr;
    /** if o_dcc_buf_2a[i] is not NULL, dcc_2A parameters for 
     * channels[i] will be got from from appIssGetDCCBuff2A.
    */
    void *o_dcc_buf_2as[ISS_SENSORS_MAX_SUPPORTED_SENSOR];

    /** if o_dcc_buf_2a[i] is not NULL, dcc_2A parameter size 
     * for channels[i] will be got from from appIssGetDCCSize2A.
     * 
     * \NOTE: if sizes are different for each channel, AEWB target
     * code should be changed: when parsing dcc buffer, use 
     * 'valid_mem_size' instead of 'mem_size' for dcc_in_prms->dcc_buf_size
     */
    vx_size o_dcc_buf_2a_sizes[ISS_SENSORS_MAX_SUPPORTED_SENSOR];

    /**
     * see SensorMod->r_channel_mask for explaination.
     * default value is SensorMod->r_channel_mask.
     * 
     * this field is used when aewb is enabled on only
     * some of channels.
     * for example, if SensorMod->r_channel_mask is 0xFF,
     * and you want only aewb enabled at channel 4~7, then
     * set `o_channel_mask` to 0xF0.
     */
    vx_uint32 o_channel_mask;

    vx_object_array i_histogram_arr;

    vx_object_array i_output_arr;
}AewbMod;

vx_status app_add_node_aewb(vx_graph graph, AewbMod *aewbObj, SensorMod *sensorObj);
void app_delete_node_aewb(AewbMod *mod);

#ifdef __cplusplus
}
#endif

#endif
