/*
 *
 * Copyright (c) 2020 Texas Instruments Incorporated
 *
 * All rights reserved not granted herein.
 *
 * Limited License.
 *
 * Texas Instruments Incorporated grants a world-wide, royalty-free, non-exclusive
 * license under copyrights and patents it now or hereafter owns or controls to make,
 * have made, use, import, offer to sell and sell ("Utilize") this software subject to the
 * terms herein.  With respect to the foregoing patent license, such license is granted
 * solely to the extent that any such patent is necessary to Utilize the software alone.
 * The patent license shall not apply to any combinations which include this software,
 * other than combinations with devices manufactured by or for TI ("TI Devices").
 * No hardware patent is licensed hereunder.
 *
 * Redistributions must preserve existing copyright notices and reproduce this license
 * (including the above copyright notice and the disclaimer and (if applicable) source
 * code license limitations below) in the documentation and/or other materials provided
 * with the distribution
 *
 * Redistribution and use in binary form, without modification, are permitted provided
 * that the following conditions are met:
 *
 * *       No reverse engineering, decompilation, or disassembly of this software is
 * permitted with respect to any software provided in binary form.
 *
 * *       any redistribution and use are licensed by TI for use only with TI Devices.
 *
 * *       Nothing shall obligate TI to provide you with source code for the software
 * licensed and provided to you in object code.
 *
 * If software source code is provided to you, modification and redistribution of the
 * source code are permitted provided that the following conditions are met:
 *
 * *       any redistribution and use of the source code, including any resulting derivative
 * works, are licensed by TI for use only with TI Devices.
 *
 * *       any redistribution and use of any object code compiled from the source code
 * and any resulting derivative works, are licensed by TI for use only with TI Devices.
 *
 * Neither the name of Texas Instruments Incorporated nor the names of its suppliers
 *
 * may be used to endorse or promote products derived from this software without
 * specific prior written permission.
 *
 * DISCLAIMER.
 *
 * THIS SOFTWARE IS PROVIDED BY TI AND TI'S LICENSORS "AS IS" AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL TI AND TI'S LICENSORS BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
 * BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY
 * OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE
 * OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
 * OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */
#ifndef _APP_CAPTURE_MODULE_H_
#define _APP_CAPTURE_MODULE_H_

#include <TI/tivx.h>
#include <TI/j7_capture.h>
#include "app_common_module.h"
#include "app_sensor_module.h"

#ifdef __cplusplus
extern "C" {
#endif 

typedef struct {
    APP_COMMON_MEMBERS
    vx_user_data_object i_config;
    tivx_capture_params_t i_params;
    vx_user_data_object i_dcc_config;
    vx_object_array i_output_arr;
    vx_reference i_error_frame;
    /** if set to true, i_params will not be modified 
     *  in app_add_node_capture. 
     * */
    const char *o_err_image_fpath;
    vx_bool_e o_use_custom_capture_config;
    vx_bool_e o_enable_error_detection;
    vx_bool_e i_is_raw_image;
}CaptureMod;

/**
 * \brief: add a Capture node to graph.
 * \note: this is only for GW_AR0233_MAX96717_UYVY or GW_AR0233_MAX96717_MULTI, whose output format is VX_DF_IMAGE_UYVY. 
 * other sensor types are not tested.
 * \note: if you want to add output_arr as graph parameters, the parameter depth should be at least 4, 
 * which is a empirical value, I don't known why, however.
 * \note: the right steps to get capture node into work:
 *      1. app_initiate_sensor
 *      2. app_add_node_capture
 *         app config sensor
 *      3. vxVerifyGraph
 *      4. app_start_sensor
 *      5. vxWaitGraph
 *      6. app_stop_sensor
 *      7. app_delete_node_capture
 *  do delete node capture before stop sensor may not block the app itself, but could couse other apps to block
*/
vx_status app_add_node_capture(vx_graph graph, CaptureMod *cap_mod, SensorMod *sensor_mod);
void      app_delete_node_capture(CaptureMod *cap_mod);

/**
 * if cap_mod->o_enable_error_detection is true, call
 * this after the vxVerifyGraph call and before the 
 * processing of the OpenVX graph
 */ 
vx_status app_send_error_frame(CaptureMod *cap_mod);

#ifdef __cplusplus
}
#endif // __cplusplus

#endif // _APP_CAPTURE_MODULE_H_
