/*
 *
 * Copyright (c) 2020 Texas Instruments Incorporated
 *
 * All rights reserved not granted herein.
 *
 * Limited License.
 *
 * Texas Instruments Incorporated grants a world-wide, royalty-free, non-exclusive
 * license under copyrights and patents it now or hereafter owns or controls to make,
 * have made, use, import, offer to sell and sell ("Utilize") this software subject to the
 * terms herein.  With respect to the foregoing patent license, such license is granted
 * solely to the extent that any such patent is necessary to Utilize the software alone.
 * The patent license shall not apply to any combinations which include this software,
 * other than combinations with devices manufactured by or for TI ("TI Devices").
 * No hardware patent is licensed hereunder.
 *
 * Redistributions must preserve existing copyright notices and reproduce this license
 * (including the above copyright notice and the disclaimer and (if applicable) source
 * code license limitations below) in the documentation and/or other materials provided
 * with the distribution
 *
 * Redistribution and use in binary form, without modification, are permitted provided
 * that the following conditions are met:
 *
 * *       No reverse engineering, decompilation, or disassembly of this software is
 * permitted with respect to any software provided in binary form.
 *
 * *       any redistribution and use are licensed by TI for use only with TI Devices.
 *
 * *       Nothing shall obligate TI to provide you with source code for the software
 * licensed and provided to you in object code.
 *
 * If software source code is provided to you, modification and redistribution of the
 * source code are permitted provided that the following conditions are met:
 *
 * *       any redistribution and use of the source code, including any resulting derivative
 * works, are licensed by TI for use only with TI Devices.
 *
 * *       any redistribution and use of any object code compiled from the source code
 * and any resulting derivative works, are licensed by TI for use only with TI Devices.
 *
 * Neither the name of Texas Instruments Incorporated nor the names of its suppliers
 *
 * may be used to endorse or promote products derived from this software without
 * specific prior written permission.
 *
 * DISCLAIMER.
 *
 * THIS SOFTWARE IS PROVIDED BY TI AND TI'S LICENSORS "AS IS" AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL TI AND TI'S LICENSORS BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
 * BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY
 * OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE
 * OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
 * OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */
#ifndef _APP_VISS_MODULE_H_
#define _APP_VISS_MODULE_H_

#include <TI/tivx_img_proc.h>
#include "app_common_module.h"
#include "app_sensor_module.h"
#include "app_utils_module.h"

#ifdef __cplusplus
extern "C" {
#endif

typedef struct {
    APP_COMMON_MEMBERS

    vx_user_data_object i_config;
    tivx_vpac_viss_params_t i_params;
    
    vx_object_array r_input_arr;
    vx_object_array i_dcc_config_arr;

    vx_object_array i_output_arr;
    vx_object_array i_h3a_stats_arr;

    /** if o_dcc_viss_bufs[i] is not NULL, dcc VISS parameters for 
     * channels[i] will be got from from appIssGetDCCBuffVISS.
    */
    const void *o_dcc_viss_bufs[ISS_SENSORS_MAX_SUPPORTED_SENSOR];

    /** if o_dcc_viss_buf_sizes[i] is not NULL, dcc VISS parameter size 
     * for channels[i] will be got from from appIssGetDCCSizeVISS.
     * 
     * \NOTE: if sizes are different for each channel, VISS target
     * code should be changed: when parsing dcc buffer, use 
     * 'valid_mem_size' instead of 'mem_size' for dcc_in_prms->dcc_buf_size
     */
    size_t o_dcc_viss_buf_sizes[ISS_SENSORS_MAX_SUPPORTED_SENSOR];
}VissMod;

vx_status app_add_node_viss(vx_graph graph, VissMod *vissObj, SensorMod *sensor);
void app_delete_node_viss(VissMod *vissObj);

#ifdef __cplusplus
}
#endif // __cplusplus
#endif
