/*
 * main.cpp
 *
 *  Created on: Aug 27, 2024
 *      Author: tmiddlet
 */

#include <stdio.h>
#include <kernel/dpl/CacheP.h>
#include <kernel/dpl/DebugP.h>
#include <kernel/dpl/CycleCounterP.h>

#include <tisp.hpp>

#include "TISP_dmaUtils.hpp"




#define NUM_RANGES (128)
#define NUM_DOPPLERS (128)
#define NUM_RX_CHANNELS (4)

#define RP_BLOCK_WIDTH (NUM_RANGES << 1)
#define RP_BLOCK_HEIGHT (8)


#define TOTAL_DMA_CHANNELS (2)

#define NUM_REPS (1)

#define DDR_SIZE (NUM_RANGES*NUM_DOPPLERS*NUM_RX_CHANNELS*sizeof(float)*2*4)

#define FFTLIB_FFT1DBATCHED_16X1024_CYCLES (29783)
#define FFTLIB_FFT1DBATCHED_1024X1024_CYCLES (FFTLIB_FFT1DBATCHED_16X1024_CYCLES) * (1024 / 16)
#define ESTIMATED_TOTAL_CYCLE_COUNT ((FFTLIB_FFT1DBATCHED_1024X1024_CYCLES)*NUM_RX_CHANNELS)


Udma_DrvHandle TISP::SuperNode::appDrvHandle;

__attribute__((section(".ddrData"), aligned(128))) uint8_t ddrBuffer[DDR_SIZE];


__attribute__((section(".l2mem"), aligned(128))) float pInputBlock[RP_BLOCK_WIDTH*RP_BLOCK_HEIGHT*2];
__attribute__((section(".l2mem"), aligned(128))) float pOutputBlock[RP_BLOCK_WIDTH*RP_BLOCK_HEIGHT*2];


using namespace TISP;

Udma_DrvHandle udmaHandle;
int main() {


    printf("Starting Program\r\n");

//    for (int j = 0; j < 128/8; j++) {
//        for (int i = 0; i < 128*8*2; i++) {
//            pOutputBlock[i] = ddrBuffer[i+j*128*8*2];
//            ddrBuffer[i+j*128*8*2] = pInputBlock[i];
//        }
//    }
    pOutputBlock[0] = ddrBuffer[0];
    ddrBuffer[0] = pInputBlock[0];
    printf("Memory access complete %p %p %p\r\n", ddrBuffer, pInputBlock, pOutputBlock);

    struct Udma_DrvObj udmaDrvObj;

    Udma_InitPrms initPrms;

    uint32_t instId;
    uint32_t retVal;

    Udma_DrvHandle drvHandle = &udmaDrvObj;

    instId = UDMA_INST_ID_MAIN_0;
    UdmaInitPrms_init(instId, &initPrms);
    initPrms.printFxn     = testDmaAutoIncPrintf;
    initPrms.virtToPhyFxn = testDmaAutoIncVirtToPhyFxn;
    retVal = Udma_init(drvHandle, &initPrms);

    if (UDMA_SOK != retVal) {
       printf("[Error] UDMA init failed!!\n");
    }

    printf("Init Complete\n");

    udmaHandle = drvHandle;

    int numChannels = 2;
    uint8_t *pTrMemCh[2];
    int32_t  chIdIn[2];  // Input channel IDs
    int32_t  chIdOut[2]; // Output channel IDs
    uint8_t *dmaUtilsContext = (uint8_t *) memalign(128, DmaUtilsAutoInc3d_getContextSize(numChannels));



    for (size_t ch = 0; ch < numChannels; ch++) {
       pTrMemCh[ch] = (uint8_t *) memalign(128, DmaUtilsAutoInc3d_getTrMemReq(1));
    }

    retVal = dmaUtils<float>::init(dmaUtilsContext, numChannels, udmaHandle);

    if (retVal != UDMA_SOK) {
       printf("[Error] UDMA init failed!!\n");
    }

    uint32_t transferSize = DMAUTILSAUTOINC3D_SYNC_2D;
    DmaUtilsAutoInc3d_TransferDim transferDimIn;  /*!< Structure to hold transfer properties of input DMA channel */
    DmaUtilsAutoInc3d_TransferDim transferDimOut; /*!< Structure to hold transfer properties of output DMA channel */

    /***********************/
    /* Configure input DMA */
    /***********************/

    // set transfer dimenssion structure
    dmaUtils<float>::dmaAutoIncSetupXferPropIn2D(128, 128, 128, 8, 128*sizeof(double), 128*sizeof(double),
                                                   &transferDimIn);
    // assign channel number
    chIdIn[0] = 0;
    /* chIdIn[0] = dmaChOffset::globalChOffset; */
    /* dmaChOffset::globalChOffset += 1; */

    // configure channel
    retVal = dmaUtils<float>::configure_channel(dmaUtilsContext, chIdIn[0], pTrMemCh, (uint8_t *) ddrBuffer,
                                                  (uint8_t *) pInputBlock, transferSize, &transferDimIn);

    if (retVal != UDMA_SOK) {
       printf("[Error] UDMA init failed!!\n");
    }

    /***********************/
    /* Configure output DMA */
    /***********************/

    // set transfer dimenssion structure
    dmaUtils<float>::dmaAutoIncSetupXferPropOut2D(128, 128, 128, 8, 128*sizeof(double), 128*sizeof(double),
                                                     &transferDimOut);
    // assign channel number
    chIdOut[0] = 1;
    /* chIdOut[0] = dmaChOffset::globalChOffset; */
    /* dmaChOffset::globalChOffset += 1; */

    // configure channel
    retVal = dmaUtils<float>::configure_channel(dmaUtilsContext, chIdOut[0], pTrMemCh, (uint8_t *) pOutputBlock,
                                                   (uint8_t *) ddrBuffer, transferSize, &transferDimOut);

    if (retVal != UDMA_SOK) {
       printf("[Error] UDMA init failed!!\n");
    }

    dmaUtils<float>::trigger(dmaUtilsContext, chIdIn, 1);

    dmaUtils<float>::wait(dmaUtilsContext, chIdIn, 1);


    printf("Goodbye\n");


}
