var Program = xdc.useModule('xdc.cfg.Program');
var cfgArgs = Program.build.cfgArgs;

var MultiProc = xdc.useModule('ti.sdo.utils.MultiProc');
var procNameAry = cfgArgs.procList.toUpperCase().split(/\s+/);
MultiProc.setConfig(Program.global.procName, procNameAry);

// ipc configuration
var Ipc = xdc.useModule('ti.sdo.ipc.Ipc');
Ipc.procSync = Ipc.ProcSync_ALL; // synchronize all processors in Ipc_start
Ipc.sr0MemorySetup = true;

// Message Queue
// xdc.useModule('ti.sdo.ipc.MessageQ');

// define host processor
Ipc.hostProcId = MultiProc.getIdMeta("HOST");

// shared region configuration
var SR0 = Program.cpu.memoryMap["SR0"];
//print("SRO.base = "+SR0);

var SharedRegion = xdc.useModule('ti.sdo.ipc.SharedRegion');
SharedRegion.setEntryMeta(0,
	new SharedRegion.Entry({
		name:           "SR0",
		base:           SR0.base,
		len:            SR0.len,
		ownerProcId:    MultiProc.getIdMeta("HOST"),
		isValid:        true,
		cacheEnable:    true
	})
);
// reduce data memory usage
var GateMP = xdc.useModule('ti.sdo.ipc.GateMP');
GateMP.maxRuntimeEntries = 4;
GateMP.RemoteCustom1Proxy = xdc.useModule('ti.sdo.ipc.gates.GateMPSupportNull');

// reduce data memory usage
var Notify = xdc.useModule('ti.sdo.ipc.Notify');
Notify.numEvents = 18;		// first 5 reserved, allow 13 more
