DSP_INCLUDE  = -I$(TI_OCL_CGT_INSTALL)/include 
DSP_INCLUDE += -I$(TI_OCL_INSTALL)/usr/share/ti/opencl
DSP_INCLUDE += -I$(TARGET_ROOTDIR)/usr/share/ti/opencl
DSP_INCLUDE += -I$(TARGET_ROOTDIR)/usr/share/ti/cgt-c6x/include

CPP   = g++ 
CL6X  = cl6x -mv6600 --abi=eabi $(DSP_INCLUDE)
CLOCL = clocl
AR    = ar

LIBS  = -lOpenCL -locl_util

UNAME_M :=$(shell uname -m)

COMPILE_CPP ?=
DBG_FLAG  ?=
CPP_FLAGS +=$(DBG_FLAG)
CL6X_FLAGS +=$(DBG_FLAG)
CLOCL_FLAGS +=$(DBG_FLAG)

# ----------------------------------------------------------------------------
# If TI_OCL_INSTALL is set, setup make from that location
# ----------------------------------------------------------------------------
ifneq ($(TI_OCL_INSTALL),)
    CPP        = g++
    CPP_FLAGS += -I$(TI_OCL_INSTALL)/usr/include
    LD_FLAGS  += -L$(TI_OCL_INSTALL)/usr/lib 
    LIBS      += -lbfd

# ----------------------------------------------------------------------------
# Otherwise, if making on x86 assume cross compile for Arm host
# ----------------------------------------------------------------------------
else ifneq (,$(findstring 86, $(UNAME_M)))
#    .DEFAULT_GOAL := cross

    # In a cross compile environment we are assuming that the EVM file system
    # is located on the build host and necessary ARM libraries are installed
    # on that file system. 
    ifneq ($(MAKECMDGOALS),clean)
       ifeq ($(TARGET_ROOTDIR),)
         $(error Environment variable TARGET_ROOTDIR must be defined. Set it to point at the EVM root file system)
       endif
    endif

    AR = arm-linux-gnueabihf-ar
    # gcc ARM cross compiler will not, by default, search the host's
    # /usr/include.  Explicitly specify here to find dependent vendor headers
	ifeq ($(COMPILE_CPP),)
        #Specify gcc for pure C application compilation
        override CPP = arm-linux-gnueabihf-gcc 
	else
        override CPP = arm-linux-gnueabihf-g++
	endif
    CPP_FLAGS += -I$(TARGET_ROOTDIR)/usr/include -idirafter /usr/include

    # If cross-compilineg, provide path to dependent ARM libraries on the 
    # target filesystem
    LD_FLAGS = -L$(LIB_DIR)/lib -L$(LIB_DIR)/usr/lib -Wl,-rpath-link,$(LIB_DIR)/lib -Wl,-rpath-link,$(LIB_DIR)/usr/lib 
endif

%.o: %.cpp
	@echo Compiling $<
	@$(CPP) -c $(CPP_FLAGS) $<

%.o: %.c
	@echo Compiling $<
	$(CPP) -c $(CPP_FLAGS) $<

%.obj: %.c
	@echo Compiling $<
	$(CL6X) -c $(CL6X_FLAGS) $<

%.out: %.cl
	@echo Compiling $< 
	$(CLOCL) $(CLOCL_FLAGS) $^

%.dsp_h: %.cl
	@echo Compiling $< 
	@$(CLOCL) -t $(CLOCL_FLAGS) $^

#$(EXE):

#cross:     $(EXE)

clean::
	@rm -f $(EXE) *.o *.obj *.out *.asm *.if *.opt *.bc *.objc *.map *.bin *.dsp_h

test: clean $(EXE)
	@echo Running   $(EXE)
	@./$(EXE) >> /dev/null
	@if [ $$? -ne 0 ] ; then echo "FAILED !!!" ; fi
