#ifndef _BTBL_PARSER_H
#define _BTBL_PARSER_H

#include "../common/device.h"
#include "../common/types.h"

#include <stdint.h>
#include <stddef.h>


/* TODO: determine what is a reasonable number of sections, or go with dynamic allocation */
#define MAX_NUM_SECTIONS  (8 * 8)

struct table_section {
    dsp_mem_type_t memory_type;
    uint32_t start_address;
    uint32_t length;
    uint8_t *data;
};

struct boot_table {
    uint32_t entry_address;
    uint32_t num_sections;
    struct table_section sections[MAX_NUM_SECTIONS];
};


int parse_btbl_binary(const uint8_t *btbl, size_t btbl_length, struct boot_table *table);
uint8_t *read_btbl_binary(struct boot_table *table_ptr, char *filename_ptr);

#endif /* _BTBL_PARSER_H */
