#ifndef _PCI_REGISTERS_H
#define _PCI_REGISTERS_H

/* PCIE registers */
#define OB_SIZE                      0x30
#define PRIORITY                     0x3C
#define EP_IRQ_CLR                   0x68
#define EP_IRQ_STATUS                0x6C
#define LEGACY_A_IRQ_STATUS_RAW      0x180
#define LEGACY_A_IRQ_ENABLE_SET      0x188
#define LEGACY_A_IRQ_ENABLE_CLR      0x18C
#define OB_OFFSET_INDEX(n)           (0x200 + (8 * (n)))
#define OB_OFFSET_HI(n)              (0x204 + (8 * (n)))
#define IB_BAR(n)                    (0x300 + (0x10 * (n)))
#define IB_START_LO(n)               (0x304 + (0x10 * (n)))
#define IB_START_HI(n)               (0x308 + (0x10 * (n)))
#define IB_OFFSET(n)                 (0x30C + (0x10 * (n)))

#endif /* _PCI_REGISTERS_H */
