#ifndef _ATVDSP_PCIE_H
#define _ATVDSP_PCIE_H

#include <linux/types.h>
#include "../common/types.h"


int atvdsp_pcie_init(void);
void atvdsp_pcie_deinit(void);

int64_t atvdsp_read_registers(uint32_t base_address, const loff_t offset, char *user_buffer,
        const size_t size);
int64_t atvdsp_write_registers(uint32_t base_address, const loff_t offset, const char *user_buffer,
        const size_t size);

int64_t atvdsp_read_memory(dsp_mem_type_t mem_type, const loff_t offset, char *user_buffer,
        const size_t size);
int64_t atvdsp_write_memory(dsp_mem_type_t mem_type, const loff_t offset, const char *user_buffer,
        const size_t size);

#endif /* _ATVDSP_PCIE_H */
