#include "atv_uart.h"
#include <ti/platform/platform.h>
#include "../../common/device.h"


#define DEVICE_REG32_W(addr, val)  *(volatile uint32_t *)(addr)=(val)
#define DEVICE_REG32_R(addr)  (*(volatile uint32_t *)(addr))


/**
 * Wait for new code to boot
 */
static void start_boot(void)
{
	void (*exit)();
	uint32_t entry_addr;

	DEVICE_REG32_W(MAGIC_ADDR, 0);
	while (1) {
		platform_delay(1);
		entry_addr = DEVICE_REG32_R(MAGIC_ADDR);
		if (entry_addr != 0) {
			exit = (void (*)())entry_addr;
			(*exit)();
		}
	}
}


int main (void)
{
	DEVICE_REG32_W(MAGIC_ADDR, 0xffffffff);

	/* Types defined in pdk_c667x_2_0_4/packages/ti/platform/platform.h */
	platform_init_flags p_flags = {
		.pll = 1,
		.ddr = 1,
		.tcsl = 0,
		.phy = 1,
		.ecc = 0, /* Needed? */
	};

	/* Use defaults */
	platform_init_config p_config = {
		.pllm = 0,
		.plld = 0,
		.prediv = 0,
		.postdiv = 0,
		.mastercore = 0,
	};

	platform_init(&p_flags, &p_config);

	atv_init_uart();
	atv_write_uart("\nPlatform initialized.");

	if (atv_pcie_init() == 0) {
		atv_write_uart("\nPCIe initialized.");
  	} else {
		atv_write_uart("\nPCIe was not initialized!");
  	}

	start_boot();
}
