#ifndef _ATVDSP_LOADER_UTILS_H
#define _ATVDSP_LOADER_UTILS_H

#include "../common/types.h"

#include <stdint.h>
#include <stdio.h>


#define ATVDSP_CONTROL_PATH    "/dev/atvdsp/control"
#define ATVDSP_LL2_CORE0_PATH  "/dev/atvdsp/ll2_core0"
#define ATVDSP_LL2_CORE1_PATH  "/dev/atvdsp/ll2_core1"
#define ATVDSP_LL2_CORE2_PATH  "/dev/atvdsp/ll2_core2"
#define ATVDSP_LL2_CORE3_PATH  "/dev/atvdsp/ll2_core3"
#define ATVDSP_LL2_CORE4_PATH  "/dev/atvdsp/ll2_core4"
#define ATVDSP_LL2_CORE5_PATH  "/dev/atvdsp/ll2_core5"
#define ATVDSP_LL2_CORE6_PATH  "/dev/atvdsp/ll2_core6"
#define ATVDSP_LL2_CORE7_PATH  "/dev/atvdsp/ll2_core7"
#define ATVDSP_MSM_PATH        "/dev/atvdsp/msm"
#define ATVDSP_DDR_PATH        "/dev/atvdsp/ddr"

#define NUM_ENTRIES(array_name)  (sizeof(array_name) / sizeof(array_name[0]))


dsp_mem_type_t get_memory_type(uint32_t address);
uint32_t get_memory_start(dsp_mem_type_t mem_type);
int open_memory_file(dsp_mem_type_t mem_type);
int open_control_file(uint32_t base_address);

#endif /* _ATVDSP_LOADER_UTILS_H */
