#ifndef _ATVDSP_DEVICE_H
#define _ATVDSP_DEVICE_H

/* Values from PCIe ROM boot */
#define ATVDSP_PCI_VENDOR_ID  0x104C
#define ATVDSP_PCI_DEVICE_ID  0xB005
#define ATVDSP_PCI_CLASSCODE  0x048000
#define ATVDSP_PCI_REVISION   0x01

/* Memories */
#define LL2_START  0x00800000
#define LL2_SIZE   (512 << 10)
#define LL2_END    (LL2_START + LL2_SIZE - 1)

#define MAGIC_ADDR  (LL2_END - 3)

#define LL2_START_CORE(core)  ((1 << 28) | ((core) << 24) | LL2_START)
#define LL2_END_CORE(core)    ((1 << 28) | ((core) << 24) | LL2_END)

#define MAGIC_ADDR_CORE(core)  ((1 << 28) | ((core) << 24) | MAGIC_ADDR)

#define MSM_START  0x0C000000
#define MSM_SIZE   (4 << 20)
#define MSM_END    (MSM_START + MSM_SIZE - 1)

#define DDR_START  0x80000000
#define DDR_SIZE   (256 << 20)
#define DDR_END    (DDR_START + DDR_SIZE - 1)

#define PCIE_DATA_START  0x60000000
#define PCIE_DATA_SIZE   (256 << 20)
#define PCIE_DATA_END    (PCIE_DATA_START + PCIE_DATA_SIZE - 1)


/* PCI registers */
#define PCIE_BASE_ADDRESS            0x21800000

/* PSC registers */
#define PSC_BASE_ADDRESS             0x02350000

/* EDMA registers */
#define EDMA_TPCC0_BASE_ADDRESS      0x02700000

/* Chip level registers */
#define CHIP_LEVEL_BASE_ADDRESS      0x02620000


/* Block size in bytes when r/w data between GPP and DSP via DSP CPU */
#define BLOCK_TRANSFER_SIZE          0x100

/* Data size in bytes when r/w data bewteen GPP and DSP via EDMA:
   GPP----PCIE link----PCIE data space----EDMA----DSP device memory (L2, DDR, ...) */
#define DMA_TRANSFER_SIZE            0x400000   /* 4MB */

/* Payload size in bytes over PCIE link. PCIe module supports
   outbound payload size of 128 bytes and inbound payload size of 256 bytes */
#define PCIE_TRANSFER_SIZE           0x80

/* For 1MB outbound translation window size */
#define PCIE_ADLEN_1MB               0x00100000
#define PCIE_1MB_BITMASK             0xFFF00000

#endif /* _ATVDSP_DEVICE_H */
