#ifndef _ATVDSP_DEVICE_REGISTERS_H
#define _ATVDSP_DEVICE_REGISTERS_H

/* PSC registers */
#define PTCMD      0x120
#define PTSTAT     0x128
#define PDSTAT(n)  (0x200 + (4 * (n)))
#define PDCTL(n)   (0x300 + (4 * (n)))
#define MDSTAT(n)  (0x800 + (4 * (n)))
#define MDCTL(n)   (0xA00 + (4 * (n)))

/* MDCTL bits */
#define MDCTL_LRST       (1U << 8)

/* MDSTAT bits */
#define MDSTAT_LRST      (1U << 8)
#define MDSTAT_LRSTDONE  (1U << 9)

/* */
#define PSC_SWRSTDISABLE  0x0
#define PSC_ENABLE        0x3

/* Power Domains */
#define PD0              0
#define LPSC_EMIF16_SPI  3
#define LPSC_TSIP        4

#define PD1              1
#define LPSC_DEBUG       5
#define LPSC_TETB_TRC    6

#define PD2              2
#define LPSC_PA          7
#define LPSC_SGMII       8
#define LPSC_SA          9

#define PD3              3
#define LPSC_PCIE        10

#define PD4              4
#define LPSC_SRIO        11

#define PD5              5
#define LPSC_HYPER       12

#define PD6              6
#define LPSC_RESERV      13

#define PD7              7
#define LPSC_MSMCRAM     14

#define PD8              8
#define LPSC_C0_TIM0     15

#define PD9              9
#define LPSC_C1_TIM1     16

#define PD10             10
#define LPSC_C2_TIM2     17

#define PD11             11
#define LPSC_C3_TIM3     18

#define PD12             12
#define LPSC_C4_TIM4     19

#define PD13             13
#define LPSC_C5_TIM5     20

#define PD14             14
#define LPSC_C6_TIM6     21

#define PD15             15
#define LPSC_C7_TIM7     22

#define PD16             16

#define PD17             17



/* EDMA registers */
#define DMAQNUM0                     0x0240
#define ESR                          0x1010
#define EESR                         0x1030
#define IESR                         0x1060
#define IPR                          0x1068
#define ICR                          0x1070
#define PARAM_0_OPT                  0x4000
#define PARAM_0_SRC                  0x4004
#define PARAM_0_A_B_CNT              0x4008
#define PARAM_0_DST                  0x400C
#define PARAM_0_SRC_DST_BIDX         0x4010
#define PARAM_0_LINK_BCNTRLD         0x4014
#define PARAM_0_SRC_DST_CIDX         0x4018
#define PARAM_0_CCNT                 0x401C


/* Chip level registers */
#define KICK0                        0x38
#define KICK1                        0x3C
#define KICK0_UNLOCK                 0x83E70B13
#define KICK1_UNLOCK                 0x95A4F1E0
#define KICK_LOCK                    0x0
#define DSP_BOOT_ADDR(n)             (0x040 + (4 * (n)))
#define IPCGR(n)                     (0x240 + (4 * (n)))

#endif /* _ATVDSP_DEVICE_REGISTERS_H */
