#ifndef _ATV_PCIE_INIT_H_
#define _ATV_PCIE_INIT_H_

#include "../../common/device.h"

#define PCIE_VENDOR_ID  ATVDSP_PCI_VENDOR_ID
#define PCIE_DEVICE_ID  ATVDSP_PCI_DEVICE_ID
#define PCIE_CLASSCODE  ATVDSP_PCI_CLASSCODE
#define PCIE_REVISION   ATVDSP_PCI_REVISION

/* BAR masks */
#define PCIE_BAR0_BAR_MASK  ((4 << 10) - 1)   /* 4 kB PCIe config */
#define PCIE_BAR1_BAR_MASK  ((32 << 10) - 1)  /* 32 kB Device registers */
#define PCIE_BAR2_BAR_MASK  (LL2_SIZE - 1) /* 512 kB LL2 */
#define PCIE_BAR3_BAR_MASK  (MSM_SIZE - 1)   /* 4 MB MSM */
#define PCIE_BAR4_BAR_MASK  (DDR_SIZE - 1) /* 256 MB DDR -- 64-bit */
#define PCIE_BAR5_BAR_MASK  0

/* Inbound translation regions for BAR1-4
 * BAR0 has hardwired translation. (See p. 2-13 and 2-15 in sprugs6d.pdf)
 */
#define PCIE_IB0_START_ADDR  CHIP_LEVEL_BASE_ADDRESS
#define PCIE_IB1_START_ADDR  LL2_START_CORE(0)
#define PCIE_IB2_START_ADDR  MSM_START
#define PCIE_IB3_START_ADDR  DDR_START
#define PCIE_IB_NUM  4

int atv_pcie_init(void);

#endif /* _ATV_PCIE_INIT_H_ */
