/**
\addtogroup ESM EtherCAT State Machine
@{
*/

/**
\file bootmode.c
\author EthercatSSC@beckhoff.com
\brief Implementation

\version 4.20

<br>Changes to version - :<br>
V4.20: File created
*/

/*--------------------------------------------------------------------------------------
------
------    Includes
------
--------------------------------------------------------------------------------------*/
#include "ecat_def.h"
#if TIESC_HW
#include "tiescbsp.h"
#endif
#if BOOTSTRAPMODE_SUPPORTED

#define    _BOOTMODE_ 1
#include "bootmode.h"
#undef _BOOTMODE_

/////////////////////////////////////////////////////////////////////////////////////////
/**
 \param    State        Current state

 \brief Dummy BL_Start function
*////////////////////////////////////////////////////////////////////////////////////////
void BL_Start( UINT8 State)
{
}

/////////////////////////////////////////////////////////////////////////////////////////
/**
 \param    password    download password

 \brief Dummy BL_StartDownload function
*////////////////////////////////////////////////////////////////////////////////////////
void BL_StartDownload(UINT32 password)
{
#if TIESC_HW
#ifdef ENABLE_ONLINE_FIRMWARE_UPGRADE
    bsp_start_fw_download(password);
#endif    
#endif    
}
/////////////////////////////////////////////////////////////////////////////////////////
/**
 \param    pData    Data pointer
 \param    Size    Data Length


 \return    FoE error code

 \brief Dummy BL_Data function
*////////////////////////////////////////////////////////////////////////////////////////
UINT16 BL_Data(UINT16 *pData,UINT16 Size)
{
#if TIESC_HW
#ifdef ENABLE_ONLINE_FIRMWARE_UPGRADE
    bsp_store_fw_data(pData,Size);
#endif    
#endif    
    return 0;
}
#endif //BOOTSTRAPMODE_SUPPORTED
/** @} */
