/**
 * ecat_appl_cnfg.h
*/
/*
 * Copyright (c) 2015, Texas Instruments Incorporated
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * *  Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * *  Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * *  Neither the name of Texas Instruments Incorporated nor the names of
 *    its contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
 * EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 **/

#include "osdrv_mmu.h"
#include "board_mux.h"

#ifndef _ECAT_APPL_CNFG_H
#define _ECAT_APPL_CNFG_H


#ifdef AM43XX_FAMILY_BUILD

PINMUX_config am437xIdkMux[] =
{
    {CHIPDB_MOD_ID_PRU_ICSS, 1, 0},
    {CHIPDB_MOD_ID_GPIO, 4, 20}, /*GPIO 4 20 */
    {CHIPDB_MOD_ID_GPIO, 0, 14}, /*GPIO 0 14 */
    {CHIPDB_MOD_ID_GPIO, 0, 15}, /*GPIO 0 15 */
    {CHIPDB_MOD_ID_GPIO, 0, 12}, /*GPIO 0 12 */
    {CHIPDB_MOD_ID_GPIO, 0, 13}, /*GPIO 0 13 */
    {CHIPDB_MOD_ID_GPIO, 0, 30}, /*GPIO 0 30 */
    {CHIPDB_MOD_ID_GPIO, 0, 26}, /*GPIO 0 26 */
    {CHIPDB_MOD_ID_GPIO, 4, 8}, /*GPIO 4 8 */
    {CHIPDB_MOD_ID_GPIO, 4, 10}, /*GPIO 4 10 */
    {CHIPDB_MOD_ID_GPIO, 4, 11}, /*GPIO 4 11 */
    {CHIPDB_MOD_ID_PWMSS, 0, 0}, /*dfd */
    {CHIPDB_MOD_ID_PWMSS, 3, 0}, /*dfdf */
    {CHIPDB_MOD_ID_PWMSS, 4, 0}, /* */
    {CHIPDB_MOD_ID_PWMSS, 5, 0}, /* */
    {CHIPDB_MOD_ID_PWMSS, 2, 0},
    {CHIPDB_MOD_ID_GPIO, 4, 27}, /*GPIO 4 27 */
    {CHIPDB_MOD_ID_GPIO, 5, 3}, /*GPIO 5 3 */
    {CHIPDB_MOD_ID_GPIO, 5, 1}, /*GPIO 5 1 */
    {CHIPDB_MOD_ID_ADC0, 0, 0}, /*ext_hw_trigger */
    {CHIPDB_MOD_ID_GPIO, 5, 12},/*GPIO 5 12 */ //print_mnb GPIO_5_12/EnDAT nRX
    {CHIPDB_MOD_ID_PRU_ICSS, 0, 0},
    {CHIPDB_MOD_ID_UART, 0, 0}, /*UART */
    {CHIPDB_MOD_ID_I2C, 2, 0},
    {CHIPDB_MOD_ID_QSPI, 0, 0},
    {CHIPDB_MOD_ID_GPIO, 3, 1},
    {CHIPDB_MOD_ID_MCSPI, 1, 0},
    /*TRI Colour LED Pinmux*/
    {CHIPDB_MOD_ID_GPIO, 2, 23}, // Red 1
    {CHIPDB_MOD_ID_GPIO, 2, 25}, // Green 0
    {0xFFFFFFFF, 0, 0}
};
SYS_MMU_ENTRY applMmuEntries[] =
{
    {(void *)0x30000000, SYS_MMU_CACHEABLE},   //QSPI CS0 Maddr1space - Cacheable
    {(void *)0x30100000, SYS_MMU_CACHEABLE},   //QSPI CS0 Maddr1space - Cacheable
    {(void *)0x30200000, SYS_MMU_CACHEABLE},   //QSPI CS0 Maddr1space - Cacheable
    {(void *)0x30300000, SYS_MMU_CACHEABLE},   //QSPI CS0 Maddr1space - Cacheable
    //{(void*)0x40300000,SYS_MMU_CACHEABLE},  //OCMCRAM  - Cacheable
    {(void *)0x44D00000, SYS_MMU_BUFFERABLE},   //PRCM - Non Cacheable | Bufferable : Device
    {(void *)0x44E00000, SYS_MMU_BUFFERABLE},   //Clock Module, PRM, GPIO0, UART0, I2C0, Non Cacheable | Bufferable : Device
    {(void *)0x47900000, SYS_MMU_BUFFERABLE},   //QSPI MMR Maddr0space -Non Cacheable | Bufferable : Device
    {(void *)0x48000000, SYS_MMU_BUFFERABLE},   //UART1,UART2,I2C1,McSPI0,McASP0 CFG,McASP1 CFG,DMTIMER,GPIO1 - Non Cacheable | Bufferable Device
    {(void *)0x48100000, 0},   //I2C2,McSPI1,UART3,UART4,UART5, GPIO2,GPIO3,MMC1 - Non Cacheable | Non Bufferable : Strongly Ordered
    {(void *)0x48200000, SYS_MMU_BUFFERABLE},   //Non Cacheable | Bufferable : Device
    {(void *)0x48300000, SYS_MMU_BUFFERABLE},   //PWM - Non Cacheable | Bufferable : Device
    {(void *)0x49000000, SYS_MMU_BUFFERABLE},   //EDMA3CC - Non Cacheable | Bufferable : Device
    {(void *)0x4A000000, SYS_MMU_BUFFERABLE},   //L4 FAST CFG- Non Cacheable | Bufferable : Device
    {(void *)0x4A100000, SYS_MMU_BUFFERABLE},   //CPSW -Non Cacheable | Bufferable : Device
    {(void *)0x54400000, SYS_MMU_SHAREABLE | SYS_MMU_BUFFERABLE},   //PRU-ICSS0/1 -Non Cacheable | Bufferable : Shared Device
    {(void *)0xFFFFFFFF, 0xFFFFFFFF}
};
#elif defined(AM335X_FAMILY_BUILD)

PINMUX_config iceV2Mux[] =
{
    {CHIPDB_MOD_ID_GPMC, 0, 0},
    {CHIPDB_MOD_ID_GPIO, 0, 0},
    {CHIPDB_MOD_ID_GPIO, 1, 0},
    {CHIPDB_MOD_ID_GPIO, 2, 0},
    {CHIPDB_MOD_ID_GPIO, 3, 0},
    {CHIPDB_MOD_ID_I2C, 0, 0},
    {CHIPDB_MOD_ID_MCSPI, 0, 0},
    {CHIPDB_MOD_ID_MCSPI, 1, 0},
    {CHIPDB_MOD_ID_PRU_ICSS, 1, 0},
    {0xFFFFFFFF, 0, 0}
};
SYS_MMU_ENTRY applMmuEntries[] =
{
    {(void *)0x08000000, SYS_MMU_CACHEABLE | SYS_MMU_BUFFERABLE},   //NOR - bufferable| Cacheable
    {(void *)0x08100000, SYS_MMU_CACHEABLE | SYS_MMU_BUFFERABLE},   //NOR -bufferable| Cacheable
    {(void *)0x08200000, SYS_MMU_CACHEABLE | SYS_MMU_BUFFERABLE},   //NOR - bufferable| Cacheable
    {(void *)0x48300000, 0},   //PWM - Non bufferable| Non Cacheable
    {(void *)0x48200000, 0},   //INTCPS,MPUSS - Non Bufferable| Non Cacheable
    {(void *)0x48100000, 0},   //I2C2,McSPI1,UART3,UART4,UART5, GPIO2,GPIO3,MMC1 - Non bufferable| Non Cacheable
    {(void *)0x48000000, 0},   //UART1,UART2,I2C1,McSPI0,McASP0 CFG,McASP1 CFG,DMTIMER,GPIO1 -Non bufferable| Non Cacheable
    {(void *)0x44E00000, 0},   //Clock Module, PRM, GPIO0, UART0, I2C0, - Non bufferable| Non Cacheable
    {(void *)0x4A300000, SYS_MMU_SHAREABLE | SYS_MMU_BUFFERABLE},   //PRUSS1 -Bufferable| Non Cacheable | Shareable
    {(void *)0x49000000, 0},   //EDMA3 - Non bufferable| Non Cacheable
    {(void *)0x4A000000, 0},   //L4 FAST CFG- Non bufferable| Non Cacheable
    {(void *)0x4A100000, 0},   //CPSW - Non bufferable| Non Cacheable
    {(void *)0xFFFFFFFF, 0xFFFFFFFF}
};

#endif

#endif
