/**
 * tiescappl.h
 *
*/
/*
 * Copyright (c) 2015, Texas Instruments Incorporated
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * *  Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * *  Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * *  Neither the name of Texas Instruments Incorporated nor the names of
 *    its contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
 * EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 **/


#ifdef _TIESC_HW_
    #define PROTO
#else
    #define PROTO extern
#endif

#if TIESC_HW
#include "tieschw.h"
/*-----------------------------------------------------------------------------------------
------
------    TI ESC application specific objects
------
-----------------------------------------------------------------------------------------*/
/******************************************************************************
*                   Object 0x1601: digital output RxPDO
******************************************************************************/
#ifdef _OBJD_
OBJCONST TSDOINFOENTRYDESC  OBJMEM asEntryDesc0x1601[] =
{
    {DEFTYPE_UNSIGNED8, 0x8, ACCESS_READ }, /* Subindex 000 */
    {DEFTYPE_UNSIGNED32, 0x20, ACCESS_READ}, /* SubIndex 001: SubIndex 001 */
    {DEFTYPE_UNSIGNED32, 0x20, ACCESS_READ}, /* SubIndex 002: SubIndex 002 */
    {DEFTYPE_UNSIGNED32, 0x20, ACCESS_READ}, /* SubIndex 003: SubIndex 003 */
    {DEFTYPE_UNSIGNED32, 0x20, ACCESS_READ}, /* SubIndex 004: SubIndex 004 */

    {DEFTYPE_UNSIGNED32, 0x20, ACCESS_READ}, /* SubIndex 005: SubIndex 005 */
    {DEFTYPE_UNSIGNED32, 0x20, ACCESS_READ}, /* SubIndex 006: SubIndex 006 */
    {DEFTYPE_UNSIGNED32, 0x20, ACCESS_READ}, /* SubIndex 007: SubIndex 007 */
    {DEFTYPE_UNSIGNED32, 0x20, ACCESS_READ}
}; /* SubIndex 008: SubIndex 008 */

OBJCONST UCHAR OBJMEM aName0x1601[] =
    "RxPDO-Map\000SubIndex 1\000SubIndex 2\000SubIndex 3\000SubIndex 4\000SubIndex 5\000SubIndex 6\000SubIndex 7\000SubIndex 8\000\377";
#endif //#ifdef _OBJD_

typedef struct STRUCT_PACKED_START
{
    UINT16   u16SubIndex0;
    UINT32   aEntries[8];
} STRUCT_PACKED_END
TOBJ1601;

PROTO TOBJ1601 RxPDOMap
#ifdef _TIESC_HW_
    = {8, {0x70100101, 0x70100201, 0x70100301, 0x70100401, 0x70100501, 0x70100601, 0x70100701, 0x70100801}}
#endif
      ;
/******************************************************************************
*                   Object 0x1602:  Motor output RxPDO
******************************************************************************/
#ifdef _OBJD_
OBJCONST TSDOINFOENTRYDESC  OBJMEM asEntryDesc0x1602[] =
{
    {DEFTYPE_UNSIGNED8, 0x8, ACCESS_READ }, /* Subindex 000 */
    {DEFTYPE_UNSIGNED32, 0x20, ACCESS_READ}, /* SubIndex 001: SubIndex 001 */
    {DEFTYPE_UNSIGNED32, 0x20, ACCESS_READ}, /* SubIndex 002: SubIndex 002 */
    {DEFTYPE_UNSIGNED32, 0x20, ACCESS_READ}
}; /* SubIndex 003: SubIndex 003 */

OBJCONST UCHAR OBJMEM aName0x1602[] =
    "RxPDO1-Map\000SubIndex 1\000SubIndex 2\000SubIndex 3\000\377";
#endif //#ifdef _OBJD_

typedef struct STRUCT_PACKED_START
{
    UINT16   u16SubIndex0;
    UINT32   aEntries[3];
} STRUCT_PACKED_END
TOBJ1602;

PROTO TOBJ1602 RxPDO1Map
#ifdef _TIESC_HW_
    = {3, {0x70200108, 0x70200208, 0x70200310}}
#endif
      ;

/******************************************************************************
*                   Object 0x1A00: digital input TxPDO
******************************************************************************/
#ifdef _OBJD_
OBJCONST TSDOINFOENTRYDESC  OBJMEM asEntryDesc0x1A00[] =
{
    {DEFTYPE_UNSIGNED8, 0x8, ACCESS_READ }, /* Subindex 000 */
    {DEFTYPE_UNSIGNED32, 0x20, ACCESS_READ},
    {DEFTYPE_UNSIGNED32, 0x20, ACCESS_READ},
    {DEFTYPE_UNSIGNED32, 0x20, ACCESS_READ},
    {DEFTYPE_UNSIGNED32, 0x20, ACCESS_READ},

    {DEFTYPE_UNSIGNED32, 0x20, ACCESS_READ},
    {DEFTYPE_UNSIGNED32, 0x20, ACCESS_READ},
    {DEFTYPE_UNSIGNED32, 0x20, ACCESS_READ},
    {DEFTYPE_UNSIGNED32, 0x20, ACCESS_READ}
};

OBJCONST UCHAR OBJMEM aName0x1A00[] =
    "TxPDO-Map\000SubIndex 1\000SubIndex 2\000SubIndex 3\000SubIndex 4\000SubIndex 5\000SubIndex 6\000SubIndex 7\000SubIndex 8\000\377";
#endif //#ifdef _OBJD_

typedef struct STRUCT_PACKED_START
{
    UINT16   u16SubIndex0;
    UINT32   aEntries[8];
} STRUCT_PACKED_END
TOBJ1A00;

PROTO TOBJ1A00 TxPDOMap
#ifdef _TIESC_HW_
    = {8, {0x60000101, 0x60000201, 0x60000301, 0x60000401, 0x60000501, 0x60000601, 0x60000701, 0x60000801}}
#endif
      ;

/******************************************************************************
*                   Object 0x1A03: Motor analog input TxPDO
******************************************************************************/
#ifdef _OBJD_
OBJCONST TSDOINFOENTRYDESC  OBJMEM asEntryDesc0x1A03[] =
{
    {DEFTYPE_UNSIGNED8, 0x8, ACCESS_READ }, /* Subindex 000 */
    {DEFTYPE_UNSIGNED32, 0x20, ACCESS_READ}, /* SubIndex 001: SubIndex 001 */
    {DEFTYPE_UNSIGNED32, 0x20, ACCESS_READ}
}; /* SubIndex 002: SubIndex 002 */

OBJCONST UCHAR OBJMEM aName0x1A03[] =
    "TxPDO1-Map\000SubIndex 1\000SubIndex 2\000\377";
#endif //#ifdef _OBJD_

typedef struct STRUCT_PACKED_START
{
    UINT16   u16SubIndex0;
    UINT32   aEntries[2];
} STRUCT_PACKED_END
TOBJ1A03;
PROTO TOBJ1A03 sAITxPDO1Map

#ifdef _TIESC_HW_
    = {2, {0x60300120, 0x60300210}}
#endif
      ;

/******************************************************************************
*                   Object 0x1C12: RxPDO assignment
******************************************************************************/
#ifdef _OBJD_
OBJCONST TSDOINFOENTRYDESC  OBJMEM asEntryDesc0x1C12[] =
{
    {DEFTYPE_UNSIGNED8, 0x08, ACCESS_READ},
    {DEFTYPE_UNSIGNED16, 0x10, ACCESS_READ},
    {DEFTYPE_UNSIGNED16, 0x10, ACCESS_READ}
};
OBJCONST UCHAR OBJMEM aName0x1C12[] = "RxPDO assign";
#endif //#ifdef _OBJD_

typedef struct STRUCT_PACKED_START
{
    UINT16   u16SubIndex0;
    UINT16   aEntries[2];
} STRUCT_PACKED_END
TOBJ1C12;

PROTO TOBJ1C12 sRxPDOassign
#ifdef _TIESC_HW_
    = {0x02, {0x1601, 0x1602}}
#endif
      ;

/******************************************************************************
*                   Object 0x1C13: TxPDO assignment
******************************************************************************/
#ifdef _OBJD_
OBJCONST TSDOINFOENTRYDESC  OBJMEM asEntryDesc0x1C13[] =
{
    {DEFTYPE_UNSIGNED8, 0x08, ACCESS_READ},
    {DEFTYPE_UNSIGNED16, 0x10, ACCESS_READ},
    {DEFTYPE_UNSIGNED16, 0x10, ACCESS_READ}
};
OBJCONST UCHAR OBJMEM aName0x1C13[] = "TxPDO assign";
#endif //#ifdef _OBJD_

typedef struct STRUCT_PACKED_START
{
    UINT16   u16SubIndex0;
    UINT16   aEntries[2];
} STRUCT_PACKED_END
TOBJ1C13;


PROTO TOBJ1C13 sTxPDOassign
#ifdef _TIESC_HW_
    = {0x02, {0x1A00, 0x1A03}}
#endif
      ;

/******************************************************************************
*                   Object 0x6000: digital input object
******************************************************************************/
#ifdef _OBJD_
OBJCONST TSDOINFOENTRYDESC  OBJMEM asEntryDesc0x6000[] =
{
    {DEFTYPE_UNSIGNED8, 0x8, ACCESS_READ }, /* Subindex 000 */
    {DEFTYPE_BOOLEAN, 0x01, ACCESS_READ | OBJACCESS_TXPDOMAPPING}, /* SubIndex 001: Switch 1 */
    {DEFTYPE_BOOLEAN, 0x01, ACCESS_READ | OBJACCESS_TXPDOMAPPING}, /* SubIndex 002: Switch 2 */
    {DEFTYPE_BOOLEAN, 0x01, ACCESS_READ | OBJACCESS_TXPDOMAPPING}, /* SubIndex 003: Switch 3 */
    {DEFTYPE_BOOLEAN, 0x01, ACCESS_READ | OBJACCESS_TXPDOMAPPING}, /* SubIndex 004: Switch 4 */
    {DEFTYPE_BOOLEAN, 0x01, ACCESS_READ | OBJACCESS_TXPDOMAPPING}, /* SubIndex 005: Switch 5 */
    {DEFTYPE_BOOLEAN, 0x01, ACCESS_READ | OBJACCESS_TXPDOMAPPING}, /* SubIndex 006: Switch 6 */
    {DEFTYPE_BOOLEAN, 0x01, ACCESS_READ | OBJACCESS_TXPDOMAPPING}, /* SubIndex 007: Switch 7 */
    {DEFTYPE_BOOLEAN, 0x01, ACCESS_READ | OBJACCESS_TXPDOMAPPING}
}; /* SubIndex 008: Switch 8 */


OBJCONST UCHAR OBJMEM aName0x6000[] =
    "DI Inputs\000Switch 1\000Switch 2\000Switch 3\000Switch 4\000Switch 5\000Switch 6\000Switch 7\000Switch 8\000\377";
#endif //#ifdef _OBJD_

typedef struct STRUCT_PACKED_START
{
    UINT16   u16SubIndex0;
    UINT8    switchs;
} STRUCT_PACKED_END
TOBJ6000;

PROTO TOBJ6000 sDIInputs
#ifdef _TIESC_HW_
    = {1, 0x00}
#endif
      ;

/******************************************************************************
*                   Object 0x6030: analog input object
******************************************************************************/
#ifdef _OBJD_
OBJCONST TSDOINFOENTRYDESC  OBJMEM asEntryDesc0x6030[] =
{
    {DEFTYPE_UNSIGNED8, 0x8, ACCESS_READ }, /* Subindex 000 */
    {DEFTYPE_INTEGER32, 0x20, ACCESS_READ | OBJACCESS_TXPDOMAPPING}, /* SubIndex 001: Info 1 */
    {DEFTYPE_INTEGER16, 0x10, ACCESS_READ | OBJACCESS_TXPDOMAPPING}
};//, /* SubIndex 002: Info 2 */


OBJCONST UCHAR OBJMEM aName0x6030[] =
    "Motor AI Inputs\000Info 1\000Info 2\000\377";
#endif //#ifdef _OBJD_

typedef struct STRUCT_PACKED_START
{
    UINT16   u16SubIndex0;
    INT32   info1;
    INT16   info2;
} STRUCT_PACKED_END
TOBJ6030;

PROTO TOBJ6030 sAI1Inputs
#ifdef _TIESC_HW_
    = {2, 0x0000, 0x00}
#endif
      ;

/******************************************************************************
*					Object 0x6060: Latch object
******************************************************************************/
#ifdef _OBJD_
OBJCONST TSDOINFOENTRYDESC	OBJMEM asEntryDesc0x6060[] = {
   {DEFTYPE_UNSIGNED8, 0x8, ACCESS_READ }, /* Subindex 000 */
   {DEFTYPE_UNSIGNED64, 0x40, ACCESS_READ | OBJACCESS_TXPDOMAPPING}, 		/* SubIndex 001: Latch 0 Positive Edge */
   {DEFTYPE_UNSIGNED64, 0x40, ACCESS_READ | OBJACCESS_TXPDOMAPPING}, 		/* SubIndex 002: Latch 0 Negative Edge */
   {DEFTYPE_UNSIGNED64, 0x40, ACCESS_READ | OBJACCESS_TXPDOMAPPING}, 		/* SubIndex 003: Latch 1 Positive Edge */
   {DEFTYPE_UNSIGNED64, 0x40, ACCESS_READ | OBJACCESS_TXPDOMAPPING},		/* SubIndex 004: Latch 1 Negative Edge */
   {DEFTYPE_UNSIGNED64, 0x40, ACCESS_READ | OBJACCESS_TXPDOMAPPING},		/* SubIndex 005: Reference Time*/
   {DEFTYPE_UNSIGNED64, 0x40, ACCESS_READ | OBJACCESS_TXPDOMAPPING},		/* SubIndex 006: Reference Time Error */
   {DEFTYPE_UNSIGNED64, 0x40, ACCESS_READ | OBJACCESS_TXPDOMAPPING},		/* SubIndex 007: Latch Time Difference */
   {DEFTYPE_UNSIGNED64, 0x40, ACCESS_READWRITE | OBJACCESS_NOPDOMAPPING},	/* SubIndex 008: Nominal Cycle Time */
   {DEFTYPE_UNSIGNED64, 0x40, ACCESS_READWRITE | OBJACCESS_NOPDOMAPPING},	/* SubIndex 009: Sync0 to Latch delay */
   {DEFTYPE_UNSIGNED32, 0x20, ACCESS_READWRITE | OBJACCESS_TXPDOMAPPING},	/* SubIndex 00A: Options*/
   {DEFTYPE_UNSIGNED32, 0x20, ACCESS_READ | OBJACCESS_TXPDOMAPPING},		/* SubIndex 00B: Synchronisation FSM sate */
   {DEFTYPE_UNSIGNED32, 0x20, ACCESS_READWRITE | OBJACCESS_RXPDOMAPPING}};	/* SubIndex 00C: Synchronisation FSM command */

OBJCONST UCHAR OBJMEM aName0x6060[] = "Sychronisation FSM\000Latch 0 Positive Edge [ns]\000Latch 0 Negative Edge [ns]\000Latch 1 Positive Edge [ns]\000Latch 1 Negative Edge [ns]\000Reference time [ns]\000Reference Time Error [ns]\000Latch Time Difference [ns]\000Nominal Cycle Time [ns]\000Sync0 to Latch Delay [ns]\000Options\000Synchronisation FSM state\000Synchronisation FSM command\000\377";
#endif //#ifdef _OBJD_

typedef struct STRUCT_PACKED_START {
   UINT16   u16SubIndex0;
   UInt64   latch0PositiveEdge;
   UInt64   latch0NegativeEdge;
   UInt64   latch1PositiveEdge;
   UInt64   latch1NegativeEdge;
   union {
   UInt64   referenceTime;
   UInt32	referenceTimeUints[2] ;
   };
   UInt64   referenceTimeError;
   UInt64   latchTimeDifference;
   UInt64 	nominalCycleTime;
   UInt64 	sync0ToLatchdelay;
   UInt32 	options;
   UInt32 	syncFsmState;
   UInt32 	syncFsmCommand;
} STRUCT_PACKED_END
TOBJ6060;

PROTO TOBJ6060 sSynchronisationFsm
#ifdef _TIESC_HW_
= { 12, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000, {0x0000000000000000}, 0x0000000000000000, 0x0000000000000000, 1000000, 25000, 0, 0, 0 }
#endif
;

/******************************************************************************
*                   Object 0x7010: digital output object
******************************************************************************/
#ifdef _OBJD_
OBJCONST TSDOINFOENTRYDESC  OBJMEM asEntryDesc0x7010 [] =
{
    {DEFTYPE_UNSIGNED8, 0x8, ACCESS_READ }, /* Subindex 000 */
    {DEFTYPE_BOOLEAN, 0x01, ACCESS_READ | OBJACCESS_RXPDOMAPPING}, /* SubIndex 001: LED 1 */
    {DEFTYPE_BOOLEAN, 0x01, ACCESS_READ | OBJACCESS_RXPDOMAPPING}, /* SubIndex 002: LED 2 */
    {DEFTYPE_BOOLEAN, 0x01, ACCESS_READ | OBJACCESS_RXPDOMAPPING}, /* SubIndex 003: LED 3 */
    {DEFTYPE_BOOLEAN, 0x01, ACCESS_READ | OBJACCESS_RXPDOMAPPING}, /* SubIndex 004: LED 4 */
    {DEFTYPE_BOOLEAN, 0x01, ACCESS_READ | OBJACCESS_RXPDOMAPPING}, /* SubIndex 005: LED 5 */
    {DEFTYPE_BOOLEAN, 0x01, ACCESS_READ | OBJACCESS_RXPDOMAPPING}, /* SubIndex 006: LED 6 */
    {DEFTYPE_BOOLEAN, 0x01, ACCESS_READ | OBJACCESS_RXPDOMAPPING}, /* SubIndex 007: LED 7 */
    {DEFTYPE_BOOLEAN, 0x01, ACCESS_READ | OBJACCESS_RXPDOMAPPING}
}; /* SubIndex 008: LED 8 */
OBJCONST UCHAR OBJMEM aName0x7010[] =
    "DO Outputs\000LED 1\000LED 2\000LED 3\000LED 4\000LED 5\000LED 6\000LED 7\000LED 8\000\377";
#endif //#ifdef _OBJD_


typedef struct STRUCT_PACKED_START
{
    UINT16   u16SubIndex0;
    UINT8    LEDs;
} STRUCT_PACKED_END
TOBJ7010;

PROTO TOBJ7010 sDOOutputs
#ifdef _TIESC_HW_
    = {1, 0x0}
#endif
      ;
/******************************************************************************
*                   Object 0x7020: Motor output object
******************************************************************************/
#ifdef _OBJD_
OBJCONST TSDOINFOENTRYDESC  OBJMEM asEntryDesc0x7020 [] =
{
    {DEFTYPE_UNSIGNED8, 0x8, ACCESS_READ }, /* Subindex 000 */
    {DEFTYPE_UNSIGNED8, 0x08, ACCESS_READ | OBJACCESS_RXPDOMAPPING}, /* SubIndex 001: motor count */
    {DEFTYPE_UNSIGNED8, 0x08, ACCESS_READ | OBJACCESS_RXPDOMAPPING}, /* SubIndex 002: motor command */
    {DEFTYPE_INTEGER16, 0x10, ACCESS_READ | OBJACCESS_RXPDOMAPPING}
}; /* SubIndex 003: motor data */
OBJCONST UCHAR OBJMEM aName0x7020[] =
    "Motor Outputs\000Count\000Command\000Data\000\377";
#endif //#ifdef _OBJD_


typedef struct STRUCT_PACKED_START
{
    UINT16   u16SubIndex0;
    UINT8    Count;
    UINT8    Cmd;
    INT16    MotorData;
} STRUCT_PACKED_END
TOBJ7020;

PROTO TOBJ7020 sDO1Outputs
#ifdef _TIESC_HW_
    = {3, 0x00, 0x00, 0x0000}
#endif
      ;
/************************************************************/

#ifdef _OBJD_
/*if _PIC18 is enabled the object dictionary is fixed defined in coeappl.c*/
TOBJECT OBJMEM ApplicationObjDic[] =
{
    /* Object 0x1601 */
    {NULL, NULL,  0x1601, {DEFTYPE_PDOMAPPING, 8 | (OBJCODE_REC << 8)}, asEntryDesc0x1601, aName0x1601, &RxPDOMap, NULL, NULL, 0x0000 },
    /* Object 0x1602 */
    {NULL, NULL,  0x1602, {DEFTYPE_PDOMAPPING, 3 | (OBJCODE_REC << 8)}, asEntryDesc0x1602, aName0x1602, &RxPDO1Map, NULL, NULL, 0x0000 },
    /* Object 0x1A00 */
    {NULL, NULL,   0x1A00, {DEFTYPE_PDOMAPPING, 8 | (OBJCODE_REC << 8)}, asEntryDesc0x1A00, aName0x1A00, &TxPDOMap, NULL, NULL, 0x0000 },
    /* Object 0x1A03 */
    {NULL, NULL,   0x1A03, {DEFTYPE_PDOMAPPING, 2 | (OBJCODE_REC << 8)}, asEntryDesc0x1A03, aName0x1A03, &sAITxPDO1Map, NULL, NULL, 0x0000 },
    /* Object 0x1C12 */
    {NULL, NULL,   0x1C12, {DEFTYPE_UNSIGNED16, 2 | (OBJCODE_ARR << 8)}, asEntryDesc0x1C12, aName0x1C12, &sRxPDOassign, NULL, NULL, 0x0000 },
    /* Object 0x1C13 */
    {NULL, NULL,   0x1C13, {DEFTYPE_UNSIGNED16, 2 | (OBJCODE_ARR << 8)}, asEntryDesc0x1C13, aName0x1C13, &sTxPDOassign, NULL, NULL, 0x0000 },
    /* Object 0x6000 */
    {NULL, NULL,   0x6000, {DEFTYPE_RECORD, 8 | (OBJCODE_REC << 8)}, asEntryDesc0x6000, aName0x6000, &sDIInputs, NULL, NULL, 0x0000 },
    /* Object 0x6020 */
    {NULL, NULL,   0x6030, {DEFTYPE_RECORD, 2 | (OBJCODE_REC << 8)}, asEntryDesc0x6030, aName0x6030, &sAI1Inputs, NULL, NULL, 0x0000 },
	   /* Object 0x6060 */
	   {NULL,NULL,   0x6060, {DEFTYPE_RECORD, 12 | (OBJCODE_REC << 8)}, asEntryDesc0x6060, aName0x6060, &sSynchronisationFsm, NULL, NULL, 0x0000 },
    /* Object 0x7010 */
    {NULL, NULL,   0x7010, {DEFTYPE_RECORD, 8 | (OBJCODE_REC << 8)}, asEntryDesc0x7010, aName0x7010, &sDOOutputs, NULL, NULL, 0x0000 },
    /* Object 0x7020 */
    {NULL, NULL,   0x7020, {DEFTYPE_RECORD, 3 | (OBJCODE_REC << 8)}, asEntryDesc0x7020, aName0x7020, &sDO1Outputs, NULL, NULL, 0x0000 },
    {NULL, NULL, 0xFFFF, {0, 0}, NULL, NULL, NULL, NULL, NULL, 0x0000}
};
#endif  //#ifdef _OBJD_

#if EXPLICIT_DEVICE_ID
    PROTO UINT16 APPL_GetDeviceID();
#endif
/*ECATCHANGE_START(V4.42.1) ECAT2*/
PROTO void APPL_Application(void);

PROTO void   APPL_AckErrorInd(UINT16 stateTrans);
PROTO UINT16 APPL_StartMailboxHandler(void);
PROTO UINT16 APPL_StopMailboxHandler(void);
PROTO UINT16 APPL_StartInputHandler(UINT16 *pIntMask);
PROTO UINT16 APPL_StopInputHandler(void);
PROTO UINT16 APPL_StartOutputHandler(void);
PROTO UINT16 APPL_StopOutputHandler(void);

PROTO UINT16 APPL_GenerateMapping(UINT16 *pInputSize, UINT16 *pOutputSize);
PROTO void APPL_InputMapping(UINT16 *pData);
PROTO void APPL_OutputMapping(UINT16 *pData);
/*ECATCHANGE_END(V4.42.1) ECAT2*/

PROTO void APPL_Latch();

#endif //#if TIESC_HW

#undef PROTO

