/**
 * tiescutils.h
 *
*/
/*
 * Copyright (c) 2015, Texas Instruments Incorporated
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * *  Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * *  Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * *  Neither the name of Texas Instruments Incorporated nor the names of
 *    its contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
 * EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 **/
#include "tiescbsp.h"

#ifndef USE_ECAT_TIMER
    #include <xdc/runtime/Timestamp.h>
#endif

#include <ti/sysbios/BIOS.h>
#include <ti/sysbios/knl/Clock.h>
#include <ti/sysbios/knl/Task.h>
#include <ti/sysbios/knl/Semaphore.h>
#include <ti/sysbios/knl/Swi.h>

#include <ti/sysbios/hal/Timer.h>
#ifdef AM43XX_FAMILY_BUILD
    #include <ti/sysbios/family/arm/a9/Cache.h>
#elif defined(AM335X_FAMILY_BUILD)
    #include <ti/sysbios/family/arm/a8/Cache.h>
#endif

#include "types.h"
#include "hw_types.h"
#include "tieschw.h"
#include "board.h"
#include "osdrv_mmu.h"
#include "osdrv_version.h"
#include "osdrv_pruss.h"
#include "board_support.h"

Void task1(UArg arg0, UArg arg1);

#ifdef ENABLE_PDI_TASK
    Void PDItask(UArg arg1, UArg arg2);
#endif
#if AL_EVENT_ENABLED
    void HW_EcatIsr(void);
#endif
Void LEDtask(UArg arg0, UArg arg1);

#ifdef ENABLE_SYNC_TASK
    Void Sync0task(UArg arg1, UArg arg2);
#endif

Void common_main();
Uint8 isEtherCATDevice(void);


#ifdef ENABLE_ONLINE_FIRMWARE_UPGRADE
    void relocate_reload_code();
#endif

