/*
 *  ======== main.c ========
 */

#include <xdc/std.h>

#include <xdc/runtime/Error.h>
#include <xdc/runtime/System.h>

#include <ti/sysbios/BIOS.h>
#include <ti/sysbios/knl/Task.h>
#include <ti/sysbios/knl/Semaphore.h>   // Added


#include "stdio.h"
#include "stdint.h"
#include "stdlib.h"
#include "string.h"


/* UART Header files */
#include <ti/drv/uart/UART.h>
#include <ti/drv/uart/UART_stdio.h>
#include <ti/drv/uart/test/src/UART_board.h>



static int cnt0=0;
static int cnt1=0;
static int cnt2=0;
static int cnt3=0;

static int intCnt8=0;
static int intCnt9=0;
static int intCnt10=0;


Task_Handle tsk0,tsk1,tsk2,tsk3;
Void myTask0(UArg arg0, UArg arg1);
Void myTask1(UArg arg0, UArg arg1);
Void myTask2(UArg arg0, UArg arg1);
Void myTask3(UArg arg0, UArg arg1);

extern Semaphore_Handle semaphore0;
extern Semaphore_Handle semaphore1;
extern Semaphore_Handle semaphore2;

extern void GPIO_CONFIG();
void Board_initUART(void);

char UartIN[16];
char UartOut[256];
/*
 *  ======== main ========
 */
Int main()
{ 
    Task_Params tskParams0,tskParams1,tskParams2,tskParams3;


      Task_Params_init(&tskParams0);
      tskParams0.priority = 1;
      tskParams0.arg0 = 0;
      tskParams0.affinity = 0;
      tsk0 = Task_create(myTask0, &tskParams0, NULL);

      Task_Params_init(&tskParams1);
      tskParams1.priority = 1;
      tskParams1.arg0 = 0;
      tskParams1.affinity = 1;
      tsk1 = Task_create(myTask1, &tskParams1, NULL);

      Task_Params_init(&tskParams2);
      tskParams2.priority = 1;
      tskParams2.arg0 = 0;
      tskParams2.affinity = 2;
      tsk2 = Task_create(myTask2, &tskParams2, NULL);

      Task_Params_init(&tskParams3);
      tskParams3.priority = 1;
      tskParams3.arg0 = 0;
      tskParams3.affinity = 3;
      tsk3 = Task_create(myTask3, &tskParams3, NULL);
      GPIO_CONFIG();
      Board_initUART();
      UART_printf("Board Initialized\n");
    BIOS_start();    /* does not return */
    return(0);
}

Void myTask0(UArg arg0, UArg arg1)
{



    while (1)
    {
        Semaphore_pend(semaphore0, BIOS_WAIT_FOREVER);
        cnt0++;
        sprintf(UartOut," Core 1 cnt: %d \n",cnt0);
        UART_printf(UartOut);

    }

    BIOS_exit(0);
}

Void myTask1(UArg arg0, UArg arg1)
{



    while (1)
    {
        Semaphore_pend(semaphore1, BIOS_WAIT_FOREVER);
        cnt1++;
        sprintf(UartOut," Core 2 cnt: %d \n",cnt1);
        UART_printf(UartOut);

    }
    BIOS_exit(0);
}

Void myTask2(UArg arg0, UArg arg1)
{

    while (1)
    {
        Semaphore_pend(semaphore2, BIOS_WAIT_FOREVER);
        cnt2++;
        sprintf(UartOut," Core 2 cnt: %d \n",cnt2);
        UART_printf(UartOut);

    }

    BIOS_exit(0);
}



Void myTask3(UArg arg0, UArg arg1)
{
    char key=0;

    while (1)
    {
        cnt3++;
        UartIN[0]=0;

        UART_gets(UartIN,1);
        UART_puts(UartIN,1);
        UART_printf("   Command received is\n");
        key=UartIN[0];
        switch(key)
        {
        case '1':
            UART_printf("   Posting Core1\n");
            Semaphore_post(semaphore0);
            break;

        case '2':
            UART_printf("   Posting Core2\n");
            Semaphore_post(semaphore1);
            break;

        case '3':
            UART_printf("   Posting Core3\n");
            Semaphore_post(semaphore2);
            break;

        default:

            break;


        }




    }

    BIOS_exit(0);
}

static int intCnt=0;

void GP8_ISR()
{

    intCnt8++;
//    Semaphore_post(semaphore0);

}

void GP9_ISR()
{

    intCnt9++;
    //Semaphore_post(semaphore1);

}

void GP10_ISR()
{

    intCnt10++;
    //Semaphore_post(semaphore2);

}


void Board_initUART(void)
{
    Board_initCfg boardCfg;

    boardCfg = BOARD_INIT_MODULE_CLOCK |
               BOARD_INIT_UNLOCK_MMR |
               BOARD_INIT_UART_STDIO;

    Board_init(boardCfg);
}
