import cv2
import numpy as np

# Intrinsic parameters
K = np.array([[310.1716481553005, 0, 632.3563210040169],
              [0, 309.9337816566858, 467.2122846247733],
              [0, 0, 1]])

# Distortion coefficients
D = np.array([0.18962102826175528, -0.11322070261143802, 0.06648528529335855, -0.014179439910941111])

# Image size (replace with your actual image size)
img_size = (1280, 944)  # Updated to match the fisheye image size

# Generate the mesh LUT
map1, map2 = cv2.fisheye.initUndistortRectifyMap(K, D, np.eye(3), K, img_size, cv2.CV_16SC2)

# Combine map1 and map2 into a single LUT
combined_lut = np.dstack((map1, map2)).flatten()

# Save the combined LUT to a .h file
def save_to_h_file(array, filename):
    with open(filename, 'w') as f:
        f.write("#ifndef COMBINED_LUT_H\n")
        f.write("#define COMBINED_LUT_H\n\n")
        f.write("const short combined_lut_frontt[] = {\n")
        for i in range(0, len(array), 10):  # Adjust the number of elements per line for readability
            f.write("    " + ", ".join(map(str, array[i:i+10])) + ",\n")
        f.write("};\n\n")
        f.write("#endif // COMBINED_LUT_H\n")

save_to_h_file(combined_lut, 'combined_lut_front.h')
# Number of values in LUT
num_values = combined_lut.size
print(f"Number of values in LUT: {num_values}")
print(f"Shape of map1: {map1.shape}")
print(f"Shape of map2: {map2.shape}")

print(f"Combined LUT shape: {combined_lut.shape}")
print(f"Combined LUT size: {combined_lut.size}")


# Save the combined LUT to a .txt file
np.savetxt('combined_lut_front.txt', combined_lut, fmt='%d', delimiter=',', header='combined_lut_front')

# Load the fisheye image
fisheye_img = cv2.imread('front.png')

# Apply the LUT to the fisheye image to get the rectilinear image
rectilinear_img = cv2.remap(fisheye_img, map1, map2, interpolation=cv2.INTER_LINEAR)

# Save the rectilinear image
cv2.imwrite('rectilinear_image_front.jpg', rectilinear_img)

# Display the images
cv2.imshow('Fisheye Image', fisheye_img)
cv2.imshow('Rectilinear Image', rectilinear_img)

# Wait for a key press and close the windows
cv2.waitKey(0)
cv2.destroyAllWindows()

